// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.6.2  Output streams
//

namespace std {

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(bool& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(short& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
#if 0
	    // 990330 bkoz this is ambiguous?
	    _M_fnumget->get(*this, 0, *this, __err, __n);
#else
	    _M_fnumget->get(*this, 0, *this, __err, __n);
#endif
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned short& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(int& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned int& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(long& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned long& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

#ifdef _G_USE_LONG_LONG
  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(long long& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned long long& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }
#endif

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(float& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(double& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(long double& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(void*& __n)
    {
      __istream_type::sentry __cerb(*this);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(__streambuf_type* __sb)
    {
      __istream_type::sentry __cerb(*this);
      if (__sb && __cerb) 
	{
	  streamsize __num = __sb->in_avail();
	  if (__num > 0)
	    {
	      char_type __buf[__num];
	      try {
		__sb->sgetn(__buf, __num);
	      }
	      catch(...) {
		this->setstate(ios_base::failbit);
		if ((this->exceptions() & ios_base::failbit) != 0)
		  throw;
	      }
	      // XXX
	     //if (_M_fnumget->put(*this, *this, this->fill(), __buf).failed())
		this->setstate(ios_base::failbit);
	    }
	  else
	    this->setstate(ios_base::failbit);
	}
      else
	this->setstate(ios_base::badbit);
      return *this;
    }

  template<typename _CharT, typename _Traits>
    int
    basic_istream<_CharT, _Traits>::sync()
    {
      sentry __cerb(*this);
      int __retval = traits_type::eof();
      _M_gcount = 0;
      if (__cerb) 
	{
	  try {
	    __streambuf_type* __sb = this->rdbuf();
	    if (!__sb || __retval == __sb->pubsync())
	      this->setstate(ios_base::badbit);		    
	    else 
	      __retval = 0;
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return __retval;
    }
  
  template<typename _CharT, typename _Traits>
    typename basic_istream<_CharT, _Traits>::pos_type
    basic_istream<_CharT, _Traits>::tellg()
    {
      pos_type __retval = pos_type(-1);
      bool __testok = this->fail() != true;
      sentry __cerb(*this);
      _M_gcount = 0;

      if (__cerb) 
	{
	  try {
	    if (__testok)
	      __retval = this->rdbuf()->pubseekoff(0, ios_base::cur, 
						   ios_base::in);
	    _M_gcount = __retval;
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return __retval;
    }


  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>&
    basic_istream<_CharT, _Traits>::seekg(pos_type __pos)
    {
      bool __testok = this->fail() != true;
      sentry __cerb(*this);
      _M_gcount = 0;

      if (__cerb) 
	{
	  try {
	    if (__testok)
	      _M_gcount = this->rdbuf()->pubseekpos(__pos);
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>&
    basic_istream<_CharT, _Traits>::seekg(off_type __off, 
					  ios_base::seekdir __dir)
    {
      bool __testok = this->fail() != true;
      sentry __cerb(*this);
      _M_gcount = 0;

      if (__cerb) 
	{
	  try {
	    if (__testok)
	      _M_gcount = this->rdbuf()->pubseekoff(__off, __dir);
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  // 21.3.7.8 basic_string::getline and operators
  template<typename _CharT, typename _Traits, typename _Alloc>
    basic_istream<_CharT, _Traits>&
    operator>>(basic_istream<_CharT, _Traits>& __is,
	       basic_string<_CharT, _Traits, _Alloc>& __s)
    {
      typename basic_istream<_CharT,_Traits>::sentry __cerb (__is);
      if (__cerb)
	{
	  __s.resize (0);
	  basic_streambuf<_CharT,_Traits>* __sb = __is.rdbuf ();
	  streamsize __w = __is.width (0);
	  ios_base::iostate __error = ios_base::goodbit;
	  while (1)
	    {
	      typename _Traits::int_type __ch = __sb->sgetc ();
	      if (_Traits::eq_int_type(__ch,_Traits::eof()))
		{ __error = ios_base::eofbit; break; }
	      else if (isspace (__ch)) // XXX wrong
		{ break; }
	      __s += _Traits::to_char_type(__ch);
	      __sb->sbumpc ();
	      if (--__w == 0)
		break;
	    }

	  if (__s.length () == 0) 
	    __error |= ios_base::failbit;
	  if (__error)
	    __is.setstate (__error);  // may throw
	}
      return __is;
    }

  template<typename _CharT, typename _Traits, typename _Alloc>
    basic_istream<_CharT, _Traits>&
    getline(basic_istream<_CharT, _Traits>& __is,
	    basic_string<_CharT, _Traits, _Alloc>& __s, _CharT __delim)
    {
      typename basic_istream<_CharT,_Traits>::sentry __cerb(__is);
      if (__cerb)
	{
	  basic_streambuf<_CharT,_Traits>* __sb = __is.rdbuf ();
	  __s.resize (0);
	  streamsize __count = 0;
	  ios_base::iostate __error = ios_base::goodbit;
	  
	  while (1)
	    {
	      typename _Traits::int_type __ch = __sb->sbumpc ();
	      if (_Traits::eq_int_type(__ch, _Traits::eof()))
		{ __error = ios_base::eofbit; break; }
	      ++__count;
	      if (_Traits::eq(_Traits::to_char_type(__ch), __delim))
		break;
	      if (__s.length () == __s.npos - 1)
		{ __error = ios_base::failbit; break; }
	      __s += _Traits::to_char_type(__ch);
	    }
	  
	  __is._M_gcount = __count;
	  if (__count == 0) __error |= ios_base::failbit;
	  if (__error != ios_base::goodbit)
	    __is.setstate (__error);  // may throw
	}
      return __is;
    }

  template<class _CharT, class _Traits, class _Alloc>
    inline basic_istream<_CharT,_Traits>&
    getline(basic_istream<_CharT, _Traits>& __is, 
	    basic_string<_CharT,_Traits,_Alloc>& __str)
    {
      return getline(__is, __str, __is.widen('\n'));
    }

} // namespace std

// Local Variables:
// mode:C++
// End:








