var NAVTREE =
[
  [ "libstdc++", "index.html", [
    [ "Todo List", "a01749.html", null ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", "functions_type" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
".html",
"a00014.html#a7d484a3437e8cc9907336f5ea04dd7ed",
"a00021.html#acc12f2da474ca2d0708663a4eb25af97",
"a00037.html#af85d83a935344009f82ae16e170fe420",
"a00049.html#a47051255483447477a8e41448f56ce40",
"a00064.html#a7010b8926688747d45887693a0c8e6b6",
"a00066.html#aff75861347059718460f4a71e70d2ea9",
"a00071.html#aef4d5a82b6a51fa750fa43d80b4a8564",
"a00087.html#a15200550c9de14f693bd2fd9badbce2b",
"a00093.html#a8b0cbb1b4b524df1e917fce0d60f63a9",
"a00131.html#adb2e9619613378d65e7fab5b0fd1c439",
"a00159.html#ab857deaace34709581c5573bc62afd49",
"a00203.html#ae5c521f32018c28c403b829eb7e0086f",
"a00220.html#af7d6e44fa7c917f95357a470af816658",
"a00227.html#af78d0aff01e713505a6ec6f225e588cd",
"a00274.html",
"a00286.html#aaf5c9bf04386edc771aff4cc38211e1b",
"a00298.html#a2ca51cfbd9ab80b548ae2bf8ea8b61b0",
"a00311.html#a575990d412e58dcd531cc61a4085cc76",
"a00316.html#aa469e89dac5b93d897739ec0841003a2",
"a00341.html#ac4c580390a6c64c53a1c21a7f0960111",
"a00379.html",
"a00406.html#a78fce039fe72466d5c27712e957da1b4",
"a00427.html#a1ac23763ec3027a0e2c7938ee81b5186",
"a00447.html#a4fb6d662a8351a9c790be9fbe78be8b4",
"a00449.html#a54948c4f38526937d510af5670ae368a",
"a00450.html#aaac4e520f0841cce4c36bd614fa6043e",
"a00452.html#aad2e731291673229100bde1f24ce828f",
"a00453.html#abc032043b1ae87565707f1bb41584ca4",
"a00467.html#aad0ff0405a043c97ad856d634a23fa02",
"a00476.html#a8e269a4d9e589df1ef1bc6df659e7a96",
"a00483.html#a0dab4a25feb468949f28f2820400cd8b",
"a00486.html#a06dfc54da53e069ddbe2669e21c48f41",
"a00489.html#a554836d016ef475ec6bc52393c87d059",
"a00492.html#a8fce2d481f763ae72f358288e6ccfe04",
"a00513.html#af45556aa44d4712d6df67ffc52e6dcd3",
"a00529.html#af1d6b5f13ea6f29d7aa9b2471fe817a0",
"a00550.html#abc791187e49bd5d8cbbb1823acf2faaf",
"a00555.html#a235f306421a0cfe626fc9cfa260d6345",
"a00560.html#aebbe7bae301824c9e872bfd4f5b001d7",
"a00577.html#aa337e99fa2102a4440033e480da5f013",
"a00616.html#a84397c8c11a5d3d5264c8e9d091327c1",
"a00621.html#ad32433d993ebe5e0019e9360411996ae",
"a00626.html#a4d50de5ee094b98f8539afb4fb0d7b01",
"a00630.html#ae86b1bb41bd714670523f9333890b0b8",
"a00643.html#a6a9a2eb43ef2fe89646033454347aa19",
"a00644.html#ac3795cde4efbdf63b27ea978f1a2755d",
"a00647.html#a2b5b079df15919cebcfc5ff9b54135cd",
"a00649.html#ab555e6245bf46e674dc26619981805b6",
"a00652.html#a7643f003a532a377d00ebe8bd288985f",
"a00665.html#a50f85ca81cbcd86cbd515cae255ef338",
"a00679.html#a410904fd95fda5af2e552ba384c98dfa",
"a00695.html#a03c15b53d4cf869d62874f367ea59f69",
"a00701.html#a5a51e69e06f6db3ea4abe493095dc187",
"a00707.html#ab16028e538ba034ad569b6933c152cdb",
"a00727.html#a369164fbcb598a49bbd7297eb6f2c5b0",
"a00762.html",
"a00797.html#gac5dbc0d791c11f4db2a8f32921d16527",
"a00853.html#a88fc8fbe18f938ebfad7c496ccafcd76",
"a00873.html#abbb256c73c5e64f1dc570edc362c2724",
"a00888.html#a5d7c77aea181517c41a76da7376f52e2",
"a00899.html#ad5b88a9ce4bae98b15e910c7f6dded0a",
"a00907.html#a57a58c6bf709742951c7e5ca607de39c",
"a00914.html#af7e0ab1b2ff55a6ac363d780b733db1b",
"a00924.html#a179357ce2cd1d4a53d9c0e5efb65e4df",
"a00950.html#a5edba6c499d334a54a667ff4b115cd90",
"a00976.html#ae08450ae43c73093e3705e72953cb54e",
"a00990.html#afb8b3496f000131daab417fa0c4c76af",
"a01013.html#a2eee23bd13796426f3018c8a9341202f",
"a01016.html#ac935f6a3b65fe0e5629ada1699c86868",
"a01022.html#aba38418b9c030d6aadaa18362aa09952",
"a01030.html#a003c72a57855efbdea6f67f560b6c9d6",
"a01031.html#aa4afb14916781ead549d5f9a27fdcb50",
"a01042.html#a09934f12c7822156e43da7d8304f8923",
"a01065.html#ae25cc2ed9ca31eb2e008406efbb6c42e",
"a01076.html#a304b8b73a11afe64bfca54576b91263b",
"a01098.html",
"a01146_source.html",
"a01185.html#a2decdda757d3ee1e926438ea532da21f",
"a01185.html#abd25d8e36a6e429c7ce7ff930f33e4cd",
"a01219.html#a25da23422018c2f962ea7956177afe5ba69bf074bf052ee4c9047b62fe7c24569",
"a01255.html#a173f93c3bca58d0411f16989cce6fedc",
"a01280_source.html",
"a01320.html#a2a67b44b8bac6d11caea3a4f13b75164",
"a01361.html#ac1f79a664ebccd6a80cd79952fc863fe",
"a01391.html#a323f314c56fe6d1dc5897dbd86daa15f",
"a01430.html#a80ae226280b7568b2f77f1aaf60ee463",
"a01451.html#ga47c5a5d9835e00a60a76f4be7ea0f671",
"a01467.html#gad8725ce43300e1f85e8eecf620267ece",
"a01490.html#a82199816c9ec4f8caa7e9012a926bcd8",
"a01545.html#a1e7645a9dd3947279e25fceb44d6dbda",
"a01549.html#a60c2de42339c226dbeaeb60ef54b7bd2",
"a01567.html#abefce699d5d983b67222537c6e5831d4",
"a01607.html#gae0342770c7466502a1900a207ec22a37",
"a01630.html#gab6aae57097ebeb128f4fef829e8a6c75",
"a01632.html#a9addda43efe433604717937826c0418d",
"a01678.html#gadd7eb026c10d4a6929b8c61d0501bdee",
"a01699.html#ga3b3a1ab0bbe3a22dc61e1ede0aec7c55",
"a01701.html#ga0af400b776b8486401daf6ecf91bacca",
"a01712.html#gaec6e1b27604a07cb7a1158c0a1da0810",
"functions_type_0x6b.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  var imgNode = document.createElement("img");
  imgNode.style.paddingLeft=(16*level).toString()+'px';
  imgNode.width  = 16;
  imgNode.height = 22;
  imgNode.border = 0;
  if (node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    imgNode.src = node.relpath+"ftv2node.png";
    domNode.appendChild(imgNode);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  if (anchor.parent().attr('class')=='memItemLeft' ||
      anchor.parent().attr('class')=='fieldtype' ||
      anchor.parent().is(':header')) 
  {
    pos = anchor.parent().position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = $(location).attr('hash');
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,window.location.hash,relpath);
     }
  })

  $(window).load(showRoot);
}

