
// 981027 ncm work with libstdc++v3

#include <iostream>
#include <locale>
#include <iomanip>
#ifdef DEBUG_ASSERT
#include <assert.h>
#endif

struct MyNP : std::numpunct<char>
{
  string do_grouping() const;
  char   do_thousands_sep() const;
};

string MyNP::do_grouping() const { static string s("\3"); return s; }
char   MyNP::do_thousands_sep() const { return ' '; }

void test01()
{
  std::cout.imbue(locale(locale(), new MyNP));
  std::cout << std::oct << std::showbase;
  std::cout << -0123456l << endl;

  std::cout << ":" << std::setw(11);
  std::cout << -01234567l << ":" << endl;

  std::cout << ":" << std::setw(11) << std::left;
  std::cout << -0123456l << ":" << endl;

  std::cout << ":" << std::setw(11) << std::right;
  std::cout << -012345l << ":" << endl;

  std::cout << ":" << std::setw(11) << std::internal;
  std::cout << -01234l << ":" << endl;

  std::cout << std::hex;
  std::cout << std::setfill('0');
  std::cout << std::internal;
  std::cout << std::showbase;
  std::cout << std::setw(16);
  std::cout << 0x12345678l << std::endl;
#ifdef DEBUG_ASSERT
  assert (std::cout.good());
#endif
}

int main() {
  test01();
  return 0;
}

