// The template and inlines for the -*- C++ -*- valarray class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_VALARRAY
#define _CPP_VALARRAY

#if ! defined (_GNUG__) && ! defined (__attribute__)
#define __attribute__(foo) 	// nothing 
#endif

#include <bits/c++config.h>
#include <bits/std_cstddef.h>
#include <bits/std_cmath.h>
#include <bits/std_cstdlib.h>
#include <bits/std_numeric.h>
#include <bits/std_functional.h>
#include <bits/std_algorithm.h>

#include <alloca.h>  // XXX non-standard.  Used also in bits/gslice.h

namespace std {

  template<class _Expression, typename _Tp> class _Meta;
  template<class _Expr1, class _Expr2, class _Op> class _BinaryExpression;
  template<class _Expression, class _Operator> class _UnaryExpression;
  template<class _Expression> class _SliceExpression;
  template<class _Expression> class _GsliceExpression;
  template<class _Expression> class _IndirectExpression;
  template<class _Expression> class _ApplyFunctionWithValue;
  template<class _Expression> class _ApplyFunctionWithConstRef;

  template<class _Tp> struct _Unary_plus;
  template<class _Tp> struct _Unary_minus;
  template<class _Tp> struct _Bitwise_and;
  template<class _Tp> struct _Bitwise_or;
  template<class _Tp> struct _Bitwise_xor;  
  template<class _Tp> struct _Bitwise_not;
  template<class _Tp> struct _Shift_left;
  template<class _Tp> struct _Shift_right;
  
  template<class _Tp> class valarray;       // An array of type _Tp
  class slice;                            // BLAS-like slice out of an array
  template<class _Tp> class slice_array;
  class gslice;                           // generalized slice out of an array
  template<class _Tp> class gslice_array;
  template<class _Tp> class mask_array;     // masked array
  template<class _Tp> class indirect_array; // indirected array

}

#include <bits/valarray_array.h>

  
namespace std {

  template<class _Tp> class valarray
  {
  public:
      typedef _Tp value_type;

      // _lib.valarray.cons_ construct/destroy:
      valarray();
      explicit valarray(size_t);
      valarray(const _Tp&, size_t);
      valarray(const _Tp*, size_t);
      valarray(const valarray&);
      valarray(const slice_array<_Tp>&);
      valarray(const gslice_array<_Tp>&);
      valarray(const mask_array<_Tp>&);
      valarray(const indirect_array<_Tp>&);
      template<class _Expression>
      valarray(const _Meta<_Expression,_Tp>& __e);
     ~valarray();

      // _lib.valarray.assign_ assignment:
      valarray<_Tp>& operator=(const valarray<_Tp>&);
      valarray<_Tp>& operator=(const _Tp&);
      valarray<_Tp>& operator=(const slice_array<_Tp>&);
      valarray<_Tp>& operator=(const gslice_array<_Tp>&);
      valarray<_Tp>& operator=(const mask_array<_Tp>&);
      valarray<_Tp>& operator=(const indirect_array<_Tp>&);

      template<class _Expression> valarray<_Tp>&
      	operator= (const _Meta<_Expression,_Tp>&);

      // _lib.valarray.access_ element access:
      _Tp                 operator[](size_t) const;
      _Tp&                operator[](size_t);		
      // _lib.valarray.sub_ subset operations:
      _Meta<_SliceExpression<_Array<_Tp> >, _Tp>
      	operator[](slice) const;
      slice_array<_Tp>    operator[](slice);
      _Meta<_GsliceExpression<_Array<_Tp> >, _Tp>
      	operator[](const gslice&) const;
      gslice_array<_Tp>   operator[](const gslice&);
      valarray<_Tp>     	 operator[](const valarray<bool>&) const;
      mask_array<_Tp>     operator[](const valarray<bool>&);
      _Meta<_IndirectExpression<valarray<_Tp> >, _Tp>
      	operator[](const valarray<size_t>&) const;
      indirect_array<_Tp> operator[](const valarray<size_t>&);

      // _lib.valarray.unary_ unary operators:
      _Meta<_UnaryExpression<valarray<_Tp>,_Unary_plus<_Tp> >,_Tp>
        operator+() const;
      _Meta<_UnaryExpression<valarray<_Tp>,negate<_Tp> >,_Tp>
        operator-() const;
      _Meta<_UnaryExpression<valarray<_Tp>,_Bitwise_not<_Tp> >,_Tp>
        operator~() const;
      _Meta<_UnaryExpression<valarray<_Tp>,logical_not<_Tp> >,bool>
        operator!() const;
      
      // _lib.valarray.cassign_ computed assignment:
      valarray<_Tp>& operator*= (const _Tp&);
      valarray<_Tp>& operator/= (const _Tp&);
      valarray<_Tp>& operator%= (const _Tp&);
      valarray<_Tp>& operator+= (const _Tp&);
      valarray<_Tp>& operator-= (const _Tp&);
      valarray<_Tp>& operator^= (const _Tp&);
      valarray<_Tp>& operator&= (const _Tp&);
      valarray<_Tp>& operator|= (const _Tp&);
      valarray<_Tp>& operator<<=(const _Tp&);
      valarray<_Tp>& operator>>=(const _Tp&);
      valarray<_Tp>& operator*= (const valarray<_Tp>&);
      valarray<_Tp>& operator/= (const valarray<_Tp>&);
      valarray<_Tp>& operator%= (const valarray<_Tp>&);
      valarray<_Tp>& operator+= (const valarray<_Tp>&);
      valarray<_Tp>& operator-= (const valarray<_Tp>&);
      valarray<_Tp>& operator^= (const valarray<_Tp>&);
      valarray<_Tp>& operator|= (const valarray<_Tp>&);
      valarray<_Tp>& operator&= (const valarray<_Tp>&);
      valarray<_Tp>& operator<<=(const valarray<_Tp>&);
      valarray<_Tp>& operator>>=(const valarray<_Tp>&);

      template<class _Expression>
        valarray<_Tp>& operator*= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator/= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator%= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator+= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator-= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator^= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator|= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator&= (const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator<<=(const _Meta<_Expression,_Tp>&);
      template<class _Expression>
        valarray<_Tp>& operator>>=(const _Meta<_Expression,_Tp>&);

      
      // _lib.valarray.members_ member functions:
      size_t size() const;
      _Tp    sum() const;	
      _Tp    min() const;	
      _Tp    max() const;	

          // FIXME: Extension
      _Tp    product () const;

      valarray<_Tp> shift (int) const;
      valarray<_Tp> cshift(int) const;
      _Meta<_ApplyFunctionWithValue<valarray<_Tp> >,_Tp>
        apply(_Tp func(_Tp)) const;
      _Meta<_ApplyFunctionWithConstRef<valarray<_Tp> >,_Tp>
        apply(_Tp func(const _Tp&)) const;			
      void resize(size_t __size, _Tp __c = _Tp());

  private:
      size_t _M_size;
      _Tp* _M_data;

      friend class _Array<_Tp>;
  };


  template<typename _Tp> struct _Unary_plus : unary_function<_Tp,_Tp> {
      _Tp operator() (const _Tp& __t) const { return __t; }
  };

  template<typename _Tp> struct _Bitwise_and : binary_function<_Tp,_Tp,_Tp> {
      _Tp operator() (_Tp __x, _Tp __y) const { return __x & __y; }
  };

  template<typename _Tp> struct _Bitwise_or : binary_function<_Tp,_Tp,_Tp> {
      _Tp operator() (_Tp __x, _Tp __y) const { return __x | __y; }
  };

  template<typename _Tp> struct _Bitwise_xor : binary_function<_Tp,_Tp,_Tp> {
      _Tp operator() (_Tp __x, _Tp __y) const { return __x ^ __y; }
  };
  
  template<typename _Tp> struct _Bitwise_not : unary_function<_Tp,_Tp> {
      _Tp operator() (_Tp __t) const { return ~__t; }
  };

  template<typename _Tp> struct _Shift_left : unary_function<_Tp,_Tp> {
      _Tp operator() (_Tp __x, _Tp __y) const { return __x << __y; }
  };

  template<typename _Tp> struct _Shift_right : unary_function<_Tp,_Tp> {
      _Tp operator() (_Tp __x, _Tp __y) const { return __x >> __y; }
  };

  
  template<typename _Tp>
  inline _Tp
  valarray<_Tp>::operator[] (size_t __i) const
  { return _M_data[__i]; }

  template<typename _Tp>
  inline _Tp&
  valarray<_Tp>::operator[] (size_t __i)
  { return _M_data[__i]; }

} // std::
      
#include <bits/slice.h>
#include <bits/slice_array.h>
#include <bits/gslice.h>
#include <bits/gslice_array.h>
#include <bits/mask_array.h>
#include <bits/indirect_array.h>

namespace std {

  template<typename _Tp>
  inline valarray<_Tp>::valarray () : _M_size (0), _M_data (0) {}

  template<typename _Tp>
  inline valarray<_Tp>::valarray (size_t __n) 
      : _M_size (__n), _M_data (new _Tp[__n]) {}

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const _Tp& __t, size_t __n)
      : _M_size (__n), _M_data (new _Tp[__n])
  { fill (_M_data, _M_data+_M_size, __t); }

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const _Tp* __pT, size_t __n)
      : _M_size (__n), _M_data (new _Tp[__n])
  { copy (__pT, __pT+__n, _M_data); }

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const valarray<_Tp>& __v)
      : _M_size (__v._M_size), _M_data (new _Tp[__v._M_size])
  { copy (__v._M_data, __v._M_data+_M_size, _M_data); }

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const slice_array<_Tp>& __sa)
      : _M_size (__sa._M_sz), _M_data (new _Tp[__sa._M_sz])
  { __valarray_copy (__sa._M_array, __sa._M_sz, __sa._M_stride,
            _Array<_Tp>(_M_data)); }

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const gslice_array<_Tp>& __ga)
      : _M_size (__ga._M_gs._M_index_size), _M_data (new _Tp[_M_size])
  { __valarray_copy (__ga._M_array, __ga._M_gs._M_index, 
            _Array<_Tp>(_M_data), _M_size); }

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const mask_array<_Tp>& __ma)
      : _M_size (__ma._M_sz), _M_data (new _Tp[__ma._M_sz])
  { __valarray_copy (__ma._M_array, __ma._M_mask,
            _Array<_Tp>(_M_data), _M_size); }

  template<typename _Tp>
  inline valarray<_Tp>::valarray (const indirect_array<_Tp>& __ia)
      : _M_size (__ia._M_sz), _M_data (new _Tp[__ia._M_sz])
  { __valarray_copy (__ia._M_array, __ia._M_index, 
		     _Array<_Tp>(_M_data), _M_size); }

  template<typename _Tp> template<class _Expr>
  inline valarray<_Tp>::valarray (const _Meta<_Expr, _Tp>& __e)
      : _M_size (__e.size ()), _M_data (new _Tp[_M_size])
  { __valarray_copy (__e, _M_size, _Array<_Tp>(_M_data)); }

  template<typename _Tp>
  inline valarray<_Tp>::~valarray () { delete[] _M_data; }

  template<typename _Tp>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const valarray<_Tp>& __v)
  {
      copy(__v._M_data, __v._M_data + _M_size, _M_data);
      return *this;
  }

  template<typename _Tp>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const _Tp& __t)
  {
      fill (_M_data, _M_data + _M_size, __t);
      return *this;
  }

  template<typename _Tp>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const slice_array<_Tp>& __sa)
  {
      __valarray_copy (__sa._M_array, __sa._M_sz,
              __sa._M_stride, _Array<_Tp>(_M_data));
      return *this;
  }

  template<typename _Tp>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const gslice_array<_Tp>& __ga)
  {
      __valarray_copy (__ga._M_array, __ga._M_gs._M_index,
              _Array<_Tp>(_M_data), _M_size);
      return *this;
  }

  template<typename _Tp>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const mask_array<_Tp>& __ma)
  {
      __valarray_copy (__ma._M_array, __ma._M_mask,
              _Array<_Tp>(_M_data), _M_size);
      return *this;
  }

  template<typename _Tp>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const indirect_array<_Tp>& __ia)
  {
      __valarray_copy (__ia._M_array, __ia._M_index,
               _Array<_Tp>(_M_data), _M_size);
      return *this;
  }

  template<typename _Tp> template<class _Expr>
  inline valarray<_Tp>&
  valarray<_Tp>::operator= (const _Meta<_Expr, _Tp>& __e)
  {
      __valarray_copy (__e, _M_size, _Array<_Tp>(_M_data));
      return *this;
  }

  template<typename _Tp>
  inline _Meta<_SliceExpression<_Array<_Tp> >, _Tp>
  valarray<_Tp>::operator[] (slice __s) const
  {
      typedef _SliceExpression<_Array<_Tp> > _Expr;
      return _Meta<_Expr, _Tp> (_Expr (_Array<_Tp>(_M_data), __s));
  }

  template<typename _Tp>
  inline slice_array<_Tp>
  valarray<_Tp>::operator[] (slice __s)
  {
      return slice_array<_Tp> (_Array<_Tp>(_M_data), __s);
  }

  template<typename _Tp>
  inline _Meta<_GsliceExpression<_Array<_Tp> >, _Tp>
  valarray<_Tp>::operator[] (const gslice& __gs) const
  {
      typedef _GsliceExpression<_Array<_Tp> > _Expr;
      return _Meta<_Expr, _Tp> (_Expr (_Array<_Tp>(_M_data), __gs));
  }

  template<typename _Tp>
  inline gslice_array<_Tp>
  valarray<_Tp>::operator[] (const gslice& __gs)
  {
      return gslice_array<_Tp> (_Array<_Tp>(_M_data), __gs);
  }

  template<typename _Tp>
  inline valarray<_Tp>
  valarray<_Tp>::operator[] (const valarray<bool>& __m) const
  {
      size_t __s (0);
      for (size_t __i=0; __i<__m.size(); ++__i)
          if (__m[__i]) ++__s;
      return valarray<_Tp> (mask_array<_Tp> (_Array<_Tp>(_M_data), __s,
                                         _Array<bool> (__m)));
  }

  template<typename _Tp>
  inline mask_array<_Tp>
  valarray<_Tp>::operator[] (const valarray<bool>& __m)
  {
      size_t __s (0);
      for (size_t __i=0; __i<__m.size(); ++__i)
          if (__m[__i]) ++__s;
      return mask_array<_Tp> (_Array<_Tp>(_M_data), __s, _Array<bool> (__m));
  }

  template<typename _Tp>
  inline _Meta<_IndirectExpression<valarray<_Tp> >, _Tp>
  valarray<_Tp>::operator[] (const valarray<size_t>& __i) const
  {
      typedef _IndirectExpression<valarray<_Tp> > _Expr;
      return _Meta<_Expr, _Tp> (_Expr (*this, __i));
  }

  template<typename _Tp>
  inline indirect_array<_Tp>
  valarray<_Tp>::operator[] (const valarray<size_t>& __i)
  {
      return indirect_array<_Tp> (_Array<_Tp>(_M_data), __i.size(),
                                _Array<size_t> (__i));
  }

#undef _DEFINE_VALARRAY_OPERATOR

#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
  template<typename _Tp>						\
  inline _Meta<_UnaryExpression<valarray<_Tp>, name##<_Tp> >, _Tp>	\
  valarray<_Tp>::operator##op() const					\
  {									\
      typedef _UnaryExpression<valarray<_Tp>, name##<_Tp> > _Expr;	\
      return _Meta<_Expr, _Tp> (*this);					\
  }

_DEFINE_VALARRAY_OPERATOR(+, _Unary_plus)
_DEFINE_VALARRAY_OPERATOR(-, negate)
_DEFINE_VALARRAY_OPERATOR(~, _Bitwise_not)

#undef _DEFINE_VALARRAY_OPERATOR    
  
  template<typename _Tp>
  inline _Meta<_UnaryExpression<valarray<_Tp>, logical_not<_Tp> >, bool>
  valarray<_Tp>::operator!() const
  {
      typedef _UnaryExpression<valarray<_Tp>, logical_not<_Tp> > _Expr;
      return _Meta<_Expr, bool>(*this);
  }

#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
  template<class _Tp>							\
  inline valarray<_Tp> &						\
  valarray<_Tp>::operator##op##= (const _Tp &__t)			\
  {									\
      _Array_augmented_##name (_Array<_Tp>(_M_data), _M_size, __t);	\
      return *this;							\
  }									\
									\
  template<class _Tp>							\
  inline valarray<_Tp> &						\
  valarray<_Tp>::operator##op##= (const valarray<_Tp> &__v)		\
  {									\
      _Array_augmented_##name (_Array<_Tp>(_M_data), _M_size, 		\
                               _Array<_Tp>(__v._M_data));		\
      return *this;							\
  }

_DEFINE_VALARRAY_OPERATOR(+, plus)
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(^, xor)
_DEFINE_VALARRAY_OPERATOR(&, and)
_DEFINE_VALARRAY_OPERATOR(|, or)
_DEFINE_VALARRAY_OPERATOR(<<, shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, shift_right)

#undef _DEFINE_VALARRAY_OPERATOR    

  template<class _Tp>
  inline size_t valarray<_Tp>::size () const { return _M_size; }

  template<class _Tp>
  inline _Tp
  valarray<_Tp>::sum () const
  {
      return accumulate (_M_data, _M_data + _M_size, _Tp ());
  }

  template<typename _Tp>
  inline _Tp
  valarray<_Tp>::product () const
  {
      return accumulate (_M_data, _M_data+_M_size, _Tp(1), multiplies<_Tp> ());
  }

  template <class _Tp>
  inline valarray<_Tp>
  valarray<_Tp>::shift (int __n) const
  {
      _Tp* const __a = static_cast<_Tp*> (alloca (sizeof(_Tp) * _M_size));
      if (! __n)                          // __n == 0: no shift
        copy (_M_data, _M_data + _M_size, __a);
      else if (__n > 0) {                  // __n > 0: shift right
          copy (_M_data+__n, _M_data + _M_size, __a);
          fill (__a+_M_size-__n, __a+_M_size, _Tp());
      }
      else {                             // __n < 0: shift left
          copy (_M_data, _M_data + _M_size+__n, __a-__n);
          fill(__a, __a-__n, _Tp());
      }
      return valarray<_Tp> (__a, _M_size);
  }

  template <class _Tp>
  inline valarray<_Tp>
  valarray<_Tp>::cshift (int __n) const
  {
      _Tp* const __a = static_cast<_Tp*> (alloca (sizeof(_Tp) * _M_size));
      if (! __n)                          // __n == 0: no cshift
        copy(_M_data, _M_data+_M_size, __a);
      else if (__n > 0) {                 // __n > 0: cshift left
          copy (_M_data, _M_data + __n, __a + _M_size-__n);
          copy (_M_data + __n, _M_data + _M_size, __a);
      }
      else {                            // __n < 0: cshift right
          copy (_M_data + _M_size + __n, _M_data + _M_size, __a);
          copy (_M_data, _M_data + _M_size + __n, __a - __n);
        }
      return valarray<_Tp> (__a, _M_size);
  }

  template <class _Tp>
  inline void
  valarray<_Tp>::resize (size_t __n, _Tp __c)
  {
      if (_M_size != __n) {
          delete[] _M_data;
          _M_size = __n;
          _M_data = new _Tp[_M_size];
      }
      fill (_M_data, _M_data+_M_size, __c);
  }

} // std::
  
#include <bits/valarray_meta.h>

namespace std {

#define _DEFINE_VALARRAY_OPERATOR(op, name) 				\
  template<class _Tp> template<class _Expr>				\
  inline valarray<_Tp> &						\
  valarray<_Tp>::operator##op##= (const _Meta<_Expr,_Tp> &__e)		\
  {									\
      _Array_augmented_##name (_Array<_Tp>(_M_data), __e, _M_size);	\
      return *this;							\
  }

_DEFINE_VALARRAY_OPERATOR(+, plus)
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(^, xor)
_DEFINE_VALARRAY_OPERATOR(&, and)
_DEFINE_VALARRAY_OPERATOR(|, or)
_DEFINE_VALARRAY_OPERATOR(<<, shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, shift_right)

#undef _DEFINE_VALARRAY_OPERATOR    
    
  template<typename _Tp>
  inline _Tp
  valarray<_Tp>::min() const
  {
      return *min_element (_M_data, _M_data+_M_size);
  }

  template<typename _Tp>
  inline _Tp
  valarray<_Tp>::max() const
  {
      return *max_element (_M_data, _M_data+_M_size);
  }
  
  template<class _Tp>
  inline _Meta<_ApplyFunctionWithValue<valarray<_Tp> >,_Tp>
  valarray<_Tp>::apply (_Tp func (_Tp)) const
  {
      typedef _ApplyFunctionWithValue<valarray<_Tp> > _Expr;
      return _Meta<_Expr,_Tp> (_Expr (*this, func));
  }

  template<class _Tp>
  inline _Meta<_ApplyFunctionWithConstRef<valarray<_Tp> >,_Tp>
  valarray<_Tp>::apply (_Tp func (const _Tp &)) const
  {
      typedef _ApplyFunctionWithConstRef<valarray<_Tp> > _Expr;
      return _Meta<_Expr,_Tp> (_Expr (*this, func));
  }

#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
  template<typename _Tp>						\
  inline _Meta								\
    <_BinaryExpression<valarray<_Tp>, valarray<_Tp>, name##<_Tp> >, _Tp> \
  operator##op (const valarray<_Tp> &__v, const valarray<_Tp> &__w)	\
  {									\
      typedef _BinaryExpression						\
          <valarray<_Tp>, valarray<_Tp>, name##<_Tp> > _Expr;		\
      return _Meta<_Expr, _Tp> (_Expr (__v, __w));			\
  }									\
									\
  template<typename _Tp>						\
  inline _Meta								\
    <_BinaryExpression<valarray<_Tp>, _Constant<_Tp>, name##<_Tp> >, _Tp> \
  operator##op (const valarray<_Tp> &__v, const _Tp &__t)		\
  {									\
      typedef _BinaryExpression						\
        <valarray<_Tp>, _Constant<_Tp>, name##<_Tp> > _Expr;		\
      return _Meta<_Expr, _Tp> (_Expr (__v, _Constant<_Tp> (__t)));	\
  }									\
									\
  template<typename _Tp>						\
  inline _Meta								\
    <_BinaryExpression<_Constant<_Tp>, valarray<_Tp>, name##<_Tp> >, _Tp> \
  operator##op (const _Tp &__t, const valarray<_Tp> &__v)		\
  {									\
      typedef _BinaryExpression						\
        <_Constant<_Tp>, valarray<_Tp>, name##<_Tp> > _Expr;		\
      return _Meta<_Expr, _Tp> (_Expr (_Constant<_Tp> (__t), __v));	\
  }

_DEFINE_VALARRAY_OPERATOR(+, plus)
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(^, _Bitwise_xor)
_DEFINE_VALARRAY_OPERATOR(&, _Bitwise_and)
_DEFINE_VALARRAY_OPERATOR(|, _Bitwise_or)
_DEFINE_VALARRAY_OPERATOR(<<, _Shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, _Shift_right)

#undef _DEFINE_VALARRAY_OPERATOR

#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
  template<typename _Tp>						\
  inline _Meta								\
     <_BinaryExpression<valarray<_Tp>, valarray<_Tp>, name##<_Tp> >, bool> \
  operator##op (const valarray<_Tp> &__v, const valarray<_Tp> &__w)	\
  {									\
      typedef _BinaryExpression						\
        <valarray<_Tp>, valarray<_Tp>, name##<_Tp> > _Expr;		\
      return _Meta<_Expr, bool> (_Expr (__v, __w));			\
  }									\
									\
  template<class _Tp>							\
  inline _Meta<_BinaryExpression					\
      <valarray<_Tp>, _Constant<_Tp>, name##<_Tp> >, bool>		\
  operator##op (const valarray<_Tp> &__v, const _Tp &__t)		\
  {									\
      typedef _BinaryExpression						\
        <valarray<_Tp>, _Constant<_Tp>, name##<_Tp> > _Expr;		\
      return _Meta<_Expr, bool> (_Expr (__v, _Constant<_Tp> (__t)));	\
  }									\
									\
  template<class _Tp>							\
  inline _Meta<_BinaryExpression					\
     <_Constant<_Tp>, valarray<_Tp>, name##<_Tp> >, bool>		\
  operator##op (const _Tp &__t, const valarray<_Tp> &__v)		\
  {									\
      typedef _BinaryExpression						\
        <_Constant<_Tp>, valarray<_Tp>, name##<_Tp> > _Expr;		\
      return _Meta<_Expr, bool> (_Expr (_Constant<_Tp> (__t), __v));	\
  }

_DEFINE_VALARRAY_OPERATOR(&&, logical_and)
_DEFINE_VALARRAY_OPERATOR(||, logical_or)
_DEFINE_VALARRAY_OPERATOR(==, equal_to)
_DEFINE_VALARRAY_OPERATOR(!=, not_equal_to)
_DEFINE_VALARRAY_OPERATOR(<, less)
_DEFINE_VALARRAY_OPERATOR(>, greater)
_DEFINE_VALARRAY_OPERATOR(<=, less_equal)
_DEFINE_VALARRAY_OPERATOR(>=, greater_equal)

#undef _DEFINE_VALARRAY_OPERATOR

} // namespace std

#endif // _CPP_VALARRAY

// Local Variables:
// mode:c++
// End:
