/*
 test/demo of OV  classes
*/

#include <stream.h>
#include "intintOVSet.h"

int my_compare(int a, int b)
{
  return a - b;
}

void printint(int x)
{
  cout << x << " ";
}

void printintOVSet(intintOVSet& l)
{
  l.apply(printint);
  cout << "\n";
}


void some_ints(intintOVSet& a, int lo, int hi)
{
  for (int i = hi; i >= lo; --i)
    a.add(i);
}

void some_rands(intintOVSet& a, int n)
{
  while (n-- > 0)
    a.add((int)rand() % 50);
}

main()
{
  intintOVSet::item_item_comparison_function = my_compare;
  intintOVSet::key_item_comparison_function = my_compare;
  int i;

  cout << "using OVSet of ints\n";
  intintOVSet a(100); some_ints(a, 1, 20);
  intintOVSet b(100); some_ints(b, 11, 30);
  intintOVSet c(100); some_rands(c, 20);
  intintOVSet d(100); some_rands(d, 20);
  
  cout << "a        ="; printintOVSet(a);
  cout << "b        ="; printintOVSet(b);
  cout << "c        ="; printintOVSet(c);
  cout << "d        ="; printintOVSet(d);
  intintOVSet f(a);
  cout << "f = a    ="; printintOVSet(f);

  cout << "a.contains(5)= " << a.contains(5) << "\n";
  cout << "a.del(5) ="; a.del(5); printintOVSet(a);

  intintOVSet e(100);
  cout << "e        ="; printintOVSet(e);
  e |= a;
  cout << "e |= a   ="; printintOVSet(e);
  e &= b;
  cout << "e &= b   ="; printintOVSet(e);
  e -= c;
  cout << "e -= c   ="; printintOVSet(e);
  e ^= d;
  cout << "e ^= d   ="; printintOVSet(e);
  cout << "deleting elements of e from f, one-by-one...\n";
  for (i = 0; i < e.length(); ++i)
    f.del(e[i]);
  cout << "f        ="; printintOVSet(f);

  cout << "b via []:\n";
  for (i = 0; i < b.length(); ++i)
    cout << b[i] << ", ";
  cout << "\n";

  cout << "\nEnd of test\n";
}
