/*
 test/demo of VHash  classes
*/

#include <stream.h>
#include "intintVHashSet.h"
#include "intintVHashAssoc.h"

int my_eq(int a, int b)
{
  return a == b;
}

void printint(int x)
{
  cout << x << " ";
}



void printVHashAssoc(intintVHashAssoc& h)
{
  cout << "count = " << h.count() << ", contents:\n";
  for (intintVHashAssocTrav p(h); p; p.advance())
    cout << "(" << p.key() << ", " << p.get() << ")";
  cout << "\n";
}

void printintVHashSet(intintVHashSet& l)
{
  l.apply(printint);
  cout << "\n";
}


void some_ints(intintVHashSet& a, int lo, int hi)
{
  for (int i = hi; i >= lo; --i)
    a.add(i);
}

void some_rands(intintVHashSet& a, int n)
{
  while (n-- > 0)
    a.add((int)rand() % 50);
}

main()
{
  intintVHashSet::item_item_equality_function = my_eq;
  intintVHashSet::key_item_equality_function = my_eq;
  intintVHashSet::key_hash_function = multiplicativehash;
  intintVHashSet::item_hash_function = multiplicativehash;
  intintVHashAssoc::key_hash_function = multiplicativehash;
  intintVHashAssoc::key_key_equality_function = my_eq;
  int i;

  cout << "using VHashSet of ints\n";
  intintVHashSet a(50); some_ints(a, 1, 20);
  intintVHashSet b(50); some_ints(b, 11, 30);
  intintVHashSet c(50); some_rands(c, 20);
  intintVHashSet d(50); some_rands(d, 20);
  
  cout << "a        ="; printintVHashSet(a);
  cout << "b        ="; printintVHashSet(b);
  cout << "c        ="; printintVHashSet(c);
  cout << "d        ="; printintVHashSet(d);
  intintVHashSet f(a);
  cout << "f = a    ="; printintVHashSet(f);

  cout << "a.contains(5)= " << a.contains(5) << "\n";
  cout << "a.del(5) ="; a.del(5); printintVHashSet(a);

  intintVHashSet e(50);
  cout << "e        ="; printintVHashSet(e);
  e |= a;
  cout << "e |= a   ="; printintVHashSet(e);
  e &= b;
  cout << "e &= b   ="; printintVHashSet(e);
  e -= c;
  cout << "e -= c   ="; printintVHashSet(e);
  e ^= d;
  cout << "e ^= d   ="; printintVHashSet(e);
  cout << "deleting elements of e from f, one-by-one...\n";
  for (intintVHashSetTrav ep(e); ep; ep.advance())
    f.del(ep.get());
  cout << "f        ="; printintVHashSet(f);

  cout << "b via traverser:\n";
  for (intintVHashSetTrav bp(b); bp; bp.advance())
    cout << bp.get() << ", ";
  cout << "\n";


  intintVHashAssoc t(50);
  cout << "\nusing intintVHashAssoc t...\n";
  printVHashAssoc(t);
  t[1000] = 1000;
  cout << "after t[1000] = 1000, t[1000] = " << t[1000] << "\n";
  printVHashAssoc(t);
  cout << "t.contains(1000) = " << t.contains(1000) << "\n";
  cout << "t.contains(2000) = " << t.contains(2000) << "\n";
  cout << "t[2000] = " << t[2000] << "\n";
  cout << "inserting...\n";
  for (i = 0; i < 10; ++i)
  {
    int key = rand() % 100;
    int cont = rand() % 100 + 500;
    cout << "(" << key << ", " << cont << ")";
    t[key] = cont;
  }
  cout << "\n";
  printVHashAssoc(t);
  t.del(1000);
  cout << "after t.del(1000), t.contains(1000) = " << t.contains(1000) << "\n";
  printVHashAssoc(t);
  t.clear();
  cout << "after t.clear()\n";
  printVHashAssoc(t);

  cout << "\nEnd of test\n";
}
