/*
 test/demo of generic lists
*/


#include <stream.h>
#include "intList.h"

int int_compare(int a, int b)
{
  return a - b;
}

int inc(int x)
{
  return x + 1;
}

int plus(int x, int y)
{
  return x + y;
}

void printint(int x)
{
  cout << x << " ";
}

void print(intList& l)
{
  l.apply(printint);
  cout << "\n";
}

int is_odd(int x)
{
  return x & 1;
}

intList sequence(int lo, int hi)
{
  if (lo > hi)
    return intList();
  else
    return intList(lo, sequence(lo+1, hi));
}

intList randseq(int n)
{
  if (n <= 0)
    return intList();
  else
    return intList((int)rand() % 50, randseq(--n));
}

main()
{
  intList a = sequence(1, 20);
  cout << "\nintList a = sequence(1, 20);\n"; print(a);
  intList b = randseq(20);
  cout << "\nintList b = randseq(20);\n"; print(b);
  intList c = concat(a, b);
  cout << "\nintList c = concat(a, b);\n"; print(c);
  intList d = map(inc, a);
  cout << "\nintList d = map(inc, a);\n"; print(d);
  intList e = reverse(a);
  cout << "\nintList e = reverse(a);\n"; print(e);
  intList f = select(is_odd, a);
  cout << "\nintList f = select(is_odd, a);\n"; print(f);
  int  red = a.reduce(plus, 0);
  cout << "\nint  red = a.reduce(plus, 0);\n"; cout << red;
  int second = a[2];
  cout << "\nint second = a[2];\n"; cout << second;
  intList g = combine(plus, a, b);
  cout << "\nintList g = combine(plus, a, b);\n"; print(g);
  g.del(is_odd);
  cout << "\ng.del(is_odd);\n"; print(g);
  b.sort(int_compare);
  cout << "\nb.sort(int_compare);\n"; print(b);
  intList h = merge(a, b, int_compare);
  cout << "\nintList h = merge(a, b, int_compare);\n"; print(h);
  int pos = a.position(2);
  cout << "\nint pos = a.position(2);\n"; cout << pos;
  intList i = c.find(a);
  cout << "\nintList i = c.find(a);\n"; print(i);
  cout << "\nh via intListTrav:\n";
  for(intListTrav p(h); p.valid(); p.advance())
    cout << p.get() << ", ";
  cout << "\ndone\n";
}
