/*
** Copyright 1988 by Brown University, Providence, Rhode Island
** 
**                         All Rights Reserved
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of Brown University not be
** used in advertising or publicity pertaining to distribution of the
** software without specific, written prior permission.
** 
** BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
** SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS, IN NO EVENT SHALL BROWN BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
**
*/
//For Gnu C++ (requires support for ANSI preprocessor string concatenator ##)
//By Page Starr, who has better things to do, and can maybe even do them now
// that this works
#ifndef Generics_H
#define Generics_H
  /*generic class macros: for actual source code */
#include <generic.h>
#include <std.h>
#include <stddef.h>
  //the following two code clumps are to prevent preprocessor errors if
  //both Generics.h and generics.h are included
#ifndef _$DVEC
#define _$DVEC 1
#define Dvec(Type) GENERIC2(DvEc,Type)
#endif

#ifndef _$SET
#define _$SET 1
#define Set(Type) GENERIC2(SeT,Type)
#define NullSet(Type) GENERIC2(NuLlSeT,Type)
#endif

#ifndef _$PTR
#define _$PTR 1
#define Ptr(Type) GENERIC2(_$P,Type)
#endif

/* Dynamic vector generic code
For type Foo, a dynamic vector Dvec(Foo) is declared by the following:
	Dvecdeclare(Foo, Num)
where Num is the default size of the array.
WARNING: do not use a default size of zero

To declare a dynamic array of type Foo, the following are acceptable:
	Dvec(Foo) bar;	 // the initial size of this array is the default (Num)
	Dvec(Foo) bar(20);          // the initial size of this array is 20
	Dvec(Foo) bar = kludge;     // kludge is of type Dvec(Foo)
	Dvec(Foo) bar(vec,20);      // vec is a twenty Foo element vector

Examples using dynamic arrays bar and kludge of type Dvec(int):
	for (long i=0; i< bar.size(); i++)
	// bar.size() returns the size of the array
	bar[i] = i;		

	int crunch[] = bar;
	// we define casts from Dvec(Foo) to Foo[]

	Dvec(int) sum;
	for (long i=0; i< (bar.max > kludge.max)? kludge.max : bar.max; i++)
		sum[i] = bar.val[i] + kludge.val[i];
	// direct access is a bit faster
*/

#define Dvecdeclare(Type,Init)                                                \
/* Type is the type of the array element, Init is the default */              \
/* initialization size */                                                     \
/* Note: NEVER use the double slash comment convention in macro definitions */\
  typedef Type *Ptr(Type);						      \
									      \
class Dvec(Type) {                                                            \
  long alloc;	   /* size of array allocated */			      \
  long sz;                                                                    \
public:                                       				      \
  long size(void);						              \
  Ptr(Type) val;       /* ptr to array of Type*/           		      \
  /* val is public since a direct access to the array is quicker */ 	      \
  /* except for bounds checking, one only really has to use the  */  	      \
  /* operator[] for lvalue expressions				  */ 	      \
									      \
									      \
  Dvec(Type)(long);							      \
  Dvec(Type)(Dvec(Type) &);						      \
  Dvec(Type)(Type [],long);						      \
  ~Dvec(Type)();							      \
			                              			      \
  Type& operator[](long);                                                     \
  Dvec(Type) operator=(Dvec(Type) operand);                                   \
  operator Ptr(Type)();							      \
};                                                                            \
									      \
                                                                              \
/*Constructor: create only */   					      \
inline Dvec(Type)::Dvec(Type)(long _size=Init) {			      \
   val = new Type[_size];                                                     \
   alloc = _size;                                                             \
   sz = 0;								      \
}									      \
									      \
/*Constructor: initialize to a Dvec(Type) */				      \
Dvec(Type)::Dvec(Type)(Dvec(Type)& operand) {				      \
 alloc=((sz=operand.sz) < Init)? Init:sz;                                     \
 /* don't allocate arrays of size < Init */                                   \
                                                                              \
 val = new Type[alloc]; 		   /* allocate space */	       	      \
 for (long i = 0; i < sz; i++) val[i]=operand.val[i];    /* copy operands */  \
}									      \
									      \
/*Constructor: initialize to passed array of Type with passed size*/	      \
Dvec(Type)::Dvec(Type)(Type operand[], long _size) {			      \
 alloc=((sz=_size) < Init)? Init:sz;                                          \
 /* don't allocate arrays of size < Init */                                   \
                                                                              \
 val = new Type[alloc];		   	   /* allocate space */		      \
 for (long i = 0; i < sz; i++) val[i]=operand[i];        /* copy operands */  \
}									      \
									      \
/*Destructor*/								      \
inline Dvec(Type)::~Dvec(Type)() {					      \
 delete val; 								      \
}									      \
									      \
/* Assignment from Dvec(Type) to Dvec(Type) */				      \
Dvec(Type) Dvec(Type)::operator=(Dvec(Type) operand) {                        \
 if (this == &operand) return (*this);  /* "beware of s=s" - Stroustrup */    \
 delete val;                                                        	      \
   alloc=((sz=operand.size()) < Init)? Init:size();                           \
 val = new Type[alloc]; 		   /* allocate space */		      \
 for (long i = 0; i < alloc; i++) val[i]=operand.val[i];   /* copy operands */\
 return(*this);								      \
}                                                                             \
									      \
/* Coercion from Dvec(Type) to *Type */					      \
inline Dvec(Type)::operator Ptr(Type)() {				      \
 return(val);								      \
}									      \
									      \
/* element access: the raison d'etre for dvecs */			      \
Type& Dvec(Type)::operator[](long ref) {                               	      \
 if (ref < sz)                                                                \
 /* don't have to change alloc or size */                                     \
                                                                              \
  return (val[ref]);                                                          \
 else if (ref < alloc) {           /* change size of the array w/o alloc */   \
  sz = ref+1;                                                                 \
  return (val[ref]);                                                          \
  }                                                                           \
 else {                            /* need to reallocate the array       */   \
  while (alloc <= ref) 							      \
	alloc<<=1;  		   /* double size as necessary  */	      \
  Type *temp  = new Type[alloc];  					      \
  for (long i=0; i < size(); i++) temp[i]=val[i];                             \
                                   /* get new array, copy values */	      \
				   /* Clearly here and elsewhere there */     \
				   /*could be optimizations for some types*/  \
  delete val;                                                                 \
  val=temp;                                                                   \
  sz = ref+1;								      \
  return (val[ref]);                                                          \
  }                                                                           \
}									      \
                                                                              \
inline long Dvec(Type)::size(void) {                                          \
  return sz;                                                                  \
  }                                                                           \
                                                                              \
/* end of Dvec macro: have fun reading cpp output of a Dvec declaration	      \


/* Set generic code
For type Foo, a set Set(Foo) is declared by the following:
	Dvecdeclare(Foo,Num)   //if you haven't declared a dvec for Foo already
	Setdeclare(Foo)

To declare a set of type Foo, the following are acceptable:
	Set(Foo) bar;		// Sets are initially empty
	Set(Foo) bar = bent;	// bent is a set

Examples using sets bar and kludge with integer elements:
	bar = bar + 3 + 4;	// union of bar and the elements 3 and 4
        bar = bar - 3 - 4;      // difference of bar and the set {3,4}
                                // (NOT equivalent to bar - (3 + 4) )

	bar = bar * kludge;	// intersection of bar and kludge
	if (bar == NullSet(Foo))// logical equivalence
	                        // NullSet is predefined for your convenience
	 cout << "Equivalent sets";
	if (bar != kludge)	// logical inequivalence
	 cout << "Sets not equivalent"
	if (2 ^ bar)		// set membership
	 cout << "2 is a member of bar";
	for (i=0; i<bar.size(); i++)   // set enumeration
	 cout << bar[i] << "is in the set \n";
				// NOTE: operator[] does not allow lvalues
        Dvec(int) crunch = bar; // casts available for Set->Dvec and Set->vec
	int crunch2[] = bar;
*/

#define Setdeclare(Type)                                                      \
class Set(Type) {                                                             \
   Dvec(Type) Set;			/*The actual storage */		      \
  public:                                                                     \
   long size(void);							      \
   Set(Type)();								      \
   Set(Type)(Set(Type) &);						      \
   Set(Type) operator+(Set(Type));                                            \
   Set(Type) operator+(Type);                                                 \
   Set(Type) operator-(Set(Type));                                            \
   Set(Type) operator-(Type);                                                 \
   Set(Type) operator*(Set(Type));                                            \
   int operator==(Set(Type));				     	     	      \
   int operator!=( Set(Type));						      \
   friend operator^(Type,Set(Type));					      \
   Type operator[](long);						      \
   operator Dvec(Type)();						      \
   operator Ptr(Type)();						      \
   Set(Type) operator=(Set(Type));					      \
 };           	                                                              \
									      \
/* constructor for the set */						      \
inline Set(Type)::Set(Type)(void) {                                           \
 ;                                                                            \
 }                                                                            \
                                                                              \
/* the size function is equally boring */                                     \
inline long Set(Type)::size(void) {					      \
 return Set.size();							      \
}									      \
									      \
/* initializer for the set */						      \
inline Set(Type)::Set(Type)(Set(Type)& val) {				      \
 Set = val.Set;								      \
}									      \
									      \
/* access an element of the set (but lvalues not allowed)*/		      \
inline Type Set(Type)::operator[](long elem) {				      \
 return(Set.val[elem]);							      \
}									      \
									      \
/* Go through array, see if id is in the set                              */  \
int operator^(Type id,Set(Type) arg) {                                        \
 for (long i = 0; i < arg.size(); i++)                                        \
  if (id == arg.Set.val[i]) return(TRUE);                                     \
 return(FALSE);                                                               \
}                                                                             \
									      \
/* check for equality	in a super gross way  */	 	     	      \
int Set(Type)::operator==(Set(Type) a) {				      \
 for (long i=0; i < size(); i++)				     	      \
  if (!(Set[i] ^ a)) return (FALSE);					      \
 for ( i=0; i < a.size(); i++)					     	      \
  if (! (a.Set[i] ^ *this)) return (FALSE);				      \
 return(TRUE);								      \
}                                                                             \
									      \
/* check for inequality */						      \
int Set(Type)::operator!=(Set(Type) a) {				      \
 return((*this == a) == FALSE);						      \
}									      \
                                                                              \
/* Perform union operation with Set(Type), returning union in new variable*/  \
Set(Type) Set(Type)::operator+(Set(Type) a)                                   \
 { Set(Type) result;                                                  	      \
   result.Set = Set;							      \
   for (long i=0; i< a.size(); i++)                                    	      \
    if (!(a.Set[i] ^ *this))                                                  \
     result.Set[result.size()] = a.Set[i];                             	      \
   return(result);                                                            \
}                                                                             \
                                                                              \
/*Union, but with a Type */                                                   \
Set(Type) Set(Type)::operator+(Type a) {                                      \
   Set(Type) result;                                                  	      \
   result.Set = Set;                                                          \
   if (!(a^ *this))                                                           \
     result.Set[size()] = a;                                           	      \
   return(result);                                                            \
}                                                                             \
                                                                              \
/* Do difference */                                                           \
/* could be more efficient, but I just added it for completeness:  */         \
/*  I don't use it myself                 */                                  \
Set(Type) Set(Type)::operator-(Set(Type) a) {                                 \
 Set(Type) result;                                                            \
 for (long i=0; i<size(); i++)                                                \
   if (!(Set[i] ^ a))                                                         \
     result.Set[result.size()] = Set[i];                                      \
 return(result);                                                              \
}                                                                             \
                                                                              \
/*Difference, but with a Type */                                              \
Set(Type) Set(Type)::operator-(Type a) {                                      \
  Set(Type) result;                                                           \
  long i; i=0;                                                                \
  while ((Set.val[i] != a)  &&  (i < size()))                                 \
    result.Set[result.size()] = Set.val[i++];                                 \
  i++;                                                                        \
  /* skip element (assuming a match)            */                            \
                                                                              \
  while (i < size())                                                          \
    result.Set[result.size()] = Set.val[i++];                                 \
  return result;                                                              \
}                                                                             \
                                                                              \
/* Perform intersection with Set, return result in new variable */            \
Set(Type) Set(Type)::operator*(Set(Type) a) {                                 \
 Set(Type) result;                                                            \
                                                                              \
 for (long i=0; i< a.size(); i++)                                      	      \
  if (a.Set[i]^ *this)                                                        \
   result.Set[result.size()] = a.Set[i];                               	      \
 return(result);                                                              \
}                                                                             \
                                                                              \
/* Perform assignment with a Set */					      \
Set(Type) Set(Type)::operator=(Set(Type) operand) {                   	      \
 Set = operand.Set;                                                           \
}									      \
									      \
/* Coerce a Set to a Dvec */						      \
inline Set(Type)::operator Dvec(Type)() {				      \
 return(Set);								      \
}									      \
									      \
/* Coerce a Set to an array */						      \
inline Set(Type)::operator Ptr(Type)() {				      \
 return(Set.val);							      \
}									      \
Set(Type) NullSet(Type);                                                      \
/* end of Set definition macro */					      \

#endif
