/*
 a test/demo of BitStrings
*/

#include <BitString.h>

main()
{
  BitString a;

  BitString b = atoBitString("1000000001");
  BitString c = atoBitString("10101010101010101010");
  BitString d = atoBitString("00110011001100110011");
  BitString e = atoBitString("11110000111100001111");
  BitString f = b;
  BitString g = ~e;
  BitString h = d;

  cout << "a      = " << a << "\n";
  cout << "b      = " << b << "\n";
  cout << "c      = " << c << "\n";
  cout << "d      = " << d << "\n";
  cout << "e      = " << e << "\n";
  cout << "f = b  = " << f << "\n";
  cout << "g = ~e = " << g << "\n";
  cout << "h = d  = " << h << "\n";

  cout << "~c     = " << (~c) << "\n";
  cout << "c & d  = " << (c & d) << "\n";
  cout << "c | d  = " << (c | d) << "\n";
  cout << "c - d  = " << (c - d) << "\n";
  cout << "c ^ d  = " << (c ^ d) << "\n";
  cout << "c + d  = " << (c + d) << "\n";
  cout << "c <<2  = " << (c << 2) << "\n";
  cout << "c >>2  = " << (c >> 2) << "\n";
  
  cout << "f &= c = " << (f &= c) << "\n";
  cout << "f |= d = " << (f |= d) << "\n";
  cout << "f -= e = " << (f -= e) << "\n";
  cout << "f ^= c = " << (f ^= c) << "\n";
  cout << "f += b = " << (f += b) << "\n";
  cout << "f <<=5 = " << (f <<= 5) << "\n";
  cout << "f >>=10= " << (f >>=10) << "\n";
  
  cout << "c == d = " << (c == d) << " ";
  cout << "c != d = " << (c != d) << " ";
  cout << "c <  d = " << (c <  d) << " ";
  cout << "c <= d = " << (c <= d) << " ";
  cout << "c >  d = " << (c >  d) << " ";
  cout << "c >= d = " << (c >= d) << "\n";
  cout << "lcompare(c, d) = " << lcompare(c, d) << "\n";

  if (!c)
    cout << "c is nil\n";
  else
    cout << "c is non-nil\n";

  for (int p = 0; p < 5; ++p)
    cout << "c.test(" << p << ") =" << c.test(p) << "\n";
  cout << "\n";

  cout << "d == h = " << (d == h) << " ";
  cout << "d != h = " << (d != h) << " ";
  cout << "d <  h = " << (d <  h) << " ";
  cout << "d <= h = " << (d <= h) << " ";
  cout << "d >  h = " << (d >  h) << " ";
  cout << "d >= h = " << (d >= h) << "\n";
  cout << "lcompare(d, h) = " << lcompare(d, h) << "\n";

  h.set(0);
  cout << "h.set(0)       :" << h << "\n";

  cout << "d == h = " << (d == h) << " ";
  cout << "d != h = " << (d != h) << " ";
  cout << "d <  h = " << (d <  h) << " ";
  cout << "d <= h = " << (d <= h) << " ";
  cout << "d >  h = " << (d >  h) << " ";
  cout << "d >= h = " << (d >= h) << "\n";
  cout << "lcompare(d, h) = " << lcompare(d, h) << "\n";

  h.set(45);
  cout << "h.set(65)      :" << h << "\n";
  h.clear(2);
  cout << "h.clear(2)     :" << h << "\n";
  h.invert(11,20);
  cout << "h.invert(11,20):" << h << "\n";
  h.set(21,30);
  cout << "h.set(21,30)   :" << h << "\n";
  h.clear(31,40);
  cout << "h.clear(31, 40):" << h << "\n";
  cout << "h.test(0,5)   = " << h.test(0, 5) << "\n";
  cout << "h.test(31,40) = " << h.test(31, 40) << "\n";

  cout << "bits in e:\n";
  for (p = e.first(); p >= 0; p = e.next(p))
    cout << p << " ";
  cout << "\n";
  cout << "e.count()= " << e.count() << " ";
  cout << "e.count(0)= " << e.count(0) << "\n";

  cout << "clear bits in g (reverse order):\n";
  for (p = g.last(0); p >= 0; p = g.previous(p, 0))
    cout << p << " ";
  cout << "\n";
  cout << "g.count()= " << g.count() << " ";
  cout << "g.count(0)= " << g.count(0) << "\n";

  BitString k = atoBitString("0101");
  cout << "k = " << k << "\n";
  cout << "c.index(k)     = " << c.index(k) << "\n";
  cout << "c.index(k, -1) = " << c.index(k, -1) << "\n";

  cout << "c.before(k) = " << c.before(k) << "\n";
  cout << "c.at(k)     = " <<  c.at(k) << "\n";
  cout << "c.after(k)  = " << c.after(k) << "\n";
  c.after(k) = k;
  cout << "c.after(k)=k :" << c << "\n";
  c.before(k) = k;
  cout << "c.before(k)=k:" << c << "\n";
  
  cout << "c.contains(k, 0) = " << c.contains(k, 0) << "\n";
  cout << "common_prefix(k,  c) = " << common_prefix(k,  c) << "\n";
  cout << "common_suffix(k,  c) = " << common_suffix(k,  c) << "\n";
  cout << "reverse(k)           = " << reverse(k) << "\n";
  k.left_trim(0);
  cout << "k.left_trim(0)       : " << k << "\n";
  k.right_trim(1);
  cout << "k.right_trim(1)      : " << k << "\n";


  BitString l = c + d + c;
  cout << "l = " << l << "\n";
  BitPattern pat(d, e);
  cout << "BitPattern pat = " << pat << "\n";
  cout << "pat.pattern    = " << pat.pattern << "\n";
  cout << "pat.mask       = " << pat.mask << "\n";
  cout << "d.matches(pat) = " << d.matches(pat) << "\n";
  cout << "l.index(pat)   = " << l.index(pat) << "\n";
  cout << "l.index(pat,-1)= " << l.index(pat, -1) << "\n";
  cout << "l.before(pat)  = " << l.before(pat) << "\n";
  cout << "l.at(pat)      = " << l.at(pat) << "\n";
  cout << "l.after(pat)   = " << l.after(pat) << "\n";


  cout << "\nEnd of test.\n";
}
