
// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#ifndef _CPP_NEW
#define _CPP_NEW 1

#include <bits/c++config.h>
#include <bits/stl_config.h>

#ifdef __GNUG__
# include_next <new>
#else

#include <bits/std_exception.h>
#include <bits/std_cstddef.h>

// 18.4  Dynamic memory management

__STL_BEGIN_NAMESPACE

    class bad_alloc;
    struct nothrow_t {};
    extern const nothrow_t nothrow;
    typedef void (*new_handler)();
    new_handler set_new_handler(new_handler) throw();

    class bad_alloc : public exception {
    public:
      bad_alloc() throw();
      bad_alloc(const bad_alloc&) throw();
      bad_alloc& operator=(const bad_alloc&) throw();
      virtual ~bad_alloc() throw();
      virtual const char* what() const throw();
    };

__STL_END_NAMESPACE

    void* operator new(__STD::size_t) throw(__STD::bad_alloc);
    void* operator new(__STD::size_t, const __STD::nothrow_t&) throw();
    void  operator delete(void*) throw();
    void  operator delete(void*, const __STD::nothrow_t&) throw();
    void* operator new[](__STD::size_t) throw(__STD::bad_alloc);
    void* operator new[](__STD::size_t, const __STD::nothrow_t&) throw();
    void  operator delete[](void*) throw();
    void  operator delete[](void*, const __STD::nothrow_t&) throw();
    void* operator new  (__STD::size_t, void*) throw();
    void* operator new[](__STD::size_t, void*) throw();
    void  operator delete  (void*, void*) throw();
    void  operator delete[](void*, void*) throw();

#endif

#endif /* _CPP_NEW */

// Local Variables:
// mode:C++
// End:
