// The template and inlines for the -*- C++ -*- slice class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_BITS_SLICE_H
#define _CPP_BITS_SLICE_H

namespace std {

class slice
{
public:
    slice ();
    slice (size_t, size_t, size_t);

    size_t start () const;
    size_t size () const;
    size_t stride () const;

private:
    const size_t _M_off;		// offset
    const size_t _M_sz;			// size
    const size_t _M_st;			// stride unit
};

inline slice::slice () {}

inline slice::slice (size_t __o, size_t __d, size_t __s)
        : _M_off (__o), _M_sz (__d), _M_st (__s) {}

inline size_t
slice::start () const
  { return _M_off; }

inline size_t
slice::size () const
  { return _M_sz; }

inline size_t
slice::stride () const
  { return _M_st; }

} // std::


#endif /* _CPP_BITS_SLICE_H */

// Local Variables:
// mode:c++
// End:
