/* Macros used by the octeon-os.c and octeon-uart.c.
 *
 * Copyright (c) 2004, 2005, 2006, 2007 Cavium Networks.
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

#ifndef __OCTEON_OS_H__
#define __OCTEON_OS_H__

void octeon_os_use_uart (int enable_uart);
void octeon_os_set_uart_num (int uart_num);

typedef enum
{
    CONSOLE_TYPE_SIM_MAGIC = 0,
    CONSOLE_TYPE_UART,
    CONSOLE_TYPE_PCI,
} octeon_console_type_t;

void octeon_os_set_console (octeon_console_type_t console_type);

void __octeon_memfile_exit (void);

#endif  /* __OCTEON_OS_H__ */
