#! /usr/bin/env bash
# This file contains the complete sequence of commands
# Mentor Graphics used to build this version of Sourcery CodeBench.
# 
# For each free or open-source component of Sourcery CodeBench,
# the source code provided includes all of the configuration
# scripts and makefiles for that component, including any and
# all modifications made by Mentor Graphics.  From this list of
# commands, you can see every configuration option used by
# Mentor Graphics during the build process.
# 
# This file is provided as a guideline for users who wish to
# modify and rebuild a free or open-source component of
# Sourcery CodeBench from source. For a number of reasons,
# though, you may not be able to successfully run this script
# directly on your system. Certain aspects of the Mentor Graphics
# build environment (such as directory names) are included in
# these commands. Mentor Graphics uses Canadian cross compilers so
# you may need to modify various configuration options and paths
# if you are building natively. This sequence of commands
# includes those used to build proprietary components of
# Sourcery CodeBench for which source code is not provided.
# 
# Please note that Sourcery CodeBench support covers only your
# use of the original, validated binaries provided as part of
# Sourcery CodeBench -- and specifically does not cover either
# the process of rebuilding a component or the use of any
# binaries you may build.  In addition, if you rebuild any
# component, you must not use the --with-pkgversion and
# --with-bugurl configuration options that embed Mentor Graphics
# trademarks in the resulting binary; see the "Mentor Graphics
# Trademarks" section in the Sourcery CodeBench Software
# License Agreement.
set -e
inform_fd=2 
umask 022
exec < /dev/null

error_handler ()
{
    exit 1
}

check_status() {
    local status="$?"
    if [ "$status" -ne 0 ]; then
	error_handler
    fi
}

check_pipe() {
    local -a status=("${PIPESTATUS[@]}")
    local limit=$1
    local ix
    
    if [ -z "$limit" ] ; then
	limit="${#status[@]}"
    fi
    for ((ix=0; ix != $limit ; ix++)); do
	if [ "${status[$ix]}" != "0" ] ; then
	    error_handler
	fi
    done
}

error () {
    echo "$script: error: $@" >& $inform_fd
    exit 1
}

nonfatal_error () {
    echo "$script: error: $@" >& $inform_fd
}

warning () {
    echo "$script: warning: $@" >& $inform_fd
}

verbose () {
    if $gnu_verbose; then
	echo "$script: $@" >& $inform_fd
    fi
}

copy_dir() {
    mkdir -p "$2"

    (cd "$1" && tar cf - .) | (cd "$2" && tar xf -)
    check_pipe
}

copy_dir_clean() {
    mkdir -p "$2"
    (cd "$1" && tar cf - \
	--exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc \
	--exclude="*~" --exclude=".#*" \
	--exclude="*.orig" --exclude="*.rej" \
	.) | (cd "$2" && tar xf -)
    check_pipe
}

update_dir_clean() {
    mkdir -p "$2"


    (cd "$1" && tar cf - \
	--exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc \
	--exclude="*~" --exclude=".#*" \
	--exclude="*.orig" --exclude="*.rej" \
	--after-date="$3" \
	. 2> /dev/null) | (cd "$2" && tar xf -)
    check_pipe
}

copy_dir_exclude() {
    local source="$1"
    local dest="$2"
    local excl="$3"
    shift 3
    mkdir -p "$dest"
    (cd "$source" && tar cfX - "$excl" "$@") | (cd "$dest" && tar xf -)
    check_pipe
}

copy_dir_only() {
    local source="$1"
    local dest="$2"
    shift 2
    mkdir -p "$dest"
    (cd "$source" && tar cf - "$@") | (cd "$dest" && tar xf -)
    check_pipe
}

check_mentor_trademarks ()
{
    local cfg_script="$1/configure"
    shift
    local have_mentor_trademark=false
    local c
    for c in "$@"; do
	case "$c" in
	    (--with-pkgversion=*[Ss]ourcery*)
		have_mentor_trademark=true
		;;
	    (--with-bugurl=*[Ss]ourcery*)
		have_mentor_trademark=true
		;;
	    (*)
		;;
	esac
    done
    if "$have_mentor_trademark"; then
	case $(dnsdomainname) in
	    (*.mentorg.com)
		"$cfg_script" "$@"
		;;
	    (*)
		error "If you rebuild any component, you must not use the" \
		    "--with-pkgversion and --with-bugurl configuration" \
		    "options that embed Mentor Graphics trademarks in the" \
		    "resulting binary; see the \"Mentor Graphics" \
		    "Trademarks\" section in the Software License Agreement."
		;;
	esac
    else
	"$cfg_script" "$@"
    fi
}

clean_environment() {
    local env_var_list
    local var




    unset BASH_ENV CDPATH POSIXLY_CORRECT TMOUT

    env_var_list=$(export | \
	grep '^declare -x ' | \
	sed -e 's/^declare -x //' -e 's/=.*//')

    for var in $env_var_list; do
	case $var in
	    HOME|HOSTNAME|LOGNAME|PWD|SHELL|SHLVL|SSH_*|TERM|USER)


		;;
	    LD_LIBRARY_PATH|PATH| \
		FLEXLM_NO_CKOUT_INSTALL_LIC|LM_APP_DISABLE_CACHE_READ)


		;;
	    CSL_CONFIG_SUB)

		;;
	    MAKEINFO)

		;;
	    *_LICENSE_FILE)













		if false; then
		    local license_file_envvar
		    license_file_envvar=

		    if [ "$var" != "$license_file_envvar" ]; then
			export -n "$var" || true
		    fi
		else
		    export -n "$var" || true
		fi
		;;
	    *)

		export -n "$var" || true
		;;
	esac
    done


    export LANG=C
    export LC_ALL=C


    export CVS_RSH=ssh



    user_shell=$SHELL
    export SHELL=$BASH
    export CONFIG_SHELL=$BASH
}

pushenv() {
    pushenv_level=$(($pushenv_level + 1))
    eval pushenv_vars_${pushenv_level}=
}


pushenv_level=0
pushenv_vars_0=



pushenvvar() {
    local pushenv_var="$1"
    local pushenv_newval="$2"
    eval local pushenv_oldval=\"\$$pushenv_var\"
    eval local pushenv_oldset=\"\${$pushenv_var+set}\"
    local pushenv_save_var=saved_${pushenv_level}_${pushenv_var}
    local pushenv_savep_var=savedp_${pushenv_level}_${pushenv_var}
    eval local pushenv_save_set=\"\${$pushenv_savep_var+set}\"
    if [ "$pushenv_save_set" = "set" ]; then
	error "Pushing $pushenv_var more than once at level $pushenv_level"
    fi
    if [ "$pushenv_oldset" = "set" ]; then
	eval $pushenv_save_var=\"\$pushenv_oldval\"
    else
	unset $pushenv_save_var
    fi
    eval $pushenv_savep_var=1
    eval export $pushenv_var=\"\$pushenv_newval\"
    local pushenv_list_var=pushenv_vars_${pushenv_level}
    eval $pushenv_list_var=\"\$$pushenv_list_var \$pushenv_var\"
}

prependenvvar() {
    local pushenv_var="$1"
    local pushenv_newval="$2"
    eval local pushenv_oldval=\"\$$pushenv_var\"
    pushenvvar "$pushenv_var" "$pushenv_newval$pushenv_oldval"
}

popenv() {
    local pushenv_var=
    eval local pushenv_vars=\"\$pushenv_vars_${pushenv_level}\"
    for pushenv_var in $pushenv_vars; do
	local pushenv_save_var=saved_${pushenv_level}_${pushenv_var}
	local pushenv_savep_var=savedp_${pushenv_level}_${pushenv_var}
	eval local pushenv_save_val=\"\$$pushenv_save_var\"
	eval local pushenv_save_set=\"\${$pushenv_save_var+set}\"
	unset $pushenv_save_var
	unset $pushenv_savep_var
	if [ "$pushenv_save_set" = "set" ]; then
	    eval export $pushenv_var=\"\$pushenv_save_val\"
	else
	    unset $pushenv_var
	fi
    done
    unset pushenv_vars_${pushenv_level}
    if [ "$pushenv_level" = "0" ]; then
	error "Popping environment level 0"
    else
	pushenv_level=$(($pushenv_level - 1))
    fi
}

prepend_path() {
    if $(eval "test -n \"\$$1\""); then
	prependenvvar "$1" "$2:"
    else
	prependenvvar "$1" "$2"
    fi
}
pushenvvar CSL_SCRIPTDIR /scratch/jwlemke/b6/vle-lite6/src/scripts-trunk
pushenvvar PATH /usr/local/tools/gcc-4.3.3/bin
pushenvvar LD_LIBRARY_PATH /usr/local/tools/gcc-4.3.3/i686-pc-linux-gnu/lib:/usr/local/tools/gcc-4.3.3/lib64:/usr/local/tools/gcc-4.3.3/lib
pushenvvar FLEXLM_NO_CKOUT_INSTALL_LIC 1
pushenvvar LM_APP_DISABLE_CACHE_READ 1
pushenvvar MAKEINFO 'makeinfo --css-ref=../cs.css'
pushenvvar CSL_CONFIG_SUB /scratch/jwlemke/b6/vle-lite6/src/config-trunk/config.sub
clean_environment
# task [001/196] /init/dirs
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj
mkdir -p /scratch/jwlemke/b6/vle-lite6/install
mkdir -p /scratch/jwlemke/b6/vle-lite6/pkg
mkdir -p /scratch/jwlemke/b6/vle-lite6/logs/data
mkdir -p /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html
mkdir -p /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf
popenv

# task [002/196] /init/cleanup
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi.src.tar.bz2 /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi.backup.tar.bz2
popenv

# task [003/196] /init/source_package/binutils
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/binutils-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/binutils-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' binutils-powerpc-vle
popd
popenv

# task [004/196] /init/source_package/gcc
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/gcc-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/gcc-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' gcc-powerpc-vle
popd
popenv

# task [005/196] /init/source_package/gdb
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/gdb-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/gdb-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' gdb-powerpc-vle
popd
popenv

# task [006/196] /init/source_package/zlib
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/zlib-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/zlib-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' zlib-1.2.3
popd
popenv

# task [007/196] /init/source_package/gmp
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/gmp-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/gmp-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' gmp-2011.09
popd
popenv

# task [008/196] /init/source_package/mpfr
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/mpfr-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/mpfr-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' mpfr-2011.09
popd
popenv

# task [009/196] /init/source_package/mpc
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/mpc-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/mpc-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' mpc-0.9
popd
popenv

# task [010/196] /init/source_package/cloog
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/cloog-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/cloog-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' cloog-0.15
popd
popenv

# task [011/196] /init/source_package/ppl
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/ppl-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/ppl-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' ppl-0.11
popd
popenv

# task [012/196] /init/source_package/getting_started
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/getting_started-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/getting_started-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' getting-started-powerpc-vle
popd
popenv

# task [013/196] /init/source_package/newlib
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/newlib-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/newlib-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' newlib-powerpc-vle
popd
popenv

# task [014/196] /init/source_package/cs3
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/cs3-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/cs3-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' cs3-powerpc-vle
popd
popenv

# task [015/196] /init/source_package/gdil
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/gdil-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/gdil-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' gdil-trunk
popd
popenv

# task [016/196] /init/source_package/power_sprite
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/power_sprite-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/power_sprite-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' power_sprite-trunk
popd
popenv

# task [017/196] /init/source_package/eembc
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/eembc-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/eembc-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' eembc-trunk
popd
popenv

# task [018/196] /init/source_package/csl_tests
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/csl_tests-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/csl_tests-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' csl-tests-trunk
popd
popenv

# task [019/196] /init/source_package/dejagnu_boards
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/dejagnu_boards-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/dejagnu_boards-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' dejagnu-boards-trunk
popd
popenv

# task [020/196] /init/source_package/scripts
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/scripts-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/scripts-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' scripts-trunk
popd
popenv

# task [021/196] /init/source_package/xfails
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/xfails-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/xfails-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' xfails-trunk
popd
popenv

# task [022/196] /init/source_package/portal
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/portal-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/portal-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' portal-trunk
popd
popenv

# task [023/196] /init/source_package/config
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/config-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/config-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' config-trunk
popd
popenv

# task [024/196] /init/source_package/libiconv
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/libiconv-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/libiconv-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' libiconv-1.11
popd
popenv

# task [025/196] /init/source_package/libelf
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/libelf-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/libelf-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' libelf-2011.09
popd
popenv

# task [026/196] /init/source_package/expat
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/expat-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/expat-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' expat-mirror
popd
popenv

# task [027/196] /init/source_package/csl_docbook
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/csl_docbook-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/csl_docbook-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' csl-docbook-trunk
popd
popenv

# task [028/196] /init/source_package/release_notes
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/release_notes-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/release_notes-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' release-notes-trunk
popd
popenv

# task [029/196] /init/source_package/make
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/make-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/make-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' make-3.81
popd
popenv

# task [030/196] /init/source_package/coreutils
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/coreutils-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi/coreutils-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' coreutils-5.94
popd
popenv

# task [031/196] /init/source_package/installanywhere
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
rm -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/installanywhere-2011.09-105.tar.bz2
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/src
tar cf /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup/installanywhere-2011.09-105.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.git --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' installanywhere-trunk
popd
popenv

# task [032/196] /i686-pc-linux-gnu/host_cleanup
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
popenv

# task [033/196] /i686-pc-linux-gnu/zlib_first/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/zlib-1.2.3 /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
popenv

# task [034/196] /i686-pc-linux-gnu/zlib_first/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushenv
pushenvvar CFLAGS '-O3 -fPIC'
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73 '
pushenvvar AR 'i686-pc-linux-gnu-ar rc'
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
./configure --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr
popenv
popd
popenv

# task [035/196] /i686-pc-linux-gnu/zlib_first/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv

# task [036/196] /i686-pc-linux-gnu/zlib_first/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv

# task [037/196] /i686-pc-linux-gnu/gmp/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gmp-2011.09 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=i686-pc-linux-gnu --host=i686-pc-linux-gnu --enable-cxx --disable-nls
popd
popenv
popenv
popenv

# task [038/196] /i686-pc-linux-gnu/gmp/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [039/196] /i686-pc-linux-gnu/gmp/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [040/196] /i686-pc-linux-gnu/gmp/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make check
popd
popenv
popenv
popenv

# task [041/196] /i686-pc-linux-gnu/mpfr/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/mpfr-2011.09 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr
popd
popenv
popenv
popenv

# task [042/196] /i686-pc-linux-gnu/mpfr/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [043/196] /i686-pc-linux-gnu/mpfr/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [044/196] /i686-pc-linux-gnu/mpfr/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make check
popd
popenv
popenv
popenv

# task [045/196] /i686-pc-linux-gnu/mpc/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/mpc-0.9 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-mpfr=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr
popd
popenv
popenv
popenv

# task [046/196] /i686-pc-linux-gnu/mpc/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [047/196] /i686-pc-linux-gnu/mpc/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [048/196] /i686-pc-linux-gnu/mpc/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make check
popd
popenv
popenv
popenv

# task [049/196] /i686-pc-linux-gnu/ppl/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/ppl-0.11 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls --with-libgmp-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-gmp-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr CPPFLAGS=-I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include LDFLAGS=-L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib --disable-watchdog
popd
popenv
popenv
popenv

# task [050/196] /i686-pc-linux-gnu/ppl/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [051/196] /i686-pc-linux-gnu/ppl/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [052/196] /i686-pc-linux-gnu/cloog/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/cloog-0.15 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls --with-ppl=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr
popd
popenv
popenv
popenv

# task [053/196] /i686-pc-linux-gnu/cloog/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [054/196] /i686-pc-linux-gnu/cloog/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [055/196] /i686-pc-linux-gnu/cloog/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make check
popd
popenv
popenv
popenv

# task [056/196] /i686-pc-linux-gnu/libelf/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/libelf-2011.09 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls
popd
popenv
popenv
popenv

# task [057/196] /i686-pc-linux-gnu/libelf/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [058/196] /i686-pc-linux-gnu/libelf/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [059/196] /i686-pc-linux-gnu/toolchain/binutils/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/binutils-powerpc-vle /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
touch /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/.gnu-stamp
popenv
popenv
popenv

# task [060/196] /i686-pc-linux-gnu/toolchain/binutils/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --with-sysroot=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/powerpc-eabi --enable-poison-system-directories
popd
popenv
popenv
popenv

# task [061/196] /i686-pc-linux-gnu/toolchain/binutils/libiberty
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4 all-libiberty
popd
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/binutils-powerpc-vle/include /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/include
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/include
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/lib
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/libiberty/libiberty.a /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/lib
popenv
popenv
popenv

# task [062/196] /i686-pc-linux-gnu/toolchain/binutils/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [063/196] /i686-pc-linux-gnu/toolchain/binutils/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share
popd
popenv
popenv
popenv

# task [064/196] /i686-pc-linux-gnu/toolchain/binutils/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/install
rm bin/powerpc-eabi-embedspu
rm ./lib/rh73/libiberty.a
rmdir ./lib/rh73
popd
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share install-html
popd
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share install-pdf
popd
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/bfd/.libs/libbfd.a /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/lib
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/bfd/bfd.h /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/include
cp /scratch/jwlemke/b6/vle-lite6/src/binutils-powerpc-vle/bfd/elf-bfd.h /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/include
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/opcodes/.libs/libopcodes.a /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-pc-linux-gnu/usr/lib
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/configure.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/etc/configure.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/configure.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly configure
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/standards.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/etc/standards.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/standards.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly standards
rmdir /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/etc
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/bfd.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/bfd.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/bfd.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly bfd
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-ld.bfd
rm -f /scratch/jwlemke/b6/vle-lite6/install/bin/ld.bfd
rm -f /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/ld.bfd
popenv
popenv
popenv

# task [065/196] /i686-pc-linux-gnu/toolchain/gcc_first/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gcc-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gcc-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gcc-powerpc-vle --build=i686-pc-linux-gnu --host=i686-pc-linux-gnu --target=powerpc-eabi --enable-threads --disable-libmudflap --disable-libssp --disable-libstdcxx-pch --enable-extra-sgxxlite-multilibs --disable-threads --with-cpu=603e --enable-extra-sgxxlite-multilibs --with-gnu-as --with-gnu-ld '--with-specs=%{save-temps: -fverbose-asm} -D__CS_SOURCERYGXX_MAJ__=2011 -D__CS_SOURCERYGXX_MIN__=9 -D__CS_SOURCERYGXX_REV__=105 %{!fcommon:%{!fno-common:-fno-common}} %{O2:%{!fno-remove-local-statics: -fremove-local-statics}} %{O*:%{O|O0|O1|O2|Os:;:%{!fno-remove-local-statics: -fremove-local-statics}}} %{Os: %{!fno-remove-local-statics: -fremove-local-statics}}' --enable-languages=c,c++ --disable-shared --enable-lto --with-newlib '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --disable-shared --disable-threads --disable-libssp --disable-libgomp --without-headers --with-newlib --disable-decimal-float --disable-libffi --disable-libquadmath --disable-libitm --disable-libatomic --enable-languages=c --with-sysroot=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/powerpc-eabi --with-build-sysroot=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-mpfr=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-mpc=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-ppl=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr '--with-host-libstdcxx=-static-libgcc -Wl,-Bstatic,-lstdc++,-Bdynamic -lm' --with-cloog=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-libelf=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-libgomp --disable-libitm --enable-poison-system-directories --with-build-time-tools=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin --with-build-time-tools=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin
popd
popenv
popenv

# task [066/196] /i686-pc-linux-gnu/toolchain/gcc_first/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4 LDFLAGS_FOR_TARGET=--sysroot=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi CPPFLAGS_FOR_TARGET=--sysroot=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi build_tooldir=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi
popd
popenv
popenv

# task [067/196] /i686-pc-linux-gnu/toolchain/gcc_first/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-first-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man install
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man install-html
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man install-pdf
popd
popenv
popenv

# task [068/196] /i686-pc-linux-gnu/toolchain/gcc_first/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushd /scratch/jwlemke/b6/vle-lite6/install
rm bin/powerpc-eabi-gccbug
rm ./lib/rh73/libiberty.a
rmdir ./lib/rh73
rmdir include
popd
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/gccinstall /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gcc/gccinstall.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/gccinstall.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly gccinstall
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/gccint /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gcc/gccint.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/gccint.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly gccint
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/cppinternals /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gcc/cppinternals.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/cppinternals.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly cppinternals
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
popenv
popenv

# task [069/196] /i686-pc-linux-gnu/toolchain/newlib/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS_FOR_TARGET '-g -O2'
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/newlib-powerpc-vle --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --enable-newlib-io-long-long --enable-newlib-register-fini --disable-newlib-multithread --disable-libgloss --disable-newlib-supplied-syscalls --disable-nls
popd
popenv
popenv
popenv

# task [070/196] /i686-pc-linux-gnu/toolchain/newlib/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS_FOR_TARGET '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [071/196] /i686-pc-linux-gnu/toolchain/newlib/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS_FOR_TARGET '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share
popd
popenv
popenv
popenv

# task [072/196] /i686-pc-linux-gnu/toolchain/newlib/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CFLAGS_FOR_TARGET '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make pdf
mkdir -p /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf
cp /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-eabi/newlib/libc/libc.pdf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/libc.pdf
mkdir -p /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf
cp /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-eabi/newlib/libm/libm.pdf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/libm.pdf
make html
mkdir -p /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-eabi/newlib/libc/libc.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/libc
mkdir -p /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/newlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-eabi/newlib/libm/libm.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/libm
popd
popenv
popenv
popenv

# task [073/196] /i686-pc-linux-gnu/toolchain/gcc_final/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
rm -f /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
ln -s . /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gcc-powerpc-vle --build=i686-pc-linux-gnu --host=i686-pc-linux-gnu --target=powerpc-eabi --enable-threads --disable-libmudflap --disable-libssp --disable-libstdcxx-pch --enable-extra-sgxxlite-multilibs --disable-threads --with-cpu=603e --enable-extra-sgxxlite-multilibs --with-gnu-as --with-gnu-ld '--with-specs=%{save-temps: -fverbose-asm} -D__CS_SOURCERYGXX_MAJ__=2011 -D__CS_SOURCERYGXX_MIN__=9 -D__CS_SOURCERYGXX_REV__=105 %{!fcommon:%{!fno-common:-fno-common}} %{O2:%{!fno-remove-local-statics: -fremove-local-statics}} %{O*:%{O|O0|O1|O2|Os:;:%{!fno-remove-local-statics: -fremove-local-statics}}} %{Os: %{!fno-remove-local-statics: -fremove-local-statics}}' --enable-languages=c,c++ --disable-shared --enable-lto --with-newlib '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --with-headers=yes --with-sysroot=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/powerpc-eabi --with-build-sysroot=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-mpfr=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-mpc=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-ppl=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr '--with-host-libstdcxx=-static-libgcc -Wl,-Bstatic,-lstdc++,-Bdynamic -lm' --with-cloog=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-libelf=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-libgomp --disable-libitm --enable-poison-system-directories --with-build-time-tools=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin --with-build-time-tools=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin
popd
popenv
popenv

# task [074/196] /i686-pc-linux-gnu/toolchain/gcc_final/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
rm -f /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
ln -s . /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4 LDFLAGS_FOR_TARGET=--sysroot=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi CPPFLAGS_FOR_TARGET=--sysroot=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi build_tooldir=/scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi
popd
popenv
popenv

# task [075/196] /i686-pc-linux-gnu/toolchain/gcc_final/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
rm -f /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
ln -s . /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man install
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man install-html
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man install-pdf
popd
popenv
popenv

# task [076/196] /i686-pc-linux-gnu/toolchain/gcc_final/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushd /scratch/jwlemke/b6/vle-lite6/install
rm bin/powerpc-eabi-gccbug
rm ./powerpc-eabi/lib/te600/libiberty.a
rm ./powerpc-eabi/lib/te200z3/libiberty.a
rm ./powerpc-eabi/lib/te500v2/libiberty.a
rm ./powerpc-eabi/lib/nof/libiberty.a
rm ./powerpc-eabi/lib/libiberty.a
rm ./powerpc-eabi/lib/te200z0/libiberty.a
rm ./powerpc-eabi/lib/te500v1/libiberty.a
rm ./lib/rh73/libiberty.a
rmdir ./lib/rh73
rmdir include
popd
rm -f /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/usr
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/gccinstall /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gcc/gccinstall.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/gccinstall.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly gccinstall
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/gccint /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gcc/gccint.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/gccint.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly gccint
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/cppinternals /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gcc/cppinternals.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/cppinternals.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly cppinternals
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libstdc++.a-gdb.py
popenv
popenv

# task [077/196] /i686-pc-linux-gnu/toolchain/zlib/0/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/zlib-1.2.3 /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
popenv

# task [078/196] /i686-pc-linux-gnu/toolchain/zlib/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushenv
pushenvvar CFLAGS '-O3 -fPIC'
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73 '
pushenvvar AR 'i686-pc-linux-gnu-ar rc'
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
./configure --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr
popenv
popd
popenv

# task [079/196] /i686-pc-linux-gnu/toolchain/zlib/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv

# task [080/196] /i686-pc-linux-gnu/toolchain/zlib/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv

# task [081/196] /i686-pc-linux-gnu/toolchain/expat/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/expat-mirror --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls
popd
popenv
popenv
popenv

# task [082/196] /i686-pc-linux-gnu/toolchain/expat/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [083/196] /i686-pc-linux-gnu/toolchain/expat/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [084/196] /i686-pc-linux-gnu/toolchain/gdb/0/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/gdb-powerpc-vle /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
touch /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/.gnu-stamp
popenv
popenv
popenv

# task [085/196] /i686-pc-linux-gnu/toolchain/gdb/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --enable-sim-float=altivec '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-libmcheck --disable-nls --with-libexpat-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-system-gdbinit=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/i686-pc-linux-gnu/powerpc-eabi/lib/gdbinit '--with-gdb-datadir='\''${prefix}'\''/powerpc-eabi/share/gdb'
popd
popenv
popenv
popenv

# task [086/196] /i686-pc-linux-gnu/toolchain/gdb/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [087/196] /i686-pc-linux-gnu/toolchain/gdb/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share
popd
popenv
popenv
popenv

# task [088/196] /i686-pc-linux-gnu/toolchain/gdb/0/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share install-html
make prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share install-pdf
popd
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/annotate /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/annotate.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/annotate.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly annotate
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/gdbint /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/gdbint.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/gdbint.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly gdbint
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/stabs /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/stabs.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/stabs.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly stabs
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/configure.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/etc/configure.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/configure.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly configure
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/standards.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/etc/standards.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/standards.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly standards
rmdir /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/etc
rm -rf /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/bfd.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/bfd.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info/bfd.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info --remove-exactly bfd
rm -f /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
popenv
popenv
popenv

# task [089/196] /i686-pc-linux-gnu/toolchain/cs3/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar CC powerpc-eabi-gcc
pushenvvar CXX powerpc-eabi-g++
pushenvvar AR powerpc-eabi-ar
pushenvvar RANLIB powerpc-eabi-ranlib
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/cs3-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/cs3-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/cs3-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/cs3-powerpc-vle --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=powerpc-eabi '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --with-intermediate-dir=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/cs3 '--with-configs=public-powerpc public-sim' --with-multilib_default=@mcpu=603e
popd
popenv
popenv
popenv

# task [090/196] /i686-pc-linux-gnu/toolchain/cs3/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar CC powerpc-eabi-gcc
pushenvvar CXX powerpc-eabi-g++
pushenvvar AR powerpc-eabi-ar
pushenvvar RANLIB powerpc-eabi-ranlib
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cs3-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [091/196] /i686-pc-linux-gnu/toolchain/cs3/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenvvar CC powerpc-eabi-gcc
pushenvvar CXX powerpc-eabi-g++
pushenvvar AR powerpc-eabi-ar
pushenvvar RANLIB powerpc-eabi-ranlib
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cs3-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share
popd
popenv
popenv
popenv

# task [092/196] /i686-pc-linux-gnu/getting_started/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/getting-started-powerpc-vle /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
touch /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/.gnu-stamp
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-vle
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/release-notes-trunk /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/release-notes
cat > /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-vle/powerpc-vle-eabi-lite-libs.xml <<'EOF0'
<!DOCTYPE getting-started SYSTEM "getting-started.dtd">
<!-- automatically generated, do not edit -->
<section id="sec-multilibs">
  <title>Library Configurations</title>
  <para>
    &csl_prod; for &csl_target_name; includes the following library
    configuration.
  </para>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">603 - 32-bit</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry>default</entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>./</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with processor cores that 
implement hardware floating-point support, such as 
Freescale's e300c3, 603e, and G2 cores.</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">e500v1 - 32-bit</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry><option>-te500v1</option></entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>te500v1/</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with processor cores that 
implement SPE scalar and vector single-precision 
floating-point instructions, such as Freescale's e200z3 
and e200z6 cores.</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">e500v2 - 32-bit</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry><option>-te500v2</option></entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>te500v2/</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with processor cores that 
implement SPE scalar and vector single-precision 
floating-point instructions and SPE double-precision 
floating-point instructions.</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">e600 (Altivec) - 32-bit</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry><option>-te600</option></entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>te600/</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with processor cores that 
implement AltiVec instructions, such as Freescale's e600 core.</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">603 - Soft-Float, 32-bit</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry><option>-msoft-float</option></entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>nof/</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with processor cores that do not 
implement hardware floating-point instructions, such as 
Freescale's 8XX and e300c2 cores.</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">e200z0 - Soft-Float, 32-bit</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry><option>-te200z0</option></entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>te200z0/</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with Freescale's VLE processors 
that do not implement hardware floating-point instructions</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <informaltable>
    <?dbfo keep-together="always" ?>
    <?dbfo table-width="100%" ?>
    <?dbhtml table-width="100%" ?>
    <tgroup cols="2" align="left">
      <colspec colname="c1" colwidth="1*" />
      <colspec colname="c2" colwidth="2*" />
      <thead>
	<row>
	  <entry namest="c1" nameend="c2">e200z3 - VLE + SPE</entry>
	</row>
      </thead>
      <tbody>
	<row>
	  <entry>Command-line option(s):</entry>
	  <entry><option>-te200z3</option></entry>
	</row>
	<row>
	  <entry>Library subdirectory:</entry>
	  <entry><filename>te200z3/</filename></entry>
	</row>
	<row>
	  <entry>Notes:</entry>
	  <entry>This multilib is compatible with Freecale's VLE processors.</entry>
	</row>
      </tbody>
    </tgroup>
  </informaltable>
  <xi:include href="/scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/library-intro.xml" xpointer="xpointer(*/*)"/>
</section>
EOF0
cat > /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-vle/powerpc-vle-eabi-lite.dtd <<'EOF0'
<!-- automatically generated, do not edit -->
<!ENTITY csl_multilib_sec "<xi:include href='/scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu/powerpc-vle/powerpc-vle-eabi-lite-libs.xml'/>">
<!ENTITY csl_subpackage_sec "">
<!ENTITY csl_binutils_component_license "&csl_gpl3.0_license;">
<!ENTITY csl_binutils_component_version "2.21.53">
<!ENTITY csl_gcc_component_license "&csl_gpl3.0_license;">
<!ENTITY csl_gcc_component_version "4.6.1">
<!ENTITY csl_gdb_component_license "&csl_gpl3.0_license;">
<!ENTITY csl_gdb_component_version "7.2.50">
<!ENTITY csl_newlib_component_license "&csl_newlib_license;">
<!ENTITY csl_newlib_component_version "1.18.0">
<!ENTITY csl_cs3_component_license "&csl_cs_license;">
<!ENTITY csl_power_sprite_component_license "&csl_cs_license;">
<!ENTITY csl_make_component_license "&csl_gpl2.0_license;">
<!ENTITY csl_coreutils_component_license "&csl_gpl2.0_license;">
EOF0
popenv
popenv
popenv

# task [093/196] /i686-pc-linux-gnu/getting_started/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/getting_started-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/getting_started-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/getting_started-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/getting_started-src-2011.09-105-powerpc-eabi-i686-pc-linux-gnu --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --disable-nls --with-release-config=powerpc-vle/powerpc-vle-eabi-lite '--with-components=binutils gcc gdb zlib gmp mpfr mpc cloog ppl getting_started newlib cs3 gdil power_sprite eembc branding contents comparison csl_tests dejagnu_boards scripts xfails portal harness config libiconv libelf expat csl_docbook release_notes make coreutils installanywhere no-alf no-alp_examples no-android no-antlr no-apm_examples no-argp no-arm_stub no-atlas_install no-board_support no-brewmp no-c6x_sprite no-ccs no-ccs_mdi_library no-cctools no-cfpe_stub no-cgen no-cml no-codewarrior_plugin no-com_codesourcery_util no-coremark no-csibe no-csldoc no-cslibc_manual no-cula_install no-cxxabi no-cygwin_wrapper no-dbgrtool no-dhrystone no-dinkum no-dltk no-eclipse no-eclipse_cdt no-eclipse_patches no-eclipse_plugin no-eclipse_zip no-edge_utils no-eglibc no-eglibc_configs no-elf2flt no-emf no-fbench no-fftw no-fftw_source no-flexlm_utils no-gettext no-glib no-glibc no-glibc_cs_opt no-glibc_localedef no-glibc_ports no-harness_test no-hexagon_codec no-hexagon_dinkum no-ide no-intel_sprite no-isl no-kinetis_examples no-libcsftdi no-libffi no-libftdi no-libosip2 no-libusb no-libusb_win32 no-license no-license_lib no-linux no-lsb no-mep_cs no-mepl no-mesp_docs no-mgls no-mingw no-mips_sprite no-mips_toolchain_manual no-mklibs no-msvcrt no-ncurses no-nucleus_binary_demos no-ocdremote no-omf2elf no-openposix no-oprofile no-oprofile_plugin no-osawareness_plugin no-ph no-plex_skel no-popt no-prelink no-python no-python_hexagon_linux no-python_macosx no-python_win32 no-qemu no-qmtest_ph no-rpm no-sgxx_application_notes no-sgxx_demos no-simdmath no-sip_parser_benchmark no-spec2000 no-spec2000_configs no-spec2006 no-spec2xxx no-sprite no-stellarisware no-stm32_generate_sgxx no-stm32_stdperiph_lib no-stm32_usb_fs_device_lib no-svxx_api_reference no-svxx_benchmarks no-svxx_binary no-svxx_copy_variants no-svxx_documentation no-svxx_fftw no-svxx_source no-sysroot_utils no-sysrootinfo no-trace_processor no-uclibc no-uclibc_configs no-verifone_plugin no-w32api no-windows_script_wrapper no-xlp_mdi' '--with-features=sgxx_version no_common gdbsimulator multilibs tarball public elf newlib_newlib cs3 sprite pe' '--with-hosts=i686-pc-linux-gnu i686-mingw32' --with-target-arch-name=Power --with-target-os-name=EABI --with-intermediate-dir=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/getting_started --with-csl-docbook=/scratch/jwlemke/b6/vle-lite6/src/csl-docbook-trunk --with-version-string=2011.09-105 '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' '--with-brand=Sourcery CodeBench Lite' --with-pkg_prefix=freescale '--with-xml-catalog-files=/usr/local/tools/gcc-4.3.3/share/sgml/docbook/docbook-xsl/catalog.xml /etc/xml/catalog' --with-license=lite --with-cs3=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/cs3/doc
popd
popenv
popenv
popenv

# task [094/196] /i686-pc-linux-gnu/getting_started/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/getting_started-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [095/196] /i686-pc-linux-gnu/getting_started/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/getting_started-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share docdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi
popd
popenv
popenv
popenv

# task [096/196] /i686-pc-linux-gnu/csl_docbook
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
cp /scratch/jwlemke/b6/vle-lite6/src/csl-docbook-trunk/css/cs.css /scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html
popenv

# task [097/196] /i686-pc-linux-gnu/gdil/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gdil-trunk --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu --with-csl-docbook=/scratch/jwlemke/b6/vle-lite6/src/csl-docbook-trunk '--with-xml-catalog-files=/usr/local/tools/gcc-4.3.3/share/sgml/docbook/docbook-xsl/catalog.xml /etc/xml/catalog' --disable-nls --with-expat=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr '--with-features=xml autoconf driver config sprite doc'
popd
popenv
popenv
popenv

# task [098/196] /i686-pc-linux-gnu/gdil/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [099/196] /i686-pc-linux-gnu/gdil/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install
popd
popenv
popenv
popenv

# task [100/196] /i686-pc-linux-gnu/power_sprite/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
pushd /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/power_sprite-trunk --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-pc-linux-gnu '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --enable-backends=pe --disable-nls --with-gdil=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-expat=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-pc-linux-gnu/usr --with-boards=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/cs3/boards
popd
popenv
popenv
popenv

# task [101/196] /i686-pc-linux-gnu/power_sprite/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make -j4
popd
popenv
popenv
popenv

# task [102/196] /i686-pc-linux-gnu/power_sprite/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-pc-linux-gnu
make install prefix=/scratch/jwlemke/b6/vle-lite6/install exec_prefix=/scratch/jwlemke/b6/vle-lite6/install libdir=/scratch/jwlemke/b6/vle-lite6/install/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/share
popd
popenv
popenv
popenv

# task [103/196] /i686-pc-linux-gnu/finalize_libc_installation
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
popenv

# task [104/196] /i686-pc-linux-gnu/pretidy_installation
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/install
rm ./lib/rh73/libiberty.a
rmdir ./lib/rh73
popd
popenv

# task [105/196] /i686-pc-linux-gnu/remove_libtool_archives
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
find /scratch/jwlemke/b6/vle-lite6/install -name '*.la' -exec rm '{}' ';'
popenv

# task [106/196] /i686-pc-linux-gnu/remove_copied_libs
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
popenv

# task [107/196] /i686-pc-linux-gnu/remove_fixed_headers
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
pushd /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/include-fixed
popd
popenv

# task [108/196] /i686-pc-linux-gnu/add_tooldir_readme
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
cat > /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/README.txt <<'EOF0'
The executables in this directory are for internal use by the compiler
and may not operate correctly when used directly.  This directory
should not be placed on your PATH.  Instead, you should use the
executables in ../../bin/ and place that directory on your PATH.
EOF0
popenv

# task [109/196] /i686-pc-linux-gnu/strip_host_objects
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-addr2line
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-ar
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-as
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-c++
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-c++filt
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-cpp
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-elfedit
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-g++
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-gcc
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-gcc-4.5.1
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-gcov
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-gdb
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-gdbtui
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-gprof
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-ld
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-nm
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-objcopy
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-objdump
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-ranlib
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-readelf
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-run
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-size
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-sprite
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-strings
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/bin/powerpc-eabi-strip
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/ar
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/as
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/c++
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/g++
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/gcc
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/ld
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/nm
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/objcopy
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/objdump
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/ranlib
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/bin/strip
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/libexec/gcc/powerpc-eabi/4.5.1/cc1
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/libexec/gcc/powerpc-eabi/4.5.1/collect2
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/libexec/gcc/powerpc-eabi/4.5.1/install-tools/fixincl
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/libexec/gcc/powerpc-eabi/4.5.1/cc1plus
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/libexec/gcc/powerpc-eabi/4.5.1/lto-wrapper
/usr/local/tools/gcc-4.3.3/bin/i686-pc-linux-gnu-strip /scratch/jwlemke/b6/vle-lite6/install/libexec/gcc/powerpc-eabi/4.5.1/lto1
popenv

# task [110/196] /i686-pc-linux-gnu/strip_target_objects
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libcs3uboot.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te600/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libcs3uboot.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z3/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libcs3uboot.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v2/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libcs3uboot.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/nof/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te200z0/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libstdc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libsupc++.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libcs3uboot.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libg.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libcs3.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libm.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libcs3unhosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/powerpc-eabi/lib/te500v1/libcs3hosted.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te600/ncrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z3/ncrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v2/ncrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/nof/ncrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te200z0/ncrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/ncrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/libgcov.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/crtend.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/ecrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/ncrtn.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/crtendS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/crtbegin.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/crtbeginS.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/libgcc.a || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/crtbeginT.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/ecrti.o || true
powerpc-eabi-objcopy -R .comment -R .note -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_pubtypes -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc /scratch/jwlemke/b6/vle-lite6/install/lib/gcc/powerpc-eabi/4.5.1/te500v1/ncrti.o || true
popenv

# task [111/196] /i686-pc-linux-gnu/package_tbz2
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
rm -f /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-i686-pc-linux-gnu.tar.bz2
pushd /scratch/jwlemke/b6/vle-lite6/obj
rm -f freescale-2011.09
ln -s /scratch/jwlemke/b6/vle-lite6/install freescale-2011.09
tar cjf /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-i686-pc-linux-gnu.tar.bz2 --owner=0 --group=0 --exclude=host-i686-pc-linux-gnu --exclude=host-i686-mingw32 freescale-2011.09/bin freescale-2011.09/i686-pc-linux-gnu freescale-2011.09/lib freescale-2011.09/libexec freescale-2011.09/powerpc-eabi freescale-2011.09/share
rm -f freescale-2011.09
popd
popenv

# task [112/196] /i686-pc-linux-gnu/package_installanywhere/unpack
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-unpack -i /scratch/jwlemke/b6/vle-lite6/install -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-pc-linux-gnu -e /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras powerpc-vle/powerpc-vle-eabi-lite
popenv

# task [113/196] /i686-pc-linux-gnu/package_installanywhere/merge_modules
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-helper-mm -i /scratch/jwlemke/b6/vle-lite6/install -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-pc-linux-gnu -m iamm-common powerpc-vle/powerpc-vle-eabi-lite
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-helper-mm -i /scratch/jwlemke/b6/vle-lite6/install -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-pc-linux-gnu -m iamm-jvm powerpc-vle/powerpc-vle-eabi-lite
popenv

# task [114/196] /i686-pc-linux-gnu/package_installanywhere/installer
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC 'i686-pc-linux-gnu-gcc -mrh73'
pushenvvar CXX 'i686-pc-linux-gnu-g++ -mrh73'
pushenvvar AR i686-pc-linux-gnu-ar
pushenvvar RANLIB i686-pc-linux-gnu-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/install/bin
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-helper -i /scratch/jwlemke/b6/vle-lite6/install -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-pc-linux-gnu -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/getting_started/license.html -e /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras powerpc-vle/powerpc-vle-eabi-lite
popenv

# task [115/196] /i686-mingw32/host_cleanup
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
popenv

# task [116/196] /i686-mingw32/host_unpack
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32
mkdir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32
ln -s . freescale-2011.09
tar xf /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-i686-pc-linux-gnu.tar.bz2 --bzip2
rm freescale-2011.09
popd
popenv

# task [117/196] /i686-mingw32/libiconv/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/libiconv-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/libiconv-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/libiconv-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/libiconv-1.11 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls
popd
popenv
popenv
popenv

# task [118/196] /i686-mingw32/libiconv/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/libiconv-2011.09-105-powerpc-eabi-i686-mingw32
make -j1
popd
popenv
popenv
popenv

# task [119/196] /i686-mingw32/libiconv/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/libiconv-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [120/196] /i686-mingw32/make/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/make-src-2011.09-105-powerpc-eabi-i686-mingw32
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/make-3.81 /scratch/jwlemke/b6/vle-lite6/obj/make-src-2011.09-105-powerpc-eabi-i686-mingw32
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/make-src-2011.09-105-powerpc-eabi-i686-mingw32
touch /scratch/jwlemke/b6/vle-lite6/obj/make-src-2011.09-105-powerpc-eabi-i686-mingw32/.gnu-stamp
popenv
popenv
popenv

# task [121/196] /i686-mingw32/make/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/make-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/make-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/make-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/make-src-2011.09-105-powerpc-eabi-i686-mingw32 --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --disable-nls --program-prefix=cs-
popd
popenv
popenv
popenv

# task [122/196] /i686-mingw32/make/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/make-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [123/196] /i686-mingw32/make/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/make-2011.09-105-powerpc-eabi-i686-mingw32
make install prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share
popd
popenv
popenv
popenv

# task [124/196] /i686-mingw32/coreutils/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/coreutils-src-2011.09-105-powerpc-eabi-i686-mingw32
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/coreutils-5.94 /scratch/jwlemke/b6/vle-lite6/obj/coreutils-src-2011.09-105-powerpc-eabi-i686-mingw32
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/coreutils-src-2011.09-105-powerpc-eabi-i686-mingw32
touch /scratch/jwlemke/b6/vle-lite6/obj/coreutils-src-2011.09-105-powerpc-eabi-i686-mingw32/.gnu-stamp
popenv
popenv
popenv

# task [125/196] /i686-mingw32/coreutils/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/coreutils-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/coreutils-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/coreutils-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/coreutils-src-2011.09-105-powerpc-eabi-i686-mingw32 --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --disable-nls --program-prefix=cs-
popd
popenv
popenv
popenv

# task [126/196] /i686-mingw32/coreutils/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/coreutils-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [127/196] /i686-mingw32/coreutils/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/coreutils-2011.09-105-powerpc-eabi-i686-mingw32
make install prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share
popd
popenv
popenv
popenv

# task [128/196] /i686-mingw32/zlib_first/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-mingw32
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/zlib-1.2.3 /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-mingw32
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-mingw32
popenv

# task [129/196] /i686-mingw32/zlib_first/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-mingw32
pushenv
pushenvvar CFLAGS '-O3 -fPIC'
pushenvvar CC 'i686-mingw32-gcc '
pushenvvar AR 'i686-mingw32-ar rc'
pushenvvar RANLIB i686-mingw32-ranlib
./configure --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr
popenv
popd
popenv

# task [130/196] /i686-mingw32/zlib_first/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv

# task [131/196] /i686-mingw32/zlib_first/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-first-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv

# task [132/196] /i686-mingw32/gmp/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gmp-2011.09 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=i686-mingw32 --host=i686-mingw32 --enable-cxx --disable-nls
popd
popenv
popenv
popenv

# task [133/196] /i686-mingw32/gmp/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [134/196] /i686-mingw32/gmp/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/jwlemke/b6/vle-lite6/obj/gmp-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [135/196] /i686-mingw32/gmp/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CFLAGS '-g -O2'
popenv
popenv
popenv

# task [136/196] /i686-mingw32/mpfr/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/mpfr-2011.09 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr
popd
popenv
popenv
popenv

# task [137/196] /i686-mingw32/mpfr/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [138/196] /i686-mingw32/mpfr/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpfr-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [139/196] /i686-mingw32/mpfr/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
popenv
popenv
popenv

# task [140/196] /i686-mingw32/mpc/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/mpc-0.9 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-mpfr=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr
popd
popenv
popenv
popenv

# task [141/196] /i686-mingw32/mpc/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [142/196] /i686-mingw32/mpc/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/mpc-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [143/196] /i686-mingw32/mpc/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
popenv
popenv
popenv

# task [144/196] /i686-mingw32/ppl/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/ppl-0.11 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls --with-libgmp-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-gmp-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr CPPFLAGS=-I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include LDFLAGS=-L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib --disable-watchdog
popd
popenv
popenv
popenv

# task [145/196] /i686-mingw32/ppl/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [146/196] /i686-mingw32/ppl/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/ppl-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [147/196] /i686-mingw32/cloog/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/cloog-0.15 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls --with-ppl=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr
popd
popenv
popenv
popenv

# task [148/196] /i686-mingw32/cloog/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [149/196] /i686-mingw32/cloog/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/cloog-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [150/196] /i686-mingw32/cloog/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
popenv
popenv
popenv

# task [151/196] /i686-mingw32/libelf/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/libelf-2011.09 --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls
popd
popenv
popenv
popenv

# task [152/196] /i686-mingw32/libelf/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [153/196] /i686-mingw32/libelf/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/libelf-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [154/196] /i686-mingw32/toolchain/binutils/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-mingw32
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/binutils-powerpc-vle /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-mingw32
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-mingw32
touch /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-mingw32/.gnu-stamp
popenv
popenv
popenv

# task [155/196] /i686-mingw32/toolchain/binutils/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/binutils-src-2011.09-105-powerpc-eabi-i686-mingw32 --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --with-sysroot=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/powerpc-eabi --enable-poison-system-directories
popd
popenv
popenv
popenv

# task [156/196] /i686-mingw32/toolchain/binutils/libiberty
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
make -j4 all-libiberty
popd
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/binutils-powerpc-vle/include /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/include
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/include
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/lib
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32/libiberty/libiberty.a /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/lib
popenv
popenv
popenv

# task [157/196] /i686-mingw32/toolchain/binutils/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [158/196] /i686-mingw32/toolchain/binutils/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
make install prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share
popd
popenv
popenv
popenv

# task [159/196] /i686-mingw32/toolchain/binutils/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32
rm lib/charset.alias
rm bin/powerpc-eabi-embedspu.exe
rm ./lib/libiberty.a
rmdir ./lib
popd
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share install-html
popd
pushd /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share install-pdf
popd
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32/bfd/.libs/libbfd.a /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/lib
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32/bfd/bfd.h /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/include
cp /scratch/jwlemke/b6/vle-lite6/src/binutils-powerpc-vle/bfd/elf-bfd.h /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/include
cp /scratch/jwlemke/b6/vle-lite6/obj/binutils-2011.09-105-powerpc-eabi-i686-mingw32/opcodes/.libs/libopcodes.a /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-binutils-i686-mingw32/usr/lib
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/configure.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/etc/configure.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/configure.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly configure
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/standards.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/etc/standards.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/standards.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly standards
rmdir /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/etc
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/bfd.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/bfd.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/bfd.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly bfd
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-ld.bfd.exe
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/ld.bfd.exe
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/ld.bfd.exe
popenv
popenv
popenv

# task [160/196] /i686-mingw32/toolchain/copy_libs
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/share/doc/freescale-powerpc-eabi/html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/share/doc/freescale-powerpc-eabi/info /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/share/doc/freescale-powerpc-eabi/man /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man
cp /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/share/doc/freescale-powerpc-eabi/LICENSE.txt /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/lib /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/lib
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/include /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/include
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/include/c++ /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/include/c++
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/lib/gcc/powerpc-eabi /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib/gcc/powerpc-eabi
popenv

# task [161/196] /i686-mingw32/toolchain/gcc_final/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushenvvar CC_FOR_TARGET powerpc-eabi-gcc
pushenvvar GCC_FOR_TARGET powerpc-eabi-gcc
pushenvvar CXX_FOR_TARGET powerpc-eabi-g++
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
ln -s . /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gcc-powerpc-vle --build=i686-pc-linux-gnu --host=i686-mingw32 --target=powerpc-eabi --enable-threads --disable-libmudflap --disable-libssp --disable-libstdcxx-pch --enable-extra-sgxxlite-multilibs --disable-threads --with-cpu=603e --enable-extra-sgxxlite-multilibs --with-gnu-as --with-gnu-ld '--with-specs=%{save-temps: -fverbose-asm} -D__CS_SOURCERYGXX_MAJ__=2011 -D__CS_SOURCERYGXX_MIN__=9 -D__CS_SOURCERYGXX_REV__=105 %{!fcommon:%{!fno-common:-fno-common}} %{O2:%{!fno-remove-local-statics: -fremove-local-statics}} %{O*:%{O|O0|O1|O2|Os:;:%{!fno-remove-local-statics: -fremove-local-statics}}} %{Os: %{!fno-remove-local-statics: -fremove-local-statics}}' --enable-languages=c,c++ --disable-shared --enable-lto --with-newlib '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --with-headers=yes --with-sysroot=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/powerpc-eabi --with-build-sysroot=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi --with-libiconv-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-gmp=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-mpfr=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-mpc=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-ppl=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr '--with-host-libstdcxx=-static-libgcc -Wl,-Bstatic,-lstdc++,-Bdynamic -lm' --with-cloog=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-libelf=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-libgomp --disable-libitm --enable-poison-system-directories --with-build-time-tools=/scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/bin --with-build-time-tools=/scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/bin
popd
popenv
popenv

# task [162/196] /i686-mingw32/toolchain/gcc_final/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushenvvar CC_FOR_TARGET powerpc-eabi-gcc
pushenvvar GCC_FOR_TARGET powerpc-eabi-gcc
pushenvvar CXX_FOR_TARGET powerpc-eabi-g++
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
ln -s . /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-mingw32
make -j4 LDFLAGS_FOR_TARGET=--sysroot=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi CPPFLAGS_FOR_TARGET=--sysroot=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi build_tooldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi all-gcc
popd
popenv
popenv

# task [163/196] /i686-mingw32/toolchain/gcc_final/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushenvvar CC_FOR_TARGET powerpc-eabi-gcc
pushenvvar GCC_FOR_TARGET powerpc-eabi-gcc
pushenvvar CXX_FOR_TARGET powerpc-eabi-g++
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
ln -s . /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
pushd /scratch/jwlemke/b6/vle-lite6/obj/gcc-2011.09-105-powerpc-eabi-i686-mingw32
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man install-gcc
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man install-html-gcc
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man install-pdf-gcc
popd
popenv
popenv

# task [164/196] /i686-mingw32/toolchain/gcc_final/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenvvar AR_FOR_TARGET powerpc-eabi-ar
pushenvvar NM_FOR_TARGET powerpc-eabi-nm
pushenvvar OBJDUMP_FOR_TARET powerpc-eabi-objdump
pushenvvar STRIP_FOR_TARGET powerpc-eabi-strip
pushenvvar CC_FOR_TARGET powerpc-eabi-gcc
pushenvvar GCC_FOR_TARGET powerpc-eabi-gcc
pushenvvar CXX_FOR_TARGET powerpc-eabi-g++
pushd /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32
rm bin/powerpc-eabi-gccbug
rmdir include
popd
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/lib/gcc/powerpc-eabi /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib/gcc/powerpc-eabi
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/lib /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/lib
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/powerpc-eabi/include/c++ /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/include/c++
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/usr
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/gccinstall /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/gcc/gccinstall.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/gccinstall.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly gccinstall
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/gccint /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/gcc/gccint.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/gccint.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly gccint
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/cppinternals /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/gcc/cppinternals.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/cppinternals.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly cppinternals
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
popenv
popenv

# task [165/196] /i686-mingw32/toolchain/zlib/0/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-mingw32
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/zlib-1.2.3 /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-mingw32
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-mingw32
popenv

# task [166/196] /i686-mingw32/toolchain/zlib/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-mingw32
pushenv
pushenvvar CFLAGS '-O3 -fPIC'
pushenvvar CC 'i686-mingw32-gcc '
pushenvvar AR 'i686-mingw32-ar rc'
pushenvvar RANLIB i686-mingw32-ranlib
./configure --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr
popenv
popd
popenv

# task [167/196] /i686-mingw32/toolchain/zlib/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv

# task [168/196] /i686-mingw32/toolchain/zlib/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/obj/zlib-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv

# task [169/196] /i686-mingw32/toolchain/expat/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/expat-mirror --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --disable-nls
popd
popenv
popenv
popenv

# task [170/196] /i686-mingw32/toolchain/expat/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [171/196] /i686-mingw32/toolchain/expat/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/expat-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [172/196] /i686-mingw32/toolchain/gdb/0/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-mingw32
copy_dir_clean /scratch/jwlemke/b6/vle-lite6/src/gdb-powerpc-vle /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-mingw32
chmod -R u+w /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-mingw32
touch /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-mingw32/.gnu-stamp
popenv
popenv
popenv

# task [173/196] /i686-mingw32/toolchain/gdb/0/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/obj/gdb-src-2011.09-105-powerpc-eabi-i686-mingw32 --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --enable-sim-float=altivec '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-libmcheck --disable-nls --with-libexpat-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-libiconv-prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-system-gdbinit=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi/i686-mingw32/powerpc-eabi/lib/gdbinit '--with-gdb-datadir='\''${prefix}'\''/powerpc-eabi/share/gdb'
popd
popenv
popenv
popenv

# task [174/196] /i686-mingw32/toolchain/gdb/0/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [175/196] /i686-mingw32/toolchain/gdb/0/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-mingw32
make install prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share
popd
popenv
popenv
popenv

# task [176/196] /i686-mingw32/toolchain/gdb/0/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushenvvar CPPFLAGS -I/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/include
pushenvvar LDFLAGS -L/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr/lib
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdb-2011.09-105-powerpc-eabi-i686-mingw32
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share install-html
make prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share install-pdf
popd
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/annotate /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/annotate.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/annotate.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly annotate
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/gdbint /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/gdbint.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/gdbint.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly gdbint
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/stabs /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/stabs.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/stabs.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly stabs
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/configure.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/etc/configure.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/configure.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly configure
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/standards.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/etc/standards.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/standards.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly standards
rmdir /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/etc
rm -rf /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/bfd.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/bfd.pdf
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info/bfd.info
install-info --infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info --remove-exactly bfd
rm -f /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html/libiberty.html /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf/libiberty.pdf
popenv
popenv
popenv

# task [177/196] /i686-mingw32/gdil/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/gdil-trunk --prefix=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --disable-shared --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 --with-csl-docbook=/scratch/jwlemke/b6/vle-lite6/src/csl-docbook-trunk '--with-xml-catalog-files=/usr/local/tools/gcc-4.3.3/share/sgml/docbook/docbook-xsl/catalog.xml /etc/xml/catalog' --disable-nls --with-expat=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr '--with-features=xml autoconf driver config sprite doc'
popd
popenv
popenv
popenv

# task [178/196] /i686-mingw32/gdil/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [179/196] /i686-mingw32/gdil/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/gdil-2011.09-105-powerpc-eabi-i686-mingw32
make install
popd
popenv
popenv
popenv

# task [180/196] /i686-mingw32/power_sprite/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
rm -rf /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-mingw32
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-mingw32
pushd /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-mingw32
check_mentor_trademarks /scratch/jwlemke/b6/vle-lite6/src/power_sprite-trunk --prefix=/opt/freescale/usr/local/gcc-4.6.1.105-newlib-1.18.0.105/powerpc-eabi --build=i686-pc-linux-gnu --target=powerpc-eabi --host=i686-mingw32 '--with-pkgversion=Sourcery CodeBench Lite 2011.09-105' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --enable-backends=pe --disable-nls --with-gdil=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-expat=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/host-libs-i686-mingw32/usr --with-boards=/scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/cs3/boards
popd
popenv
popenv
popenv

# task [181/196] /i686-mingw32/power_sprite/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-mingw32
make -j4
popd
popenv
popenv
popenv

# task [182/196] /i686-mingw32/power_sprite/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushenv
pushenv
pushd /scratch/jwlemke/b6/vle-lite6/obj/power_sprite-2011.09-105-powerpc-eabi-i686-mingw32
make install prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 exec_prefix=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 libdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib htmldir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/html pdfdir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/pdf infodir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/info mandir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share/doc/freescale-powerpc-eabi/man datadir=/scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/share
popd
popenv
popenv
popenv

# task [183/196] /i686-mingw32/pretidy_installation
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32
rm ./lib/libiberty.a
popd
popenv

# task [184/196] /i686-mingw32/remove_libtool_archives
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
find /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 -name '*.la' -exec rm '{}' ';'
popenv

# task [185/196] /i686-mingw32/remove_copied_libs
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
popenv

# task [186/196] /i686-mingw32/remove_fixed_headers
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
pushd /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/lib/gcc/powerpc-eabi/4.5.1/include-fixed
popd
popenv

# task [187/196] /i686-mingw32/add_tooldir_readme
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
cat > /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/README.txt <<'EOF0'
The executables in this directory are for internal use by the compiler
and may not operate correctly when used directly.  This directory
should not be placed on your PATH.  Instead, you should use the
executables in ../../bin/ and place that directory on your PATH.
EOF0
popenv

# task [188/196] /i686-mingw32/strip_host_objects
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/cs-make.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/cs-rm.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-addr2line.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-ar.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-as.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-c++.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-c++filt.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-cpp.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-elfedit.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-g++.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-gcc-4.5.1.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-gcc.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-gcov.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-gdb.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-gprof.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-ld.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-nm.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-objcopy.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-objdump.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-ranlib.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-readelf.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-run.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-size.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-sprite.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-strings.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/bin/powerpc-eabi-strip.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/ar.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/as.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/c++.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/g++.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/gcc.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/ld.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/nm.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/objcopy.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/objdump.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/ranlib.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/powerpc-eabi/bin/strip.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/libexec/gcc/powerpc-eabi/4.5.1/cc1.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/libexec/gcc/powerpc-eabi/4.5.1/collect2.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/libexec/gcc/powerpc-eabi/4.5.1/install-tools/fixincl.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/libexec/gcc/powerpc-eabi/4.5.1/cc1plus.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/libexec/gcc/powerpc-eabi/4.5.1/lto-wrapper.exe
i686-mingw32-strip /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32/libexec/gcc/powerpc-eabi/4.5.1/lto1.exe
popenv

# task [189/196] /i686-mingw32/package_tbz2
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
rm -f /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-i686-mingw32.tar.bz2
pushd /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32
popd
pushd /scratch/jwlemke/b6/vle-lite6/obj
rm -f freescale-2011.09
ln -s /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 freescale-2011.09
tar cjf /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-i686-mingw32.tar.bz2 --owner=0 --group=0 --exclude=host-i686-pc-linux-gnu --exclude=host-i686-mingw32 freescale-2011.09/bin freescale-2011.09/i686-mingw32 freescale-2011.09/lib freescale-2011.09/libexec freescale-2011.09/powerpc-eabi freescale-2011.09/share
rm -f freescale-2011.09
popd
popenv

# task [190/196] /i686-mingw32/package_installanywhere/unpack
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-unpack -i /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-mingw32 -e /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras powerpc-vle/powerpc-vle-eabi-lite
popenv

# task [191/196] /i686-mingw32/package_installanywhere/merge_modules
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-helper-mm -i /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-mingw32 -m iamm-common powerpc-vle/powerpc-vle-eabi-lite
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-helper-mm -i /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-mingw32 -m iamm-jvm powerpc-vle/powerpc-vle-eabi-lite
popenv

# task [192/196] /i686-mingw32/package_installanywhere/installer
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
pushenvvar CC i686-mingw32-gcc
pushenvvar CXX i686-mingw32-g++
pushenvvar AR i686-mingw32-ar
pushenvvar RANLIB i686-mingw32-ranlib
prepend_path PATH /scratch/jwlemke/b6/vle-lite6/obj/tools-i686-pc-linux-gnu-2011.09-105-powerpc-eabi-i686-mingw32/bin
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-ia-helper -i /scratch/jwlemke/b6/vle-lite6/install/host-i686-mingw32 -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -h i686-mingw32 -f /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras/getting_started/license.html -e /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras powerpc-vle/powerpc-vle-eabi-lite
popenv

# task [193/196] /fini/extras_package
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.extras
pushd /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi
tar cjf /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi.extras.tar.bz2 --owner=0 --group=0 freescale-2011.09-105-powerpc-eabi.extras
popd
popenv

# task [194/196] /fini/build_summary
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
cat > /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-summary.xml <<'EOF0'
<?xml version="1.0" ?><build><variable var="release_config_canonical" value="powerpc-vle/powerpc-vle-eabi-lite"/><variable var="version" value="2011.09-105"/><variable var="hosts_string" value="i686-pc-linux-gnu i686-mingw32"/><variable var="target" value="powerpc-eabi"/><variable var="build_date" value="20130106"/><variable var="HOSTNAME" value="build6-lucid-cs"/><variable var="build_operating_system" value="squeeze/sid"/><variable var="build_uname" value="Linux build6-lucid-cs 2.6.32-28-generic #55-Ubuntu SMP Mon Jan 10 23:42:43 UTC 2011 x86_64 GNU/Linux"/><variable var="USER" value="jwlemke"/><checksum type="md5" value="c346647f7e3f369f5ed74facf4441952" file="freescale-2011.09-105-powerpc-eabi-i686-pc-linux-gnu.tar.bz2"/><checksum type="md5" value="b8114482211753bf79ccde609b27aa69" file="freescale-2011.09-105-powerpc-eabi-i686-mingw32.tar.bz2"/><checksum type="md5" value="525a661f215ff52215b0905e88bc2cae" file="freescale-2011.09-105-powerpc-eabi.extras.tar.bz2"/></build>
EOF0
popenv

# task [195/196] /fini/backups_package
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi.backup
pushd /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi
tar cjf /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi.backup.tar.bz2 --owner=0 --group=0 freescale-2011.09-105-powerpc-eabi.backup
popd
popenv

# task [196/196] /fini/sources_package
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CXX_FOR_BUILD i686-pc-linux-gnu-g++
mkdir -p /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
cp /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi-summary.xml /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
cp /scratch/jwlemke/b6/vle-lite6/logs/freescale-2011.09-105-powerpc-eabi.sh /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi/freescale-2011.09-105-powerpc-eabi
pushd /scratch/jwlemke/b6/vle-lite6/obj/pkg-2011.09-105-powerpc-eabi
tar cjf /scratch/jwlemke/b6/vle-lite6/pkg/freescale-2011.09-105-powerpc-eabi.src.tar.bz2 --owner=0 --group=0 freescale-2011.09-105-powerpc-eabi
popd
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-test -i /scratch/jwlemke/b6/vle-lite6/install -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -T /scratch/jwlemke/b6/vle-lite6/obj/testlogs-2011.09-105-powerpc-eabi powerpc-vle/powerpc-vle-eabi-lite
copy_dir /scratch/jwlemke/b6/vle-lite6/obj/testlogs-2011.09-105-powerpc-eabi /scratch/jwlemke/b6/vle-lite6/testlogs
/scratch/jwlemke/b6/vle-lite6/src/scripts-trunk/gnu-test-package -i /scratch/jwlemke/b6/vle-lite6/install -l /scratch/jwlemke/b6/vle-lite6/logs -o /scratch/jwlemke/b6/vle-lite6/obj -p /scratch/jwlemke/b6/vle-lite6/pkg -s /scratch/jwlemke/b6/vle-lite6/src -T /scratch/jwlemke/b6/vle-lite6/testlogs -T /scratch/jwlemke/b6/vle-lite6/obj/testlogs-2011.09-105-powerpc-eabi powerpc-vle/powerpc-vle-eabi-lite
