var search_data = {"index":{"searchIndex":["curses","key","mouseevent","pad","window","object","<<()","escdelay()","escdelay=()","tabsize()","tabsize=()","addch()","addch()","addstr()","addstr()","attroff()","attroff()","attron()","attron()","attrset()","attrset()","beep()","begx()","begy()","bkgd()","bkgd()","bkgdset()","bkgdset()","box()","can_change_color?()","cbreak()","clear()","clear()","close()","close_screen()","closed?()","clrtoeol()","clrtoeol()","color_content()","color_pair()","color_pairs()","color_set()","colors()","cols()","crmode()","curs_set()","curx()","cury()","def_prog_mode()","delch()","delch()","deleteln()","deleteln()","doupdate()","echo()","flash()","getbkgd()","getch()","getch()","getmouse()","getstr()","getstr()","has_colors?()","have_all()","idlok()","inch()","inch()","init_color()","init_pair()","init_screen()","insch()","insch()","insertln()","insertln()","keyname()","keypad()","keypad=()","lines()","maxx()","maxy()","mouseinterval()","mousemask()","move()","new()","new()","nl()","nocbreak()","nocrmode()","nodelay=()","noecho()","nonl()","noraw()","noutrefresh()","noutrefresh()","pair_content()","pair_number()","raw()","refresh()","refresh()","refresh()","reset_prog_mode()","resize()","resize()","resizeterm()","scrl()","scrl()","scroll()","scrollok()","setpos()","setpos()","setscrreg()","setscrreg()","standend()","standend()","standout()","standout()","start_color()","stdscr()","subpad()","subwin()","timeout=()","timeout=()","ungetch()","ungetmouse()","use_default_colors()","history","manifest","readme","makefile","depend"],"longSearchIndex":["curses","curses::key","curses::mouseevent","curses::pad","curses::window","object","curses::window#<<()","curses::escdelay()","curses::escdelay=()","curses::tabsize()","curses::tabsize=()","curses::addch()","curses::window#addch()","curses::addstr()","curses::window#addstr()","curses::attroff()","curses::window#attroff()","curses::attron()","curses::window#attron()","curses::attrset()","curses::window#attrset()","curses::beep()","curses::window#begx()","curses::window#begy()","curses::bkgd()","curses::window#bkgd()","curses::bkgdset()","curses::window#bkgdset()","curses::window#box()","curses::can_change_color?()","curses::cbreak()","curses::clear()","curses::window#clear()","curses::window#close()","curses::close_screen()","curses::closed?()","curses::clrtoeol()","curses::window#clrtoeol()","curses::color_content()","curses::color_pair()","curses::color_pairs()","curses::window#color_set()","curses::colors()","curses::cols()","curses::crmode()","curses::curs_set()","curses::window#curx()","curses::window#cury()","curses::def_prog_mode()","curses::delch()","curses::window#delch()","curses::deleteln()","curses::window#deleteln()","curses::doupdate()","curses::echo()","curses::flash()","curses::window#getbkgd()","curses::getch()","curses::window#getch()","curses::getmouse()","curses::getstr()","curses::window#getstr()","curses::has_colors?()","object#have_all()","curses::window#idlok()","curses::inch()","curses::window#inch()","curses::init_color()","curses::init_pair()","curses::init_screen()","curses::insch()","curses::window#insch()","curses::insertln()","curses::window#insertln()","curses::keyname()","curses::window#keypad()","curses::window#keypad=()","curses::lines()","curses::window#maxx()","curses::window#maxy()","curses::mouseinterval()","curses::mousemask()","curses::window#move()","curses::pad::new()","curses::window::new()","curses::nl()","curses::nocbreak()","curses::nocrmode()","curses::window#nodelay=()","curses::noecho()","curses::nonl()","curses::noraw()","curses::pad#noutrefresh()","curses::window#noutrefresh()","curses::pair_content()","curses::pair_number()","curses::raw()","curses::refresh()","curses::pad#refresh()","curses::window#refresh()","curses::reset_prog_mode()","curses::resize()","curses::window#resize()","curses::resizeterm()","curses::scrl()","curses::window#scrl()","curses::window#scroll()","curses::window#scrollok()","curses::setpos()","curses::window#setpos()","curses::setscrreg()","curses::window#setscrreg()","curses::standend()","curses::window#standend()","curses::standout()","curses::window#standout()","curses::start_color()","curses::stdscr()","curses::pad#subpad()","curses::window#subwin()","curses::timeout=()","curses::window#timeout=()","curses::ungetch()","curses::ungetmouse()","curses::use_default_colors()","","","","",""],"info":[["Curses","","Curses.html","","<p>Description\n<p>An implementation of the CRT screen handling and optimization library.\n<p>Structures and such …\n"],["Curses::Key","","Curses/Key.html","","<p>a container for the KEY_* values.\n<p>See also system manual for getch(3)\n"],["Curses::MouseEvent","","Curses/MouseEvent.html","","<p>Description\n<p>Curses::MouseEvent\n<p>Example\n"],["Curses::Pad","","Curses/Pad.html","","<p>Description\n<p>A Pad is like a Window but allows for scrolling of contents that cannot fit\non the screen. …\n"],["Curses::Window","","Curses/Window.html","","<p>Description\n<p>The means by which to create and manage frames or windows. While there may\nbe more than one …\n"],["Object","","Object.html","",""],["<<","Curses::Window","Curses/Window.html#method-i-3C-3C","(p1)","<p>&lt;&lt;\n<p>Add String <code>str</code> to the current string.\n<p>See also Curses::Window.addstr\n"],["ESCDELAY","Curses","Curses.html#method-c-ESCDELAY","()","<p>Returns the total time, in milliseconds, for which curses will await a\ncharacter sequence, e.g., a function …\n"],["ESCDELAY=","Curses","Curses.html#method-c-ESCDELAY-3D","(p1)","<p>Sets the ESCDELAY to Integer <code>value</code>\n"],["TABSIZE","Curses","Curses.html#method-c-TABSIZE","()","<p>Returns the number of positions in a tab.\n"],["TABSIZE=","Curses","Curses.html#method-c-TABSIZE-3D","(p1)","<p>Sets the TABSIZE to Integer <code>value</code>\n"],["addch","Curses","Curses.html#method-c-addch","(p1)","<p>Add a character <code>ch</code>, with attributes, then advance the cursor.\n<p>see also the system manual for curs_addch …\n"],["addch","Curses::Window","Curses/Window.html#method-i-addch","(p1)","<p>Add a character <code>ch</code>, with attributes, to the window, then\nadvance the cursor.\n<p>see also the system manual …\n"],["addstr","Curses","Curses.html#method-c-addstr","(p1)","<p>add a string of characters <code>str</code>, to the window and advance\ncursor\n"],["addstr","Curses::Window","Curses/Window.html#method-i-addstr","(p1)","<p>add a string of characters <code>str</code>, to the window and advance\ncursor\n"],["attroff","Curses","Curses.html#method-c-attroff","(p1)","<p>Turns on the named attributes <code>attrs</code> without affecting any\nothers.\n<p>See also Curses::Window.attrset for …\n"],["attroff","Curses::Window","Curses/Window.html#method-i-attroff","(p1)","<p>Turns on the named attributes <code>attrs</code> without affecting any\nothers.\n<p>See also Curses::Window.attrset\n"],["attron","Curses","Curses.html#method-c-attron","(p1)","<p>Turns off the named attributes <code>attrs</code> without turning any other\nattributes on or off.\n<p>See also Curses::Window.attrset …\n"],["attron","Curses::Window","Curses/Window.html#method-i-attron","(p1)","<p>Turns off the named attributes <code>attrs</code> without turning any other\nattributes on or off.\n<p>See also Curses::Window.attrset …\n"],["attrset","Curses","Curses.html#method-c-attrset","(p1)","<p>Sets the current attributes of the given window to <code>attrs</code>.\n<p>see also Curses::Window.attrset\n"],["attrset","Curses::Window","Curses/Window.html#method-i-attrset","(p1)","<p>Sets the current attributes of the given window to <code>attrs</code>.\n<p>The following video attributes, defined in &lt;curses.h&gt;, …\n"],["beep","Curses","Curses.html#method-c-beep","()","<p>Sounds an audible alarm on the terminal, if possible; otherwise it flashes\nthe screen (visual bell). …\n"],["begx","Curses::Window","Curses/Window.html#method-i-begx","()","<p>A getter for the beginning column (X coord) of the window\n"],["begy","Curses::Window","Curses/Window.html#method-i-begy","()","<p>A getter for the beginning line (Y coord) of the window\n"],["bkgd","Curses","Curses.html#method-c-bkgd","(p1)","<p>Window background manipulation routines.\n<p>Set the background property of the current and then apply the …\n"],["bkgd","Curses::Window","Curses/Window.html#method-i-bkgd","(p1)","<p>Set the background of the current window and apply character Integer\n<code>ch</code> to every character.\n<p>see also  …\n"],["bkgdset","Curses","Curses.html#method-c-bkgdset","(p1)","<p>Manipulate the background of the named window with character Integer\n<code>ch</code>\n<p>The background becomes a property …\n"],["bkgdset","Curses::Window","Curses/Window.html#method-i-bkgdset","(p1)","<p>Manipulate the background of the current window with character Integer\n<code>ch</code>\n<p>see also Curses.bkgdset\n"],["box","Curses::Window","Curses/Window.html#method-i-box","(p1, p2, p3 = v3)","<p>set the characters to frame the window in. The vertical <code>vert</code>\nand horizontal <code>hor</code> character.\n\n<pre>win = Curses::Window.new(5,5,5,5) ...</pre>\n"],["can_change_color?","Curses","Curses.html#method-c-can_change_color-3F","()","<p>Returns <code>true</code> or <code>false</code> depending on whether the\nterminal can change color attributes\n"],["cbreak","Curses","Curses.html#method-c-cbreak","()","<p>Put the terminal into cbreak mode.\n<p>Normally, the tty driver buffers typed characters until a newline or …\n"],["clear","Curses","Curses.html#method-c-clear","()","<p>Clears every position on the screen completely, so that a subsequent call\nby Curses.refresh for the  …\n"],["clear","Curses::Window","Curses/Window.html#method-i-clear","()","<p>Clear the window.\n"],["close","Curses::Window","Curses/Window.html#method-i-close","()","<p>Deletes the window, and frees the memory\n"],["close_screen","Curses","Curses.html#method-c-close_screen","()","<p>A program should always call Curses.close_screen before exiting or escaping\nfrom curses mode temporarily. …\n"],["closed?","Curses","Curses.html#method-c-closed-3F","()","<p>Returns <code>true</code> if the window/screen has been closed, without any\nsubsequent Curses.refresh calls, returns …\n"],["clrtoeol","Curses","Curses.html#method-c-clrtoeol","()","<p>Clears to the end of line, that the cursor is currently on.\n"],["clrtoeol","Curses::Window","Curses/Window.html#method-i-clrtoeol","()","<p>Clear the window to the end of line, that the cursor is currently on.\n"],["color_content","Curses","Curses.html#method-c-color_content","(p1)","<p>Returns an 3 item Array of the RGB values in <code>color</code>\n"],["color_pair","Curses","Curses.html#method-c-color_pair","(p1)","<p>Sets the color pair attributes to <code>attrs</code>.\n<p>This should be equivalent to Curses.attrset(COLOR_PAIR(<code>attrs</code> …\n"],["color_pairs","Curses","Curses.html#method-c-color_pairs","()","<p>Returns the COLOR_PAIRS available, if the curses library supports it.\n"],["color_set","Curses::Window","Curses/Window.html#method-i-color_set","(p1)","<p>Sets the current color of the given window to the foreground/background\ncombination described by the …\n"],["colors","Curses","Curses.html#method-c-colors","()","<p>returns COLORS\n"],["cols","Curses","Curses.html#method-c-cols","()","<p>Returns the number of columns on the screen\n"],["crmode","Curses","Curses.html#method-c-crmode","()","<p>Put the terminal into cbreak mode.\n<p>Normally, the tty driver buffers typed characters until a newline or …\n"],["curs_set","Curses","Curses.html#method-c-curs_set","(p1)","<p>Sets Cursor Visibility. 0: invisible 1: visible 2: very visible\n"],["curx","Curses::Window","Curses/Window.html#method-i-curx","()","<p>A getter for the current column (X coord) of the window\n"],["cury","Curses::Window","Curses/Window.html#method-i-cury","()","<p>A getter for the current line (Y coord) of the window\n"],["def_prog_mode","Curses","Curses.html#method-c-def_prog_mode","()","<p>Save the current terminal modes as the “program” state for use by the\nCurses.reset_prog_mode …\n"],["delch","Curses","Curses.html#method-c-delch","()","<p>Delete the character under the cursor\n"],["delch","Curses::Window","Curses/Window.html#method-i-delch","()","<p>Delete the character under the cursor\n"],["deleteln","Curses","Curses.html#method-c-deleteln","()","<p>Delete the line under the cursor.\n"],["deleteln","Curses::Window","Curses/Window.html#method-i-deleteln","()","<p>Delete the line under the cursor.\n"],["doupdate","Curses","Curses.html#method-c-doupdate","()","<p>Refreshes the windows and lines.\n<p>Curses.doupdate allows multiple updates with more efficiency than\nCurses.refresh …\n"],["echo","Curses","Curses.html#method-c-echo","()","<p>Enables characters typed by the user to be echoed by Curses.getch as they\nare typed.\n"],["flash","Curses","Curses.html#method-c-flash","()","<p>Flashes the screen, for visual alarm on the terminal, if possible;\notherwise it sounds the alert.\n<p>see …\n"],["getbkgd","Curses::Window","Curses/Window.html#method-i-getbkgd","()","<p>Returns an Integer (<code>ch</code>) for the character property in the\ncurrent window.\n"],["getch","Curses","Curses.html#method-c-getch","()","<p>Read and returns a character from the window.\n<p>See Curses::Key to all the function KEY_* available\n"],["getch","Curses::Window","Curses/Window.html#method-i-getch","()","<p>Read and returns a character from the window.\n<p>See Curses::Key to all the function KEY_* available\n"],["getmouse","Curses","Curses.html#method-c-getmouse","()","<p>Returns coordinates of the mouse.\n<p>This will read and pop the mouse event data off the queue\n<p>See the BUTTON*, …\n"],["getstr","Curses","Curses.html#method-c-getstr","()","<p>This is equivalent to a series f Curses::Window.getch calls\n"],["getstr","Curses::Window","Curses/Window.html#method-i-getstr","()","<p>This is equivalent to a series f Curses::Window.getch calls\n"],["has_colors?","Curses","Curses.html#method-c-has_colors-3F","()","<p>Returns <code>true</code> or <code>false</code> depending on whether the\nterminal has color capabilities.\n"],["have_all","Object","Object.html#method-i-have_all","(*args)",""],["idlok","Curses::Window","Curses/Window.html#method-i-idlok","(p1)","<p>If <code>bool</code> is <code>true</code> curses considers using the\nhardware insert/delete line feature of terminals so equipped. …\n"],["inch","Curses","Curses.html#method-c-inch","()","<p>Returns the character at the current position.\n"],["inch","Curses::Window","Curses/Window.html#method-i-inch","()","<p>Returns the character at the current position of the window.\n"],["init_color","Curses","Curses.html#method-c-init_color","(p1, p2, p3, p4)","<p>Changes the definition of a color. It takes four arguments:\n<p>the number of the color to be changed, <code>color</code> …\n"],["init_pair","Curses","Curses.html#method-c-init_pair","(p1, p2, p3)","<p>Changes the definition of a color-pair.\n<p>It takes three arguments: the number of the color-pair to be changed …\n"],["init_screen","Curses","Curses.html#method-c-init_screen","()","<p>Initialize a standard screen\n<p>see also Curses.stdscr\n"],["insch","Curses","Curses.html#method-c-insch","(p1)","<p>Insert a character <code>ch</code>, before the cursor.\n"],["insch","Curses::Window","Curses/Window.html#method-i-insch","(p1)","<p>Insert a character <code>ch</code>, before the cursor, in the current\nwindow\n"],["insertln","Curses","Curses.html#method-c-insertln","()","<p>Inserts a line above the cursor, and the bottom line is lost\n"],["insertln","Curses::Window","Curses/Window.html#method-i-insertln","()","<p>Inserts a line above the cursor, and the bottom line is lost\n"],["keyname","Curses","Curses.html#method-c-keyname","(p1)","<p>Returns the character string corresponding to key <code>c</code>\n"],["keypad","Curses::Window","Curses/Window.html#method-i-keypad","(p1)","<p>Enables the keypad of the user&#39;s terminal.\n<p>If enabled (<code>bool</code> is <code>true</code>), the user can press a\nfunction …\n"],["keypad=","Curses::Window","Curses/Window.html#method-i-keypad-3D","(p1)","<p>Enables the keypad of the user&#39;s terminal.\n<p>If enabled (<code>bool</code> is <code>true</code>), the user can press a\nfunction …\n"],["lines","Curses","Curses.html#method-c-lines","()","<p>Returns the number of lines on the screen\n"],["maxx","Curses::Window","Curses/Window.html#method-i-maxx","()","<p>A getter for the maximum columns for the window\n"],["maxy","Curses::Window","Curses/Window.html#method-i-maxy","()","<p>A getter for the maximum lines for the window\n"],["mouseinterval","Curses","Curses.html#method-c-mouseinterval","(p1)","<p>The Curses.mouseinterval function sets the maximum time (in thousands of a\nsecond) that can elapse between …\n"],["mousemask","Curses","Curses.html#method-c-mousemask","(p1)","<p>Returns the <code>mask</code> of the reportable events\n"],["move","Curses::Window","Curses/Window.html#method-i-move","(p1, p2)","<p>Moves the window so that the upper left-hand corner is at position\n(<code>y</code>, <code>x</code>)\n"],["new","Curses::Pad","Curses/Pad.html#method-c-new","(p1, p2)","<p>Construct a new Curses::Pad with constraints of <code>height</code> lines,\n<code>width</code> columns\n"],["new","Curses::Window","Curses/Window.html#method-c-new","(p1, p2, p3, p4)","<p>Construct a new Curses::Window with constraints of <code>height</code>\nlines, <code>width</code> columns, begin at <code>top</code> line, and …\n"],["nl","Curses","Curses.html#method-c-nl","()","<p>Enable the underlying display device to translate the return key into\nnewline on input, and whether it …\n"],["nocbreak","Curses","Curses.html#method-c-nocbreak","()","<p>Put the terminal into normal mode (out of cbreak mode).\n<p>See Curses.cbreak for more detail.\n"],["nocrmode","Curses","Curses.html#method-c-nocrmode","()","<p>Put the terminal into normal mode (out of cbreak mode).\n<p>See Curses.cbreak for more detail.\n"],["nodelay=","Curses::Window","Curses/Window.html#method-i-nodelay-3D","(p1)","<p>When in no-delay mode Curses::Window#getch is a non-blocking call.  If no\ninput is ready #getch returns …\n"],["noecho","Curses","Curses.html#method-c-noecho","()","<p>Disables characters typed by the user to be echoed by Curses.getch as they\nare typed.\n"],["nonl","Curses","Curses.html#method-c-nonl","()","<p>Disable the underlying display device to translate the return key into\nnewline on input\n<p>See Curses.nl …\n"],["noraw","Curses","Curses.html#method-c-noraw","()","<p>Put the terminal out of raw mode.\n<p>see Curses.raw for more detail\n"],["noutrefresh","Curses::Pad","Curses/Pad.html#method-i-noutrefresh","(p1, p2, p3, p4, p5, p6)","<p>Refreshes the pad.  <code>pad_minrow</code> and pad_mincol+ define the\nupper-left corner of the rectangle to be displayed. …\n"],["noutrefresh","Curses::Window","Curses/Window.html#method-i-noutrefresh","()","<p>Refreshes the windows and lines.\n<p>Curses::Window.noutrefresh allows multiple updates with more efficiency …\n"],["pair_content","Curses","Curses.html#method-c-pair_content","(p1)","<p>Returns a 2 item Array, with the foreground and background color, in\n<code>pair</code>\n"],["pair_number","Curses","Curses.html#method-c-pair_number","(p1)","<p>Returns the Fixnum color pair number of attributes <code>attrs</code>.\n"],["raw","Curses","Curses.html#method-c-raw","()","<p>Put the terminal into raw mode.\n<p>Raw mode is similar to Curses.cbreak mode, in that characters typed are …\n"],["refresh","Curses","Curses.html#method-c-refresh","()","<p>Refreshes the windows and lines.\n"],["refresh","Curses::Pad","Curses/Pad.html#method-i-refresh","(p1, p2, p3, p4, p5, p6)","<p>Refreshes the pad.  <code>pad_minrow</code> and pad_mincol+ define the\nupper-left corner of the rectangle to be displayed. …\n"],["refresh","Curses::Window","Curses/Window.html#method-i-refresh","()","<p>Refreshes the windows and lines.\n"],["reset_prog_mode","Curses","Curses.html#method-c-reset_prog_mode","()","<p>Reset the current terminal modes to the saved state by the\nCurses.def_prog_mode\n<p>This is done automatically …\n"],["resize","Curses","Curses.html#method-c-resize","(p1, p2)","<p>Resize the current term to Fixnum <code>lines</code> and Fixnum\n<code>cols</code>\n"],["resize","Curses::Window","Curses/Window.html#method-i-resize","(p1, p2)","<p>Resize the current window to Fixnum <code>lines</code> and Fixnum\n<code>cols</code>\n"],["resizeterm","Curses","Curses.html#method-c-resizeterm","(p1, p2)","<p>Resize the current term to Fixnum <code>lines</code> and Fixnum\n<code>cols</code>\n"],["scrl","Curses","Curses.html#method-c-scrl","(p1)","<p>Scrolls the current window Fixnum <code>num</code> lines. The current\ncursor position is not changed.\n<p>For positive …\n"],["scrl","Curses::Window","Curses/Window.html#method-i-scrl","(p1)","<p>Scrolls the current window Fixnum <code>num</code> lines. The current\ncursor position is not changed.\n<p>For positive …\n"],["scroll","Curses::Window","Curses/Window.html#method-i-scroll","()","<p>Scrolls the current window up one line.\n"],["scrollok","Curses::Window","Curses/Window.html#method-i-scrollok","(p1)","<p>Controls what happens when the cursor of a window is moved off the edge of\nthe window or scrolling region, …\n"],["setpos","Curses","Curses.html#method-c-setpos","(p1, p2)","<p>A setter for the position of the cursor, using coordinates <code>x</code>\nand <code>y</code>\n"],["setpos","Curses::Window","Curses/Window.html#method-i-setpos","(p1, p2)","<p>A setter for the position of the cursor in the current window, using\ncoordinates <code>x</code> and <code>y</code>\n"],["setscrreg","Curses","Curses.html#method-c-setscrreg","(p1, p2)","<p>Set a software scrolling region in a window. <code>top</code> and\n<code>bottom</code> are lines numbers of the margin.\n<p>If this option …\n"],["setscrreg","Curses::Window","Curses/Window.html#method-i-setscrreg","(p1, p2)","<p>Set a software scrolling region in a window. <code>top</code> and\n<code>bottom</code> are lines numbers of the margin.\n<p>If this option …\n"],["standend","Curses","Curses.html#method-c-standend","()","<p>Enables the Normal display (no highlight)\n<p>This is equivalent to Curses.attron(A_NORMAL)\n<p>see also Curses::Window.attrset …\n"],["standend","Curses::Window","Curses/Window.html#method-i-standend","()","<p>Enables the Normal display (no highlight)\n<p>This is equivalent to Curses::Window.attron(A_NORMAL)\n<p>see also …\n"],["standout","Curses","Curses.html#method-c-standout","()","<p>Enables the best highlighting mode of the terminal.\n<p>This is equivalent to Curses:Window.attron(A_STANDOUT) …\n"],["standout","Curses::Window","Curses/Window.html#method-i-standout","()","<p>Enables the best highlighting mode of the terminal.\n<p>This is equivalent to Curses::Window.attron(A_STANDOUT) …\n"],["start_color","Curses","Curses.html#method-c-start_color","()","<p>Initializes the color attributes, for terminals that support it.\n<p>This must be called, in order to use …\n"],["stdscr","Curses","Curses.html#method-c-stdscr","()","<p>The Standard Screen.\n<p>Upon initializing curses, a default window called stdscr, which is the size\nof the …\n"],["subpad","Curses::Pad","Curses/Pad.html#method-i-subpad","(p1, p2, p3, p4)","<p>Construct a new subpad with constraints of <code>height</code> lines,\n<code>width</code> columns, begin at <code>begin_x</code> line, and\n<code>begin_y</code> …\n"],["subwin","Curses::Window","Curses/Window.html#method-i-subwin","(p1, p2, p3, p4)","<p>Construct a new subwindow with constraints of <code>height</code> lines,\n<code>width</code> columns, begin at <code>top</code> line, and begin …\n"],["timeout=","Curses","Curses.html#method-c-timeout-3D","(p1)","<p>Sets block and non-blocking reads for the window.\n<p>If delay is negative, blocking read is used (i.e., waits …\n"],["timeout=","Curses::Window","Curses/Window.html#method-i-timeout-3D","(p1)","<p>Sets block and non-blocking reads for the window.\n<p>If delay is negative, blocking read is used (i.e., waits …\n"],["ungetch","Curses","Curses.html#method-c-ungetch","(p1)","<p>Places <code>ch</code> back onto the input queue to be returned by the next\ncall to Curses.getch.\n<p>There is just one …\n"],["ungetmouse","Curses","Curses.html#method-c-ungetmouse","(p1)","<p>It pushes a KEY_MOUSE event onto the input queue, and associates with that\nevent the given state data …\n"],["use_default_colors","Curses","Curses.html#method-c-use_default_colors","()","<p>tells the curses library to use terminal&#39;s default colors.\n<p>see also the system manual for default_colors …\n"],["History","","History_md.html","","<p>1.0.2 / 2016-03-15\n<p>Bug fixes:\n<p>Fix ncursesw support. Pull request #16 by peter50216, patch by eTM. Issue …\n"],["Manifest","","Manifest_txt.html","","<p>BSDL COPYING History.md Manifest.txt README.md Rakefile curses.gemspec\next/curses/curses.c ext/curses/depend …\n"],["README","","README_md.html","","<p>curses\n<p>github.com/ruby/curses\n<p>github.com/ruby/curses/issues\n"],["Makefile","","ext/curses/Makefile.html","","<p>SHELL = /bin/sh\n<p># V=0 quiet, V=1 verbose.  other values don&#39;t work. V = 1 Q1 = $(V:1=)\nQ = $(Q1:0=@) …\n"],["depend","","ext/curses/depend.html","","<p>$(OBJS): $(HDRS) $(ruby_headers) \\\n\n<pre>$(hdrdir)/ruby/io.h \\\n$(hdrdir)/ruby/encoding.h \\\n$(hdrdir)/ruby/oniguruma.h ...</pre>\n"]]}}