/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 4 "gtksourceview2.override"
#define NO_IMPORT_PYGOBJECT
#include "pygobject.h"

#include "pygtksourceview-private.h"

#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourceview-typebuiltins.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <gtksourceview/gtksourcestyle.h>
#include <gtksourceview/gtksourcestylescheme.h>
#include <gtksourceview/gtksourcelanguage.h>
#include <gtksourceview/gtksourcegutter.h>

#include <gtksourceview/gtksourceiter.h>
#include <gtksourceview/gtksourcebuffer.h>
#include <gtksourceview/gtksourceprintcompositor.h>
#include <gtksourceview/gtksourcecompletion.h>
#include <gtksourceview/gtksourcecompletionitem.h>
#include <gtksourceview/gtksourcecompletionprovider.h>
#include <gtksourceview/gtksourcecompletioninfo.h>
#include <gtksourceview/completion-providers/words/gtksourcecompletionwords.h>

static PyObject *
glist_to_pylist_objs (const GList *source)
{
    const GList *iter;
    PyObject *dest = PyList_New (0);
    for (iter = source; iter != NULL; iter = iter->next)
    {
        PyObject *item = pygobject_new ((GObject *)iter->data);
        PyList_Append (dest, item);
        Py_DECREF (item);
    }
    return dest;
}

static PyObject *
gslist_to_pylist_objs (const GSList *source)
{
    const GSList *iter;
    PyObject *dest = PyList_New (0);
    for (iter = source; iter != NULL; iter = iter->next)
    {
        PyObject *item = pygobject_new ((GObject *)iter->data);
        PyList_Append (dest, item);
        Py_DECREF (item);
    }
    return dest;
}

static PyObject *
strv_to_pylist (char **strv)
{
    gsize len, i;
    PyObject *list;

    len = strv ? g_strv_length (strv) : 0;
    list = PyList_New (len);

    for (i = 0; i < len; i++)
        PyList_SetItem (list, i, PyString_FromString (strv[i]));

    return list;
}

static gboolean
pylist_to_strv (PyObject *list,
                char   ***strvp)
{
    int i, len;
    char **ret;

    *strvp = NULL;

    if (list == Py_None)
        return TRUE;

    if (!PySequence_Check (list))
    {
        PyErr_Format (PyExc_TypeError, "argument must be a list or tuple of strings");
        return FALSE;
    }

    if ((len = PySequence_Size (list)) < 0)
        return FALSE;

    ret = g_new (char*, len + 1);
    for (i = 0; i <= len; ++i)
        ret[i] = NULL;

    for (i = 0; i < len; ++i)
    {
        PyObject *item = PySequence_GetItem (list, i);

        if (!item)
        {
            g_strfreev (ret);
            return FALSE;
        }

        if (!PyString_Check (item))
        {
            Py_DECREF (item);
            g_strfreev (ret);
            PyErr_Format (PyExc_TypeError, "argument must be a list of strings");
            return FALSE;
        }

        ret[i] = g_strdup (PyString_AsString (item));
        Py_DECREF (item);
    }

    *strvp = ret;
    return TRUE;
}

void
pygtksourceview_custom_destroy_notify(gpointer user_data)
{
    PyGtkSourceViewCustomNotify *cunote = user_data;
    PyGILState_STATE state;

    g_return_if_fail(user_data);
    state = pyg_gil_state_ensure();
    Py_XDECREF(cunote->func);
    Py_XDECREF(cunote->data);
    pyg_gil_state_release(state);
    
    g_free(cunote);
}

#line 141 "gtksourceview2.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)
static PyTypeObject *_PyGdkPixbuf_Type;
#define PyGdkPixbuf_Type (*_PyGdkPixbuf_Type)
static PyTypeObject *_PyGtkTextTagTable_Type;
#define PyGtkTextTagTable_Type (*_PyGtkTextTagTable_Type)
static PyTypeObject *_PyGtkTextView_Type;
#define PyGtkTextView_Type (*_PyGtkTextView_Type)
static PyTypeObject *_PyGtkTextBuffer_Type;
#define PyGtkTextBuffer_Type (*_PyGtkTextBuffer_Type)
static PyTypeObject *_PyGtkTextMark_Type;
#define PyGtkTextMark_Type (*_PyGtkTextMark_Type)
static PyTypeObject *_PyGtkPrintContext_Type;
#define PyGtkPrintContext_Type (*_PyGtkPrintContext_Type)
static PyTypeObject *_PyGtkWidget_Type;
#define PyGtkWidget_Type (*_PyGtkWidget_Type)
static PyTypeObject *_PyGtkWindow_Type;
#define PyGtkWindow_Type (*_PyGtkWindow_Type)
static PyTypeObject *_PyGtkTextIter_Type;
#define PyGtkTextIter_Type (*_PyGtkTextIter_Type)
static PyTypeObject *_PyGtkCellRenderer_Type;
#define PyGtkCellRenderer_Type (*_PyGtkCellRenderer_Type)
static PyTypeObject *_PyGtkTooltip_Type;
#define PyGtkTooltip_Type (*_PyGtkTooltip_Type)
static PyTypeObject *_PyGInitiallyUnowned_Type;
#define PyGInitiallyUnowned_Type (*_PyGInitiallyUnowned_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject G_GNUC_INTERNAL PyGtkSourceBuffer_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceGutter_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceLanguage_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceLanguageManager_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceMark_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourcePrintCompositor_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceStyle_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceStyleScheme_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceStyleSchemeManager_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceView_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletion_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionInfo_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionItem_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionContext_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionWords_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionProposal_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionProvider_Type;
PyTypeObject G_GNUC_INTERNAL PyGtkSourceUndoManager_Type;

#line 193 "gtksourceview2.c"



/* ----------- GtkSourceBuffer ----------- */

static int
_wrap_gtk_source_buffer_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GType obj_type = pyg_type_from_object((PyObject *) self);
    GParameter params[2];
    PyObject *parsed_args[2] = {NULL, };
    char *arg_names[] = {"language", "tag_table", NULL };
    char *prop_names[] = {"language", "tag_table", NULL };
    guint nparams, i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:gtksourceview2.Buffer.__init__" , arg_names , &parsed_args[0] , &parsed_args[1]))
        return -1;

    memset(params, 0, sizeof(GParameter)*2);
    if (!pyg_parse_constructor_args(obj_type, arg_names,
                                    prop_names, params, 
                                    &nparams, parsed_args))
        return -1;
    pygobject_constructv(self, nparams, params);
    for (i = 0; i < nparams; ++i)
        g_value_unset(&params[i].value);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create gtksourceview2.Buffer object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_gtk_source_buffer_get_highlight_syntax(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_buffer_get_highlight_syntax(GTK_SOURCE_BUFFER(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_buffer_set_highlight_syntax(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "highlight", NULL };
    int highlight;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.Buffer.set_highlight_syntax", kwlist, &highlight))
        return NULL;
    
    gtk_source_buffer_set_highlight_syntax(GTK_SOURCE_BUFFER(self->obj), highlight);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_get_highlight_matching_brackets(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_buffer_get_highlight_matching_brackets(GTK_SOURCE_BUFFER(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_buffer_set_highlight_matching_brackets(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "highlight", NULL };
    int highlight;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.Buffer.set_highlight_matching_brackets", kwlist, &highlight))
        return NULL;
    
    gtk_source_buffer_set_highlight_matching_brackets(GTK_SOURCE_BUFFER(self->obj), highlight);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_get_max_undo_levels(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_buffer_get_max_undo_levels(GTK_SOURCE_BUFFER(self->obj));
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gtk_source_buffer_set_max_undo_levels(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "max_undo_levels", NULL };
    int max_undo_levels;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.Buffer.set_max_undo_levels", kwlist, &max_undo_levels))
        return NULL;
    
    gtk_source_buffer_set_max_undo_levels(GTK_SOURCE_BUFFER(self->obj), max_undo_levels);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_get_language(PyGObject *self)
{
    GtkSourceLanguage *ret;

    
    ret = gtk_source_buffer_get_language(GTK_SOURCE_BUFFER(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_buffer_set_language(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "language", NULL };
    GtkSourceLanguage *language = NULL;
    PyGObject *py_language;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.Buffer.set_language", kwlist, &py_language))
        return NULL;
    if (py_language && pygobject_check(py_language, &PyGtkSourceLanguage_Type))
        language = GTK_SOURCE_LANGUAGE(py_language->obj);
    else if ((PyObject *)py_language != Py_None) {
        PyErr_SetString(PyExc_TypeError, "language should be a GtkSourceLanguage or None");
        return NULL;
    }
    
    gtk_source_buffer_set_language(GTK_SOURCE_BUFFER(self->obj), (GtkSourceLanguage *) language);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_can_undo(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_buffer_can_undo(GTK_SOURCE_BUFFER(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_buffer_can_redo(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_buffer_can_redo(GTK_SOURCE_BUFFER(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_buffer_undo(PyGObject *self)
{
    
    gtk_source_buffer_undo(GTK_SOURCE_BUFFER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_redo(PyGObject *self)
{
    
    gtk_source_buffer_redo(GTK_SOURCE_BUFFER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_begin_not_undoable_action(PyGObject *self)
{
    
    gtk_source_buffer_begin_not_undoable_action(GTK_SOURCE_BUFFER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_end_not_undoable_action(PyGObject *self)
{
    
    gtk_source_buffer_end_not_undoable_action(GTK_SOURCE_BUFFER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_get_style_scheme(PyGObject *self)
{
    GtkSourceStyleScheme *ret;

    
    ret = gtk_source_buffer_get_style_scheme(GTK_SOURCE_BUFFER(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_buffer_set_style_scheme(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "scheme", NULL };
    PyGObject *scheme;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.Buffer.set_style_scheme", kwlist, &PyGtkSourceStyleScheme_Type, &scheme))
        return NULL;
    
    gtk_source_buffer_set_style_scheme(GTK_SOURCE_BUFFER(self->obj), GTK_SOURCE_STYLE_SCHEME(scheme->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_ensure_highlight(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "start", "end", NULL };
    PyObject *py_start, *py_end;
    GtkTextIter *start = NULL, *end = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"OO:GtkSourceView.Buffer.ensure_highlight", kwlist, &py_start, &py_end))
        return NULL;
    if (pyg_boxed_check(py_start, GTK_TYPE_TEXT_ITER))
        start = pyg_boxed_get(py_start, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "start should be a GtkTextIter");
        return NULL;
    }
    if (pyg_boxed_check(py_end, GTK_TYPE_TEXT_ITER))
        end = pyg_boxed_get(py_end, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "end should be a GtkTextIter");
        return NULL;
    }
    
    gtk_source_buffer_ensure_highlight(GTK_SOURCE_BUFFER(self->obj), start, end);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_create_source_mark(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "category", "where", NULL };
    char *name, *category;
    PyObject *py_where;
    GtkTextIter *where = NULL;
    GtkSourceMark *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"zsO:GtkSourceView.Buffer.create_source_mark", kwlist, &name, &category, &py_where))
        return NULL;
    if (pyg_boxed_check(py_where, GTK_TYPE_TEXT_ITER))
        where = pyg_boxed_get(py_where, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "where should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_buffer_create_source_mark(GTK_SOURCE_BUFFER(self->obj), name, category, where);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_buffer_forward_iter_to_source_mark(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "category", NULL };
    PyObject *py_iter;
    char *category = NULL;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O|z:GtkSourceView.Buffer.forward_iter_to_source_mark", kwlist, &py_iter, &category))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_buffer_forward_iter_to_source_mark(GTK_SOURCE_BUFFER(self->obj), iter, category);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_buffer_backward_iter_to_source_mark(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "category", NULL };
    PyObject *py_iter;
    char *category = NULL;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O|z:GtkSourceView.Buffer.backward_iter_to_source_mark", kwlist, &py_iter, &category))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_buffer_backward_iter_to_source_mark(GTK_SOURCE_BUFFER(self->obj), iter, category);
    
    return PyBool_FromLong(ret);

}

#line 337 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_buffer_get_source_marks_at_iter(PyGObject *self,
                                                 PyObject *args,
                                                 PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "category", NULL };
    PyObject    *py_iter, *py_ret;
    gchar       *category;
    GtkTextIter *iter = NULL;
    GSList      *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "Oz:GtkSourceBuffer.get_source_marks_at_iter",
                                     kwlist, &py_iter, &category))
        return NULL;

    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }

    ret = gtk_source_buffer_get_source_marks_at_iter(GTK_SOURCE_BUFFER(self->obj),
                                                     iter, category);

    py_ret = gslist_to_pylist_objs (ret);

    return py_ret;
}

#line 566 "gtksourceview2.c"


#line 370 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_buffer_get_source_marks_at_line(PyGObject *self,
                                                 PyObject *args,
                                                 PyObject *kwargs)
{
    static char *kwlist[] = { "line", "category", NULL };
    PyObject    *py_ret;
    gint        line;
    gchar       *category;
    GSList      *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "iz:GtkSourceBuffer.get_source_marks_at_line",
                                     kwlist, &line, &category))
        return NULL;

    ret = gtk_source_buffer_get_source_marks_at_line(GTK_SOURCE_BUFFER(self->obj),
                                                     line, category);

    py_ret = gslist_to_pylist_objs (ret);

    return py_ret;
}

#line 594 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_buffer_remove_source_marks(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "start", "end", "category", NULL };
    PyObject *py_start, *py_end;
    char *category = NULL;
    GtkTextIter *start = NULL, *end = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"OO|z:GtkSourceView.Buffer.remove_source_marks", kwlist, &py_start, &py_end, &category))
        return NULL;
    if (pyg_boxed_check(py_start, GTK_TYPE_TEXT_ITER))
        start = pyg_boxed_get(py_start, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "start should be a GtkTextIter");
        return NULL;
    }
    if (pyg_boxed_check(py_end, GTK_TYPE_TEXT_ITER))
        end = pyg_boxed_get(py_end, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "end should be a GtkTextIter");
        return NULL;
    }
    
    gtk_source_buffer_remove_source_marks(GTK_SOURCE_BUFFER(self->obj), start, end, category);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_get_undo_manager(PyGObject *self)
{
    GtkSourceUndoManager *ret;

    
    ret = gtk_source_buffer_get_undo_manager(GTK_SOURCE_BUFFER(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_buffer_set_undo_manager(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "manager", NULL };
    PyGObject *py_manager;
    GtkSourceUndoManager *manager = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.Buffer.set_undo_manager", kwlist, &py_manager))
        return NULL;
    if (py_manager && pygobject_check(py_manager, &PyGtkSourceUndoManager_Type))
        manager = GTK_SOURCE_UNDO_MANAGER(py_manager->obj);
    else if ((PyObject *)py_manager != Py_None) {
        PyErr_SetString(PyExc_TypeError, "manager should be a GtkSourceUndoManager or None");
        return NULL;
    }
    
    gtk_source_buffer_set_undo_manager(GTK_SOURCE_BUFFER(self->obj), (GtkSourceUndoManager *) manager);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_buffer_iter_has_context_class(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "context_class", NULL };
    PyObject *py_iter;
    char *context_class;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Os:GtkSourceView.Buffer.iter_has_context_class", kwlist, &py_iter, &context_class))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_buffer_iter_has_context_class(GTK_SOURCE_BUFFER(self->obj), iter, context_class);
    
    return PyBool_FromLong(ret);

}

#line 1240 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_buffer_get_context_classes_at_iter(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", NULL };
    PyObject *py_iter;
    GtkTextIter *iter = NULL;
    gchar **context_classes;

    PyObject *ret;

    if (!PyArg_ParseTupleAndKeywords(args,
                                     kwargs,
                                     "Os:GtkSourceBuffer.get_context_classes_at_iter",
                                     kwlist,
                                     &py_iter))
        return NULL;

    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
    {
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    }
    else
    {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }

    context_classes = gtk_source_buffer_get_context_classes_at_iter (GTK_SOURCE_BUFFER (self->obj),
                                                                     iter);
    ret = strv_to_pylist (context_classes);
    g_strfreev (context_classes);

    return ret;
}
#line 719 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_buffer_iter_forward_to_context_class_toggle(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "context_class", NULL };
    PyObject *py_iter;
    char *context_class;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Os:GtkSourceView.Buffer.iter_forward_to_context_class_toggle", kwlist, &py_iter, &context_class))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_buffer_iter_forward_to_context_class_toggle(GTK_SOURCE_BUFFER(self->obj), iter, context_class);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_buffer_iter_backward_to_context_class_toggle(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "context_class", NULL };
    PyObject *py_iter;
    char *context_class;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Os:GtkSourceView.Buffer.iter_backward_to_context_class_toggle", kwlist, &py_iter, &context_class))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_buffer_iter_backward_to_context_class_toggle(GTK_SOURCE_BUFFER(self->obj), iter, context_class);
    
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyGtkSourceBuffer_methods[] = {
    { "get_highlight_syntax", (PyCFunction)_wrap_gtk_source_buffer_get_highlight_syntax, METH_NOARGS,
      NULL },
    { "set_highlight_syntax", (PyCFunction)_wrap_gtk_source_buffer_set_highlight_syntax, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_highlight_matching_brackets", (PyCFunction)_wrap_gtk_source_buffer_get_highlight_matching_brackets, METH_NOARGS,
      NULL },
    { "set_highlight_matching_brackets", (PyCFunction)_wrap_gtk_source_buffer_set_highlight_matching_brackets, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_max_undo_levels", (PyCFunction)_wrap_gtk_source_buffer_get_max_undo_levels, METH_NOARGS,
      NULL },
    { "set_max_undo_levels", (PyCFunction)_wrap_gtk_source_buffer_set_max_undo_levels, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_language", (PyCFunction)_wrap_gtk_source_buffer_get_language, METH_NOARGS,
      NULL },
    { "set_language", (PyCFunction)_wrap_gtk_source_buffer_set_language, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "can_undo", (PyCFunction)_wrap_gtk_source_buffer_can_undo, METH_NOARGS,
      NULL },
    { "can_redo", (PyCFunction)_wrap_gtk_source_buffer_can_redo, METH_NOARGS,
      NULL },
    { "undo", (PyCFunction)_wrap_gtk_source_buffer_undo, METH_NOARGS,
      NULL },
    { "redo", (PyCFunction)_wrap_gtk_source_buffer_redo, METH_NOARGS,
      NULL },
    { "begin_not_undoable_action", (PyCFunction)_wrap_gtk_source_buffer_begin_not_undoable_action, METH_NOARGS,
      NULL },
    { "end_not_undoable_action", (PyCFunction)_wrap_gtk_source_buffer_end_not_undoable_action, METH_NOARGS,
      NULL },
    { "get_style_scheme", (PyCFunction)_wrap_gtk_source_buffer_get_style_scheme, METH_NOARGS,
      NULL },
    { "set_style_scheme", (PyCFunction)_wrap_gtk_source_buffer_set_style_scheme, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "ensure_highlight", (PyCFunction)_wrap_gtk_source_buffer_ensure_highlight, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_source_mark", (PyCFunction)_wrap_gtk_source_buffer_create_source_mark, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "forward_iter_to_source_mark", (PyCFunction)_wrap_gtk_source_buffer_forward_iter_to_source_mark, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "backward_iter_to_source_mark", (PyCFunction)_wrap_gtk_source_buffer_backward_iter_to_source_mark, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_source_marks_at_iter", (PyCFunction)_wrap_gtk_source_buffer_get_source_marks_at_iter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_source_marks_at_line", (PyCFunction)_wrap_gtk_source_buffer_get_source_marks_at_line, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "remove_source_marks", (PyCFunction)_wrap_gtk_source_buffer_remove_source_marks, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_undo_manager", (PyCFunction)_wrap_gtk_source_buffer_get_undo_manager, METH_NOARGS,
      NULL },
    { "set_undo_manager", (PyCFunction)_wrap_gtk_source_buffer_set_undo_manager, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "iter_has_context_class", (PyCFunction)_wrap_gtk_source_buffer_iter_has_context_class, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_context_classes_at_iter", (PyCFunction)_wrap_gtk_source_buffer_get_context_classes_at_iter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "iter_forward_to_context_class_toggle", (PyCFunction)_wrap_gtk_source_buffer_iter_forward_to_context_class_toggle, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "iter_backward_to_context_class_toggle", (PyCFunction)_wrap_gtk_source_buffer_iter_backward_to_context_class_toggle, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceBuffer_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.Buffer",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceBuffer_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_buffer_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceGutter ----------- */

static PyObject *
_wrap_gtk_source_gutter_get_window(PyGObject *self)
{
    GdkWindow *ret;

    
    ret = gtk_source_gutter_get_window(GTK_SOURCE_GUTTER(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_gutter_insert(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "renderer", "position", NULL };
    PyGObject *renderer;
    int position;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!i:GtkSourceView.Gutter.insert", kwlist, &PyGtkCellRenderer_Type, &renderer, &position))
        return NULL;
    
    gtk_source_gutter_insert(GTK_SOURCE_GUTTER(self->obj), GTK_CELL_RENDERER(renderer->obj), position);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_gutter_reorder(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "renderer", "position", NULL };
    PyGObject *renderer;
    int position;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!i:GtkSourceView.Gutter.reorder", kwlist, &PyGtkCellRenderer_Type, &renderer, &position))
        return NULL;
    
    gtk_source_gutter_reorder(GTK_SOURCE_GUTTER(self->obj), GTK_CELL_RENDERER(renderer->obj), position);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_gutter_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "renderer", NULL };
    PyGObject *renderer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.Gutter.remove", kwlist, &PyGtkCellRenderer_Type, &renderer))
        return NULL;
    
    gtk_source_gutter_remove(GTK_SOURCE_GUTTER(self->obj), GTK_CELL_RENDERER(renderer->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 516 "gtksourceview2.override"
static void
pygtksourceview_cell_data_func_marshal (GtkSourceGutter *gutter,
                                        GtkCellRenderer *cell,
                                        gint line_number,
                                        gboolean current_line,
                                        gpointer data)
{
    PyGILState_STATE state;
    PyGtkSourceViewCustomNotify *cunote = data;
    PyObject *retobj;
    PyObject *pygutter, *pycell;

    g_assert (cunote->func);

    state = pyg_gil_state_ensure();

    pygutter = pygobject_new((GObject *)gutter);
    pycell = pygobject_new((GObject *)cell);
    
    if (cunote->data)
        retobj = PyEval_CallFunction(cunote->func, "(NNiiO)",
                                     pygutter, pycell,
                                     line_number, current_line, cunote->data);
    else
        retobj = PyEval_CallFunction(cunote->func, "(NNii)",
                                     pygutter, pycell,
                                     line_number, current_line);

    if (retobj == NULL) {
        PyErr_Print();
    } else
        Py_DECREF(retobj);

    pyg_gil_state_release(state);
}

static PyObject *
_wrap_gtk_source_gutter_set_cell_data_func (PyGObject *self,
                                            PyObject *args,
                                            PyObject *kwargs)
{
    PyObject *pycell, *pyfunc, *pyarg = NULL;
    GtkCellRenderer *cell;
    PyGtkSourceViewCustomNotify *cunote;

    if (!PyArg_ParseTuple(args, "OO|O:GtkSourceGutter.set_cell_data_func",
                          &pycell, &pyfunc, &pyarg))
        return NULL;

    if (pygobject_check(pycell, &PyGtkCellRenderer_Type))
        cell = GTK_CELL_RENDERER(pygobject_get(pycell));
    else {
        PyErr_SetString(PyExc_TypeError,
                        "first argument must be a GtkCellRenderer");
        return NULL;
    }

    if (pyfunc == Py_None) {
        PyErr_SetString(PyExc_TypeError,
                        "Function can't be None");
    } else {
        cunote = g_new0(PyGtkSourceViewCustomNotify, 1);
        cunote->func = pyfunc;
        cunote->data = pyarg;
        Py_INCREF(cunote->func);
        Py_XINCREF(cunote->data);

        gtk_source_gutter_set_cell_data_func(GTK_SOURCE_GUTTER(self->obj), cell,
                                        pygtksourceview_cell_data_func_marshal,
                                        cunote,
                                        pygtksourceview_custom_destroy_notify);
    }

    Py_INCREF(Py_None);
    return Py_None;
}

#line 1018 "gtksourceview2.c"


#line 1031 "gtksourceview2.override"
static void
pygtksourceview_cell_size_func_marshal (GtkSourceGutter *gutter,
                                        GtkCellRenderer *cell,
                                        gpointer data)
{
    PyGILState_STATE state;
    PyGtkSourceViewCustomNotify *cunote = data;
    PyObject *retobj;
    PyObject *pygutter, *pycell;

    g_assert (cunote->func);

    state = pyg_gil_state_ensure();

    pygutter = pygobject_new((GObject *)gutter);
    pycell = pygobject_new((GObject *)cell);
    
    if (cunote->data)
        retobj = PyEval_CallFunction(cunote->func, "(NNO)",
                                     pygutter, pycell,
                                     cunote->data);
    else
        retobj = PyEval_CallFunction(cunote->func, "(NN)",
                                     pygutter, pycell);

    if (retobj == NULL) {
        PyErr_Print();
    } else
        Py_DECREF(retobj);

    pyg_gil_state_release(state);
}

static PyObject *
_wrap_gtk_source_gutter_set_cell_size_func (PyGObject *self,
                                            PyObject *args,
                                            PyObject *kwargs)
{
    PyObject *pycell, *pyfunc, *pyarg = NULL;
    GtkCellRenderer *cell;
    PyGtkSourceViewCustomNotify *cunote;

    if (!PyArg_ParseTuple(args, "OO|O:GtkSourceGutter.set_cell_size_func",
                          &pycell, &pyfunc, &pyarg))
        return NULL;

    if (pygobject_check(pycell, &PyGtkCellRenderer_Type))
        cell = GTK_CELL_RENDERER(pygobject_get(pycell));
    else {
        PyErr_SetString(PyExc_TypeError,
                        "first argument must be a GtkCellRenderer");
        return NULL;
    }

    if (pyfunc == Py_None) {
        PyErr_SetString(PyExc_TypeError,
                        "func must be a callable object");
    } else {
        cunote = g_new0(PyGtkSourceViewCustomNotify, 1);
        cunote->func = pyfunc;
        cunote->data = pyarg;
        Py_INCREF(cunote->func);
        Py_XINCREF(cunote->data);

        gtk_source_gutter_set_cell_size_func(GTK_SOURCE_GUTTER(self->obj), cell,
                                        pygtksourceview_cell_size_func_marshal,
                                        cunote,
                                        pygtksourceview_custom_destroy_notify);
    }

    Py_INCREF(Py_None);
    return Py_None;
}

#line 1096 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_gutter_queue_draw(PyGObject *self)
{
    
    gtk_source_gutter_queue_draw(GTK_SOURCE_GUTTER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceGutter__do_cell_activated(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    gpointer klass;
    static char *kwlist[] = { "self", "renderer", "iter", "event", NULL };
    PyGObject *self, *renderer;
    PyObject *py_iter, *py_event;
    GtkTextIter *iter = NULL;
    GdkEvent *event = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!OO:GtkSourceView.Gutter.cell_activated", kwlist, &PyGtkSourceGutter_Type, &self, &PyGtkCellRenderer_Type, &renderer, &py_iter, &py_event))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    if (pyg_boxed_check(py_event, GDK_TYPE_EVENT))
        event = pyg_boxed_get(py_event, GdkEvent);
    else {
        PyErr_SetString(PyExc_TypeError, "event should be a GdkEvent");
        return NULL;
    }
    klass = g_type_class_ref(pyg_type_from_object(cls));
    if (GTK_SOURCE_GUTTER_CLASS(klass)->cell_activated)
        GTK_SOURCE_GUTTER_CLASS(klass)->cell_activated(GTK_SOURCE_GUTTER(self->obj), GTK_CELL_RENDERER(renderer->obj), iter, event);
    else {
        PyErr_SetString(PyExc_NotImplementedError, "virtual method GtkSourceView.Gutter.cell_activated not implemented");
        g_type_class_unref(klass);
        return NULL;
    }
    g_type_class_unref(klass);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceGutter__do_query_tooltip(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    gpointer klass;
    static char *kwlist[] = { "self", "renderer", "iter", "tooltip", NULL };
    PyGObject *self, *renderer, *tooltip;
    PyObject *py_iter;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!OO!:GtkSourceView.Gutter.query_tooltip", kwlist, &PyGtkSourceGutter_Type, &self, &PyGtkCellRenderer_Type, &renderer, &py_iter, &PyGtkTooltip_Type, &tooltip))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    klass = g_type_class_ref(pyg_type_from_object(cls));
    if (GTK_SOURCE_GUTTER_CLASS(klass)->query_tooltip)
        ret = GTK_SOURCE_GUTTER_CLASS(klass)->query_tooltip(GTK_SOURCE_GUTTER(self->obj), GTK_CELL_RENDERER(renderer->obj), iter, GTK_TOOLTIP(tooltip->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "virtual method GtkSourceView.Gutter.query_tooltip not implemented");
        g_type_class_unref(klass);
        return NULL;
    }
    g_type_class_unref(klass);
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyGtkSourceGutter_methods[] = {
    { "get_window", (PyCFunction)_wrap_gtk_source_gutter_get_window, METH_NOARGS,
      NULL },
    { "insert", (PyCFunction)_wrap_gtk_source_gutter_insert, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "reorder", (PyCFunction)_wrap_gtk_source_gutter_reorder, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "remove", (PyCFunction)_wrap_gtk_source_gutter_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_cell_data_func", (PyCFunction)_wrap_gtk_source_gutter_set_cell_data_func, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_cell_size_func", (PyCFunction)_wrap_gtk_source_gutter_set_cell_size_func, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "queue_draw", (PyCFunction)_wrap_gtk_source_gutter_queue_draw, METH_NOARGS,
      NULL },
    { "do_cell_activated", (PyCFunction)_wrap_GtkSourceGutter__do_cell_activated, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_query_tooltip", (PyCFunction)_wrap_GtkSourceGutter__do_query_tooltip, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceGutter_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.Gutter",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceGutter_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static void
_wrap_GtkSourceGutter__proxy_do_cell_activated(GtkSourceGutter *self, GtkCellRenderer*renderer, GtkTextIter*iter, GdkEvent*event)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_renderer = NULL;
    PyObject *py_iter;
    PyObject *py_event;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    if (renderer)
        py_renderer = pygobject_new((GObject *) renderer);
    else {
        Py_INCREF(Py_None);
        py_renderer = Py_None;
    }
    py_iter = pyg_boxed_new(GTK_TYPE_TEXT_ITER, iter, FALSE, FALSE);
    py_event = pyg_boxed_new(GDK_TYPE_EVENT, event, FALSE, FALSE);
    
    py_args = PyTuple_New(3);
    PyTuple_SET_ITEM(py_args, 0, py_renderer);
    PyTuple_SET_ITEM(py_args, 1, py_iter);
    PyTuple_SET_ITEM(py_args, 2, py_event);
    
    py_method = PyObject_GetAttrString(py_self, "do_cell_activated");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static gboolean
_wrap_GtkSourceGutter__proxy_do_query_tooltip(GtkSourceGutter *self, GtkCellRenderer*renderer, GtkTextIter*iter, GtkTooltip*tooltip)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_renderer = NULL;
    PyObject *py_iter;
    PyObject *py_tooltip = NULL;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    if (renderer)
        py_renderer = pygobject_new((GObject *) renderer);
    else {
        Py_INCREF(Py_None);
        py_renderer = Py_None;
    }
    py_iter = pyg_boxed_new(GTK_TYPE_TEXT_ITER, iter, FALSE, FALSE);
    if (tooltip)
        py_tooltip = pygobject_new((GObject *) tooltip);
    else {
        Py_INCREF(Py_None);
        py_tooltip = Py_None;
    }
    
    py_args = PyTuple_New(3);
    PyTuple_SET_ITEM(py_args, 0, py_renderer);
    PyTuple_SET_ITEM(py_args, 1, py_iter);
    PyTuple_SET_ITEM(py_args, 2, py_tooltip);
    
    py_method = PyObject_GetAttrString(py_self, "do_query_tooltip");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}

static int
__GtkSourceGutter_class_init(gpointer gclass, PyTypeObject *pyclass)
{
    PyObject *o;
    GtkSourceGutterClass *klass = GTK_SOURCE_GUTTER_CLASS(gclass);
    PyObject *gsignals = PyDict_GetItemString(pyclass->tp_dict, "__gsignals__");

    o = PyObject_GetAttrString((PyObject *) pyclass, "do_cell_activated");
    if (o == NULL)
        PyErr_Clear();
    else {
        if (!PyObject_TypeCheck(o, &PyCFunction_Type)
            && !(gsignals && PyDict_GetItemString(gsignals, "cell_activated")))
            klass->cell_activated = _wrap_GtkSourceGutter__proxy_do_cell_activated;
        Py_DECREF(o);
    }

    o = PyObject_GetAttrString((PyObject *) pyclass, "do_query_tooltip");
    if (o == NULL)
        PyErr_Clear();
    else {
        if (!PyObject_TypeCheck(o, &PyCFunction_Type)
            && !(gsignals && PyDict_GetItemString(gsignals, "query_tooltip")))
            klass->query_tooltip = _wrap_GtkSourceGutter__proxy_do_query_tooltip;
        Py_DECREF(o);
    }
    return 0;
}


/* ----------- GtkSourceLanguage ----------- */

static PyObject *
_wrap_gtk_source_language_get_id(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_language_get_id(GTK_SOURCE_LANGUAGE(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_language_get_name(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_language_get_name(GTK_SOURCE_LANGUAGE(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_language_get_section(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_language_get_section(GTK_SOURCE_LANGUAGE(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_language_get_hidden(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_language_get_hidden(GTK_SOURCE_LANGUAGE(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_language_get_metadata(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.Language.get_metadata", kwlist, &name))
        return NULL;
    
    ret = gtk_source_language_get_metadata(GTK_SOURCE_LANGUAGE(self->obj), name);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 174 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_get_mime_types(PyGObject *self)
{
    gchar **mime_types;
    PyObject *ret;

    mime_types = gtk_source_language_get_mime_types (GTK_SOURCE_LANGUAGE (self->obj));
    ret = strv_to_pylist (mime_types);
    g_strfreev (mime_types);

    return ret;
}

#line 1518 "gtksourceview2.c"


#line 159 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_get_globs(PyGObject *self)
{
    gchar **globs;
    PyObject *ret;

    globs = gtk_source_language_get_globs (GTK_SOURCE_LANGUAGE (self->obj));
    ret = strv_to_pylist (globs);
    g_strfreev (globs);

    return ret;
}

#line 1535 "gtksourceview2.c"


#line 323 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_get_style_ids(PyGObject *self)
{
    gchar       **ret;
    PyObject    *py_ret;

    ret = gtk_source_language_get_style_ids(GTK_SOURCE_LANGUAGE(self->obj));
    py_ret = strv_to_pylist ((char**) ret);

    return py_ret;
}

#line 1551 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_language_get_style_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "style_id", NULL };
    char *style_id;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.Language.get_style_name", kwlist, &style_id))
        return NULL;
    
    ret = gtk_source_language_get_style_name(GTK_SOURCE_LANGUAGE(self->obj), style_id);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceLanguage_methods[] = {
    { "get_id", (PyCFunction)_wrap_gtk_source_language_get_id, METH_NOARGS,
      NULL },
    { "get_name", (PyCFunction)_wrap_gtk_source_language_get_name, METH_NOARGS,
      NULL },
    { "get_section", (PyCFunction)_wrap_gtk_source_language_get_section, METH_NOARGS,
      NULL },
    { "get_hidden", (PyCFunction)_wrap_gtk_source_language_get_hidden, METH_NOARGS,
      NULL },
    { "get_metadata", (PyCFunction)_wrap_gtk_source_language_get_metadata, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_mime_types", (PyCFunction)_wrap_gtk_source_language_get_mime_types, METH_NOARGS,
      NULL },
    { "get_globs", (PyCFunction)_wrap_gtk_source_language_get_globs, METH_NOARGS,
      NULL },
    { "get_style_ids", (PyCFunction)_wrap_gtk_source_language_get_style_ids, METH_NOARGS,
      NULL },
    { "get_style_name", (PyCFunction)_wrap_gtk_source_language_get_style_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

#line 303 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_tp_new(PyTypeObject *type)
{
    PyErr_SetString(PyExc_TypeError,
            "cannot create instance of type `GtkSourceLanguage'");
    return NULL;
}

#line 1603 "gtksourceview2.c"


PyTypeObject G_GNUC_INTERNAL PyGtkSourceLanguage_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.Language",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceLanguage_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)_wrap_gtk_source_language_tp_new,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceLanguageManager ----------- */

 static int
_wrap_gtk_source_language_manager_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":gtksourceview2.LanguageManager.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create gtksourceview2.LanguageManager object");
        return -1;
    }
    return 0;
}

#line 189 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_manager_get_language_ids (PyGObject *self)
{
    PyObject *py_ret;
    const char * const *ret;

    ret = gtk_source_language_manager_get_language_ids (GTK_SOURCE_LANGUAGE_MANAGER (self->obj));
    py_ret = strv_to_pylist ((char**) ret);

    return py_ret;
}

#line 1688 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_language_manager_get_language(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", NULL };
    char *id;
    GtkSourceLanguage *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.LanguageManager.get_language", kwlist, &id))
        return NULL;
    
    ret = gtk_source_language_manager_get_language(GTK_SOURCE_LANGUAGE_MANAGER(self->obj), id);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 203 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_manager_get_search_path(PyGObject *self)
{
    const char * const *ret;
    PyObject  *py_ret;

    ret = gtk_source_language_manager_get_search_path (GTK_SOURCE_LANGUAGE_MANAGER(self->obj));
    py_ret = strv_to_pylist ((char**) ret);

    return py_ret;
}

#line 1720 "gtksourceview2.c"


#line 217 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_language_manager_set_search_path (PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dirs", NULL };
    PyObject *py_dirs;
    char **dirs;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceLanguageManager.set_search_path", kwlist, &py_dirs))
        return NULL;

    if (!pylist_to_strv (py_dirs, &dirs))
        return NULL;

    gtk_source_language_manager_set_search_path (GTK_SOURCE_LANGUAGE_MANAGER (self->obj), dirs);
    g_strfreev (dirs);

    Py_INCREF(Py_None);
    return Py_None;
}

#line 1744 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_language_manager_guess_language(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "filename", "content_type", NULL };
    char *filename = NULL, *content_type = NULL;
    GtkSourceLanguage *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"|zz:GtkSourceView.LanguageManager.guess_language", kwlist, &filename, &content_type))
        return NULL;
    
    ret = gtk_source_language_manager_guess_language(GTK_SOURCE_LANGUAGE_MANAGER(self->obj), filename, content_type);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static const PyMethodDef _PyGtkSourceLanguageManager_methods[] = {
    { "get_language_ids", (PyCFunction)_wrap_gtk_source_language_manager_get_language_ids, METH_NOARGS,
      NULL },
    { "get_language", (PyCFunction)_wrap_gtk_source_language_manager_get_language, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_search_path", (PyCFunction)_wrap_gtk_source_language_manager_get_search_path, METH_NOARGS,
      NULL },
    { "set_search_path", (PyCFunction)_wrap_gtk_source_language_manager_set_search_path, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "guess_language", (PyCFunction)_wrap_gtk_source_language_manager_guess_language, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceLanguageManager_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.LanguageManager",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceLanguageManager_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_language_manager_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceMark ----------- */

static int
_wrap_gtk_source_mark_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "category", NULL };
    char *name, *category;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"zs:GtkSourceView.Mark.__init__", kwlist, &name, &category))
        return -1;
    self->obj = (GObject *)gtk_source_mark_new(name, category);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GtkSourceMark object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gtk_source_mark_get_category(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_mark_get_category(GTK_SOURCE_MARK(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_mark_next(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", NULL };
    char *category;
    GtkSourceMark *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"z:GtkSourceView.Mark.next", kwlist, &category))
        return NULL;
    
    ret = gtk_source_mark_next(GTK_SOURCE_MARK(self->obj), category);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_mark_prev(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", NULL };
    char *category;
    GtkSourceMark *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"z:GtkSourceView.Mark.prev", kwlist, &category))
        return NULL;
    
    ret = gtk_source_mark_prev(GTK_SOURCE_MARK(self->obj), category);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static const PyMethodDef _PyGtkSourceMark_methods[] = {
    { "get_category", (PyCFunction)_wrap_gtk_source_mark_get_category, METH_NOARGS,
      NULL },
    { "next", (PyCFunction)_wrap_gtk_source_mark_next, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "prev", (PyCFunction)_wrap_gtk_source_mark_prev, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceMark_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.Mark",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceMark_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_mark_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourcePrintCompositor ----------- */

static int
_wrap_gtk_source_print_compositor_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "buffer", NULL };
    PyGObject *buffer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.PrintCompositor.__init__", kwlist, &PyGtkSourceBuffer_Type, &buffer))
        return -1;
    self->obj = (GObject *)gtk_source_print_compositor_new(GTK_SOURCE_BUFFER(buffer->obj));

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GtkSourcePrintCompositor object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_buffer(PyGObject *self)
{
    GtkSourceBuffer *ret;

    
    ret = gtk_source_print_compositor_get_buffer(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_tab_width(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "width", NULL };
    PyObject *py_width = NULL;
    guint width = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.set_tab_width", kwlist, &py_width))
        return NULL;
    if (py_width) {
        if (PyLong_Check(py_width))
            width = PyLong_AsUnsignedLong(py_width);
        else if (PyInt_Check(py_width))
            width = PyInt_AsLong(py_width);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'width' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    gtk_source_print_compositor_set_tab_width(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), width);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_tab_width(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_print_compositor_get_tab_width(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_wrap_mode(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "wrap_mode", NULL };
    PyObject *py_wrap_mode = NULL;
    GtkWrapMode wrap_mode;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.set_wrap_mode", kwlist, &py_wrap_mode))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_WRAP_MODE, py_wrap_mode, (gpointer)&wrap_mode))
        return NULL;
    
    gtk_source_print_compositor_set_wrap_mode(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), wrap_mode);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_wrap_mode(PyGObject *self)
{
    gint ret;

    
    ret = gtk_source_print_compositor_get_wrap_mode(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return pyg_enum_from_gtype(GTK_TYPE_WRAP_MODE, ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_highlight_syntax(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "highlight", NULL };
    int highlight;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.PrintCompositor.set_highlight_syntax", kwlist, &highlight))
        return NULL;
    
    gtk_source_print_compositor_set_highlight_syntax(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), highlight);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_highlight_syntax(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_print_compositor_get_highlight_syntax(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_print_compositor_set_print_line_numbers(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "interval", NULL };
    PyObject *py_interval = NULL;
    guint interval = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.set_print_line_numbers", kwlist, &py_interval))
        return NULL;
    if (py_interval) {
        if (PyLong_Check(py_interval))
            interval = PyLong_AsUnsignedLong(py_interval);
        else if (PyInt_Check(py_interval))
            interval = PyInt_AsLong(py_interval);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'interval' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    gtk_source_print_compositor_set_print_line_numbers(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), interval);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_print_line_numbers(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_print_compositor_get_print_line_numbers(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_body_font_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "font_name", NULL };
    char *font_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.PrintCompositor.set_body_font_name", kwlist, &font_name))
        return NULL;
    
    gtk_source_print_compositor_set_body_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), font_name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_body_font_name(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_print_compositor_get_body_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_set_line_numbers_font_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "font_name", NULL };
    char *font_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"z:GtkSourceView.PrintCompositor.set_line_numbers_font_name", kwlist, &font_name))
        return NULL;
    
    gtk_source_print_compositor_set_line_numbers_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), font_name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_line_numbers_font_name(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_print_compositor_get_line_numbers_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_set_header_font_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "font_name", NULL };
    char *font_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"z:GtkSourceView.PrintCompositor.set_header_font_name", kwlist, &font_name))
        return NULL;
    
    gtk_source_print_compositor_set_header_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), font_name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_header_font_name(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_print_compositor_get_header_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_set_footer_font_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "font_name", NULL };
    char *font_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"z:GtkSourceView.PrintCompositor.set_footer_font_name", kwlist, &font_name))
        return NULL;
    
    gtk_source_print_compositor_set_footer_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), font_name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_footer_font_name(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_print_compositor_get_footer_font_name(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_top_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "unit", NULL };
    PyObject *py_unit = NULL;
    double ret;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.get_top_margin", kwlist, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    ret = gtk_source_print_compositor_get_top_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), unit);
    
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_top_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "margin", "unit", NULL };
    PyObject *py_unit = NULL;
    double margin;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dO:GtkSourceView.PrintCompositor.set_top_margin", kwlist, &margin, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    gtk_source_print_compositor_set_top_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), margin, unit);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_bottom_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "unit", NULL };
    PyObject *py_unit = NULL;
    double ret;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.get_bottom_margin", kwlist, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    ret = gtk_source_print_compositor_get_bottom_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), unit);
    
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_bottom_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "margin", "unit", NULL };
    PyObject *py_unit = NULL;
    double margin;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dO:GtkSourceView.PrintCompositor.set_bottom_margin", kwlist, &margin, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    gtk_source_print_compositor_set_bottom_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), margin, unit);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_left_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "unit", NULL };
    PyObject *py_unit = NULL;
    double ret;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.get_left_margin", kwlist, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    ret = gtk_source_print_compositor_get_left_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), unit);
    
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_left_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "margin", "unit", NULL };
    PyObject *py_unit = NULL;
    double margin;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dO:GtkSourceView.PrintCompositor.set_left_margin", kwlist, &margin, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    gtk_source_print_compositor_set_left_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), margin, unit);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_right_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "unit", NULL };
    PyObject *py_unit = NULL;
    double ret;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.PrintCompositor.get_right_margin", kwlist, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    ret = gtk_source_print_compositor_get_right_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), unit);
    
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_set_right_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "margin", "unit", NULL };
    PyObject *py_unit = NULL;
    double margin;
    GtkUnit unit;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dO:GtkSourceView.PrintCompositor.set_right_margin", kwlist, &margin, &py_unit))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_UNIT, py_unit, (gpointer)&unit))
        return NULL;
    
    gtk_source_print_compositor_set_right_margin(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), margin, unit);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_set_print_header(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "print_", NULL };
    int print;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.PrintCompositor.set_print_header", kwlist, &print))
        return NULL;
    
    gtk_source_print_compositor_set_print_header(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), print);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_print_header(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_print_compositor_get_print_header(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_print_compositor_set_print_footer(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "print_", NULL };
    int print;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.PrintCompositor.set_print_footer", kwlist, &print))
        return NULL;
    
    gtk_source_print_compositor_set_print_footer(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), print);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_print_footer(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_print_compositor_get_print_footer(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_print_compositor_set_header_format(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "separator", "left", "center", "right", NULL };
    int separator;
    char *left, *center, *right;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"izzz:GtkSourceView.PrintCompositor.set_header_format", kwlist, &separator, &left, &center, &right))
        return NULL;
    
    gtk_source_print_compositor_set_header_format(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), separator, left, center, right);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_set_footer_format(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "separator", "left", "center", "right", NULL };
    int separator;
    char *left, *center, *right;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"izzz:GtkSourceView.PrintCompositor.set_footer_format", kwlist, &separator, &left, &center, &right))
        return NULL;
    
    gtk_source_print_compositor_set_footer_format(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), separator, left, center, right);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_print_compositor_get_n_pages(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_print_compositor_get_n_pages(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_paginate(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", NULL };
    PyGObject *context;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.PrintCompositor.paginate", kwlist, &PyGtkPrintContext_Type, &context))
        return NULL;
    
    ret = gtk_source_print_compositor_paginate(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), GTK_PRINT_CONTEXT(context->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_print_compositor_get_pagination_progress(PyGObject *self)
{
    double ret;

    
    ret = gtk_source_print_compositor_get_pagination_progress(GTK_SOURCE_PRINT_COMPOSITOR(self->obj));
    
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_draw_page(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", "page_nr", NULL };
    PyGObject *context;
    int page_nr;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!i:GtkSourceView.PrintCompositor.draw_page", kwlist, &PyGtkPrintContext_Type, &context, &page_nr))
        return NULL;
    
    gtk_source_print_compositor_draw_page(GTK_SOURCE_PRINT_COMPOSITOR(self->obj), GTK_PRINT_CONTEXT(context->obj), page_nr);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourcePrintCompositor_methods[] = {
    { "get_buffer", (PyCFunction)_wrap_gtk_source_print_compositor_get_buffer, METH_NOARGS,
      NULL },
    { "set_tab_width", (PyCFunction)_wrap_gtk_source_print_compositor_set_tab_width, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_tab_width", (PyCFunction)_wrap_gtk_source_print_compositor_get_tab_width, METH_NOARGS,
      NULL },
    { "set_wrap_mode", (PyCFunction)_wrap_gtk_source_print_compositor_set_wrap_mode, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_wrap_mode", (PyCFunction)_wrap_gtk_source_print_compositor_get_wrap_mode, METH_NOARGS,
      NULL },
    { "set_highlight_syntax", (PyCFunction)_wrap_gtk_source_print_compositor_set_highlight_syntax, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_highlight_syntax", (PyCFunction)_wrap_gtk_source_print_compositor_get_highlight_syntax, METH_NOARGS,
      NULL },
    { "set_print_line_numbers", (PyCFunction)_wrap_gtk_source_print_compositor_set_print_line_numbers, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_print_line_numbers", (PyCFunction)_wrap_gtk_source_print_compositor_get_print_line_numbers, METH_NOARGS,
      NULL },
    { "set_body_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_set_body_font_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_body_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_get_body_font_name, METH_NOARGS,
      NULL },
    { "set_line_numbers_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_set_line_numbers_font_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_line_numbers_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_get_line_numbers_font_name, METH_NOARGS,
      NULL },
    { "set_header_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_set_header_font_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_header_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_get_header_font_name, METH_NOARGS,
      NULL },
    { "set_footer_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_set_footer_font_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_footer_font_name", (PyCFunction)_wrap_gtk_source_print_compositor_get_footer_font_name, METH_NOARGS,
      NULL },
    { "get_top_margin", (PyCFunction)_wrap_gtk_source_print_compositor_get_top_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_top_margin", (PyCFunction)_wrap_gtk_source_print_compositor_set_top_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_bottom_margin", (PyCFunction)_wrap_gtk_source_print_compositor_get_bottom_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_bottom_margin", (PyCFunction)_wrap_gtk_source_print_compositor_set_bottom_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_left_margin", (PyCFunction)_wrap_gtk_source_print_compositor_get_left_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_left_margin", (PyCFunction)_wrap_gtk_source_print_compositor_set_left_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_right_margin", (PyCFunction)_wrap_gtk_source_print_compositor_get_right_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_right_margin", (PyCFunction)_wrap_gtk_source_print_compositor_set_right_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_print_header", (PyCFunction)_wrap_gtk_source_print_compositor_set_print_header, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_print_header", (PyCFunction)_wrap_gtk_source_print_compositor_get_print_header, METH_NOARGS,
      NULL },
    { "set_print_footer", (PyCFunction)_wrap_gtk_source_print_compositor_set_print_footer, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_print_footer", (PyCFunction)_wrap_gtk_source_print_compositor_get_print_footer, METH_NOARGS,
      NULL },
    { "set_header_format", (PyCFunction)_wrap_gtk_source_print_compositor_set_header_format, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_footer_format", (PyCFunction)_wrap_gtk_source_print_compositor_set_footer_format, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_n_pages", (PyCFunction)_wrap_gtk_source_print_compositor_get_n_pages, METH_NOARGS,
      NULL },
    { "paginate", (PyCFunction)_wrap_gtk_source_print_compositor_paginate, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_pagination_progress", (PyCFunction)_wrap_gtk_source_print_compositor_get_pagination_progress, METH_NOARGS,
      NULL },
    { "draw_page", (PyCFunction)_wrap_gtk_source_print_compositor_draw_page, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourcePrintCompositor_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.PrintCompositor",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourcePrintCompositor_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_print_compositor_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceStyle ----------- */

static int
_wrap_gtk_source_style_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":gtksourceview2.Style.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create gtksourceview2.Style object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_gtk_source_style_copy(PyGObject *self)
{
    GtkSourceStyle *ret;

    
    ret = gtk_source_style_copy(GTK_SOURCE_STYLE(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static const PyMethodDef _PyGtkSourceStyle_methods[] = {
    { "copy", (PyCFunction)_wrap_gtk_source_style_copy, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceStyle_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.Style",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceStyle_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_style_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceStyleScheme ----------- */

static PyObject *
_wrap_gtk_source_style_scheme_get_id(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_style_scheme_get_id(GTK_SOURCE_STYLE_SCHEME(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_style_scheme_get_name(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_style_scheme_get_name(GTK_SOURCE_STYLE_SCHEME(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_style_scheme_get_description(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_style_scheme_get_description(GTK_SOURCE_STYLE_SCHEME(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 289 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_style_scheme_get_authors (PyGObject *self)
{
    PyObject *py_ret;
    const char * const *ret;

    ret = gtk_source_style_scheme_get_authors (GTK_SOURCE_STYLE_SCHEME (self->obj));
    py_ret = strv_to_pylist ((char**) ret);

    return py_ret;
}

#line 2790 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_style_scheme_get_filename(PyGObject *self)
{
    const gchar *ret;

    
    ret = gtk_source_style_scheme_get_filename(GTK_SOURCE_STYLE_SCHEME(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_style_scheme_get_style(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "style_name", NULL };
    char *style_name;
    GtkSourceStyle *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.StyleScheme.get_style", kwlist, &style_name))
        return NULL;
    
    ret = gtk_source_style_scheme_get_style(GTK_SOURCE_STYLE_SCHEME(self->obj), style_name);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static const PyMethodDef _PyGtkSourceStyleScheme_methods[] = {
    { "get_id", (PyCFunction)_wrap_gtk_source_style_scheme_get_id, METH_NOARGS,
      NULL },
    { "get_name", (PyCFunction)_wrap_gtk_source_style_scheme_get_name, METH_NOARGS,
      NULL },
    { "get_description", (PyCFunction)_wrap_gtk_source_style_scheme_get_description, METH_NOARGS,
      NULL },
    { "get_authors", (PyCFunction)_wrap_gtk_source_style_scheme_get_authors, METH_NOARGS,
      NULL },
    { "get_filename", (PyCFunction)_wrap_gtk_source_style_scheme_get_filename, METH_NOARGS,
      NULL },
    { "get_style", (PyCFunction)_wrap_gtk_source_style_scheme_get_style, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

#line 313 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_style_scheme_tp_new(PyTypeObject *type)
{
    PyErr_SetString(PyExc_TypeError,
            "cannot create instance of type `GtkSourceStyleScheme'");
    return NULL;
}

#line 2848 "gtksourceview2.c"


PyTypeObject G_GNUC_INTERNAL PyGtkSourceStyleScheme_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.StyleScheme",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceStyleScheme_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)_wrap_gtk_source_style_scheme_tp_new,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceStyleSchemeManager ----------- */

static int
_wrap_gtk_source_style_scheme_manager_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":gtksourceview2.StyleSchemeManager.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create gtksourceview2.StyleSchemeManager object");
        return -1;
    }
    return 0;
}

#line 253 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_style_scheme_manager_set_search_path(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dirs", NULL };
    PyObject *py_dirs;
    char **dirs;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceStyleSchemeManager.set_search_path", kwlist, &py_dirs))
        return NULL;

    if (!pylist_to_strv (py_dirs, &dirs))
        return NULL;

    gtk_source_style_scheme_manager_set_search_path (GTK_SOURCE_STYLE_SCHEME_MANAGER (self->obj), dirs);
    g_strfreev (dirs);

    Py_INCREF(Py_None);
    return Py_None;
}

#line 2941 "gtksourceview2.c"


#line 239 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_style_scheme_manager_get_search_path(PyGObject *self)
{
    const char * const *ret;
    PyObject *py_ret;

    ret = gtk_source_style_scheme_manager_get_search_path (GTK_SOURCE_STYLE_SCHEME_MANAGER (self->obj));
    py_ret = strv_to_pylist ((char**) ret);

    return py_ret;
}

#line 2957 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_style_scheme_manager_append_search_path(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", NULL };
    char *path;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.StyleSchemeManager.append_search_path", kwlist, &path))
        return NULL;
    
    gtk_source_style_scheme_manager_append_search_path(GTK_SOURCE_STYLE_SCHEME_MANAGER(self->obj), path);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_style_scheme_manager_prepend_search_path(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", NULL };
    char *path;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.StyleSchemeManager.prepend_search_path", kwlist, &path))
        return NULL;
    
    gtk_source_style_scheme_manager_prepend_search_path(GTK_SOURCE_STYLE_SCHEME_MANAGER(self->obj), path);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 275 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_style_scheme_manager_get_scheme_ids (PyGObject *self)
{
    PyObject *py_ret;
    const char * const *ret;

    ret = gtk_source_style_scheme_manager_get_scheme_ids (GTK_SOURCE_STYLE_SCHEME_MANAGER (self->obj));
    py_ret = strv_to_pylist ((char**) ret);

    return py_ret;
}

#line 3003 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_style_scheme_manager_get_scheme(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "scheme_id", NULL };
    char *scheme_id;
    GtkSourceStyleScheme *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.StyleSchemeManager.get_scheme", kwlist, &scheme_id))
        return NULL;
    
    ret = gtk_source_style_scheme_manager_get_scheme(GTK_SOURCE_STYLE_SCHEME_MANAGER(self->obj), scheme_id);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_style_scheme_manager_force_rescan(PyGObject *self)
{
    
    gtk_source_style_scheme_manager_force_rescan(GTK_SOURCE_STYLE_SCHEME_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceStyleSchemeManager_methods[] = {
    { "set_search_path", (PyCFunction)_wrap_gtk_source_style_scheme_manager_set_search_path, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_search_path", (PyCFunction)_wrap_gtk_source_style_scheme_manager_get_search_path, METH_NOARGS,
      NULL },
    { "append_search_path", (PyCFunction)_wrap_gtk_source_style_scheme_manager_append_search_path, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "prepend_search_path", (PyCFunction)_wrap_gtk_source_style_scheme_manager_prepend_search_path, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_scheme_ids", (PyCFunction)_wrap_gtk_source_style_scheme_manager_get_scheme_ids, METH_NOARGS,
      NULL },
    { "get_scheme", (PyCFunction)_wrap_gtk_source_style_scheme_manager_get_scheme, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "force_rescan", (PyCFunction)_wrap_gtk_source_style_scheme_manager_force_rescan, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceStyleSchemeManager_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.StyleSchemeManager",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceStyleSchemeManager_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_style_scheme_manager_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceView ----------- */

static int
_wrap_gtk_source_view_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GType obj_type = pyg_type_from_object((PyObject *) self);
    GParameter params[1];
    PyObject *parsed_args[1] = {NULL, };
    char *arg_names[] = {"buffer", NULL };
    char *prop_names[] = {"buffer", NULL };
    guint nparams, i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|O:gtksourceview2.View.__init__" , arg_names , &parsed_args[0]))
        return -1;

    memset(params, 0, sizeof(GParameter)*1);
    if (!pyg_parse_constructor_args(obj_type, arg_names,
                                    prop_names, params, 
                                    &nparams, parsed_args))
        return -1;
    pygobject_constructv(self, nparams, params);
    for (i = 0; i < nparams; ++i)
        g_value_unset(&params[i].value);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create gtksourceview2.View object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_gtk_source_view_set_show_line_numbers(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "show", NULL };
    int show;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_show_line_numbers", kwlist, &show))
        return NULL;
    
    gtk_source_view_set_show_line_numbers(GTK_SOURCE_VIEW(self->obj), show);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_show_line_numbers(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_show_line_numbers(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_indent_width(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "width", NULL };
    int width;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_indent_width", kwlist, &width))
        return NULL;
    
    gtk_source_view_set_indent_width(GTK_SOURCE_VIEW(self->obj), width);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_indent_width(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_indent_width(GTK_SOURCE_VIEW(self->obj));
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gtk_source_view_set_tab_width(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "width", NULL };
    PyObject *py_width = NULL;
    guint width = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.View.set_tab_width", kwlist, &py_width))
        return NULL;
    if (py_width) {
        if (PyLong_Check(py_width))
            width = PyLong_AsUnsignedLong(py_width);
        else if (PyInt_Check(py_width))
            width = PyInt_AsLong(py_width);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'width' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    gtk_source_view_set_tab_width(GTK_SOURCE_VIEW(self->obj), width);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_tab_width(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_view_get_tab_width(GTK_SOURCE_VIEW(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_gtk_source_view_set_auto_indent(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "enable", NULL };
    int enable;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_auto_indent", kwlist, &enable))
        return NULL;
    
    gtk_source_view_set_auto_indent(GTK_SOURCE_VIEW(self->obj), enable);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_auto_indent(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_auto_indent(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_insert_spaces_instead_of_tabs(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "enable", NULL };
    int enable;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_insert_spaces_instead_of_tabs", kwlist, &enable))
        return NULL;
    
    gtk_source_view_set_insert_spaces_instead_of_tabs(GTK_SOURCE_VIEW(self->obj), enable);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_insert_spaces_instead_of_tabs(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_insert_spaces_instead_of_tabs(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_indent_on_tab(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "enable", NULL };
    int enable;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_indent_on_tab", kwlist, &enable))
        return NULL;
    
    gtk_source_view_set_indent_on_tab(GTK_SOURCE_VIEW(self->obj), enable);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_indent_on_tab(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_indent_on_tab(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_highlight_current_line(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "show", NULL };
    int show;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_highlight_current_line", kwlist, &show))
        return NULL;
    
    gtk_source_view_set_highlight_current_line(GTK_SOURCE_VIEW(self->obj), show);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_highlight_current_line(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_highlight_current_line(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_show_right_margin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "show", NULL };
    int show;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_show_right_margin", kwlist, &show))
        return NULL;
    
    gtk_source_view_set_show_right_margin(GTK_SOURCE_VIEW(self->obj), show);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_show_right_margin(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_show_right_margin(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_right_margin_position(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "pos", NULL };
    PyObject *py_pos = NULL;
    guint pos = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.View.set_right_margin_position", kwlist, &py_pos))
        return NULL;
    if (py_pos) {
        if (PyLong_Check(py_pos))
            pos = PyLong_AsUnsignedLong(py_pos);
        else if (PyInt_Check(py_pos))
            pos = PyInt_AsLong(py_pos);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'pos' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    gtk_source_view_set_right_margin_position(GTK_SOURCE_VIEW(self->obj), pos);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_right_margin_position(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_view_get_right_margin_position(GTK_SOURCE_VIEW(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_gtk_source_view_set_show_line_marks(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "show", NULL };
    int show;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GtkSourceView.View.set_show_line_marks", kwlist, &show))
        return NULL;
    
    gtk_source_view_set_show_line_marks(GTK_SOURCE_VIEW(self->obj), show);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_show_line_marks(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_view_get_show_line_marks(GTK_SOURCE_VIEW(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_view_set_mark_category_pixbuf(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", "pixbuf", NULL };
    char *category;
    PyGObject *py_pixbuf;
    GdkPixbuf *pixbuf = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GtkSourceView.View.set_mark_category_pixbuf", kwlist, &category, &py_pixbuf))
        return NULL;
    if (py_pixbuf && pygobject_check(py_pixbuf, &PyGdkPixbuf_Type))
        pixbuf = GDK_PIXBUF(py_pixbuf->obj);
    else if ((PyObject *)py_pixbuf != Py_None) {
        PyErr_SetString(PyExc_TypeError, "pixbuf should be a GdkPixbuf or None");
        return NULL;
    }
    
    gtk_source_view_set_mark_category_pixbuf(GTK_SOURCE_VIEW(self->obj), category, (GdkPixbuf *) pixbuf);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_mark_category_pixbuf(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", NULL };
    char *category;
    GdkPixbuf *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.View.get_mark_category_pixbuf", kwlist, &category))
        return NULL;
    
    ret = gtk_source_view_get_mark_category_pixbuf(GTK_SOURCE_VIEW(self->obj), category);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_view_set_mark_category_priority(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", "priority", NULL };
    char *category;
    int priority;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:GtkSourceView.View.set_mark_category_priority", kwlist, &category, &priority))
        return NULL;
    
    gtk_source_view_set_mark_category_priority(GTK_SOURCE_VIEW(self->obj), category, priority);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_mark_category_priority(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", NULL };
    char *category;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GtkSourceView.View.get_mark_category_priority", kwlist, &category))
        return NULL;
    
    ret = gtk_source_view_get_mark_category_priority(GTK_SOURCE_VIEW(self->obj), category);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gtk_source_view_set_smart_home_end(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "smart_he", NULL };
    PyObject *py_smart_he = NULL;
    GtkSourceSmartHomeEndType smart_he;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.View.set_smart_home_end", kwlist, &py_smart_he))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_SOURCE_SMART_HOME_END_TYPE, py_smart_he, (gpointer)&smart_he))
        return NULL;
    
    gtk_source_view_set_smart_home_end(GTK_SOURCE_VIEW(self->obj), smart_he);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_smart_home_end(PyGObject *self)
{
    gint ret;

    
    ret = gtk_source_view_get_smart_home_end(GTK_SOURCE_VIEW(self->obj));
    
    return pyg_enum_from_gtype(GTK_TYPE_SOURCE_SMART_HOME_END_TYPE, ret);
}

static PyObject *
_wrap_gtk_source_view_set_draw_spaces(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "flags", NULL };
    PyObject *py_flags = NULL;
    GtkSourceDrawSpacesFlags flags;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.View.set_draw_spaces", kwlist, &py_flags))
        return NULL;
    if (pyg_flags_get_value(GTK_TYPE_SOURCE_DRAW_SPACES_FLAGS, py_flags, (gpointer)&flags))
        return NULL;
    
    gtk_source_view_set_draw_spaces(GTK_SOURCE_VIEW(self->obj), flags);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_get_draw_spaces(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_view_get_draw_spaces(GTK_SOURCE_VIEW(self->obj));
    
    return pyg_flags_from_gtype(GTK_TYPE_SOURCE_DRAW_SPACES_FLAGS, ret);
}

static PyObject *
_wrap_gtk_source_view_set_mark_category_background(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", "color", NULL };
    char *category;
    PyObject *py_color = Py_None;
    GdkColor *color = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GtkSourceView.View.set_mark_category_background", kwlist, &category, &py_color))
        return NULL;
    if (pyg_boxed_check(py_color, GDK_TYPE_COLOR))
        color = pyg_boxed_get(py_color, GdkColor);
    else if (py_color != Py_None) {
        PyErr_SetString(PyExc_TypeError, "color should be a GdkColor or None");
        return NULL;
    }
    
    gtk_source_view_set_mark_category_background(GTK_SOURCE_VIEW(self->obj), category, color);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 486 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_view_get_mark_category_background(PyGObject *self,
                                                   PyObject *args,
                                                   PyObject *kwargs)
{
    static char *kwlist[] = { "category", NULL };
    char *category;
    int ret;
    GdkColor dest = { 0, 0, 0, 0 };

    if (!PyArg_ParseTupleAndKeywords(args,
                                kwargs,
                                "s:GtkSourceView.get_mark_category_background",
                                kwlist, &category))
        return NULL;

    ret = gtk_source_view_get_mark_category_background(
                                                    GTK_SOURCE_VIEW(self->obj),
                                                    category, &dest);

    if (ret)
        return pyg_boxed_new(GDK_TYPE_COLOR, &dest, TRUE, TRUE);
    else {
        Py_INCREF(Py_None);
        return(Py_None);
    }
}

#line 3598 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_view_get_completion(PyGObject *self)
{
    GtkSourceCompletion *ret;

    
    ret = gtk_source_view_get_completion(GTK_SOURCE_VIEW(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_view_get_gutter(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "window_type", NULL };
    PyObject *py_window_type = NULL;
    GtkSourceGutter *ret;
    GtkTextWindowType window_type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.View.get_gutter", kwlist, &py_window_type))
        return NULL;
    if (pyg_enum_get_value(GTK_TYPE_TEXT_WINDOW_TYPE, py_window_type, (gpointer)&window_type))
        return NULL;
    
    ret = gtk_source_view_get_gutter(GTK_SOURCE_VIEW(self->obj), window_type);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_view_set_mark_category_icon_from_pixbuf(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", "pixbuf", NULL };
    char *category;
    PyGObject *py_pixbuf;
    GdkPixbuf *pixbuf = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GtkSourceView.View.set_mark_category_icon_from_pixbuf", kwlist, &category, &py_pixbuf))
        return NULL;
    if (py_pixbuf && pygobject_check(py_pixbuf, &PyGdkPixbuf_Type))
        pixbuf = GDK_PIXBUF(py_pixbuf->obj);
    else if ((PyObject *)py_pixbuf != Py_None) {
        PyErr_SetString(PyExc_TypeError, "pixbuf should be a GdkPixbuf or None");
        return NULL;
    }
    
    gtk_source_view_set_mark_category_icon_from_pixbuf(GTK_SOURCE_VIEW(self->obj), category, (GdkPixbuf *) pixbuf);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_set_mark_category_icon_from_stock(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", "stock_id", NULL };
    char *category, *stock_id;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sz:GtkSourceView.View.set_mark_category_icon_from_stock", kwlist, &category, &stock_id))
        return NULL;
    
    gtk_source_view_set_mark_category_icon_from_stock(GTK_SOURCE_VIEW(self->obj), category, stock_id);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_view_set_mark_category_icon_from_icon_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "category", "name", NULL };
    char *category, *name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sz:GtkSourceView.View.set_mark_category_icon_from_icon_name", kwlist, &category, &name))
        return NULL;
    
    gtk_source_view_set_mark_category_icon_from_icon_name(GTK_SOURCE_VIEW(self->obj), category, name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 1107 "gtksourceview2.override"
static gchar *
pygtksourceview_mark_tooltip_func_marshal (GtkSourceMark *mark,
                                           gpointer data)
{
    PyGILState_STATE state;
    PyGtkSourceViewCustomNotify *cunote = data;
    PyObject *retobj;
    PyObject *pymark;
    gchar *retval = NULL;

    g_assert (cunote->func);

    state = pyg_gil_state_ensure();

    pymark = pygobject_new((GObject *)mark);
    
    if (cunote->data)
        retobj = PyEval_CallFunction(cunote->func, "(NO)",
                                     pymark,
                                     cunote->data);
    else
        retobj = PyEval_CallFunction(cunote->func, "(N)",
                                     pymark);

    if (retobj == NULL) {
        PyErr_Print();
    } else
        retval = PyString_AsString(retobj);
        Py_DECREF(retobj);

    pyg_gil_state_release(state);
    
    return retval;
}

static PyObject *
_wrap_gtk_source_view_set_mark_category_tooltip_func (PyGObject *self,
                                                      PyObject *args,
                                                      PyObject *kwargs)
{
    PyObject *pyfunc, *pyarg = NULL;
    PyGtkSourceViewCustomNotify *cunote;
    gchar *category;

    if (!PyArg_ParseTuple(args, "sO|O:GtkSourceView.set_mark_category_tooltip_func",
                          &category, &pyfunc, &pyarg))
        return NULL;

    if (pyfunc == Py_None) {
        gtk_source_view_set_mark_category_tooltip_func(GTK_SOURCE_VIEW(self->obj),
                                        category, NULL, NULL, NULL);
    } else {
        cunote = g_new0(PyGtkSourceViewCustomNotify, 1);
        cunote->func = pyfunc;
        cunote->data = pyarg;
        Py_INCREF(cunote->func);
        Py_XINCREF(cunote->data);

        gtk_source_view_set_mark_category_tooltip_func(GTK_SOURCE_VIEW(self->obj),
                                        category,
                                        pygtksourceview_mark_tooltip_func_marshal,
                                        cunote,
                                        pygtksourceview_custom_destroy_notify);
    }

    Py_INCREF(Py_None);
    return Py_None;
}

#line 3755 "gtksourceview2.c"


#line 1178 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_view_set_mark_category_tooltip_markup_func (PyGObject *self,
                                                             PyObject *args,
                                                             PyObject *kwargs)
{
    PyObject *pyfunc, *pyarg = NULL;
    PyGtkSourceViewCustomNotify *cunote;
    gchar *category;

    if (!PyArg_ParseTuple(args, "sO|O:GtkSourceView.set_mark_category_tooltip_markup_func",
                          &category, &pyfunc, &pyarg))
        return NULL;

    if (pyfunc == Py_None) {
        gtk_source_view_set_mark_category_tooltip_markup_func(GTK_SOURCE_VIEW(self->obj),
                                        category, NULL, NULL, NULL);
    } else {
        cunote = g_new0(PyGtkSourceViewCustomNotify, 1);
        cunote->func = pyfunc;
        cunote->data = pyarg;
        Py_INCREF(cunote->func);
        Py_XINCREF(cunote->data);

        gtk_source_view_set_mark_category_tooltip_markup_func(GTK_SOURCE_VIEW(self->obj),
                                        category,
                                        pygtksourceview_mark_tooltip_func_marshal,
                                        cunote,
                                        pygtksourceview_custom_destroy_notify);
    }

    Py_INCREF(Py_None);
    return Py_None;
}

#line 3793 "gtksourceview2.c"


static PyObject *
_wrap_GtkSourceView__do_undo(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    gpointer klass;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.View.undo", kwlist, &PyGtkSourceView_Type, &self))
        return NULL;
    klass = g_type_class_ref(pyg_type_from_object(cls));
    if (GTK_SOURCE_VIEW_CLASS(klass)->undo)
        GTK_SOURCE_VIEW_CLASS(klass)->undo(GTK_SOURCE_VIEW(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "virtual method GtkSourceView.View.undo not implemented");
        g_type_class_unref(klass);
        return NULL;
    }
    g_type_class_unref(klass);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceView__do_redo(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    gpointer klass;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.View.redo", kwlist, &PyGtkSourceView_Type, &self))
        return NULL;
    klass = g_type_class_ref(pyg_type_from_object(cls));
    if (GTK_SOURCE_VIEW_CLASS(klass)->redo)
        GTK_SOURCE_VIEW_CLASS(klass)->redo(GTK_SOURCE_VIEW(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "virtual method GtkSourceView.View.redo not implemented");
        g_type_class_unref(klass);
        return NULL;
    }
    g_type_class_unref(klass);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceView__do_line_mark_activated(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    gpointer klass;
    static char *kwlist[] = { "self", "iter", "event", NULL };
    PyGObject *self;
    PyObject *py_iter, *py_event;
    GtkTextIter *iter = NULL;
    GdkEvent *event = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!OO:GtkSourceView.View.line_mark_activated", kwlist, &PyGtkSourceView_Type, &self, &py_iter, &py_event))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    if (pyg_boxed_check(py_event, GDK_TYPE_EVENT))
        event = pyg_boxed_get(py_event, GdkEvent);
    else {
        PyErr_SetString(PyExc_TypeError, "event should be a GdkEvent");
        return NULL;
    }
    klass = g_type_class_ref(pyg_type_from_object(cls));
    if (GTK_SOURCE_VIEW_CLASS(klass)->line_mark_activated)
        GTK_SOURCE_VIEW_CLASS(klass)->line_mark_activated(GTK_SOURCE_VIEW(self->obj), iter, event);
    else {
        PyErr_SetString(PyExc_NotImplementedError, "virtual method GtkSourceView.View.line_mark_activated not implemented");
        g_type_class_unref(klass);
        return NULL;
    }
    g_type_class_unref(klass);
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceView_methods[] = {
    { "set_show_line_numbers", (PyCFunction)_wrap_gtk_source_view_set_show_line_numbers, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_show_line_numbers", (PyCFunction)_wrap_gtk_source_view_get_show_line_numbers, METH_NOARGS,
      NULL },
    { "set_indent_width", (PyCFunction)_wrap_gtk_source_view_set_indent_width, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_indent_width", (PyCFunction)_wrap_gtk_source_view_get_indent_width, METH_NOARGS,
      NULL },
    { "set_tab_width", (PyCFunction)_wrap_gtk_source_view_set_tab_width, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_tab_width", (PyCFunction)_wrap_gtk_source_view_get_tab_width, METH_NOARGS,
      NULL },
    { "set_auto_indent", (PyCFunction)_wrap_gtk_source_view_set_auto_indent, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_auto_indent", (PyCFunction)_wrap_gtk_source_view_get_auto_indent, METH_NOARGS,
      NULL },
    { "set_insert_spaces_instead_of_tabs", (PyCFunction)_wrap_gtk_source_view_set_insert_spaces_instead_of_tabs, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_insert_spaces_instead_of_tabs", (PyCFunction)_wrap_gtk_source_view_get_insert_spaces_instead_of_tabs, METH_NOARGS,
      NULL },
    { "set_indent_on_tab", (PyCFunction)_wrap_gtk_source_view_set_indent_on_tab, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_indent_on_tab", (PyCFunction)_wrap_gtk_source_view_get_indent_on_tab, METH_NOARGS,
      NULL },
    { "set_highlight_current_line", (PyCFunction)_wrap_gtk_source_view_set_highlight_current_line, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_highlight_current_line", (PyCFunction)_wrap_gtk_source_view_get_highlight_current_line, METH_NOARGS,
      NULL },
    { "set_show_right_margin", (PyCFunction)_wrap_gtk_source_view_set_show_right_margin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_show_right_margin", (PyCFunction)_wrap_gtk_source_view_get_show_right_margin, METH_NOARGS,
      NULL },
    { "set_right_margin_position", (PyCFunction)_wrap_gtk_source_view_set_right_margin_position, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_right_margin_position", (PyCFunction)_wrap_gtk_source_view_get_right_margin_position, METH_NOARGS,
      NULL },
    { "set_show_line_marks", (PyCFunction)_wrap_gtk_source_view_set_show_line_marks, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_show_line_marks", (PyCFunction)_wrap_gtk_source_view_get_show_line_marks, METH_NOARGS,
      NULL },
    { "set_mark_category_pixbuf", (PyCFunction)_wrap_gtk_source_view_set_mark_category_pixbuf, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_mark_category_pixbuf", (PyCFunction)_wrap_gtk_source_view_get_mark_category_pixbuf, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mark_category_priority", (PyCFunction)_wrap_gtk_source_view_set_mark_category_priority, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_mark_category_priority", (PyCFunction)_wrap_gtk_source_view_get_mark_category_priority, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_smart_home_end", (PyCFunction)_wrap_gtk_source_view_set_smart_home_end, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_smart_home_end", (PyCFunction)_wrap_gtk_source_view_get_smart_home_end, METH_NOARGS,
      NULL },
    { "set_draw_spaces", (PyCFunction)_wrap_gtk_source_view_set_draw_spaces, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_draw_spaces", (PyCFunction)_wrap_gtk_source_view_get_draw_spaces, METH_NOARGS,
      NULL },
    { "set_mark_category_background", (PyCFunction)_wrap_gtk_source_view_set_mark_category_background, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_mark_category_background", (PyCFunction)_wrap_gtk_source_view_get_mark_category_background, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_completion", (PyCFunction)_wrap_gtk_source_view_get_completion, METH_NOARGS,
      NULL },
    { "get_gutter", (PyCFunction)_wrap_gtk_source_view_get_gutter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mark_category_icon_from_pixbuf", (PyCFunction)_wrap_gtk_source_view_set_mark_category_icon_from_pixbuf, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mark_category_icon_from_stock", (PyCFunction)_wrap_gtk_source_view_set_mark_category_icon_from_stock, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mark_category_icon_from_icon_name", (PyCFunction)_wrap_gtk_source_view_set_mark_category_icon_from_icon_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mark_category_tooltip_func", (PyCFunction)_wrap_gtk_source_view_set_mark_category_tooltip_func, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mark_category_tooltip_markup_func", (PyCFunction)_wrap_gtk_source_view_set_mark_category_tooltip_markup_func, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "do_undo", (PyCFunction)_wrap_GtkSourceView__do_undo, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_redo", (PyCFunction)_wrap_GtkSourceView__do_redo, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_line_mark_activated", (PyCFunction)_wrap_GtkSourceView__do_line_mark_activated, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceView_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.View",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceView_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_view_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static void
_wrap_GtkSourceView__proxy_do_undo(GtkSourceView *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_undo");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceView__proxy_do_redo(GtkSourceView *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_redo");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceView__proxy_do_line_mark_activated(GtkSourceView *self, GtkTextIter*iter, GdkEvent*event)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_iter;
    PyObject *py_event;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    py_iter = pyg_boxed_new(GTK_TYPE_TEXT_ITER, iter, FALSE, FALSE);
    py_event = pyg_boxed_new(GDK_TYPE_EVENT, event, FALSE, FALSE);
    
    py_args = PyTuple_New(2);
    PyTuple_SET_ITEM(py_args, 0, py_iter);
    PyTuple_SET_ITEM(py_args, 1, py_event);
    
    py_method = PyObject_GetAttrString(py_self, "do_line_mark_activated");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}

static int
__GtkSourceView_class_init(gpointer gclass, PyTypeObject *pyclass)
{
    PyObject *o;
    GtkSourceViewClass *klass = GTK_SOURCE_VIEW_CLASS(gclass);
    PyObject *gsignals = PyDict_GetItemString(pyclass->tp_dict, "__gsignals__");

    o = PyObject_GetAttrString((PyObject *) pyclass, "do_undo");
    if (o == NULL)
        PyErr_Clear();
    else {
        if (!PyObject_TypeCheck(o, &PyCFunction_Type)
            && !(gsignals && PyDict_GetItemString(gsignals, "undo")))
            klass->undo = _wrap_GtkSourceView__proxy_do_undo;
        Py_DECREF(o);
    }

    o = PyObject_GetAttrString((PyObject *) pyclass, "do_redo");
    if (o == NULL)
        PyErr_Clear();
    else {
        if (!PyObject_TypeCheck(o, &PyCFunction_Type)
            && !(gsignals && PyDict_GetItemString(gsignals, "redo")))
            klass->redo = _wrap_GtkSourceView__proxy_do_redo;
        Py_DECREF(o);
    }

    o = PyObject_GetAttrString((PyObject *) pyclass, "do_line_mark_activated");
    if (o == NULL)
        PyErr_Clear();
    else {
        if (!PyObject_TypeCheck(o, &PyCFunction_Type)
            && !(gsignals && PyDict_GetItemString(gsignals, "line_mark_activated")))
            klass->line_mark_activated = _wrap_GtkSourceView__proxy_do_line_mark_activated;
        Py_DECREF(o);
    }
    return 0;
}


/* ----------- GtkSourceCompletion ----------- */

static PyObject *
_wrap_gtk_source_completion_add_provider(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "provider", NULL };
    PyGObject *provider;
    int ret;
    GError *error = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.Completion.add_provider", kwlist, &PyGtkSourceCompletionProvider_Type, &provider))
        return NULL;
    
    ret = gtk_source_completion_add_provider(GTK_SOURCE_COMPLETION(self->obj), GTK_SOURCE_COMPLETION_PROVIDER(provider->obj), &error);
    
    if (pyg_error_check(&error))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_completion_remove_provider(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "provider", NULL };
    PyGObject *provider;
    int ret;
    GError *error = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.Completion.remove_provider", kwlist, &PyGtkSourceCompletionProvider_Type, &provider))
        return NULL;
    
    ret = gtk_source_completion_remove_provider(GTK_SOURCE_COMPLETION(self->obj), GTK_SOURCE_COMPLETION_PROVIDER(provider->obj), &error);
    
    if (pyg_error_check(&error))
        return NULL;
    return PyBool_FromLong(ret);

}

#line 634 "gtksourceview2.override"
static GList *
pylist_to_glist_gobjs (PyObject *object, GType gtype)
{
    PyObject *item;
    GObject *obj;
    GList *ret = NULL;
    int num;
    int i;
    
    if (object == Py_None) {
        return ret;
    }
    
    num = PySequence_Size (object);
    
    for (i = 0; i < num; ++i) {
        item = PySequence_GetItem (object, i);
        
        if (PyObject_TypeCheck(item, &PyGObject_Type)) {
            obj = pygobject_get (item);
            
            if (g_type_is_a (G_TYPE_FROM_INSTANCE (obj), gtype)) {
                ret = g_list_prepend (ret, g_object_ref (obj));
            }
        }
    }
    
    return g_list_reverse (ret);
}

static PyObject *
_wrap_gtk_source_completion_get_providers(PyGObject *self,
                                          PyObject *args,
                                          PyObject *kwargs)
{
    static char *kwlist[] = { NULL };
    PyObject    *py_ret;
    GList      *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "Oz:GtkSourceCompletion.get_providers",
                                     kwlist))
        return NULL;

    ret = gtk_source_completion_get_providers(GTK_SOURCE_COMPLETION(self->obj));

    py_ret = glist_to_pylist_objs (ret);

    return py_ret;
}

#line 4307 "gtksourceview2.c"


#line 687 "gtksourceview2.override"

static PyObject *
_wrap_gtk_source_completion_show(PyGObject *self,
                                  PyObject  *args,
                                  PyObject  *kwargs)
{
    static char *kwlist[] = { "providers", "context", NULL };
    PyObject *providers;
    PyGObject *context;
    GList *items;
    
    if (!PyArg_ParseTupleAndKeywords(args,
                                         kwargs,
                                         "|OO!:GtkSourceCompletion.show",
                                         kwlist, &providers, &PyGtkSourceCompletionContext_Type, &context));

    if (providers != Py_None && !PySequence_Check(providers)) {
        PyErr_SetString(PyExc_TypeError, "providers must be a list");
        return NULL;
    }
    
    items = pylist_to_glist_gobjs (providers, GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    
    gtk_source_completion_show (GTK_SOURCE_COMPLETION(self->obj), 
                                items, 
                                GTK_SOURCE_COMPLETION_CONTEXT (context->obj));
    
    g_list_foreach (items, (GFunc)g_object_unref, NULL);
    g_list_free (items);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 4345 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_completion_hide(PyGObject *self)
{
    
    gtk_source_completion_hide(GTK_SOURCE_COMPLETION(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_get_info_window(PyGObject *self)
{
    GtkSourceCompletionInfo *ret;

    
    ret = gtk_source_completion_get_info_window(GTK_SOURCE_COMPLETION(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 998 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_completion_create_context(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "position", NULL };
    PyObject *py_position = NULL;
    GtkSourceCompletionContext *ret;
    GtkTextIter *position = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, 
                                     kwargs,
                                     "|O!:GtkSourceCompletion.create_context", 
                                     kwlist, 
                                     &PyGtkTextIter_Type, &py_position))
        return NULL;

	if (py_position != NULL)
	{
		if (pyg_boxed_check(py_position, GTK_TYPE_TEXT_ITER))
		    position = pyg_boxed_get(py_position, GtkTextIter);
		else {
		    PyErr_SetString(PyExc_TypeError, "position should be a GtkTextIter");
		    return NULL;
	    }
	}
    
    ret = gtk_source_completion_create_context(GTK_SOURCE_COMPLETION(self->obj), position);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 4402 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_completion_move_window(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "iter", NULL };
    PyObject *py_iter;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GtkSourceView.Completion.move_window", kwlist, &py_iter))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    gtk_source_completion_move_window(GTK_SOURCE_COMPLETION(self->obj), iter);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceCompletion_methods[] = {
    { "add_provider", (PyCFunction)_wrap_gtk_source_completion_add_provider, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "remove_provider", (PyCFunction)_wrap_gtk_source_completion_remove_provider, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_providers", (PyCFunction)_wrap_gtk_source_completion_get_providers, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "show", (PyCFunction)_wrap_gtk_source_completion_show, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "hide", (PyCFunction)_wrap_gtk_source_completion_hide, METH_NOARGS,
      NULL },
    { "get_info_window", (PyCFunction)_wrap_gtk_source_completion_get_info_window, METH_NOARGS,
      NULL },
    { "create_context", (PyCFunction)_wrap_gtk_source_completion_create_context, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "move_window", (PyCFunction)_wrap_gtk_source_completion_move_window, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletion_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.Completion",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceCompletion_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceCompletionInfo ----------- */

 static int
_wrap_gtk_source_completion_info_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     ":gtksourceview2.CompletionInfo.__init__",
                                     kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);
    if (!self->obj) {
        PyErr_SetString(
            PyExc_RuntimeError, 
            "could not create gtksourceview2.CompletionInfo object");
        return -1;
    }
    return 0;
}

static PyObject *
_wrap_gtk_source_completion_info_move_to_iter(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "view", "iter", NULL };
    PyGObject *view;
    PyObject *py_iter;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O:GtkSourceView.CompletionInfo.move_to_iter", kwlist, &PyGtkTextView_Type, &view, &py_iter))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    gtk_source_completion_info_move_to_iter(GTK_SOURCE_COMPLETION_INFO(self->obj), GTK_TEXT_VIEW(view->obj), iter);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_info_set_sizing(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "width", "height", "shrink_width", "shrink_height", NULL };
    int width, height, shrink_width, shrink_height;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"iiii:GtkSourceView.CompletionInfo.set_sizing", kwlist, &width, &height, &shrink_width, &shrink_height))
        return NULL;
    
    gtk_source_completion_info_set_sizing(GTK_SOURCE_COMPLETION_INFO(self->obj), width, height, shrink_width, shrink_height);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_info_set_widget(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "widget", NULL };
    PyGObject *widget;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionInfo.set_widget", kwlist, &PyGtkWidget_Type, &widget))
        return NULL;
    
    gtk_source_completion_info_set_widget(GTK_SOURCE_COMPLETION_INFO(self->obj), GTK_WIDGET(widget->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_info_get_widget(PyGObject *self)
{
    GtkWidget *ret;

    
    ret = gtk_source_completion_info_get_widget(GTK_SOURCE_COMPLETION_INFO(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_completion_info_process_resize(PyGObject *self)
{
    
    gtk_source_completion_info_process_resize(GTK_SOURCE_COMPLETION_INFO(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceCompletionInfo_methods[] = {
    { "move_to_iter", (PyCFunction)_wrap_gtk_source_completion_info_move_to_iter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_sizing", (PyCFunction)_wrap_gtk_source_completion_info_set_sizing, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_widget", (PyCFunction)_wrap_gtk_source_completion_info_set_widget, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_widget", (PyCFunction)_wrap_gtk_source_completion_info_get_widget, METH_NOARGS,
      NULL },
    { "process_resize", (PyCFunction)_wrap_gtk_source_completion_info_process_resize, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionInfo_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.CompletionInfo",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceCompletionInfo_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_completion_info_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceCompletionItem ----------- */

#line 970 "gtksourceview2.override"
static int
_wrap_gtk_source_completion_item_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "label", "text", "icon", "info", NULL };
    char *label, *text = NULL, *info = NULL;
    PyGObject *icon = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, 
                                     kwargs, "s|sO!s:GtkSourceCompletionItem.__init__", 
                                     kwlist, 
                                     &label, 
                                     &text, 
                                     &PyGdkPixbuf_Type, &icon, 
                                     &info))
        return -1;

    self->obj = (GObject *)gtk_source_completion_item_new(label, text, icon ? GDK_PIXBUF(icon->obj) : NULL, info);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GtkSourceCompletionItem object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

#line 4681 "gtksourceview2.c"


PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionItem_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.CompletionItem",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_completion_item_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceCompletionContext ----------- */

#line 595 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_completion_context_add_proposals(PyGObject *self,
                                                  PyObject *args,
                                                  PyObject *kwargs)
{
    static char *kwlist[] = { "provider", "proposals", "finished", NULL };
    PyGObject   *py_provider;
    PyObject    *py_proposals;
    PyObject    *py_finished = NULL;
    GList       *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "O!O|O:GtkSourceCompletionContext.add_proposals",
                                     kwlist, 
                                     &PyGtkSourceCompletionProvider_Type, &py_provider, 
                                     &py_proposals, 
                                     &py_finished))
        return NULL;

	if (py_proposals != Py_None && !PySequence_Check(py_proposals)) {
        PyErr_SetString(PyExc_TypeError, "proposals must be a list");
        return NULL;
    }

	ret = pylist_to_glist_gobjs (py_proposals, GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
	gtk_source_completion_context_add_proposals(GTK_SOURCE_COMPLETION_CONTEXT (self->obj),
	                                            GTK_SOURCE_COMPLETION_PROVIDER (py_provider->obj),
	                                            ret,
	                                            py_finished == NULL ? TRUE : PyObject_IsTrue (py_finished));

    g_list_foreach(ret, (GFunc)g_object_unref, NULL);
    g_list_free(ret);

	Py_INCREF(Py_None);
    return Py_None;
}

#line 4771 "gtksourceview2.c"


#line 723 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_completion_context_get_iter(PyGObject *self)
{
	GtkTextIter iter;
    gtk_source_completion_context_get_iter(GTK_SOURCE_COMPLETION_CONTEXT(self->obj), &iter);
    
    return pyg_boxed_new(GTK_TYPE_TEXT_ITER, &iter, TRUE, TRUE);
}

#line 4784 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_completion_context_get_activation(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_completion_context_get_activation(GTK_SOURCE_COMPLETION_CONTEXT(self->obj));
    
    return pyg_flags_from_gtype(GTK_TYPE_SOURCE_COMPLETION_ACTIVATION, ret);
}

static const PyMethodDef _PyGtkSourceCompletionContext_methods[] = {
    { "add_proposals", (PyCFunction)_wrap_gtk_source_completion_context_add_proposals, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_iter", (PyCFunction)_wrap_gtk_source_completion_context_get_iter, METH_NOARGS,
      NULL },
    { "get_activation", (PyCFunction)_wrap_gtk_source_completion_context_get_activation, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionContext_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.CompletionContext",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceCompletionContext_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceCompletionWords ----------- */

#line 1214 "gtksourceview2.override"
static int
_wrap_gtk_source_completion_words_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "icon", NULL };
    char *name = NULL;
    PyGObject *icon = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, 
                                     kwargs,
                                     "|sO!:GtkSourceCompletionWords.__init__", 
                                     kwlist, 
                                     &name, &PyGdkPixbuf_Type, &icon))
        return -1;

    self->obj = (GObject *)gtk_source_completion_words_new(name, icon ? GDK_PIXBUF(icon->obj) : NULL);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GtkSourceCompletionWords object");
        return -1;
    }
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

#line 4882 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_completion_words_register(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "buffer", NULL };
    PyGObject *buffer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionWords.register", kwlist, &PyGtkTextBuffer_Type, &buffer))
        return NULL;
    
    gtk_source_completion_words_register(GTK_SOURCE_COMPLETION_WORDS(self->obj), GTK_TEXT_BUFFER(buffer->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_words_unregister(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "buffer", NULL };
    PyGObject *buffer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionWords.unregister", kwlist, &PyGtkTextBuffer_Type, &buffer))
        return NULL;
    
    gtk_source_completion_words_unregister(GTK_SOURCE_COMPLETION_WORDS(self->obj), GTK_TEXT_BUFFER(buffer->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceCompletionWords_methods[] = {
    { "register", (PyCFunction)_wrap_gtk_source_completion_words_register, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "unregister", (PyCFunction)_wrap_gtk_source_completion_words_unregister, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionWords_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.CompletionWords",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceCompletionWords_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gtk_source_completion_words_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GtkSourceCompletionProposal ----------- */

static PyObject *
_wrap_gtk_source_completion_proposal_get_label(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_completion_proposal_get_label(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_proposal_get_markup(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_completion_proposal_get_markup(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_proposal_get_text(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_completion_proposal_get_text(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_proposal_get_icon(PyGObject *self)
{
    GdkPixbuf *ret;

    
    ret = gtk_source_completion_proposal_get_icon(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_completion_proposal_get_info(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_completion_proposal_get_info(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_proposal_changed(PyGObject *self)
{
    
    gtk_source_completion_proposal_changed(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_proposal_hash(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_completion_proposal_hash(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_gtk_source_completion_proposal_equal(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "other", NULL };
    PyGObject *other;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.equal", kwlist, &PyGtkSourceCompletionProposal_Type, &other))
        return NULL;
    
    ret = gtk_source_completion_proposal_equal(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(other->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_get_label(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.get_label", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->get_label)
        ret = iface->get_label(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.get_label not implemented");
        return NULL;
    }
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_get_markup(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.get_markup", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->get_markup)
        ret = iface->get_markup(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.get_markup not implemented");
        return NULL;
    }
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_get_text(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.get_text", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->get_text)
        ret = iface->get_text(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.get_text not implemented");
        return NULL;
    }
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_get_icon(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    GdkPixbuf *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.get_icon", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->get_icon)
        ret = iface->get_icon(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.get_icon not implemented");
        return NULL;
    }
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_get_info(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.get_info", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->get_info)
        ret = iface->get_info(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.get_info not implemented");
        return NULL;
    }
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_changed(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.changed", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->changed)
        iface->changed(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.changed not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_hash(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    guint ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProposal.hash", kwlist, &PyGtkSourceCompletionProposal_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->hash)
        ret = iface->hash(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.hash not implemented");
        return NULL;
    }
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_GtkSourceCompletionProposal__do_equal(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProposalIface *iface;
    static char *kwlist[] = { "self", "other", NULL };
    PyGObject *self, *other;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:GtkSourceView.CompletionProposal.equal", kwlist, &PyGtkSourceCompletionProposal_Type, &self, &PyGtkSourceCompletionProposal_Type, &other))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROPOSAL);
    if (iface->equal)
        ret = iface->equal(GTK_SOURCE_COMPLETION_PROPOSAL(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(other->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProposal.equal not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyGtkSourceCompletionProposal_methods[] = {
    { "get_label", (PyCFunction)_wrap_gtk_source_completion_proposal_get_label, METH_NOARGS,
      NULL },
    { "get_markup", (PyCFunction)_wrap_gtk_source_completion_proposal_get_markup, METH_NOARGS,
      NULL },
    { "get_text", (PyCFunction)_wrap_gtk_source_completion_proposal_get_text, METH_NOARGS,
      NULL },
    { "get_icon", (PyCFunction)_wrap_gtk_source_completion_proposal_get_icon, METH_NOARGS,
      NULL },
    { "get_info", (PyCFunction)_wrap_gtk_source_completion_proposal_get_info, METH_NOARGS,
      NULL },
    { "changed", (PyCFunction)_wrap_gtk_source_completion_proposal_changed, METH_NOARGS,
      NULL },
    { "hash", (PyCFunction)_wrap_gtk_source_completion_proposal_hash, METH_NOARGS,
      NULL },
    { "equal", (PyCFunction)_wrap_gtk_source_completion_proposal_equal, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "do_get_label", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_get_label, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_markup", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_get_markup, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_text", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_get_text, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_icon", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_get_icon, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_info", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_get_info, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_changed", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_changed, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_hash", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_hash, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_equal", (PyCFunction)_wrap_GtkSourceCompletionProposal__do_equal, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionProposal_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.CompletionProposal",                   /* tp_name */
    sizeof(PyObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceCompletionProposal_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static gchar*
_wrap_GtkSourceCompletionProposal__proxy_do_get_label(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gchar* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_label");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "s", &retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    retval = g_strdup(retval);
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gchar*
_wrap_GtkSourceCompletionProposal__proxy_do_get_markup(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gchar* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_markup");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "s", &retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    retval = g_strdup(retval);
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gchar*
_wrap_GtkSourceCompletionProposal__proxy_do_get_text(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gchar* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_text");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "s", &retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    retval = g_strdup(retval);
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static GdkPixbuf*
_wrap_GtkSourceCompletionProposal__proxy_do_get_icon(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    GdkPixbuf* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_icon");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    if (!PyObject_TypeCheck(py_retval, &PyGObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "retval should be a GObject");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    retval = (GdkPixbuf*) pygobject_get(py_retval);
    g_object_ref((GObject *) retval);
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gchar*
_wrap_GtkSourceCompletionProposal__proxy_do_get_info(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gchar* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_info");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "s", &retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    retval = g_strdup(retval);
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static void
_wrap_GtkSourceCompletionProposal__proxy_do_changed(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_changed");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static guint
_wrap_GtkSourceCompletionProposal__proxy_do_hash(GtkSourceCompletionProposal *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    guint retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_hash");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "i", &retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gboolean
_wrap_GtkSourceCompletionProposal__proxy_do_equal(GtkSourceCompletionProposal *self, GtkSourceCompletionProposal*other)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_other = NULL;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    if (other)
        py_other = pygobject_new((GObject *) other);
    else {
        Py_INCREF(Py_None);
        py_other = Py_None;
    }
    
    py_args = PyTuple_New(1);
    PyTuple_SET_ITEM(py_args, 0, py_other);
    
    py_method = PyObject_GetAttrString(py_self, "do_equal");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}

static void
__GtkSourceCompletionProposal__interface_init(GtkSourceCompletionProposalIface *iface, PyTypeObject *pytype)
{
    GtkSourceCompletionProposalIface *parent_iface = g_type_interface_peek_parent(iface);
    PyObject *py_method;

    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_label") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_label = _wrap_GtkSourceCompletionProposal__proxy_do_get_label;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_label = parent_iface->get_label;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_markup") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_markup = _wrap_GtkSourceCompletionProposal__proxy_do_get_markup;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_markup = parent_iface->get_markup;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_text") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_text = _wrap_GtkSourceCompletionProposal__proxy_do_get_text;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_text = parent_iface->get_text;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_icon") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_icon = _wrap_GtkSourceCompletionProposal__proxy_do_get_icon;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_icon = parent_iface->get_icon;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_info") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_info = _wrap_GtkSourceCompletionProposal__proxy_do_get_info;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_info = parent_iface->get_info;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_changed") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->changed = _wrap_GtkSourceCompletionProposal__proxy_do_changed;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->changed = parent_iface->changed;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_hash") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->hash = _wrap_GtkSourceCompletionProposal__proxy_do_hash;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->hash = parent_iface->hash;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_equal") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->equal = _wrap_GtkSourceCompletionProposal__proxy_do_equal;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->equal = parent_iface->equal;
        }
    Py_XDECREF(py_method);
    }
}


static const GInterfaceInfo __GtkSourceCompletionProposal__iinfo = {
    (GInterfaceInitFunc) __GtkSourceCompletionProposal__interface_init,
    NULL,
    NULL
};


/* ----------- GtkSourceCompletionProvider ----------- */

static PyObject *
_wrap_gtk_source_completion_provider_get_name(PyGObject *self)
{
    gchar *ret;

    
    ret = gtk_source_completion_provider_get_name(GTK_SOURCE_COMPLETION_PROVIDER(self->obj));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_provider_get_icon(PyGObject *self)
{
    GdkPixbuf *ret;

    
    ret = gtk_source_completion_provider_get_icon(GTK_SOURCE_COMPLETION_PROVIDER(self->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_completion_provider_populate(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", NULL };
    PyGObject *context;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProvider.populate", kwlist, &PyGtkSourceCompletionContext_Type, &context))
        return NULL;
    
    gtk_source_completion_provider_populate(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_CONTEXT(context->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_completion_provider_get_activation(PyGObject *self)
{
    guint ret;

    
    ret = gtk_source_completion_provider_get_activation(GTK_SOURCE_COMPLETION_PROVIDER(self->obj));
    
    return pyg_flags_from_gtype(GTK_TYPE_SOURCE_COMPLETION_ACTIVATION, ret);
}

static PyObject *
_wrap_gtk_source_completion_provider_match(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", NULL };
    PyGObject *context;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProvider.match", kwlist, &PyGtkSourceCompletionContext_Type, &context))
        return NULL;
    
    ret = gtk_source_completion_provider_match(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_CONTEXT(context->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_completion_provider_get_info_widget(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "proposal", NULL };
    PyGObject *proposal;
    GtkWidget *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProvider.get_info_widget", kwlist, &PyGtkSourceCompletionProposal_Type, &proposal))
        return NULL;
    
    ret = gtk_source_completion_provider_get_info_widget(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_completion_provider_update_info(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "proposal", "info", NULL };
    PyGObject *proposal, *info;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:GtkSourceView.CompletionProvider.update_info", kwlist, &PyGtkSourceCompletionProposal_Type, &proposal, &PyGtkSourceCompletionInfo_Type, &info))
        return NULL;
    
    gtk_source_completion_provider_update_info(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj), GTK_SOURCE_COMPLETION_INFO(info->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 780 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_completion_provider_get_start_iter(PyGObject *self,
                                                    PyObject  *args,
                                                    PyObject  *kwargs)
{
    static char *kwlist[] = { "context", "proposal", NULL };
    PyGObject *context;
    PyGObject *proposal;
	gboolean ret;
	GtkTextIter iter;
	
	if (!PyArg_ParseTupleAndKeywords(args,
                                         kwargs,
                                         "|O!O!:GtkSourceCompletionProvider.get_start_iter",
                                         kwlist, 
                                         &PyGtkSourceCompletionContext_Type, &context,
                                         &PyGtkSourceCompletionProposal_Type, &proposal));

	ret = gtk_source_completion_provider_get_start_iter (GTK_SOURCE_COMPLETION_PROVIDER (self->obj),
	                                                     GTK_SOURCE_COMPLETION_CONTEXT (context->obj),
	                                                     GTK_SOURCE_COMPLETION_PROPOSAL (proposal->obj),
	                                                     &iter);

	if (!ret)
	{
		Py_INCREF(Py_None);
		return Py_None;
	}
	else
	{
		return pyg_boxed_new(GTK_TYPE_TEXT_ITER, &iter, TRUE, TRUE);
	}
}
#line 6056 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_completion_provider_activate_proposal(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "proposal", "iter", NULL };
    PyGObject *proposal;
    PyObject *py_iter;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O:GtkSourceView.CompletionProvider.activate_proposal", kwlist, &PyGtkSourceCompletionProposal_Type, &proposal, &py_iter))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    
    ret = gtk_source_completion_provider_activate_proposal(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj), iter);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_get_name(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProvider.get_name", kwlist, &PyGtkSourceCompletionProvider_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->get_name)
        ret = iface->get_name(GTK_SOURCE_COMPLETION_PROVIDER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.get_name not implemented");
        return NULL;
    }
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_get_icon(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    GdkPixbuf *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProvider.get_icon", kwlist, &PyGtkSourceCompletionProvider_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->get_icon)
        ret = iface->get_icon(GTK_SOURCE_COMPLETION_PROVIDER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.get_icon not implemented");
        return NULL;
    }
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_populate(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", "context", NULL };
    PyGObject *self, *context;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:GtkSourceView.CompletionProvider.populate", kwlist, &PyGtkSourceCompletionProvider_Type, &self, &PyGtkSourceCompletionContext_Type, &context))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->populate)
        iface->populate(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_CONTEXT(context->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.populate not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_get_activation(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    guint ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.CompletionProvider.get_activation", kwlist, &PyGtkSourceCompletionProvider_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->get_activation)
        ret = iface->get_activation(GTK_SOURCE_COMPLETION_PROVIDER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.get_activation not implemented");
        return NULL;
    }
    return pyg_flags_from_gtype(GTK_TYPE_SOURCE_COMPLETION_ACTIVATION, ret);
}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_match(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", "context", NULL };
    PyGObject *self, *context;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:GtkSourceView.CompletionProvider.match", kwlist, &PyGtkSourceCompletionProvider_Type, &self, &PyGtkSourceCompletionContext_Type, &context))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->match)
        ret = iface->match(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_CONTEXT(context->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.match not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_get_info_widget(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", "proposal", NULL };
    PyGObject *self, *proposal;
    PyObject *py_ret;
    GtkWidget *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!:GtkSourceView.CompletionProvider.get_info_widget", kwlist, &PyGtkSourceCompletionProvider_Type, &self, &PyGtkSourceCompletionProposal_Type, &proposal))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->get_info_widget)
        ret = iface->get_info_widget(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.get_info_widget not implemented");
        return NULL;
    }
    py_ret = pygobject_new((GObject *)ret);
    if (ret != NULL)
        g_object_unref(ret);
    return py_ret;
}

static PyObject *
_wrap_GtkSourceCompletionProvider__do_update_info(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", "proposal", "info", NULL };
    PyGObject *self, *proposal, *info;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!O!:GtkSourceView.CompletionProvider.update_info", kwlist, &PyGtkSourceCompletionProvider_Type, &self, &PyGtkSourceCompletionProposal_Type, &proposal, &PyGtkSourceCompletionInfo_Type, &info))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->update_info)
        iface->update_info(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj), GTK_SOURCE_COMPLETION_INFO(info->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.update_info not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

#line 734 "gtksourceview2.override"
static PyObject *
_wrap_GtkSourceCompletionProvider__do_get_start_iter(PyObject *cls,
                                                     PyObject *args,
                                                     PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", "context", "proposal", NULL };
    PyGObject *self;
    PyGObject *context;
    PyGObject *proposal;
    gboolean ret;
    GtkTextIter iter;

    if (!PyArg_ParseTupleAndKeywords(args, 
                                     kwargs, 
                                     "O!O!O!:GtkSourceCompletionProvider.get_start_iter", kwlist, 
                                     &PyGtkSourceCompletionProvider_Type, &self,
                                     &PyGtkSourceCompletionContext_Type, &context,
                                     &PyGtkSourceCompletionProposal_Type, &proposal))
        return NULL;

    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);

    if (iface->get_start_iter)
        ret = iface->get_start_iter(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), 
                                    GTK_SOURCE_COMPLETION_CONTEXT(context->obj),
                                    GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj),
                                    &iter);
    else{
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceCompletionProvider.get_start_iter not implemented");
        return NULL;
    }
    
    if (ret)
    {
	    return pyg_boxed_new(GTK_TYPE_TEXT_ITER, &iter, TRUE, TRUE);
	}
	else
	{
		Py_INCREF(Py_None);
		return Py_None;
	}
}

#line 6280 "gtksourceview2.c"


static PyObject *
_wrap_GtkSourceCompletionProvider__do_activate_proposal(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceCompletionProviderIface *iface;
    static char *kwlist[] = { "self", "proposal", "iter", NULL };
    PyGObject *self, *proposal;
    PyObject *py_iter;
    int ret;
    GtkTextIter *iter = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!O!O:GtkSourceView.CompletionProvider.activate_proposal", kwlist, &PyGtkSourceCompletionProvider_Type, &self, &PyGtkSourceCompletionProposal_Type, &proposal, &py_iter))
        return NULL;
    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);
    else {
        PyErr_SetString(PyExc_TypeError, "iter should be a GtkTextIter");
        return NULL;
    }
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_COMPLETION_PROVIDER);
    if (iface->activate_proposal)
        ret = iface->activate_proposal(GTK_SOURCE_COMPLETION_PROVIDER(self->obj), GTK_SOURCE_COMPLETION_PROPOSAL(proposal->obj), iter);
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.CompletionProvider.activate_proposal not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyGtkSourceCompletionProvider_methods[] = {
    { "get_name", (PyCFunction)_wrap_gtk_source_completion_provider_get_name, METH_NOARGS,
      NULL },
    { "get_icon", (PyCFunction)_wrap_gtk_source_completion_provider_get_icon, METH_NOARGS,
      NULL },
    { "populate", (PyCFunction)_wrap_gtk_source_completion_provider_populate, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_activation", (PyCFunction)_wrap_gtk_source_completion_provider_get_activation, METH_NOARGS,
      NULL },
    { "match", (PyCFunction)_wrap_gtk_source_completion_provider_match, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_info_widget", (PyCFunction)_wrap_gtk_source_completion_provider_get_info_widget, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "update_info", (PyCFunction)_wrap_gtk_source_completion_provider_update_info, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_start_iter", (PyCFunction)_wrap_gtk_source_completion_provider_get_start_iter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "activate_proposal", (PyCFunction)_wrap_gtk_source_completion_provider_activate_proposal, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "do_get_name", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_get_name, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_icon", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_get_icon, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_populate", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_populate, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_activation", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_get_activation, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_match", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_match, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_info_widget", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_get_info_widget, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_update_info", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_update_info, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_get_start_iter", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_get_start_iter, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_activate_proposal", (PyCFunction)_wrap_GtkSourceCompletionProvider__do_activate_proposal, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceCompletionProvider_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.CompletionProvider",                   /* tp_name */
    sizeof(PyObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceCompletionProvider_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static gchar*
_wrap_GtkSourceCompletionProvider__proxy_do_get_name(GtkSourceCompletionProvider *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gchar* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_name");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "s", &retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    retval = g_strdup(retval);
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static GdkPixbuf*
_wrap_GtkSourceCompletionProvider__proxy_do_get_icon(GtkSourceCompletionProvider *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    GdkPixbuf* retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_icon");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    if (!PyObject_TypeCheck(py_retval, &PyGObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "retval should be a GObject");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    retval = (GdkPixbuf*) pygobject_get(py_retval);
    g_object_ref((GObject *) retval);
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static void
_wrap_GtkSourceCompletionProvider__proxy_do_populate(GtkSourceCompletionProvider *self, GtkSourceCompletionContext*context)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_context = NULL;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    if (context)
        py_context = pygobject_new((GObject *) context);
    else {
        Py_INCREF(Py_None);
        py_context = Py_None;
    }
    
    py_args = PyTuple_New(1);
    PyTuple_SET_ITEM(py_args, 0, py_context);
    
    py_method = PyObject_GetAttrString(py_self, "do_populate");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static GtkSourceCompletionActivation
_wrap_GtkSourceCompletionProvider__proxy_do_get_activation(GtkSourceCompletionProvider *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    GtkSourceCompletionActivation retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_get_activation");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    if (pyg_flags_get_value(GTK_TYPE_SOURCE_COMPLETION_ACTIVATION, py_retval, (gint *)&retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return -G_MAXINT;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gboolean
_wrap_GtkSourceCompletionProvider__proxy_do_match(GtkSourceCompletionProvider *self, GtkSourceCompletionContext*context)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_context = NULL;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    if (context)
        py_context = pygobject_new((GObject *) context);
    else {
        Py_INCREF(Py_None);
        py_context = Py_None;
    }
    
    py_args = PyTuple_New(1);
    PyTuple_SET_ITEM(py_args, 0, py_context);
    
    py_method = PyObject_GetAttrString(py_self, "do_match");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
#line 897 "gtksourceview2.override"

static GtkWidget*
_wrap_GtkSourceCompletionProvider__proxy_do_get_info_widget(GtkSourceCompletionProvider *self, GtkSourceCompletionProposal*proposal)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_proposal = NULL;
    GtkWidget* retval;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    if (proposal)
        py_proposal = pygobject_new((GObject *) proposal);
    else {
        Py_INCREF(Py_None);
        py_proposal = Py_None;
    }
    
    py_args = PyTuple_New(1);
    PyTuple_SET_ITEM(py_args, 0, py_proposal);
    
    py_method = PyObject_GetAttrString(py_self, "do_get_info_widget");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    if (!PyObject_TypeCheck(py_retval, &PyGObject_Type)) {
        PyErr_SetString(PyExc_TypeError, "retval should be a GObject");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return NULL;
    }
    retval = (GtkWidget*) pygobject_get(py_retval);    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}

#line 6776 "gtksourceview2.c"


static void
_wrap_GtkSourceCompletionProvider__proxy_do_update_info(GtkSourceCompletionProvider *self, GtkSourceCompletionProposal*proposal, GtkSourceCompletionInfo*info)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_proposal = NULL;
    PyObject *py_info = NULL;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    if (proposal)
        py_proposal = pygobject_new((GObject *) proposal);
    else {
        Py_INCREF(Py_None);
        py_proposal = Py_None;
    }
    if (info)
        py_info = pygobject_new((GObject *) info);
    else {
        Py_INCREF(Py_None);
        py_info = Py_None;
    }
    
    py_args = PyTuple_New(2);
    PyTuple_SET_ITEM(py_args, 0, py_proposal);
    PyTuple_SET_ITEM(py_args, 1, py_info);
    
    py_method = PyObject_GetAttrString(py_self, "do_update_info");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
#line 815 "gtksourceview2.override"
static gboolean
_wrap_GtkSourceCompletionProvider__proxy_do_get_start_iter(GtkSourceCompletionProvider *self, GtkSourceCompletionContext*context, GtkSourceCompletionProposal*proposal, GtkTextIter*iter)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_context = NULL;
    PyObject *py_proposal = NULL;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    if (context)
        py_context = pygobject_new((GObject *) context);
    else {
        Py_INCREF(Py_None);
        py_context = Py_None;
    }
    
    if (proposal)
        py_proposal = pygobject_new((GObject *) proposal);
    else {
        Py_INCREF(Py_None);
        py_proposal = Py_None;
    }
    
    py_args = PyTuple_New(2);
    PyTuple_SET_ITEM(py_args, 0, py_context);
    PyTuple_SET_ITEM(py_args, 1, py_proposal);
    
    py_method = PyObject_GetAttrString(py_self, "do_get_start_iter");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval || py_retval == Py_None) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }

    if (!pyg_boxed_check(py_retval, GTK_TYPE_TEXT_ITER)) {
        PyErr_SetString(PyExc_TypeError, "retval should be a GtkTextIter");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    *iter = *pyg_boxed_get(py_retval, GtkTextIter);
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return TRUE;
}
#line 6934 "gtksourceview2.c"


static gboolean
_wrap_GtkSourceCompletionProvider__proxy_do_activate_proposal(GtkSourceCompletionProvider *self, GtkSourceCompletionProposal*proposal, GtkTextIter*iter)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_proposal = NULL;
    PyObject *py_iter;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_args;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    if (proposal)
        py_proposal = pygobject_new((GObject *) proposal);
    else {
        Py_INCREF(Py_None);
        py_proposal = Py_None;
    }
    py_iter = pyg_boxed_new(GTK_TYPE_TEXT_ITER, iter, FALSE, FALSE);
    
    py_args = PyTuple_New(2);
    PyTuple_SET_ITEM(py_args, 0, py_proposal);
    PyTuple_SET_ITEM(py_args, 1, py_iter);
    
    py_method = PyObject_GetAttrString(py_self, "do_activate_proposal");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, py_args);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_args);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_args);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}

static void
__GtkSourceCompletionProvider__interface_init(GtkSourceCompletionProviderIface *iface, PyTypeObject *pytype)
{
    GtkSourceCompletionProviderIface *parent_iface = g_type_interface_peek_parent(iface);
    PyObject *py_method;

    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_name") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_name = _wrap_GtkSourceCompletionProvider__proxy_do_get_name;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_name = parent_iface->get_name;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_icon") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_icon = _wrap_GtkSourceCompletionProvider__proxy_do_get_icon;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_icon = parent_iface->get_icon;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_populate") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->populate = _wrap_GtkSourceCompletionProvider__proxy_do_populate;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->populate = parent_iface->populate;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_activation") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_activation = _wrap_GtkSourceCompletionProvider__proxy_do_get_activation;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_activation = parent_iface->get_activation;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_match") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->match = _wrap_GtkSourceCompletionProvider__proxy_do_match;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->match = parent_iface->match;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_info_widget") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_info_widget = _wrap_GtkSourceCompletionProvider__proxy_do_get_info_widget;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_info_widget = parent_iface->get_info_widget;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_update_info") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->update_info = _wrap_GtkSourceCompletionProvider__proxy_do_update_info;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->update_info = parent_iface->update_info;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_get_start_iter") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->get_start_iter = _wrap_GtkSourceCompletionProvider__proxy_do_get_start_iter;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->get_start_iter = parent_iface->get_start_iter;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_activate_proposal") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->activate_proposal = _wrap_GtkSourceCompletionProvider__proxy_do_activate_proposal;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->activate_proposal = parent_iface->activate_proposal;
        }
    Py_XDECREF(py_method);
    }
}


static const GInterfaceInfo __GtkSourceCompletionProvider__iinfo = {
    (GInterfaceInitFunc) __GtkSourceCompletionProvider__interface_init,
    NULL,
    NULL
};


/* ----------- GtkSourceUndoManager ----------- */

static PyObject *
_wrap_gtk_source_undo_manager_can_undo(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_undo_manager_can_undo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_undo_manager_can_redo(PyGObject *self)
{
    int ret;

    
    ret = gtk_source_undo_manager_can_redo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gtk_source_undo_manager_undo(PyGObject *self)
{
    
    gtk_source_undo_manager_undo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_undo_manager_redo(PyGObject *self)
{
    
    gtk_source_undo_manager_redo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_undo_manager_begin_not_undoable_action(PyGObject *self)
{
    
    gtk_source_undo_manager_begin_not_undoable_action(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_undo_manager_end_not_undoable_action(PyGObject *self)
{
    
    gtk_source_undo_manager_end_not_undoable_action(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_undo_manager_can_redo_changed(PyGObject *self)
{
    
    gtk_source_undo_manager_can_redo_changed(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_source_undo_manager_can_undo_changed(PyGObject *self)
{
    
    gtk_source_undo_manager_can_undo_changed(GTK_SOURCE_UNDO_MANAGER(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceUndoManager__do_can_undo(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.can_undo", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->can_undo)
        ret = iface->can_undo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.can_undo not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_GtkSourceUndoManager__do_can_redo(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.can_redo", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->can_redo)
        ret = iface->can_redo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.can_redo not implemented");
        return NULL;
    }
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_GtkSourceUndoManager__do_undo(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.undo", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->undo)
        iface->undo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.undo not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceUndoManager__do_redo(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.redo", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->redo)
        iface->redo(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.redo not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceUndoManager__do_begin_not_undoable_action(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.begin_not_undoable_action", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->begin_not_undoable_action)
        iface->begin_not_undoable_action(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.begin_not_undoable_action not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceUndoManager__do_end_not_undoable_action(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.end_not_undoable_action", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->end_not_undoable_action)
        iface->end_not_undoable_action(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.end_not_undoable_action not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceUndoManager__do_can_redo_changed(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.can_redo_changed", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->can_redo_changed)
        iface->can_redo_changed(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.can_redo_changed not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_GtkSourceUndoManager__do_can_undo_changed(PyObject *cls, PyObject *args, PyObject *kwargs)
{
    GtkSourceUndoManagerIface *iface;
    static char *kwlist[] = { "self", NULL };
    PyGObject *self;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:GtkSourceView.UndoManager.can_undo_changed", kwlist, &PyGtkSourceUndoManager_Type, &self))
        return NULL;
    iface = g_type_interface_peek(g_type_class_peek(pyg_type_from_object(cls)), GTK_TYPE_SOURCE_UNDO_MANAGER);
    if (iface->can_undo_changed)
        iface->can_undo_changed(GTK_SOURCE_UNDO_MANAGER(self->obj));
    else {
        PyErr_SetString(PyExc_NotImplementedError, "interface method GtkSourceView.UndoManager.can_undo_changed not implemented");
        return NULL;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGtkSourceUndoManager_methods[] = {
    { "can_undo", (PyCFunction)_wrap_gtk_source_undo_manager_can_undo, METH_NOARGS,
      NULL },
    { "can_redo", (PyCFunction)_wrap_gtk_source_undo_manager_can_redo, METH_NOARGS,
      NULL },
    { "undo", (PyCFunction)_wrap_gtk_source_undo_manager_undo, METH_NOARGS,
      NULL },
    { "redo", (PyCFunction)_wrap_gtk_source_undo_manager_redo, METH_NOARGS,
      NULL },
    { "begin_not_undoable_action", (PyCFunction)_wrap_gtk_source_undo_manager_begin_not_undoable_action, METH_NOARGS,
      NULL },
    { "end_not_undoable_action", (PyCFunction)_wrap_gtk_source_undo_manager_end_not_undoable_action, METH_NOARGS,
      NULL },
    { "can_redo_changed", (PyCFunction)_wrap_gtk_source_undo_manager_can_redo_changed, METH_NOARGS,
      NULL },
    { "can_undo_changed", (PyCFunction)_wrap_gtk_source_undo_manager_can_undo_changed, METH_NOARGS,
      NULL },
    { "do_can_undo", (PyCFunction)_wrap_GtkSourceUndoManager__do_can_undo, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_can_redo", (PyCFunction)_wrap_GtkSourceUndoManager__do_can_redo, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_undo", (PyCFunction)_wrap_GtkSourceUndoManager__do_undo, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_redo", (PyCFunction)_wrap_GtkSourceUndoManager__do_redo, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_begin_not_undoable_action", (PyCFunction)_wrap_GtkSourceUndoManager__do_begin_not_undoable_action, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_end_not_undoable_action", (PyCFunction)_wrap_GtkSourceUndoManager__do_end_not_undoable_action, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_can_redo_changed", (PyCFunction)_wrap_GtkSourceUndoManager__do_can_redo_changed, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { "do_can_undo_changed", (PyCFunction)_wrap_GtkSourceUndoManager__do_can_undo_changed, METH_VARARGS|METH_KEYWORDS|METH_CLASS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGtkSourceUndoManager_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gtksourceview2.UndoManager",                   /* tp_name */
    sizeof(PyObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGtkSourceUndoManager_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};

static gboolean
_wrap_GtkSourceUndoManager__proxy_do_can_undo(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_can_undo");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static gboolean
_wrap_GtkSourceUndoManager__proxy_do_can_redo(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    gboolean retval;
    PyObject *py_main_retval;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_can_redo");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    py_retval = Py_BuildValue("(N)", py_retval);
    if (!PyArg_ParseTuple(py_retval, "O", &py_main_retval)) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return FALSE;
    }
    
    retval = PyObject_IsTrue(py_main_retval)? TRUE : FALSE;
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
    
    return retval;
}
static void
_wrap_GtkSourceUndoManager__proxy_do_undo(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_undo");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceUndoManager__proxy_do_redo(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_redo");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceUndoManager__proxy_do_begin_not_undoable_action(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_begin_not_undoable_action");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceUndoManager__proxy_do_end_not_undoable_action(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_end_not_undoable_action");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceUndoManager__proxy_do_can_redo_changed(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_can_redo_changed");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}
static void
_wrap_GtkSourceUndoManager__proxy_do_can_undo_changed(GtkSourceUndoManager *self)
{
    PyGILState_STATE __py_state;
    PyObject *py_self;
    PyObject *py_retval;
    PyObject *py_method;
    
    __py_state = pyg_gil_state_ensure();
    py_self = pygobject_new((GObject *) self);
    if (!py_self) {
        if (PyErr_Occurred())
            PyErr_Print();
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    py_method = PyObject_GetAttrString(py_self, "do_can_undo_changed");
    if (!py_method) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    py_retval = PyObject_CallObject(py_method, NULL);
    if (!py_retval) {
        if (PyErr_Occurred())
            PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    if (py_retval != Py_None) {
        PyErr_SetString(PyExc_TypeError, "virtual method should return None");
        PyErr_Print();
        Py_XDECREF(py_retval);
        Py_DECREF(py_method);
        Py_DECREF(py_self);
        pyg_gil_state_release(__py_state);
        return;
    }
    
    
    Py_XDECREF(py_retval);
    Py_DECREF(py_method);
    Py_DECREF(py_self);
    pyg_gil_state_release(__py_state);
}

static void
__GtkSourceUndoManager__interface_init(GtkSourceUndoManagerIface *iface, PyTypeObject *pytype)
{
    GtkSourceUndoManagerIface *parent_iface = g_type_interface_peek_parent(iface);
    PyObject *py_method;

    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_can_undo") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->can_undo = _wrap_GtkSourceUndoManager__proxy_do_can_undo;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->can_undo = parent_iface->can_undo;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_can_redo") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->can_redo = _wrap_GtkSourceUndoManager__proxy_do_can_redo;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->can_redo = parent_iface->can_redo;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_undo") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->undo = _wrap_GtkSourceUndoManager__proxy_do_undo;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->undo = parent_iface->undo;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_redo") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->redo = _wrap_GtkSourceUndoManager__proxy_do_redo;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->redo = parent_iface->redo;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_begin_not_undoable_action") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->begin_not_undoable_action = _wrap_GtkSourceUndoManager__proxy_do_begin_not_undoable_action;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->begin_not_undoable_action = parent_iface->begin_not_undoable_action;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_end_not_undoable_action") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->end_not_undoable_action = _wrap_GtkSourceUndoManager__proxy_do_end_not_undoable_action;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->end_not_undoable_action = parent_iface->end_not_undoable_action;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_can_redo_changed") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->can_redo_changed = _wrap_GtkSourceUndoManager__proxy_do_can_redo_changed;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->can_redo_changed = parent_iface->can_redo_changed;
        }
    Py_XDECREF(py_method);
    }
    py_method = pytype? PyObject_GetAttrString((PyObject *) pytype, "do_can_undo_changed") : NULL;
    if (py_method && !PyObject_TypeCheck(py_method, &PyCFunction_Type)) {
        iface->can_undo_changed = _wrap_GtkSourceUndoManager__proxy_do_can_undo_changed;
    } else {
        PyErr_Clear();
        if (parent_iface) {
            iface->can_undo_changed = parent_iface->can_undo_changed;
        }
    Py_XDECREF(py_method);
    }
}


static const GInterfaceInfo __GtkSourceUndoManager__iinfo = {
    (GInterfaceInitFunc) __GtkSourceUndoManager__interface_init,
    NULL,
    NULL
};


/* ----------- functions ----------- */

#line 441 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_iter_forward_search(PyObject *self, PyObject *args,
                                      PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "str", "flags", "limit", NULL };
    gchar *str;
    PyObject *py_flags, *py_iter, *py_limit = Py_None;
    GtkTextIter match_start, match_end, *iter = NULL, *limit = NULL;
    GtkSourceSearchFlags flags;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                    "OsO|O:gtksourceview2.iter_forward_search",
                                    kwlist, &py_iter, &str, &py_flags,
                                    &py_limit))
        return NULL;

    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);

    if (pyg_boxed_check(py_limit, GTK_TYPE_TEXT_ITER))
        limit = pyg_boxed_get(py_limit, GtkTextIter);

    else if (py_limit != Py_None) {
        PyErr_SetString(PyExc_TypeError,"limit must be a GtkTextIter or None");
        return NULL;
    }

    if (pyg_flags_get_value(GTK_TYPE_TEXT_SEARCH_FLAGS, py_flags,
                            (gint *)&flags))
        return NULL;

    if (gtk_source_iter_forward_search(iter, str, flags, &match_start,
                                        &match_end, limit))
        return Py_BuildValue("(NN)",
                             pyg_boxed_new(GTK_TYPE_TEXT_ITER, &match_start,
                                           TRUE, TRUE),
                             pyg_boxed_new(GTK_TYPE_TEXT_ITER, &match_end,
                                           TRUE, TRUE));

    Py_INCREF(Py_None);
    return Py_None;
}

#line 8019 "gtksourceview2.c"


#line 396 "gtksourceview2.override"
static PyObject *
_wrap_gtk_source_iter_backward_search(PyObject *self, PyObject *args,
                                      PyObject *kwargs)
{
    static char *kwlist[] = { "iter", "str", "flags", "limit", NULL };
    gchar *str;
    PyObject *py_flags, *py_iter, *py_limit = Py_None;
    GtkTextIter match_start, match_end, *iter = NULL, *limit = NULL;
    GtkSourceSearchFlags flags;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                    "OsO|O:gtksourceview2.iter_backward_search",
                                    kwlist, &py_iter, &str, &py_flags,
                                    &py_limit))
        return NULL;

    if (pyg_boxed_check(py_iter, GTK_TYPE_TEXT_ITER))
        iter = pyg_boxed_get(py_iter, GtkTextIter);

    if (pyg_boxed_check(py_limit, GTK_TYPE_TEXT_ITER))
        limit = pyg_boxed_get(py_limit, GtkTextIter);

    else if (py_limit != Py_None) {
        PyErr_SetString(PyExc_TypeError,"limit must be a GtkTextIter or None");
        return NULL;
    }

    if (pyg_flags_get_value(GTK_TYPE_TEXT_SEARCH_FLAGS, py_flags,
                            (gint *)&flags))
        return NULL;

    if (gtk_source_iter_backward_search(iter, str, flags, &match_start,
                                        &match_end, limit))
        return Py_BuildValue("(NN)",
                             pyg_boxed_new(GTK_TYPE_TEXT_ITER, &match_start,
                                           TRUE, TRUE),
                             pyg_boxed_new(GTK_TYPE_TEXT_ITER, &match_end,
                                           TRUE, TRUE));

    Py_INCREF(Py_None);
    return Py_None;
}

#line 8066 "gtksourceview2.c"


static PyObject *
_wrap_gtk_source_language_manager_get_default(PyObject *self)
{
    GtkSourceLanguageManager *ret;

    
    ret = gtk_source_language_manager_get_default();
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_style_scheme_manager_get_default(PyObject *self)
{
    GtkSourceStyleSchemeManager *ret;

    
    ret = gtk_source_style_scheme_manager_get_default();
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_print_compositor_new_from_view(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "view", NULL };
    PyGObject *view;
    GtkSourcePrintCompositor *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:print_compositor_new_from_view", kwlist, &PyGtkSourceView_Type, &view))
        return NULL;
    
    ret = gtk_source_print_compositor_new_from_view(GTK_SOURCE_VIEW(view->obj));
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_completion_item_new_with_markup(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "markup", "text", "icon", "info", NULL };
    char *markup, *text, *info;
    PyGObject *icon;
    GtkSourceCompletionItem *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssO!s:completion_item_new_with_markup", kwlist, &markup, &text, &PyGdkPixbuf_Type, &icon, &info))
        return NULL;
    
    ret = gtk_source_completion_item_new_with_markup(markup, text, GDK_PIXBUF(icon->obj), info);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gtk_source_completion_item_new_from_stock(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "label", "text", "stock", "info", NULL };
    char *label, *text, *stock, *info;
    GtkSourceCompletionItem *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssss:completion_item_new_from_stock", kwlist, &label, &text, &stock, &info))
        return NULL;
    
    ret = gtk_source_completion_item_new_from_stock(label, text, stock, info);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

const PyMethodDef pygtksourceview2_functions[] = {
    { "iter_forward_search", (PyCFunction)_wrap_gtk_source_iter_forward_search, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "iter_backward_search", (PyCFunction)_wrap_gtk_source_iter_backward_search, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "language_manager_get_default", (PyCFunction)_wrap_gtk_source_language_manager_get_default, METH_NOARGS,
      NULL },
    { "style_scheme_manager_get_default", (PyCFunction)_wrap_gtk_source_style_scheme_manager_get_default, METH_NOARGS,
      NULL },
    { "print_compositor_new_from_view", (PyCFunction)_wrap_gtk_source_print_compositor_new_from_view, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "completion_item_new_with_markup", (PyCFunction)_wrap_gtk_source_completion_item_new_with_markup, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "completion_item_new_from_stock", (PyCFunction)_wrap_gtk_source_completion_item_new_from_stock, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};


/* ----------- enums and flags ----------- */

void
pygtksourceview2_add_constants(PyObject *module, const gchar *strip_prefix)
{
#ifdef VERSION
    PyModule_AddStringConstant(module, "__version__", VERSION);
#endif
  pyg_flags_add(module, "SearchFlags", strip_prefix, GTK_TYPE_SOURCE_SEARCH_FLAGS);
  pyg_enum_add(module, "SmartHomeEndType", strip_prefix, GTK_TYPE_SOURCE_SMART_HOME_END_TYPE);
  pyg_flags_add(module, "DrawSpacesFlags", strip_prefix, GTK_TYPE_SOURCE_DRAW_SPACES_FLAGS);
  pyg_enum_add(module, "CompletionError", strip_prefix, GTK_TYPE_SOURCE_COMPLETION_ERROR);
  pyg_flags_add(module, "CompletionActivation", strip_prefix, GTK_TYPE_SOURCE_COMPLETION_ACTIVATION);

  if (PyErr_Occurred())
    PyErr_Print();
}

/* initialise stuff extension classes */
void
pygtksourceview2_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        _PyGObject_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
        _PyGInitiallyUnowned_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGInitiallyUnowned_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return ;
    }
    if ((module = PyImport_ImportModule("gtk")) != NULL) {
        _PyGtkTextTagTable_Type = (PyTypeObject *)PyObject_GetAttrString(module, "TextTagTable");
        if (_PyGtkTextTagTable_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name TextTagTable from gtk");
            return ;
        }
        _PyGtkTextView_Type = (PyTypeObject *)PyObject_GetAttrString(module, "TextView");
        if (_PyGtkTextView_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name TextView from gtk");
            return ;
        }
        _PyGtkTextBuffer_Type = (PyTypeObject *)PyObject_GetAttrString(module, "TextBuffer");
        if (_PyGtkTextBuffer_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name TextBuffer from gtk");
            return ;
        }
        _PyGtkTextMark_Type = (PyTypeObject *)PyObject_GetAttrString(module, "TextMark");
        if (_PyGtkTextMark_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name TextMark from gtk");
            return ;
        }
        _PyGtkPrintContext_Type = (PyTypeObject *)PyObject_GetAttrString(module, "PrintContext");
        if (_PyGtkPrintContext_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name PrintContext from gtk");
            return ;
        }
        _PyGtkWidget_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Widget");
        if (_PyGtkWidget_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Widget from gtk");
            return ;
        }
        _PyGtkWindow_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Window");
        if (_PyGtkWindow_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Window from gtk");
            return ;
        }
        _PyGtkTextIter_Type = (PyTypeObject *)PyObject_GetAttrString(module, "TextIter");
        if (_PyGtkTextIter_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name TextIter from gtk");
            return ;
        }
        _PyGtkCellRenderer_Type = (PyTypeObject *)PyObject_GetAttrString(module, "CellRenderer");
        if (_PyGtkCellRenderer_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name CellRenderer from gtk");
            return ;
        }
        _PyGtkTooltip_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Tooltip");
        if (_PyGtkTooltip_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Tooltip from gtk");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gtk");
        return ;
    }
    if ((module = PyImport_ImportModule("gtk.gdk")) != NULL) {
        _PyGdkPixbuf_Type = (PyTypeObject *)PyObject_GetAttrString(module, "Pixbuf");
        if (_PyGdkPixbuf_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name Pixbuf from gtk.gdk");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gtk.gdk");
        return ;
    }


#line 8283 "gtksourceview2.c"
    pyg_register_interface(d, "CompletionProposal", GTK_TYPE_SOURCE_COMPLETION_PROPOSAL, &PyGtkSourceCompletionProposal_Type);
    pyg_register_interface_info(GTK_TYPE_SOURCE_COMPLETION_PROPOSAL, &__GtkSourceCompletionProposal__iinfo);
    pyg_register_interface(d, "CompletionProvider", GTK_TYPE_SOURCE_COMPLETION_PROVIDER, &PyGtkSourceCompletionProvider_Type);
    pyg_register_interface_info(GTK_TYPE_SOURCE_COMPLETION_PROVIDER, &__GtkSourceCompletionProvider__iinfo);
    pyg_register_interface(d, "UndoManager", GTK_TYPE_SOURCE_UNDO_MANAGER, &PyGtkSourceUndoManager_Type);
    pyg_register_interface_info(GTK_TYPE_SOURCE_UNDO_MANAGER, &__GtkSourceUndoManager__iinfo);
    pygobject_register_class(d, "GtkSourceBuffer", GTK_TYPE_SOURCE_BUFFER, &PyGtkSourceBuffer_Type, Py_BuildValue("(O)", &PyGtkTextBuffer_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_BUFFER);
    pygobject_register_class(d, "GtkSourceGutter", GTK_TYPE_SOURCE_GUTTER, &PyGtkSourceGutter_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_GUTTER);
    pyg_register_class_init(GTK_TYPE_SOURCE_GUTTER, __GtkSourceGutter_class_init);
    pygobject_register_class(d, "GtkSourceLanguage", GTK_TYPE_SOURCE_LANGUAGE, &PyGtkSourceLanguage_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_LANGUAGE);
    pygobject_register_class(d, "GtkSourceLanguageManager", GTK_TYPE_SOURCE_LANGUAGE_MANAGER, &PyGtkSourceLanguageManager_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_LANGUAGE_MANAGER);
    pygobject_register_class(d, "GtkSourceMark", GTK_TYPE_SOURCE_MARK, &PyGtkSourceMark_Type, Py_BuildValue("(O)", &PyGtkTextMark_Type));
    pygobject_register_class(d, "GtkSourcePrintCompositor", GTK_TYPE_SOURCE_PRINT_COMPOSITOR, &PyGtkSourcePrintCompositor_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GtkSourceStyle", GTK_TYPE_SOURCE_STYLE, &PyGtkSourceStyle_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_STYLE);
    pygobject_register_class(d, "GtkSourceStyleScheme", GTK_TYPE_SOURCE_STYLE_SCHEME, &PyGtkSourceStyleScheme_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_STYLE_SCHEME);
    pygobject_register_class(d, "GtkSourceStyleSchemeManager", GTK_TYPE_SOURCE_STYLE_SCHEME_MANAGER, &PyGtkSourceStyleSchemeManager_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_STYLE_SCHEME_MANAGER);
    pygobject_register_class(d, "GtkSourceView", GTK_TYPE_SOURCE_VIEW, &PyGtkSourceView_Type, Py_BuildValue("(O)", &PyGtkTextView_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_VIEW);
    pyg_register_class_init(GTK_TYPE_SOURCE_VIEW, __GtkSourceView_class_init);
    pygobject_register_class(d, "GtkSourceCompletion", GTK_TYPE_SOURCE_COMPLETION, &PyGtkSourceCompletion_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_COMPLETION);
    pygobject_register_class(d, "GtkSourceCompletionInfo", GTK_TYPE_SOURCE_COMPLETION_INFO, &PyGtkSourceCompletionInfo_Type, Py_BuildValue("(O)", &PyGtkWindow_Type));
    pyg_set_object_has_new_constructor(GTK_TYPE_SOURCE_COMPLETION_INFO);
    pygobject_register_class(d, "GtkSourceCompletionItem", GTK_TYPE_SOURCE_COMPLETION_ITEM, &PyGtkSourceCompletionItem_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pygobject_register_class(d, "GtkSourceCompletionContext", GTK_TYPE_SOURCE_COMPLETION_CONTEXT, &PyGtkSourceCompletionContext_Type, Py_BuildValue("(O)", &PyGInitiallyUnowned_Type));
    pygobject_register_class(d, "GtkSourceCompletionWords", GTK_TYPE_SOURCE_COMPLETION_WORDS, &PyGtkSourceCompletionWords_Type, NULL);
}
