# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

class AuthError(bb.Union):
    """
    Errors occurred during authentication.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_access_token: The access token is invalid.
    :ivar invalid_select_user: The user specified in 'Dropbox-API-Select-User'
        is no longer on the team.
    :ivar invalid_select_admin: The user specified in 'Dropbox-API-Select-Admin'
        is not a Dropbox Business team admin.
    :ivar other: An unspecified error.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_access_token = None
    # Attribute is overwritten below the class definition
    invalid_select_user = None
    # Attribute is overwritten below the class definition
    invalid_select_admin = None
    # Attribute is overwritten below the class definition
    other = None

    def is_invalid_access_token(self):
        """
        Check if the union tag is ``invalid_access_token``.

        :rtype: bool
        """
        return self._tag == 'invalid_access_token'

    def is_invalid_select_user(self):
        """
        Check if the union tag is ``invalid_select_user``.

        :rtype: bool
        """
        return self._tag == 'invalid_select_user'

    def is_invalid_select_admin(self):
        """
        Check if the union tag is ``invalid_select_admin``.

        :rtype: bool
        """
        return self._tag == 'invalid_select_admin'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AuthError(%r, %r)' % (self._tag, self._value)

AuthError_validator = bv.Union(AuthError)

AuthError._invalid_access_token_validator = bv.Void()
AuthError._invalid_select_user_validator = bv.Void()
AuthError._invalid_select_admin_validator = bv.Void()
AuthError._other_validator = bv.Void()
AuthError._tagmap = {
    'invalid_access_token': AuthError._invalid_access_token_validator,
    'invalid_select_user': AuthError._invalid_select_user_validator,
    'invalid_select_admin': AuthError._invalid_select_admin_validator,
    'other': AuthError._other_validator,
}

AuthError.invalid_access_token = AuthError('invalid_access_token')
AuthError.invalid_select_user = AuthError('invalid_select_user')
AuthError.invalid_select_admin = AuthError('invalid_select_admin')
AuthError.other = AuthError('other')

token_revoke = bb.Route(
    'token/revoke',
    False,
    bv.Void(),
    bv.Void(),
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)

ROUTES = {
    'token/revoke': token_revoke,
}

