# This shell script that emits a C file.
# It does some substitutions.
cat >em_${EMULATION_NAME}.c <<EOF
/* This file is is generated by a shell script.  DO NOT EDIT! */

/* emulate the original gld for the given ${EMULATION_NAME}
   Copyright (C) 1991 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com

This file is part of GLD, the Gnu Linker.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define TARGET_IS_${EMULATION_NAME}

#include "bfd.h"
#include "sysdep.h"
#include "ld.h"
#include "config.h"
#include "ldemul.h"
#include "ldfile.h"
#include "ldmisc.h"

extern  boolean lang_float_flag;


extern enum bfd_architecture ldfile_output_architecture;
extern unsigned long ldfile_output_machine;
extern char *ldfile_output_machine_name;

static void gld${EMULATION_NAME}_before_parse()
{
#ifdef TARGET_IS_m88kbcs
  extern char lprefix;
  lprefix = '@';
#else
#ifndef TARGET_ /* I.e., if not generic */
  ldfile_output_architecture = bfd_arch_${ARCH};
#endif
#endif
}


static char *gld${EMULATION_NAME}_script =  
#include "${EMULATION_NAME}.x"
;
static char *gld${EMULATION_NAME}_script_option_Ur  =  
#include "${EMULATION_NAME}.xu"
;
static char *gld${EMULATION_NAME}_script_option_r  =  
#include "${EMULATION_NAME}.xr"
;
static char *gld${EMULATION_NAME}_script_option_n  =  /* Used with -n flag. */
#include "${EMULATION_NAME}.xn"
;
static char *gld${EMULATION_NAME}_script_option_N  =  /* Used with -N flag. */
#include "${EMULATION_NAME}.xbn"
;

static char *gld${EMULATION_NAME}_get_script()
{			     
  extern ld_config_type config;
  if (config.relocateable_output == true &&
      config.build_constructors == true) {
    return gld${EMULATION_NAME}_script_option_Ur;
  }
  if (config.relocateable_output == true) {
    return gld${EMULATION_NAME}_script_option_r;
  }
  if (!config.text_read_only)
    return gld${EMULATION_NAME}_script_option_N;
  if (!config.magic_demand_paged)
    return gld${EMULATION_NAME}_script_option_n;
  return gld${EMULATION_NAME}_script;
}
struct ld_emulation_xfer_struct ld_${EMULATION_NAME}_emulation = 
{
  gld${EMULATION_NAME}_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  after_allocation_default,
  set_output_arch_default,
  ldemul_default_target,
  before_allocation_default,
  gld${EMULATION_NAME}_get_script,
  "${EMULATION_NAME}",
  "${OUTPUT_FORMAT}"
};
EOF
