const classes             = Components.classes;
const interfaces          = Components.interfaces;
const nsILocalFile        = interfaces.nsILocalFile;

function GetLocalFileFromURLSpec(url)
{
  return GetFileFromURLSpec(url).QueryInterface(nsILocalFile);
}

function GetFileFromURLSpec(url)
{
  var fileHandler = GetFileProtocolHandler();
  return fileHandler.getFileFromURLSpec(url);
}

function OpenLocalDirectory(aUrl, aRQdata)
{
  EnableAllUI(false);

  var localFile = GetLocalFileFromURLSpec(aUrl);

  var dirEntries = localFile.directoryEntries;
  while (dirEntries.hasMoreElements())
  {
    var fileEntry = dirEntries.getNext().QueryInterface(Components.interfaces.nsIFile);
    AddLocalDirSubdirs(aUrl, fileEntry, aRQdata);
  }

  var i, l = gItemsArray.length;
  for (i = aRQdata.row; i < l; i++)
    gItemsArray[i].realIndex = i;
  gDialog.SiteTree.treeBoxObject.invalidateRow(aRQdata.parentRow);            

  EnableAllUI(true);
}


function AddLocalDirSubdirs(aUrl, aDirEntry, aRQdata)
{
  var name = aDirEntry.leafName;
  var path = aUrl + "/" + name;
  var size = aDirEntry.fileSize;
  var lastModifiedDate = new Date(aDirEntry.lastModifiedTime);

  gTreeView.addRow(aRQdata,
                   name,
                   path,
                   size,
                   lastModifiedDate,
                   aDirEntry.isDirectory(),
                   false,
                   false,
                   aDirEntry.isSymlink(),
                   aRQdata.level,
                   false);
  gDialog.SiteTree.treeBoxObject.rowCountChanged(aRQdata.row - 1, 1);    
}
