/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Playsophy code.
 *
 * The Initial Developer of the Original Code is Playsophy
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * ***** END LICENSE BLOCK ***** */

/**********************************************************************************
 * mozileSave.js V0.52c: this file implements save/post option in Mozile. It marries
 * a transport configuration file with the transport driver infrastructure of Bitflux
 * implemented in mozDataTransport.js
 * 
 * - move configuration into an XML file
 * - pass file name/id and actual content back in any errors (change mozDataTransport)
 **********************************************************************************/

/**
 * Configuration: this will move into an XML file that configures mozile for a page/web site
 *
 * Options:
 * method to use | element or whole document
 * ex/ webdav false or http true or file false
 * 
 * Note: that some options like "save to file" only support the "document" option and the element setting
 * will be ignored.
 */
const METHODNAME = "webdav";
//const METHODNAME = "file";
//const METHODNAME = "alert";
//const METHODNAME = "http";

// set this to false if you want to save the whole file or document rather than just the current area
// note: if only saving editable area and there is more than one editable area in your page then make sure that
// it has an id.
const EDITABLEAREAONLY = true; 

/**
 * Change this to use the configuration file!
 */
function mozileSave()
{
	// POST05: look up method to use for this web site from the configuration file: for now, default
	// to "methodName" and "editableAreaOnly" constants

	// get contents to save and an identifier for that content
	if(ptb) ptb.ptbDeactivate(); // first nix the toolbar if active
	var contentToSave;
	var id = document.location.pathname;
	if(EDITABLEAREAONLY)
	{
		// get the contents of the editable area
		var cssr = window.getSelection().getEditableRange();
		var editableArea = cssr.top;
		var dataToSaveRange = document.createRange();
		dataToSaveRange.selectNodeContents(editableArea);
		var dataToSave = dataToSaveRange.cloneContents();
		
		contentToSave = documentSaveXML(dataToSave);
		if(editableArea.id) // append editable area id to file name if there is an id
			id = document.location.pathname + "#" + editableArea.id;
	}
	else
		contentToSave = documentSaveXML(document);

	var td = new mozTransportDriver(METHODNAME);

	td.save(id, contentToSave, __mozileSaved);

	// reactivate a toolbar if initialized
	if(ptb) ptb.ptbActivate();
}

/**
 * Remote post: use Bitflux transport driver. This is INCOMPLETE: it will account for webDAV and other
 * transports (webDAV using http://www.mozdev.org/source/browse/twingle/source/twingle/content/jsdav.js)
 *
 * POST05: 
 * - reuse Bitflux Transport Driver Infrastructure (or Twingle driver) code in Mozile along with 
 * specific driver for webDAV.
 * - place HTTPPost into same architecture
 */ 
function __mozileSaved(reqObj) 
{	
	if (reqObj.isError)
		alert ("couldn't save document \n" + reqObj.statusText);
}