/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview Provides shared utilities for Mozile's testing system.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: util.js,v 1.2 2006/08/23 16:55:33 jameso Exp $
 */

mozile.test = {};
mozile.test.shared = {};

/**
 * Create an initial selection.
 * If this isn't done before using the selection IE will throw an "Unspecified Error".
 */
mozile.test.shared.preselect = function() {
	var target = document.getElementById("target");
	if(mozile.browser.isIE) {
		var range = document.body.createTextRange();
		//range.findText("Not Editable");
		range.moveToElementText(target);
		range.collapse();
		range.select();
	}
	else {
		window.getSelection().collapse(target.firstChild, 0);
	}
}



/**
 * Indicates that this is an HTML (not an XHTML or XML) test.
 * @type Boolean
 */
mozile.test.isHTML = false;

/**
 * Indicates that this is an XHTML test.
 * @type Boolean
 */
mozile.test.isXHTML = false;

/**
 * Indicates that this is an XML test.
 * @type Boolean
 */
mozile.test.isXML = false;

var loc = document.location.toString();
if(loc.match("testpage.html")) mozile.test.isXHTML = true;
else if(loc.match("testpage.htm")) mozile.test.isHTML = true;
else if(loc.match("testpage.xml")) mozile.test.isXML = true;


