/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Node object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Node.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Node";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRelations"];
	return ["testRNGNode", "testRelations", "testMayHave", "testMustHave", "testReset", "testSelfValidate", "testValidation"];
}

/**
 * 
 */
function getNode() {
	var element = mozile.xml.parseElement("<element/>");
	return new mozile.rng.Node(element, mozile.test.rng.schema);
}

/**
 * 
 */
function testRNGNode() {
	var RNGNode = getNode();
	mozile.test.rng.checkRNGNode(RNGNode, "mozile.rng.Element");
}

/**
 * 
 */
function testRelations() {
	var schema = new mozile.rng.Schema();
	schema.parse("../rng/test.xml");
	var RNGNode = schema._root.getChildNode(0).getChildNode(0);

	assertEquals("The RNGNode should have two children", 2, RNGNode.getChildNodes().length);
	assertEquals("There should be two descendants", 2, RNGNode.getDescendants("attribute", true).length);
	assertEquals("The first child should be the first descendant", RNGNode.getChildNodes()[0], RNGNode.getDescendants("attribute", true)[0]);
	
	var child = RNGNode.getChildNode(0);
	assertEquals("The parent node should be RNGNode", RNGNode, child.getParentNode());
	assertEquals("The parent element should be RNGNode", RNGNode, child.getParentElement());
	assertEquals("The grammar should be the schema root", schema._root, child.getGrammar());
	
	assertEquals("The nextSibling should be the second child", RNGNode.getChildNode(1), RNGNode.getChildNode(0).getNextSibling());
	assertNull("The nextSibling should be null", RNGNode.getChildNodes()[RNGNode.getChildNodes().length-1].getNextSibling());

	// Test append, remove
	var newNode = new mozile.rng.Node(mozile.xml.parse('<text/>'));
	assertEquals("Append the new node", newNode, RNGNode.appendChild(newNode));
	assertEquals("Check the parent node", RNGNode, newNode.getParentNode());
	assertEquals("The RNGNode should have three children", 3, RNGNode.getChildNodes().length);
	
	assertEquals("Remove the new node", newNode, RNGNode.removeChild(newNode));
	assertEquals("The RNGNode should have two children", 2, RNGNode.getChildNodes().length);
}

/**
 * 
 */
function testMayHave() {
	// Currently trivial
}

/**
 * 
 */
function testMustHave() {
	// Currently trivial
}

/**
 * 
 */
function testReset() {
	// Currently trivial
}

/**
 * 
 */
function testSelfValidate() {
	// Currently trivial
}

/**
 * 
 */
function testValidation() {
	// nothing to test
}


