/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Attribute object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Attribute.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Attribute";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRNGNode", "testValidate"];
}

/**
 * Create a sample node.
 */
function getNode() {
	return new mozile.rng.Attribute(mozile.xml.parseElement('<attribute name="id"/>'), mozile.test.rng.schema);
}
	
/**
 * Test node, naming, and namespace.
 */
function testRNGNode() {
	var RNGNode = getNode();
	mozile.test.rng.checkRNGNode(RNGNode);
	assertEquals("Name should be 'id'", "id", RNGNode.getName());
	assertNull("The namespace should be null", RNGNode.getNamespace());

	// Older versions of Safari crash during this test.
	if(mozile.browser.isSafari && mozile.browser.safariVersion <= 418) return;

	// Check namespace
	var element = mozile.xml.parseElement('<attribute name="   a    " ns="http://somenamespace.com"/>');
	RNGNode = new mozile.rng.Attribute(element);
	assertEquals("The name should be 'a' without whitespace", "a", RNGNode.getName());
	assertEquals("The name should the localName", RNGNode.getName(), RNGNode.getLocalName());
	assertEquals("The namespace should be http://somenamespace.com", "http://somenamespace.com", RNGNode.getNamespace());

	// Check qualified namespace
	var element = mozile.xml.parseElement('<attribute name="  b:a  " xmlns:b="http://somenamespace.com"/>');
	RNGNode = new mozile.rng.Attribute(element);
	assertEquals("The name should be 'b:a' without whitespace", "b:a", RNGNode.getName());
	assertEquals("The name should match 'prefix:localName'", RNGNode.getName(), RNGNode.getPrefix() +":"+ RNGNode.getLocalName());
	assertEquals("The namespace should be http://somenamespace.com", "http://somenamespace.com", RNGNode.getNamespace());

	assertFalse("mustHave('element') should be false", RNGNode.mustHave('element'));
	assertTrue("mustHave('attribute') is true", RNGNode.mustHave('attribute'));

}

/**
 * Test validation.
 */
function testValidate() {
	// Older versions of Safari have limited namespace support.
	if(mozile.browser.isSafari && mozile.browser.safariVersion <= 418)
		mozile.test.rng.checkCases(name, [1])
	else mozile.test.rng.checkCases(name);
}
