/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's splitNode command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: splitNode.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */

mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.splitNode";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testSplitElement"];
	return ["testSplitText", "testSplitElement", "testEnsureNonEmpty"];
}

/**
 * 
 */
function testSplitText() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNode;
	assertEquals("Name should be 'SplitNode'", "SplitNode", command.name);

	var target = document.getElementById("target");
	var targetChildren = target.childNodes.length;
	var text = target.firstChild;
	var original = text.data;

	selection.collapse(text, 5);
	selection.extend(text, 15);

	// Text Case
	// Execute
	var state = command.request({}, false, text, 10);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Target should have one more child node", targetChildren + 1, target.childNodes.length);
	assertEquals("Check the first part of the split 'text' node.", original.substring(0, 10), text.data);
	assertEquals("Check the second part of the split 'text' node.", original.substring(10), text.nextSibling.data);
	
	assertEquals("The old container should be text", text, state.oldContainer);
	assertEquals("The new container should be text's next sibling", text.nextSibling, state.newContainer);
	
	// Check selection.
	assertEquals("The selection anchor should be in the first node", target.firstChild, selection.anchorNode);
	assertEquals("The selection anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("The selection focus should be in the second node", target.childNodes[1], selection.focusNode);
	assertEquals("The selection focus offset should be 5", 5, selection.focusOffset);
	assertFalse("The selection should not be collapsed", selection.isCollapsed);
	
	// Unexecute
	state = command.unexecute(state, true); // use "fresh" mode
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Target should have the original number of child nodes", targetChildren, target.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
	
	// Check selection.
	assertEquals("The selection anchor should be in the text", text, selection.anchorNode);
	assertEquals("The selection anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("The selection focus should be in the text", text, selection.focusNode);
	assertEquals("The selection focus offset should be 15", 15, selection.focusOffset);
	assertFalse("The selection should not be collapsed", selection.isCollapsed);
}


/**
 * 
 */
function testSplitElement() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.splitNode;
	assertEquals("Name should be 'SplitNode'", "SplitNode", command.name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");

	selection.collapse(target.firstChild, 5);
	selection.extend(target2.firstChild, 5);

	// Execute
	var state = command.request({}, false, target2);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("target2 should be in the new container", target2, target.nextSibling.firstChild);
	
	assertEquals("The old container should be target", target, state.oldContainer);
	assertEquals("The new container should be target's next sibling", target.nextSibling, state.newContainer);
	
	// Check selection.
	assertEquals("The selection anchor should be in target's first child", target.firstChild, selection.anchorNode);
	assertEquals("The selection anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("The selection focus should be in target2's first child", target2.firstChild, selection.focusNode);
	assertEquals("The selection focus offset should be 5", 5, selection.focusOffset);
	assertFalse("The selection should not be collapsed", selection.isCollapsed);
	
	// Unexecute
	state = command.unexecute(state, true); // use "fresh" mode
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
	
	// Check selection.
	assertEquals("The selection anchor should still be in target's first child", target.firstChild, selection.anchorNode);
	assertEquals("The selection anchor offset should still be 5", 5, selection.anchorOffset);
	assertEquals("The selection focus should still be in target2's first child", target2.firstChild, selection.focusNode);
	assertEquals("The selection focus offset should still be 5", 5, selection.focusOffset);
	assertFalse("The selection should not be collapsed", selection.isCollapsed);
}


/**
 * 
 */
function testEnsureNonEmpty() {
	return;
	mozile.test.shared.preselect();
	var command = mozile.edit.splitNode;
	assertEquals("Name should be 'SplitNode'", "SplitNode", command.name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");

	var state = new mozile.edit.State(command);
	state.target = target2.firstChild;

	// Execute
	state = command.execute(state, false);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("target2 should be in the new container", target2, target.nextSibling.firstChild);
	
	// Unexecute
	state = command.unexecute(state, true); // use "fresh" mode
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
}
