/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's removeNode command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: removeNode.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.removeNode";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testCommand"];
}

/**
 * 
 */
function testCommand() {
	var command = mozile.edit.removeNode;
	assertEquals("Name should be 'RemoveNode'", "RemoveNode", command.name);
	
	var event = {
		type: "keypress", 
		charCode: 65, 
		ctrlKey: false, 
		metaKey: false
	}
	var target = document.getElementById("target");
	var targets = [
		target.firstChild,
		target
	];
	var states = new Array();
	var state;
	
	// Execute
	for(var i=0; i < targets.length; i++) {
		state = new mozile.edit.State(command, false); // don't store the selection
		state.direction = mozile.edit.PREVIOUS;
		state.content = targets[i];
		state = command.execute(state, false);
		states.push(state);
		assertTrue("Command "+ i +" should have been executed.", state.executed);
		if(state.content.parentNode) assertEquals("If target "+ i +" has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, state.content.parentNode.nodeType);
		else assertEquals("Check that the target "+ i +" has been removed", null, state.content.parentNode);
	}
	
	// Unexecute
	for(i = states.length - 1; i >= 0; i--) {
		var state = states[i];
		state = command.unexecute(state, true); // use "fresh" mode
		assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
		assertNotNull("Check that the target "+ i +" has been restored", 
			state.content.parentNode);
	}
	
}
