/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's moveNode command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: moveNode.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.moveNode";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testCommand"];
}

/**
 * 
 */
function testCommand() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();

	var command = mozile.edit.moveNode;
	assertEquals("Name should be 'MoveNode'", "MoveNode", command.name);

	var container = document.getElementById("container");
	var firstChild = container.firstChild;
	var firstElement = mozile.dom.getFirstChildElement(container);
	var target = document.getElementById("target");
	
	selection.collapse(firstElement.firstChild, 5);
	selection.extend(target.firstChild, 5);
	
	// Execute
	var state = command.request({}, false, container, null, target);
	assertTrue("The command should have been executed.", state.executed);
	assertEquals("The container's first child should be 'target'", container.firstChild, target);
	
	assertEquals("The selection anchor should be in the same node", firstElement.firstChild, selection.anchorNode);
	assertEquals("The selection anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("The selection focus should be in the same node", target.firstChild, selection.focusNode);
	assertEquals("The selection focus offset should be 5", 5, selection.focusOffset);
	assertFalse("The selection should not be collapsed", selection.isCollapsed);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("The container's first child should be 'firstChild'", container.firstChild, firstChild);
}
