/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's mergeNodes command.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: mergeNodes.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.mergeNodes";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testMergeNodes"];
	return ["testMergeText", "testMergeNodes"];
}

/**
 * 
 */
function testMergeText() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.mergeNodes;
	assertEquals("Name should be 'MergeNodes'", "MergeNodes", command.name);

	var target = document.getElementById("target");
	var targetChildren = target.childNodes.length;
	var text = target.firstChild;
	var original = text.data;
	var offset = 10;
	text.splitText(offset);

	selection.collapse(target.childNodes[0], 5);
	selection.extend(target.childNodes[1], 5);

	var state = new mozile.edit.State(command);
	state.from = mozile.xpath.getXPath(target.childNodes[1]);
	state.to = mozile.xpath.getXPath(target.childNodes[0]);
	
	// Execute
	var i = 1;
	state = command.execute(state, false);
	//alert([target.childNodes[0].data, target.childNodes[1].data].join("\n\n") );
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals(i +" Text should be merged", original, text.data);
	assertEquals(i +" Target should have the original number of child nodes", targetChildren, target.childNodes.length);
	assertEquals("Execute: Anchor node should be text", text, selection.anchorNode);
	assertEquals("Execute: Anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("Execute: Focus node should be text", text, selection.focusNode);
	assertEquals("Execute: Focus offset should be 15", 15, selection.focusOffset);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals(i +" Text should be split", original.substring(0, offset), text.data);
	assertEquals(i +" Target should have one more child node", targetChildren + 1, target.childNodes.length);
	assertEquals("Unexecute: Anchor node should be child 0", target.childNodes[0], selection.anchorNode);
	assertEquals("Unexecute: Anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("Unexecute: Focus node should be child 1", target.childNodes[1], selection.focusNode);
	assertEquals("Unexecute: Focus offset should be 5", 5, selection.focusOffset);
	
	// Redo
	i = 2;
	state = command.execute(state, false);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals(i +" Text should be merged", original, text.data);
	assertEquals(i +" Target should have the original number of child nodes", targetChildren, target.childNodes.length);
	
	// Undo
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals(i +" Text should be split", original.substring(0, offset), text.data);
	assertEquals(i +" Target should have one more child node", targetChildren + 1, target.childNodes.length);

	// Restore the text node.
	text.appendData(text.nextSibling.data);
	target.removeChild(text.nextSibling);
}

/**
 * 
 */
function testMergeNodes() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var command = mozile.edit.mergeNodes;
	assertEquals("Name should be 'MergeNodes'", "MergeNodes", command.name);

	var target = document.getElementById("target");
	var targetChildren = target.childNodes.length;
	var container = document.getElementById("container");
	var firstElement = mozile.dom.getFirstChildElement(container);
	var firstElementChildren = firstElement.childNodes.length;
	var firstText = firstElement.firstChild.data;
	var secondText = target.firstChild.data;

	selection.collapse(firstElement.firstChild, 5);
	selection.extend(target.lastChild, 5);
	
	// Execute
	var i = 1;
	var state = command.request({}, false, target, firstElement);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	if(target.parentNode) assertEquals("If the target has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, target.parentNode.nodeType);
	else assertEquals("Check that the target has been removed", null, target.parentNode);
	assertEquals("FirstElement's first child should be a merged text node", firstText + secondText, firstElement.firstChild.data);
	assertEquals("FirstElement should have a combined number of childNodes", firstElementChildren + targetChildren - 1, firstElement.childNodes.length);

	assertEquals("Execute: Anchor node should be firstChild", firstElement.firstChild, selection.anchorNode);
	assertEquals("Execute: Anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("Execute: Focus node should be lastChild", firstElement.lastChild, selection.focusNode);
	assertEquals("Execute: Focus offset should be 5", 5, selection.focusOffset);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Target's parent should be 'container'", container, target.parentNode);
	assertEquals("FirstElement's first child should be firstText", firstText, firstElement.firstChild.data);
	assertEquals("FirstElement should have the orginal number of childNodes", firstElementChildren, firstElement.childNodes.length);
	assertEquals("Target should have the orginal number of childNodes", targetChildren, target.childNodes.length);

	assertEquals("Unexecute: Anchor node should be firstChild", firstElement.firstChild, selection.anchorNode);
	assertEquals("Unexecute: Anchor offset should be 5", 5, selection.anchorOffset);
	assertEquals("Unexecute: Focus node should be lastChild", target.lastChild, selection.focusNode);
	assertEquals("Unexecute: Focus offset should be 5", 5, selection.focusOffset);
	
}
