/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Style  command class.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Style.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.Style";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testElement"];
	return ["testIsActive", "testElement", "testBlock"];
}

/**
 * 
 */
function testIsActive() {
	var name = "testCommand";
	var command = new mozile.edit.Style(name);
	command.target = "localName p";
	command.styleName = "color";
	command.styleValue = "red";
	
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var container = document.getElementById("container");
	var event = {};

	var test = 1;
	event.node = target2.firstChild;
	assertFalse(test +" Check inside target2", command.isActive(event));
	event.node = target.firstChild;
	assertFalse(test +" Check inside target", command.isActive(event));
	event.node = container;
	assertFalse(test +" Check inside container", command.isActive(event));

	test = 2;
	target.style.color = "red";
	event.node = target2.firstChild;
	assertTrue(test +" Check inside target2", command.isActive(event));
	event.node = target.firstChild;
	assertTrue(test +" Check inside target", command.isActive(event));
	event.node = container;
	assertFalse(test +" Check inside container", command.isActive(event));
	target.style.color = "";
}

/**
 * 
 */
function testElement() {
	var name = "testCommand";
	var command = new mozile.edit.Style(name);
	command.prompt = function(event, state) { 
		state.test = true; 
		return true;
	}
	command.styleName = "color";
	command.styleValue = "red";

	assertEquals("Name should be '"+ name +"'", name, command.name);
	assertEquals("Group should be false", false, command.group);

	mozile.test.shared.preselect();
	var target2 = document.getElementById("target2");

	var selection = mozile.dom.selection.get();
	selection.collapse(target2.firstChild, 5);
	
	var event = { };
	
	// Execute
	var state = command.prepare(event);
	assertNotUndefined("There should be a state")
	assertEquals("test should be true", true, state.test);
	
	state = command.execute(state);
	assertTrue("The command should have been executed.", state.executed);
	assertEquals("Check the text node contents after execution", 
		"red", target2.style.color);

	assertEquals("The selection should be in the firstChild", target2.firstChild, selection.focusNode);
	assertEquals("The selection offset should be 5", 5, selection.focusOffset);
	assertEquals("The selection should be collapsed", true, selection.isCollapsed);
	
	// Unexecute
	state = command.unexecute(state);
	assertFalse("The command should have been unexecuted.", state.executed);
	assertEquals("Check the text node contents after execution", 
		"", target2.style.color);

	delete mozile.edit.allCommands[name];
}

/**
 * 
 */
function testBlock() {
	var name = "testCommand";
	var command = new mozile.edit.Style(name);
	command.target = "block";
	command.styleName = "color";
	command.styleValue = "red";

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");

	var selection = mozile.dom.selection.get();
	selection.collapse(target2.firstChild, 5);
	
	var event = { };
	
	// Execute
	var state = command.prepare(event);
	assertNotUndefined("There should be a state")
	
	state = command.execute(state);
	assertTrue("The command should have been executed.", state.executed);
	assertEquals("Check the text node contents after execution", 
		"red", target.style.color);

	assertEquals("The selection should be in the firstChild", target2.firstChild, selection.focusNode);
	assertEquals("The selection offset should be 5", 5, selection.focusOffset);
	assertEquals("The selection should be collapsed", true, selection.isCollapsed);
	
	// Unexecute
	state = command.unexecute(state);
	assertFalse("The command should have been unexecuted.", state.executed);
	assertEquals("Check the text node contents after execution", 
		"", target.style.color);

	delete mozile.edit.allCommands[name];
}

