/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Split command class.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Split.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */

mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.Split";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testSplit"];
	return ["testSplit"];
}


/**
 * 
 */
function testSplit() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var name = "testCommand";
	var command = new mozile.edit.Split(name);

	var container = document.getElementById("container");
	var containerChildren = container.childNodes.length;
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var text = target2.firstChild;
	var original = text.data;

	// Execute
	var i = 1;
	selection.collapse(text, 2);
	selection.extend(text, 6);
	var state = command.request({}, false);
	//alert(container.innerHTML);
	assertTrue("Command "+ i +" should have been executed.", state.executed);
	assertEquals("Container should have one more child node", containerChildren + 1, container.childNodes.length);
	assertEquals("Check the first part of the split 'text' node.", original.substring(0, 2), target2.lastChild.data);
	assertEquals("Check the second part of the split 'text' node.", original.substring(6), target.nextSibling.firstChild.firstChild.data);
	
	assertEquals("The old container should be target", target, state.oldContainer);
	assertEquals("The new container should be target's next sibling", target.nextSibling, state.newContainer);
	
	// Unexecute
	state = command.unexecute(state, false);
	assertFalse("Command "+ i +" should have been unexecuted.", state.executed);
	assertEquals("Container should the original number of child nodes", containerChildren, container.childNodes.length);
	assertEquals("The 'text' node should be restored.", original, text.data);
}