/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Remove  command class.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Replace.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.Replace";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testIsAvailable", "testIsActive", "testElement", "testBlock"];
}

/**
 * 
 */
function testIsAvailable() {
	var name = "testCommand";
	var command = new mozile.edit.Replace(name);
	command.target = "block";
	command.element = "p";
	
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var container = document.getElementById("container");
	var event = {};

	var test = 1;
	event.node = target2.firstChild;
	assertTrue(test +" Check inside target2", command.isAvailable(event));
	event.node = target.firstChild;
	assertTrue(test +" Check inside target", command.isAvailable(event));
	
	test = 2;
	command.target = "localName span";
	event.node = target2.firstChild;
	assertTrue(test +" Check inside target2", command.isAvailable(event));
	event.node = target.firstChild;
	assertFalse(test +" Check inside target", command.isAvailable(event));
	event.node = container;
	assertFalse(test +" Check inside container", command.isAvailable(event));
}

/**
 * 
 */
function testIsActive() {
	var name = "testCommand";
	var command = new mozile.edit.Replace(name);
	command.target = "block";
	command.element = "p";
	
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var container = document.getElementById("container");
	var event = {};

	var test = 1;
	event.node = target2.firstChild;
	assertTrue(test +" Check inside target2", command.isActive(event));
	event.node = target.firstChild;
	assertTrue(test +" Check inside target", command.isActive(event));
	event.node = container;
	assertFalse(test +" Check inside container", command.isActive(event));
}

/**
 * 
 */
function testElement() {
	var name = "testCommand";
	var command = new mozile.edit.Replace(name);
	var elementName = "element";
	if(mozile.test.isXML)
		command.element = mozile.dom.createElementNS(mozile.xml.ns.xhtml, elementName);
	else command.element = mozile.dom.createElement(elementName);
	command.prompt = function(event, state) { 
		state.test = true; 
		return true;
	}

	assertEquals("Name should be '"+ name +"'", name, command.name);
	assertEquals("Group should be false", false, command.group);

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var original = target.firstChild.data;
	var length = target.childNodes.length;

	var selection = mozile.dom.selection.get();
	selection.collapse(target.firstChild, 5);
	
	var event = { };
	
	// Execute
	var state = command.prepare(event);
	var targetNode = mozile.xpath.getNode(state.target);
	assertNotUndefined("There should be a state")
	assertNotUndefined("There should be a state.element", state.element);
	assertEquals("The state.element should have the right name", elementName, mozile.dom.getLocalName(state.element).toLowerCase());
	assertEquals("test should be true", true, state.test);
	
	state = command.execute(state);
	assertTrue("The command should have been executed.", state.executed);
	var element = document.getElementById("target");
	assertEquals("Check the text node contents after execution", 
		original, element.firstChild.data);
	assertEquals("There should be just as many child nodes", length, element.childNodes.length);

	assertEquals("The selection should be in the firstChild", element.firstChild, selection.focusNode);
	assertEquals("The selection offset should be 5", 5, selection.focusOffset);
	assertEquals("The selection should be collapsed", true, selection.isCollapsed);

	if(targetNode.parentNode) assertEquals("If the target has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, targetNode.parentNode.nodeType);
	else assertEquals("Check that the state.wrapper has been removed", null, targetNode.parentNode);
	
	// Unexecute
	state = command.unexecute(state);
	assertFalse("The command should have been unexecuted.", state.executed);
	assertEquals("Check the text node contents after unexecution", 
		original, target.firstChild.data);

	if(state.element.parentNode) assertEquals("If the state.element has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, state.element.parentNode.nodeType);
	else assertEquals("Check that the state.element has been removed", null, state.element.parentNode);

	delete mozile.edit.allCommands[name];
}

/**
 * 
 */
function testBlock() {
	var name = "testCommand";
	var command = new mozile.edit.Replace(name);
	var elementName = "element";
	if(mozile.test.isXML)
		command.element = mozile.dom.createElementNS(mozile.xml.ns.xhtml, elementName);
	else command.element = mozile.dom.createElement(elementName);
	command.target = "block";

	mozile.test.shared.preselect();
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var original = target2.firstChild.data;
	var length = target.childNodes.length;

	var selection = mozile.dom.selection.get();
	selection.collapse(target2.firstChild, 5);
	
	var event = { };
	
	// Execute
	var state = command.prepare(event);
	var targetNode = mozile.xpath.getNode(state.target);
	assertNotUndefined("There should be a state")
	assertNotUndefined("There should be a state.element", state.element);
	assertEquals("The state.element should have the right name", elementName, mozile.dom.getLocalName(state.element).toLowerCase());
	
	state = command.execute(state);
	assertTrue("The command should have been executed.", state.executed);
	var element = document.getElementById("target");
	assertEquals("There should be just as many child nodes", length, element.childNodes.length);

	assertEquals("The selection should be in the firstChild", target2.firstChild, selection.focusNode);
	assertEquals("The selection offset should be 5", 5, selection.focusOffset);
	assertEquals("The selection should be collapsed", true, selection.isCollapsed);

	if(targetNode.parentNode) assertEquals("If the target has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, targetNode.parentNode.nodeType);
	else assertEquals("Check that the state.wrapper has been removed", null, targetNode.parentNode);
	
	// Unexecute
	state = command.unexecute(state);
	assertFalse("The command should have been unexecuted.", state.executed);
	assertEquals("Check the text node contents after unexecution", 
		original, target2.firstChild.data);

	if(state.element.parentNode) assertEquals("If the state.element has a parent, it has to be a document fragment", mozile.dom.DOCUMENT_FRAGMENT_NODE, state.element.parentNode.nodeType);
	else assertEquals("Check that the state.element has been removed", null, state.element.parentNode);

	delete mozile.edit.allCommands[name];
}

