/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Navigate command class.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Navigate.js,v 1.3 2006/08/23 16:55:28 jameso Exp $
 */

mozile.require("mozile.edit.rich");
mozile.require("mozile.test.shared.util");
var name = "mozile.edit.Navigate";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testNavigate"];
	return ["testNavigate", "testNavigateCollapse"];
}


/**
 * Navigate to target2.
 */
function testNavigate() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var name = "testCommand";
	var command = new mozile.edit.Navigate(name);
	command.target = "localname span";
	command.direction = "next";
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var text = target2.firstChild;
	
	selection.collapse(target.firstChild, 5);
	var state = command.request({}, false);
	assertTrue("The command should have been executed.", state.executed);	
	assertEquals("The anchorNode should be text", text, selection.anchorNode);
	assertEquals("The anchorOffset should be 0", 0, selection.anchorOffset);
	assertEquals("The focusNode should be text", text, selection.focusNode);
	assertEquals("The focusOffset should be text.data.length", text.data.length, selection.focusOffset);
}

/**
 * Navigate to target2 and collapse.
 */
function testNavigateCollapse() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var name = "testCommand";
	var command = new mozile.edit.Navigate(name);
	command.target = "localname span";
	command.direction = "next";
	command.collapse = "start";
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var text = target2.firstChild;
	
	selection.collapse(target.firstChild, 5);
	var state = command.request({}, false);
	assertTrue("The command should have been executed.", state.executed);	
	assertEquals("The anchorNode should be text", text, selection.anchorNode);
	assertEquals("The anchorOffset should be 0", 0, selection.anchorOffset);
	assertEquals("The focusNode should be text", text, selection.focusNode);
	assertEquals("The focusOffset should be 0", 0, selection.focusOffset);
}

