/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's Command object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Command.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */

mozile.require("mozile.edit");
var name = "mozile.edit.Command";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testRespond"];
	return ["testBasics", "testEvaluate", "testRespond", "testTest", "testIsAvailable", "testIsActive", "testState", "testTrigger", "testRequest",  "testExecute"];
}

/**
 * 
 */
function testBasics() {
	var name = "testCommand";
	var command = new mozile.edit.Command(name);
	
	assertEquals("Name should be '"+ name +"'", name, command.name);
	assertEquals("Group should be false", false, command.group);
}

/**
 * 
 */
function testEvaluate() {
	var command = new mozile.edit.Command();
	command.evaluate("this.test = true");
	assertEquals("text should be true", true, command.test);
}

/**
 * 
 */
function testRespond() {
	var command = new mozile.edit.Command();
	
	watch = "node";
	command.watchesChanges = watch;
	assertFalse("'none' when watching '"+ watch +"'", command.respond("none"));
	assertFalse("'state' when watching '"+ watch +"'", command.respond("state"));
	assertFalse("'text' when watching '"+ watch +"'", command.respond("text"));
	assertTrue("'node' when watching '"+ watch +"'", command.respond("node"));
	
	watch = "text";
	command.watchesChanges = watch;
	assertFalse("'none' when watching '"+ watch +"'", command.respond("none"));
	assertFalse("'state' when watching '"+ watch +"'", command.respond("state"));
	assertTrue("'text' when watching '"+ watch +"'", command.respond("text"));
	assertTrue("'node' when watching '"+ watch +"'", command.respond("node"));
	
	watch = "state";
	command.watchesChanges = watch;
	assertFalse("'none' when watching '"+ watch +"'", command.respond("none"));
	assertTrue("'state' when watching '"+ watch +"'", command.respond("state"));
	assertTrue("'text' when watching '"+ watch +"'", command.respond("text"));
	assertTrue("'node' when watching '"+ watch +"'", command.respond("node"));
}

/**
 * 
 */
function testTest() {
	// Currently trivial
}

/**
 * 
 */
function testIsAvailable() {
	var command = new mozile.edit.Command();
	assertTrue("The command should be available", command.isAvailable());
}

/**
 * 
 */
function testIsActive() {
	var command = new mozile.edit.Command();
	assertFalse("The command should not be available", command.isActive());
}

/**
 * 
 */
function testState() {
	var command = new mozile.edit.Command();
	var state = new mozile.edit.State(command, false);
	assertNotNull("The state should not be null", state);
	assertNotUndefined("The state should not be undefined", state);
	assertFalse("The 'executed' property should be false", state.executed);
}

/**
 * 
 */
function testTrigger() {
	// Currently trivial
}

/**
 * 
 */
function testRequest() {
	// Currently trivial
}

/**
 * 
 */
function testExecute() {
	var command = new mozile.edit.Command();
	var state = new mozile.edit.State(command);
	state.selection = {before: null, after: null};
	assertFalse("The 'executed' property should be false", state.executed);

	state = command.execute(state);
	assertTrue("The 'executed' property should be true", state.executed);

	state = command.unexecute(state);
	assertFalse("The 'executed' property should be false again", state.executed);
}





