/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's cross-browser selection functions.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Selection.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */


mozile.require("mozile.dom");
mozile.require("mozile.test.shared.util");
var name = "mozile.dom.Selection.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testCollapse", "testContainsNode", "testDelete", "testExtend", "testSelectionInit", "testRanges", "testRanges2", "testRemoveRange",  "testSelectAllChildren", "testLanguageDirection", "testStoreRestore"];
}



/**
 *
 */
function testSelectionInit() {
	mozile.test.shared.preselect();
	var selection = new mozile.dom.Selection();
	assertEquals("Select constructor should create an selection object", "object", typeof(selection));
}

/**
 * Check collapse(), collapseToStart(), and collapseToEnd().
 */
function testCollapse() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var range = new mozile.dom.Range();
	var target = document.getElementById("target");
	var text = target.firstChild;

	// Collapse
	selection.collapse(text, 3);
	checkCollapsed("1", text, 3);

	// Collapse to start
	range.setStart(text, 2);
	range.setEnd(text, 5);
	selection.removeAllRanges();
	selection.addRange(range);
	selection.collapseToStart();
	checkCollapsed("2", text, 2);

	// Collapse to end
	range.setStart(text, 2);
	range.setEnd(text, 5);
	selection.removeAllRanges();
	selection.addRange(range);
	selection.collapseToEnd();
	checkCollapsed("3", text, 5);

	return;
	
	// TODO: Is this test important?
	var node = mozile.xpath.getNode("/html[1]/body[1]/div[1]/p[1]");
	selection.collapse(node, 2);
	checkCollapsed("4", node, 2);
	
}

/**
 * Check to see that the selection's anchorNode and focusNode == node, anchorOffset and focusOffset == offset, and isCollapsed == true.
 * @param {String} name A name for this check.
 * @param {Node} node
 * @param {Integer} offset
 * @type Void
 */
function checkCollapsed(name, node, offset) {
	var selection = mozile.dom.selection.get();
	assertEquals(name +" Check anchorNode", node, selection.anchorNode);
	assertEquals(name +" Check anchorOffset", offset, selection.anchorOffset);
	assertEquals(name +" Check focusNode", node, selection.focusNode);
	assertEquals(name +" Check focusOffset", offset, selection.focusOffset);
	assertTrue(name +" Check collapsed", selection.isCollapsed);
}

/**
 *
 */
function testContainsNode() {
	// Not implemented
}

/**
 *
 */
function testDelete() {
	// Not implemented
}

/**
 *
 */
function testExtend() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();
	var target = document.getElementById("target");
	var text = target.firstChild;

	// Span text
	var node = text;
	var o1 = 3;
	var o2 = 5;
	selection.collapse(node, o1);
	checkCollapsed("1", node, o1);

	selection.extend(node, o2);
	assertEquals("Check the selection string", node.data.substring(o1, o2), selection.toString());

	assertEquals("Check anchorNode", node, selection.anchorNode);
	assertEquals("Check anchorOffset", o1, selection.anchorOffset);
	assertEquals("Check focusNode", node, selection.focusNode);
	assertEquals("Check focusOffset", o2, selection.focusOffset);
	
	// Span nodes
	selection.collapse(target.firstChild, o1);
	checkCollapsed("2", target.firstChild, o1);

	selection.extend(target.lastChild, o2);
	assertEquals("Check anchorNode", target.firstChild, selection.anchorNode);
	assertEquals("Check anchorOffset", o1, selection.anchorOffset);
	assertEquals("Check focusNode", target.lastChild, selection.focusNode);
	assertEquals("Check focusOffset", o2, selection.focusOffset);

}

/**
 *
 */
function testRanges() {
	var target = document.getElementById('target');
	var range1 = new mozile.dom.Range();
	// Different start and end.
	range1.setStart(target.firstChild, 0);
	range1.setEnd(target.firstChild, 1);
	var selection = new mozile.dom.Selection();
	selection.removeAllRanges();
	selection.addRange(range1);
	var range2 = selection.getRangeAt(0);

	assertNotNull("There should be a range", range2);
	assertEquals("startContainer names should be equal", range1.startContainer.nodeName, range2.startContainer.nodeName);
	assertEquals("startContainers should be equal", range1.startContainer, range2.startContainer);
	assertEquals("startOffsets should be equal", range1.startOffset, range2.startOffset);
	assertEquals("endContainers should be equal", range1.endContainer, range2.endContainer);
	assertEquals("endOffsets should be equal", range1.endOffset, range2.endOffset);

}


/**
 *
 */
function testRanges2() {
	mozile.test.shared.preselect();
	var target = document.getElementById('target2');
	var range1 = new mozile.dom.Range();
	range1.setStart(target.firstChild, 1);
	range1.collapse(true);
	//alert("Range1\n"+ mozile.util.dumpValues(range1._range));
	var selection = new mozile.dom.Selection();
	selection.removeAllRanges();
	selection.addRange(range1);
	//alert("selection\n"+ mozile.util.dumpValues(selection._selection.createRangeCollection().item(0)));
	var range2 = selection.getRangeAt(0);
	//alert("Range2\n"+ mozile.util.dumpValues(range2._range));

	//alert(range1.startOffset +" = "+ range2.startOffset +" ? "+ (range1.startOffset == range2.startOffset) +"\n"+
	//	range1.endOffset +" = "+ range2.endOffset +" ? "+ (range1.endOffset == range2.endOffset) );

	assertNotNull("There should be a range", range2);
	assertEquals("startContainer names should be equal", range1.startContainer.nodeName, range2.startContainer.nodeName);
	assertEquals("startContainer XPaths should be equal", 
		mozile.xpath.getXPath(range1.startContainer), 
		mozile.xpath.getXPath(range2.startContainer) );
	assertEquals("startContainers should be equal", range1.startContainer, range2.startContainer);
	assertEquals("startOffsets should be equal", range1.startOffset, range2.startOffset);
	assertEquals("endContainers should be equal", range1.endContainer, range2.endContainer);
	assertEquals("endOffsets should be equal", range1.endOffset, range2.endOffset);

}

/**
 *
 */
function testRemoveRange() {
	// Currently trivial.
}

/**
 *
 */
function testSelectAllChildren() {
	// TODO: Finish this test.
	return;

	mozile.test.shared.preselect();
	var selection = new mozile.dom.Selection();
	var para = document.getElementById('paragraph');
	selection.selectAllChildren(para.firstChild);
	var r = selection.getRangeAt(0);
	//alert(mozile.util.dumpValues(selection.store()) +"\n\n"+ mozile.util.dumpValues(r.store()));
	assertEquals("Containing text doesn't match (1)", 'foobar', r.toString());
	assertEquals("startContainer should be the given node", para.firstChild, r.startContainer);
	assertEquals("endContainer should be the given node", para.firstChild, r.endContainer);
	assertEquals("commonAncestorContainer should be the given node", para.firstChild, r.commonAncestorContainer);
	
	selection.selectAllChildren(para.firstChild.firstChild.nextSibling);
	r = selection.getRangeAt(0);
	assertEquals("Containing text doesn't match (2)", '', r.toString());
	
	selection.selectAllChildren(para);
	r = selection.getRangeAt(0);
	assertEquals("Containing text doesn't match (3)", 'foobarHeading 1foobar', r.toString());
	
	var target = document.getElementById("target");
	selection.selectAllChildren(target);
	r = selection.getRangeAt(0);
	assertEquals("startContainer should be the target", target, r.startContainer);
	assertEquals("startOffset should be 0", 0, r.startOffset);
	assertEquals("endContainer should be the last child node", target, r.endContainer);
	assertEquals("endOffset should be the target's childNodes length", target.childNodes.length, r.endOffset);
	assertEquals("commonAncestorContainer should be the target", target, r.commonAncestorContainer);
}
mozile.require("mozile.util");

/**
 *
 */
function testLanguageDirection() {
	// Not implemented
}

/**
 *
 */
function testStoreRestore() {
	var target = document.getElementById('target');
	var text = target.firstChild;

	var selection = new mozile.dom.Selection();
	selection.collapse(text, 0);
	selection.extend(text, 10);

	var state = selection.store();
	assertNotNull("There should be a stored state", state);
	assertEquals("State should be an object", "object", typeof(state));

	selection.collapse(target.lastChild, 5);
	assertEquals("The anchorNode should be in the lastChild", target.lastChild, selection.anchorNode);
	assertEquals("The anchorOffset should be 5", 5, selection.anchorOffset);
	assertEquals("The focusNode should be in the lastChild", target.lastChild, selection.focusNode);
	assertEquals("The focusOffset should be 5", 5, selection.focusOffset);
	
	selection.restore(state);
	assertEquals("The anchorNode should be in text", text, selection.anchorNode);
	assertEquals("The anchorOffset should be 0", 0, selection.anchorOffset);
	assertEquals("The focusNode should be in text", text, selection.focusNode);
	assertEquals("The focusOffset should be 10", 10, selection.focusOffset);

}

