/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's extensions to the DOM Node object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Node.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

mozile.require("mozile.dom");

var name = "mozile.dom.Node";

/**
 * Expose the functions named in this aray to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testNode"];
}

/**
 *
 */
function testNode() {
	var target = document.getElementById("target");
	target = new mozile.dom.Node(target);
	var target2 = document.getElementById("target2");
	target2 = new mozile.dom.Node(target2);
	var container = document.getElementById("container");
	container = new mozile.dom.Node(container);

	assertFalse("Should the node be ignored?", target.isIgnored());
	
	assertFalse("A child is not an ancestor", target.isAncestorOf(container));
	assertTrue("A parent is an ancestor", container.isAncestorOf(target));
	
	assertEquals("Check the first child element", target2, target.getFirstChildElement() );
	assertEquals("Check the next sibling element", document.getElementById("target3"), target2.getNextSiblingElement() );
	
	var element = document.createElement("element");
	target.insertAfter(element, target.lastChild);
	assertEquals("insertAfter should append the element", element, target.lastChild);
}

