/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's extensions to the DOM Document object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Document.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

mozile.require("mozile.dom");

var name = "mozile.dom.Document";

/**
 * Expose the functions named in this aray to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testGetters"];
}


function testGetters() {
	var doc = new mozile.dom.Document(document);
	
	// HTML Case
	if(doc.documentElement.nodeName.toLowerCase() == "html") {
		assertTrue("This is HTML", doc.isHTML());
		assertEquals("Get the head", document.getElementsByTagName("head")[0], doc.getHead());
		assertEquals("Get the body", document.getElementsByTagName("body")[0], doc.getBody());
	}
	// XML Case
	else {
		assertFalse("This is not HTML", doc.isHTML());
		assertEquals("Get the head", document.documentElement, doc.getHead());
		assertEquals("Get the body", document.documentElement, doc.getBody());
	}
}

