/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's XPath functions.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: xpath.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

mozile.require("mozile.xpath");
var name = "mozile.xpath.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	//return ["testGetXPathRoot"];
	return ["testGetXPath", "testGetXPathRoot", "testComponents"]; //"testEvaluate"
}

/**
 * 
 */
function testGetXPath() {
	var target = document.getElementById("target");
	var para = document.getElementById("p1");
	var nodes = [
		document,	// document
		document.documentElement,	// element
		target,	// element
		target.getAttributeNode("id"), // attribute
		target.firstChild,	// text node
		para.firstChild // comment node
	];
	
	// Attribute case won't work in IE
	if(navigator.userAgent.indexOf("MSIE") > -1) {
		nodes.splice(3,1);
		// TODO: IE XML case hasn't been debugged.
		if(location.toString().indexOf("testpage.xml") > -1) return;
	}

	for(var i=0; i < nodes.length; i++) {
		checkXPath(nodes[i]);
	}

}

/**
 * 
 */
function testGetXPathRoot() {
	var target = document.getElementById("target");
	var target2 = document.getElementById("target2");
	var para = document.getElementById("p1");
	var nodes = [
		target,	// element
		target.getAttributeNode("id"), // attribute
		target.firstChild,	// text node
		target2,
		target2.firstChild
	];
	
	// Attribute case won't work in IE
	if(navigator.userAgent.indexOf("MSIE") > -1) {
		nodes.splice(3,1);
		// TODO: IE XML case hasn't been debugged.
		if(location.toString().indexOf("testpage.xml") > -1) return;
	}

	for(var i=0; i < nodes.length; i++) {
		checkXPath(nodes[i], target);
	}

}


/**
 * 
 */
function testComponents() {
	var xpath = "/html[1]/body[1]/div[1]/p[2]/@id";
	var components = mozile.xpath.getComponents(xpath);
	assertEquals("The should be 5 components", 5, components.length);

	var component = mozile.xpath.getComponent("p[2]");
	assertEquals("Check the name", "p", component.name);
	assertEquals("Check the position", "2", component.position);
}


/**
 * 
 */
function testEvaluate() {
	if(!window.XPathEvaluator && !document.selectNodes) {
		warn("This browser does not support XPath");
		return;
	}

	var target = document.getElementById("target");
	var nodes = [
		target,
		target.getAttributeNode("id"),
		target.firstChild
	];

	for(var i=0; i < nodes.length; i++) {
		checkXPath2(nodes[i]);
	}
}


/**
 * Checks to see if an 
 * @param {Node} The node to check.
 */
function checkXPath(node, root) {
	var xpath = mozile.xpath.getXPath(node, root);
	//alert("XPath: "+ xpath);
	assertNotNull("getXPath should not be null.", xpath);
	assertNotUndefined("getXPath should be defined.", xpath);
	assertEquals("getXPath should be a string.", "string", typeof(xpath));
	
	var result = mozile.xpath.getNode(xpath, root);
	//alert("Result:"+ result.nodeName);
	var original = node;
	if(node.original) original = node.original;
	assertNotNull("The result for '"+ xpath +"' should not be null", result);
	assertEquals("Names should match.", mozile.dom.getLocalName(original), mozile.dom.getLocalName(result));
	assertEquals("Types should match.", original.nodeType, result.nodeType);
	assertEquals("Parents should match.", original.parentNode, result.parentNode);
	
	// Special case for badly behaving old Mozilla versions.
	// They seem to do everything right, except the node identity check fails for attributes.
	if(node.nodeType == mozile.dom.ATTRIBUTE_NODE) {
		if(!mozile.browser.isMozilla || mozile.browser.mozillaVersion >= 1.8)
			assertEquals("The result should match the node.", original, result);
	}
	else assertEquals("The result should match the original node.", original, result);
}

/**
 * Uses mozile.xpath.evaluate() to check a node's getXPath method.
 * @param {Node} The node to check.
 */
function checkXPath2(node) {
	var xpath = mozile.xpath.getXPath(node);
	//alert("XPath: "+ xpath);
	assertNotNull("getXPath should not be null.", xpath);
	assertNotUndefined("getXPath should be defined.", xpath);
	assertEquals("getXPath should be a string.", "string", typeof(xpath));
	
	var result = mozile.xpath.getNode(xpath);
	var original = node;
	if(node.original) original = node.original;
	assertEquals("There should be exactly one result.", 1, result.length);
	assertEquals("Names should match.", original.nodeName, result[0].nodeName);
	assertEquals("Types should match.", original.nodeType, result[0].nodeType);
	assertEquals("The result should match the node.", original, result[0]);		
}
