/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's XML utility functions.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: xml.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

mozile.loadModule("mozile.xml");
var name = "mozile.xml.*";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testNS", "testLoad", "testParse", "testParseElement", "testSerialize" ];
}

/**
 * 
 */
function testNS() {
	assertEquals("Check RNG namespace", "http://relaxng.org/ns/structure/1.0", mozile.xml.ns.rng);
	assertEquals("Check XHTML namespace", "http://www.w3.org/1999/xhtml", mozile.xml.ns.xhtml);
	assertEquals("Check XUL namespace", "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", mozile.xml.ns.xul);
}

/**
 * 
 */
function testLookupPrefix() {
	assertEquals("Check RNG prefix", "rng", mozile.xml.lookupPrefix("http://relaxng.org/ns/structure/1.0"));
	assertEquals("Check XHTML prefix", "xhtml", mozile.xml.lookupPrefix("http://www.w3.org/1999/xhtml"));
}

/**
 * 
 */
function testLoad() {
	var xmlDoc = mozile.xml.load("../core/dummy.xml");
	assertNotNull("The xmlDoc should exist", xmlDoc);
	assertNotNull("The documentElement should exist", xmlDoc.documentElement);
	assertEquals("The documentElement name should be 'success'", "success", xmlDoc.documentElement.nodeName);
}

/**
 * 
 */
function testParse() {
	var xmlDoc = mozile.xml.parse("<success/>");
	assertNotNull("The xmlDoc should exist", xmlDoc);
	assertNotNull("The documentElement should exist", xmlDoc.documentElement);
	assertEquals("The documentElement name should be 'success'", "success", xmlDoc.documentElement.nodeName);
}

/**
 * 
 */
function testParseElement() {
	var element = mozile.xml.parseElement("<success/>");
	assertNotNull("The element should exist", element);
	assertEquals("The element name should be 'success'", "success", element.nodeName);
}

/**
 * 
 */
function testSerialize() {
	var input = "<success/>";
	var xmlDoc = mozile.xml.parse(input);
	var output = mozile.xml.serialize(xmlDoc);
	// remove trailing whitespace and replace " />" with "/>"
	output = output.replace(/\s+$/, ""); // ignore trailing whitespace
	output = output.replace(/<\?.*\?>/, ""); // ignore <?xml?> declarations
	output = output.replace(" />", "/>"); // ignore extra space before "/>"
	assertEquals("Serialize the document", input, output);
}


