/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's debugging functionality.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: debug.js,v 1.2 2006/08/23 16:55:27 jameso Exp $
 */

var name = "mozile.debug";


/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testIsSelected", "testLogging", "testShow"];
}

/**
 * 
 */
function testIsSelected() {
	var storeLogLevel = mozile.debug.logLevel;

	// Suppress tests
	mozile.debug.logLevel = "suppress";
	assertFalse("Test level: '"+ mozile.debug.logLevel +"' vs. 'warn'", 
		mozile.debug.isSelected("log", "warn"));
	assertFalse("Test level: '"+ mozile.debug.logLevel +"' vs. 'inform'", 
		mozile.debug.isSelected("log", "inform"));
	assertFalse("Test level: '"+ mozile.debug.logLevel +"' vs. 'debug'", 
		mozile.debug.isSelected("log", "debug"));

	// Warn tests
	mozile.debug.logLevel = "warn";
	assertTrue("Test level: '"+ mozile.debug.logLevel +"' vs. 'warn'", 
		mozile.debug.isSelected("log", "warn"));
	assertFalse("Test level: '"+ mozile.debug.logLevel +"' vs. 'inform'", 
		mozile.debug.isSelected("log", "inform"));
	assertFalse("Test level: '"+ mozile.debug.logLevel +"' vs. 'debug'", 
		mozile.debug.isSelected("log", "debug"));

	// Inform tests
	mozile.debug.logLevel = "inform";
	assertTrue("Test level: '"+ mozile.debug.logLevel +"' vs. 'warn'", 
		mozile.debug.isSelected("log", "warn"));
	assertTrue("Test level: '"+ mozile.debug.logLevel +"' vs. 'inform'", 
		mozile.debug.isSelected("log", "inform"));
	assertFalse("Test level: '"+ mozile.debug.logLevel +"' vs. 'debug'", 
		mozile.debug.isSelected("log", "debug"));

	// Debug tests
	mozile.debug.logLevel = "debug";
	assertTrue("Test level: '"+ mozile.debug.logLevel +"' vs. 'warn'", 
		mozile.debug.isSelected("log", "warn"));
	assertTrue("Test level: '"+ mozile.debug.logLevel +"' vs. 'inform'", 
		mozile.debug.isSelected("log", "inform"));
	assertTrue("Test level: '"+ mozile.debug.logLevel +"' vs. 'debug'", 
		mozile.debug.isSelected("log", "debug"));

	mozile.debug.logLevel = storeLogLevel;
}

/**
 *
 */
function testLogging() {
	var storeLogLevel = mozile.debug.logLevel;
	var storeAlertLevel = mozile.debug.alertLevel;
	mozile.debug.alertLevel = "suppress";
	mozile.debug.logLevel = "debug";
	var message;
	
	// Warn test
	mozile.debug.messages = new Array();
	mozile.debug.warn("mozile.text.debug", "Debug message");
	assertEquals("There should be one message", 1, mozile.debug.messages.length);
	checkMessage(mozile.debug.messages[0]);
	mozile.debug.messages[0].level = "warn";
	
	// Inform test
	mozile.debug.messages = new Array();
	mozile.debug.inform("mozile.text.debug", "Debug message");
	assertEquals("There should be one message", 1, mozile.debug.messages.length);
	checkMessage(mozile.debug.messages[0]);
	mozile.debug.messages[0].level = "inform";
	
	// Debug test
	mozile.debug.messages = new Array();
	mozile.debug.debug("mozile.text.debug", "Debug message");
	assertEquals("There should be one message", 1, mozile.debug.messages.length);
	checkMessage(mozile.debug.messages[0]);
	mozile.debug.messages[0].level = "debug";
	
	
	mozile.debug.logLevel = storeLogLevel;
	mozile.debug.alertLevel = storeAlertLevel;
}

/**
 *
 */
function testShow() {
	// Currently trivial.
}


/**
 *
 */
function checkMessage(message) {
	assertNotUndefined("There should be a message caller", message.caller);
	assertNotUndefined("There should be a message level", message.level);
	assertNotUndefined("There should be a message message", message.message);
	assertNotUndefined("There should be a message date", message.date);
	assertEquals("There should be a message string", "string", typeof(message.toString()));
}
