/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Help Viewer API in Java.
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozdev.firebirdhelp.HelpViewer;

import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;

public interface iHelpTopic
{
	/**
	 *Add a subtopic of this help topic.
	 *@param aSubTopic The <code>iHelpTopic</code> to make the child of this node.
	 */
	void addSubTopic(iHelpTopic aSubTopic);
	/**
	 *Removes all subtopics of this topic.
	 */
	void removeSubTopics();
	/**
	 *Returns an iterator that will let you iterate through all of the
	 *sub-topics.
	 */
	Iterator topicIterator();
	/**
	 *Returns a TreeNode of this topic so you can insert it in a JTree.
	 */
	DefaultMutableTreeNode getTreeNode();
	
	/**
	 *Returns the name of the topic.
	 */
	String name();
	/**
	 *Returns the URL that should be loaded in the Help Viewer when this
	 *topic is clicked on or enabled.
	 */
	String url();
}
