/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Iterator;
import org.mozdev.MacroTracker.classes.*;
import org.mozdev.MacroTracker.ui.*;
import org.mozdev.MacroTracker.toolkit.*;
import org.mozdev.MacroTracker.main.MacroTracker;

import java.io.*;

import com.trfenv.rlk.Debug;

/**
 *The form used to display a bug from the CDatabase.
 *
 *@author R.J. Keller <rlk@trfenv.com>
 *@version 0.1
 */
public class frmBug extends PanelMenuBar implements ActionListener
{
	private JTabbedPane tbpTabs;

	private JTextArea txtDiscussion;

	private JLabel lblBug;
	private JLabel lblStatus;
	private JLabel lblResolution;
	private JLabel lblAssignedTo;
	private JLabel lblReporter;
	private hyperlinkLabel lblComponentsLabel;

	private JComboBox cboProduct;
	private JComboBox cboHardware;
	private JComboBox cboOS;
	private JComboBox cboVersion;
	private JComboBox cboTargetMilestone;
	private JComboBox cboCC;
	private JComboBox cboPriority;
	private JComboBox cboSeverity;
	private JComboBox cboComponent;

	private MTextField txtQAContact;
	private MTextField txtURL;
	private MTextField txtSummary;
	private MTextField txtStatusWhiteboard;
	private MTextField txtBlocks;
	private MTextField txtDependsOn;
	private MTextField txtChangeAssignedTo;
	private MTextField txtAddCC;

	private JRadioButton rdoConfirmBug;
	private JRadioButton rdoResolveBug;
	private JRadioButton rdoMarkBugVerified;
	private JRadioButton rdoMarkBugClosed;
	private JRadioButton rdoReopenBug;

	private JMenuItem mnuOpenBug;
	private JMenuItem mnuFileSave;
	private JMenuItem mnuExportXML;
	private JMenuItem mnuExportHTML;
	private JMenuItem mnuFileExit;
	private JMenuItem mnuHelpContents;
	private JMenuItem mnuHelpAbout;

	private JButton btnAddComments;
	private JButton btnOK;
	private JButton btnCancel;
	private JButton btnApply;
	
	private Bug mCurrentBug;

	public void saveBug()
	{
		mCurrentBug.setProduct( MacroTracker.gMasterBugDatabase.getProduct(cboProduct.getSelectedIndex()) );
		mCurrentBug.setComponent( (String)cboComponent.getItemAt(cboComponent.getSelectedIndex()) );
		mCurrentBug.setOS( (String)cboOS.getItemAt(cboOS.getSelectedIndex()) );
		mCurrentBug.setVersion( Double.parseDouble( (String)cboVersion.getItemAt(cboVersion.getSelectedIndex()) ) );
		mCurrentBug.setTargetMilestone( Double.parseDouble( (String)cboTargetMilestone.getItemAt(cboTargetMilestone.getSelectedIndex()) ) );

		//ToDo: Add String Tokenizer to get all the added CCs.

		//ToDo: Set up a setSeverity() overload function that takes in a String parameter.
		//mCurrentBug.setSeverity( cboSeverity.getItem(cboSeverity.getSelectedIndex()) );

		if (MacroTracker.gMasterBugDatabase.isValidUser(txtQAContact.getText()))
//ToDo: Get this working once the iBugDatabase interface is up and running.
//			mCurrentBug.setQAContact( MacroTracker.masterBugDatabase.getUser(txtQAContact.getText()) );
//ToDo: remove this below ;)
;
		else
			JOptionPane.showMessageDialog( this, "Invalid QA Contact given. Please insert a valid QA Contact");

		if (MacroTracker.gMasterBugDatabase.isValidUser(txtChangeAssignedTo.getText()))
//ToDo: Get this working once the iBugDatabase interface is up and running.
//			mCurrentBug.setAssignedTo( MacroTracker.masterBugDatabase.getUser(txtChangeAssignedTo.getText()) );
;
		else
			JOptionPane.showMessageDialog( this, "Invalid Asignee given. Please change the asignee's email address in order to continue.");

		mCurrentBug.setHardware( (String)cboHardware.getItemAt(cboHardware.getSelectedIndex()) );
		mCurrentBug.setSummary( txtSummary.getText() );
		mCurrentBug.setStatusWB( txtStatusWhiteboard.getText() );
	}

    private void initalizeComponents(Bug bug)
    {
		Debug.println("-- LOADING BUG " + String.valueOf(bug.getBugNumber()) + " --");

		mCurrentBug = bug;

    	lblBug.setText(String.valueOf(bug.getBugNumber()));
    	lblStatus.setText(String.valueOf(bug.getStatus().toString()));
    	lblResolution.setText(String.valueOf(bug.getResolution().toString()));
    	lblAssignedTo.setText(bug.getAssignedTo().getEmail() + " (" + bug.getAssignedTo().getName() + ")");
    	lblReporter.setText(bug.getReporter().getEmail() + " (" + bug.getReporter().getEmail() + ")");

    	//-- PRODUCTS --//
		for (Iterator i = MacroTracker.gMasterBugDatabase.productIterator(); i.hasNext();)
    	{
    		Product j = (Product)i.next();
    		cboProduct.addItem(j.name);

    		if (j == bug.getProduct())
    		{
    			cboProduct.setSelectedIndex(cboProduct.getSelectedIndex());
    		}
    	}

   		Product currentProduct = bug.getProduct();

    	//--COMPONENTS--//
		for (int i = 0; i < currentProduct.componentSize(); i++)
    	{
    		Product.component j = currentProduct.getComponent(i);
    		cboComponent.addItem(j.getName());

    		if (j.equals(bug.getComponent()))
    		{
    			cboComponent.setSelectedIndex(cboComponent.getItemCount());
    		}
    	}

    	//--HARDWARE--//
		for (int i = 0; i < currentProduct.platformSize(); i++)
    	{
    		String j = currentProduct.getPlatform(i);
    		cboHardware.addItem(j);

    		if (j.equals(bug.getHardware()))
    			cboHardware.setSelectedIndex(cboHardware.getItemCount());
    	}

    	//--OPERATING SYSTEMS--//
		for (int i = 0; i < currentProduct.OSSize(); i++)
    	{
    		String j = currentProduct.getOS(i);
    		cboOS.addItem(j);

    		if (j.equals(bug.getOS()))
    			cboOS.setSelectedIndex(cboOS.getItemCount());
    	}

    	//--VERSION--//
		for (int i = 0; i < currentProduct.versionSize(); i++)
    	{
    		double j = currentProduct.getVersion(i);
    		cboVersion.addItem(String.valueOf(j));

    		if (j == bug.getVersion())
    			cboVersion.setSelectedIndex(cboVersion.getItemCount());
    	}

    	//--TARGET MILESTONE--//
    	//ToDo: Need to do this later once it's hooked up in the Product
    	//	class.

    	//--CC LIST--//
		for (Iterator i = bug.ccIterator(); i.hasNext();)
    	{
    		User j = (User)i.next();
    		cboCC.addItem(j.getEmail());
    	}

    	//--PRIORITY--//
    	for (int i = 0; i < 5; i++)
    	{
    		cboPriority.addItem("P" + i);

    		if (i == bug.getPriority())
    			cboPriority.setSelectedIndex(i);
    	}

    	//--SEVERITY--//
    	for (int i = 0; i < 6; i++)
    	{
    		//ToDo: This will not make the severities work properly. Needs fixing!
			//String severity = Bug.getSeverity();
//
//			cboSeverity.addItem(severity);
//
//			if (Bug.getSeverityString(bug.getSeverity()) == severity)
//				cboSeverity.setSelectedIndex(i);
		}

    	txtQAContact.setText(bug.getQAContact().getEmail());
    	txtURL.setText(bug.getURL());
    	txtSummary.setText(bug.getSummary());
    	txtStatusWhiteboard.setText(bug.getStatusWB());

    	txtDiscussion.setText(bug.getDescription());

    	for (Iterator i = bug.commentIterator(); i.hasNext();)
    	{
    		UserComment j = (UserComment)i.next();
    		txtDiscussion.setText(txtDiscussion.getText() + "\n\n\n------ Additional Comments From " + j.getAuthor().getName() + " -------\n\n" + j.getComment());
		}
    }

	public frmBug( Bug bug )
	{
		this();

		initalizeComponents(bug);
	}

	public frmBug()
	{


		//Set the window to a Border Layout so that we can have the tab pane
		//in the center and the buttons on the bottom.
		setLayout( new BorderLayout() );

		//-- BEGIN GENERAL TAB --//

		//boldLabel - A JLabel that has the font automatically set to bold.
		class boldLabel extends JLabel
		{
			public boldLabel( String text )
			{
				super(text);

				setFont(new Font("sans-serif", Font.BOLD, 11));
			}
		}

		JPanel pnlGeneral = new JPanel();
		pnlGeneral.setLayout(new GridLayout(14,1));

		JPanel pnl01 = new JPanel();
		pnlGeneral.add(pnl01);
		pnl01.setLayout(new GridLayout(1,4));
		pnl01.add(new boldLabel("Bug Number:"));
		lblBug = new JLabel();
		pnl01.add(lblBug);
		pnl01.add(new boldLabel("Hardware"));
		cboHardware = new JComboBox();
		pnl01.add(cboHardware);

		JPanel pnl02 = new JPanel();
		pnl02.setLayout(new GridLayout(1,4));
		pnlGeneral.add(pnl02);
		pnl02.add(new boldLabel("Product"));
		cboProduct = new JComboBox();
		pnl02.add(cboProduct);
		pnl02.add(new boldLabel("Priority"));
		cboPriority = new JComboBox();
		pnl02.add(cboPriority);

		JPanel pnl03 = new JPanel();
		pnl03.setLayout(new GridLayout(1,4));
		pnlGeneral.add(pnl03);
		// special component loading script so that we can open something
		// other than a URL in the MiniBrowser.
		lblComponentsLabel = new hyperlinkLabel();
		lblComponentsLabel.setText("Component:");
		class mouseLoader implements MouseListener
		{				
			public void mouseClicked( MouseEvent e )
			{
				Debug.println("Running Component MouseEvent.");

				DescribeComponent compDescription = new DescribeComponent(mCurrentBug.getProduct());
				compDescription.setVisible( true );
			}
					
			public void mouseEntered( MouseEvent e ){}
			public void mouseExited( MouseEvent e ){}		
			public void mousePressed( MouseEvent e ){}
			public void mouseReleased( MouseEvent e ){}
		}
		lblComponentsLabel.addMouseListener(new mouseLoader());
		
		pnl03.add(lblComponentsLabel);
		cboComponent = new JComboBox();
		pnl03.add(cboComponent);
		pnl03.add(new boldLabel("Severity"));
		cboSeverity = new JComboBox();
		pnl03.add(cboSeverity);

		JPanel pnl04 = new JPanel();
		pnl04.setLayout(new GridLayout(1,4));
		pnlGeneral.add(pnl04);
		pnl04.add(new hyperlinkLabel("Status", "http://bugzilla.mozilla.org/bug_status.html"));
		lblStatus = new JLabel();
		pnl04.add(lblStatus);
		pnl04.add(new boldLabel("OS"));
		cboOS = new JComboBox();
		pnl04.add(cboOS);

		JPanel pnl05 = new JPanel();
		pnl05.setLayout(new GridLayout(1,4));
		pnlGeneral.add(pnl05);
		pnl05.add(new hyperlinkLabel("Resolution", "http://bugzilla.mozilla.org/bug_status.html"));
		lblResolution = new JLabel();
		pnl05.add(lblResolution);
		pnl05.add(new boldLabel("Version"));
		cboVersion = new JComboBox();
		pnl05.add(cboVersion);

		JPanel pnl06 = new JPanel();
		pnl06.setLayout(new GridLayout(1,4));
		pnlGeneral.add(pnl06);
		pnl06.add(new hyperlinkLabel("Assigned To", "http://bugzilla.mozilla.org/bug_status.html#assigned_to"));
		lblAssignedTo = new JLabel();
		pnl06.add(lblAssignedTo);
		pnl06.add(new boldLabel("Target Milestone"));
		cboTargetMilestone = new JComboBox();
		pnl06.add(cboTargetMilestone);

		JPanel pnl07 = new JPanel();
		pnl07.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl07);
		pnl07.add(new boldLabel("QA Contact"));
		txtQAContact = new MTextField();
		pnl07.add(txtQAContact);

		JPanel pnl08 = new JPanel();
		pnl08.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl08);
		pnl08.add(new boldLabel("URL"));
		txtURL = new MTextField();
		pnl08.add(txtURL);

		JPanel pnl09 = new JPanel();
		pnl09.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl09);
		pnl09.add(new boldLabel("Summary"));
		txtSummary = new MTextField();
		pnl09.add(txtSummary);

		JPanel pnl10 = new JPanel();
		pnl10.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl10);
		pnl10.add(new boldLabel("Status Whiteboard"));
		txtStatusWhiteboard = new MTextField();
		pnl10.add(txtStatusWhiteboard);

		JPanel pnl11 = new JPanel();
		pnl11.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl11);
		pnl11.add(new boldLabel("Blocks"));
		txtBlocks = new MTextField();
		pnl11.add(txtBlocks);

		JPanel pnl12 = new JPanel();
		pnl12.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl12);
		pnl12.add(new boldLabel("Depends On"));
		txtDependsOn = new MTextField();
		pnl12.add(txtDependsOn);

		JPanel pnl13 = new JPanel();
		pnl13.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl13);
		pnl13.add(new boldLabel("Reporter"));
		lblReporter = new JLabel();
		pnl13.add(lblReporter);

		JPanel pnl14 = new JPanel();
		pnl14.setLayout(new GridLayout(1,2));
		pnlGeneral.add(pnl14);
		pnl14.add(new boldLabel("CC"));
		cboCC = new JComboBox();
		pnl14.add(cboCC);

		tbpTabs = new JTabbedPane();
		tbpTabs.addTab("General", pnlGeneral);
		add(tbpTabs, BorderLayout.CENTER);
		//-- END GENERAL TAB --//

		//-- CHANGE BUG TAB --//
		JPanel pnlChangeBug = new JPanel();
		pnlChangeBug.setLayout( new GridLayout(2,1) );

		ButtonGroup statusChanges = new ButtonGroup();

		JPanel pnlStatusChanges = new JPanel();
		pnlStatusChanges.setBorder(new TitledBorder(null, "Status Changes"));
		pnlStatusChanges.setLayout(new GridLayout(2,1));
		pnlChangeBug.add(pnlStatusChanges);

		rdoConfirmBug = new JRadioButton("Confirm bug (change status to NEW)");
		statusChanges.add(rdoConfirmBug);
		pnlStatusChanges.add(rdoConfirmBug);

		rdoResolveBug = new JRadioButton("Resolve bug, change resolution to");
		statusChanges.add(rdoResolveBug);
		pnlStatusChanges.add(rdoResolveBug);

		pnlChangeBug.add(pnlStatusChanges);

		tbpTabs.addTab("Change Bug", pnlChangeBug);

		JPanel pnlGeneralChanges = new JPanel();
		pnlGeneralChanges.setBorder(new TitledBorder(null, "General Changes"));
		pnlGeneralChanges.setLayout( new GridLayout(3, 2) );

		txtChangeAssignedTo = new MTextField();
		txtAddCC = new MTextField();

		pnlGeneralChanges.add( new JLabel("Reassign bug to:"));
		pnlGeneralChanges.add(txtChangeAssignedTo);
		pnlGeneralChanges.add(new JLabel("Add person to CC list:"));
		pnlGeneralChanges.add(txtAddCC);

		pnlChangeBug.add(pnlGeneralChanges);

		//-- END CHANGE BUG TAB --//

		//-- BEGIN DISCUSSION TAB --//
		JPanel pnlDiscussion = new JPanel();
		pnlDiscussion.setLayout( new BorderLayout() );

		JPanel pnlDiscussionTop = new JPanel();
		pnlDiscussionTop.setLayout( new FlowLayout( FlowLayout.LEFT ) );
		pnlDiscussionTop.add(new JLabel("Discussion:"));

		btnAddComments = new JButton("Add Comments");
		pnlDiscussionTop.add(btnAddComments);

		pnlDiscussion.add( pnlDiscussionTop, BorderLayout.NORTH );

		txtDiscussion = new JTextArea();
		txtDiscussion.setEnabled(false);
		JScrollPane discussionScrlPn = new JScrollPane( txtDiscussion );

		pnlDiscussion.add( discussionScrlPn, BorderLayout.CENTER );

		tbpTabs.addTab("Discussion", pnlDiscussion);
		//-- END DISCUSSION TAB --//

		//-- BEGIN BOTTOM BUTTONS --//
		btnOK = new JButton("OK");
		btnCancel = new JButton("Cancel");
		btnApply = new JButton("Apply");

		JPanel pnlBottomButtons = new JPanel();
		pnlBottomButtons.setLayout( new FlowLayout() );

		btnOK.addActionListener( this );
		btnCancel.addActionListener( this );

		pnlBottomButtons.add(btnOK);
		pnlBottomButtons.add(btnCancel);
		pnlBottomButtons.add(btnApply);

		add(pnlBottomButtons, BorderLayout.SOUTH);

		Debug.createObject(this);
	}

	public void actionPerformed(ActionEvent event)
	{
		if (event.getSource() == btnOK)
		{
			setVisible( false );
		}
		else if (event.getSource() == btnCancel ||
		         event.getSource() == mnuFileExit)
		{
			setVisible( false );
		}
		else if (event.getSource() == mnuHelpAbout)
		{
			frmAbout aboutScreen = new frmAbout();
			aboutScreen.setVisible(true);
		}
		else if (event.getSource() == mnuOpenBug)
		{
			frmOpenBug openBug = new frmOpenBug( mFrameToUse );
			openBug.setVisible( true );
		}
	}

	// This variable is here to feed to the ActionListener. This is required for the
	// mnuOpenBug click event to run.
	private Frame mFrameToUse;

	public JMenuBar getMenuBar( Frame parent )
	{
		JMenuBar mnuBar = new JMenuBar();

		JMenu mnuFile = new JMenu("File");
		mnuFile.setMnemonic('F');
		mnuBar.add(mnuFile);

		mnuFileSave = new JMenuItem("Save");
		JMenu mnuExport = new JMenu("Export");mnuExportXML = new JMenuItem("XML...");
		mnuExportHTML = new JMenuItem("HTML...");
		mnuFileExit = new JMenuItem("Exit");

		mFrameToUse = parent;

		mnuOpenBug = new JMenuItem("Open Bug...");
		mnuOpenBug.setMnemonic('O');
		mnuOpenBug.addActionListener( this );

		mnuFileSave.setMnemonic('S');
		mnuExport.setMnemonic('E');
		mnuExportHTML.setMnemonic('H');
		mnuExportXML.setMnemonic('X');
		mnuFileExit.setMnemonic('x');

		mnuFile.add(mnuFileSave);
		mnuFile.add(mnuExport);
		mnuExport.add(mnuExportHTML);
		mnuExport.add(mnuExportXML);
		mnuFile.addSeparator();
		mnuFile.add(mnuFileExit);
		mnuFile.add(mnuOpenBug);

		mnuFileExit.addActionListener( this );

		mnuBar.add(StandardComponents.generateHelpMenu());

		return mnuBar;
	}
}
