/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Debug;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.SQLError;
import org.gjt.mm.mysql.Util;

public abstract class MysqlIO {
    private Socket _mysqlConnection = null;
    private InputStream _mysqlInput = null;
    private BufferedOutputStream _mysqlOutput = null;
    private ResultSet _pendingResultSet = null;
    static int MAXBUF = 65535;
    static final int HEADER_LENGTH = 4;
    static final int COMP_HEADER_LENGTH = 3;
    private byte _packetSequence = 0;
    private byte _protocolVersion = 0;
    private String _serverVersion = null;
    private int _serverMajorVersion = 0;
    private int _serverMinorVersion = 0;
    private int _serverSubMinorVersion = 0;
    private int _port = 3306;
    private String _host = null;
    private Deflater _deflater = null;
    private Inflater _inflater = null;
    private Buffer _reusablePacket = null;
    private Buffer _sendPacket = null;
    SQLWarning _warningChain = null;
    private static int CLIENT_LONG_PASSWORD = 1;
    private static int CLIENT_FOUND_ROWS = 2;
    private static int CLIENT_LONG_FLAG = 4;
    private static int CLIENT_CONNECT_WITH_DB = 8;
    private static int CLIENT_NO_SCHEMA = 16;
    private static int CLIENT_COMPRESS = 32;
    private static int CLIENT_ODBC = 64;
    private static int CLIENT_LOCAL_FILES = 128;
    private static int CLIENT_IGNORE_SPACE = 256;
    private boolean _useCompression = false;
    private Connection _connection;
    private boolean _profileSql = false;

    public MysqlIO(String string, int n, Connection connection) throws IOException, SQLException {
        this._connection = connection;
        this._reusablePacket = new Buffer(this._connection.getNetBufferLength(), this._connection.getMaxAllowedPacket());
        this._port = n;
        this._host = string;
        this._mysqlConnection = new Socket(this._host, this._port);
        try {
            this._mysqlConnection.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._mysqlInput = new BufferedInputStream(this._mysqlConnection.getInputStream(), 16384);
        this._mysqlOutput = new BufferedOutputStream(this._mysqlConnection.getOutputStream());
    }

    void init(String string, String string2) throws SQLException {
        block25: {
            try {
                int n;
                int n2;
                Buffer buffer = this.readPacket();
                this._protocolVersion = buffer.readByte();
                if (this._protocolVersion == -1) {
                    try {
                        this._mysqlConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new SQLException("Server configuration denies access to data source", "08001", 0);
                }
                this._serverVersion = buffer.readString();
                int n3 = this._serverVersion.indexOf(".");
                if (n3 != -1) {
                    try {
                        int n4;
                        this._serverMajorVersion = n4 = Integer.parseInt(this._serverVersion.substring(0, n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String string3 = this._serverVersion.substring(n3 + 1, this._serverVersion.length());
                    n3 = string3.indexOf(".");
                    if (n3 != -1) {
                        int n5;
                        try {
                            this._serverMinorVersion = n5 = Integer.parseInt(string3.substring(0, n3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        string3 = string3.substring(n3 + 1, string3.length());
                        n5 = 0;
                        while (n5 < string3.length()) {
                            if (string3.charAt(n5) < '0' || string3.charAt(n5) > '9') break;
                            ++n5;
                        }
                        try {
                            this._serverSubMinorVersion = n2 = Integer.parseInt(string3.substring(0, n5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                long l = buffer.readLong();
                String string4 = buffer.readString();
                n2 = 0;
                if (buffer._pos >= buffer._bufLength || ((n = buffer.readInt()) & CLIENT_COMPRESS) != 0) {
                    // empty if block
                }
                n2 |= CLIENT_FOUND_ROWS;
                n2 = this._protocolVersion > 9 ? (n2 |= CLIENT_LONG_PASSWORD) : (n2 &= ~CLIENT_LONG_PASSWORD);
                n = 16;
                int n6 = 0;
                if (string != null) {
                    n6 = string.length();
                }
                int n7 = n6 + n + 6 + 4;
                Buffer buffer2 = new Buffer(n7);
                buffer2.writeInt(n2);
                buffer2.writeLongInt(n7);
                buffer2.writeString(string);
                if (this._protocolVersion > 9) {
                    buffer2.writeString(Util.newCrypt(string2, string4));
                } else {
                    buffer2.writeString(Util.oldCrypt(string2, string4));
                }
                this.send(buffer2);
                Buffer buffer3 = this.readPacket();
                byte by = buffer3.readByte();
                if (by == -1) {
                    String string5 = "";
                    int n8 = 2000;
                    if (this._protocolVersion > 9) {
                        n8 = buffer3.readInt();
                        string5 = buffer3.readString();
                        this.clearReceive();
                        String string6 = SQLError.mysqlToXOpen(n8);
                        if (string6.equals("S1000")) {
                            throw new SQLException("Communication failure during handshake. Is there a server running on " + this._host + ":" + this._port + "?");
                        }
                        throw new SQLException(SQLError.get(string6) + ": " + string5, string6, n8);
                    }
                    string5 = buffer3.readString();
                    this.clearReceive();
                    if (string5.indexOf("Access denied") != -1) {
                        throw new SQLException(SQLError.get("28000") + ": " + string5, "28000", n8);
                    }
                    throw new SQLException(SQLError.get("08001") + ": " + string5, "08001", n8);
                }
                if (by == 0) {
                    if (this._serverMajorVersion >= 3 && this._serverMinorVersion >= 22 && this._serverSubMinorVersion >= 5) {
                        buffer2.newReadLength();
                        buffer2.newReadLength();
                    } else {
                        buffer2.readLength();
                        buffer2.readLength();
                    }
                    break block25;
                }
                throw new SQLException("Unknown Status code from server", "08007", by);
            }
            catch (IOException iOException) {
                throw new SQLException(SQLError.get("08S01") + ": " + iOException.getClass().getName(), "08S01", 0);
            }
        }
    }

    void resetMaxBuf() {
        this._reusablePacket._maxLength = this._connection.getMaxAllowedPacket();
        this._sendPacket._maxLength = this._connection.getMaxAllowedPacket();
    }

    String getServerVersion() {
        return this._serverVersion;
    }

    final Buffer sendCommand(int n, String string, Buffer buffer) throws Exception {
        byte by;
        Buffer buffer2 = null;
        try {
            if (buffer == null) {
                int n2 = 8 + (string != null ? string.length() : 0) + 2;
                if (this._sendPacket == null) {
                    this._sendPacket = new Buffer(n2, this._connection.getMaxAllowedPacket());
                }
                this._packetSequence = (byte)-1;
                this._sendPacket.clear();
                if (this._useCompression) {
                    this._sendPacket._pos += 3;
                }
                this._sendPacket.writeByte((byte)n);
                if (n == 2 || n == 5 || n == 6 || n == 3) {
                    this._sendPacket.writeStringNoNull(string);
                } else if (n == 12) {
                    long l = new Long(string);
                    this._sendPacket.writeLong(l);
                } else if (n == 7 && this._protocolVersion > 9) {
                    Debug.msg(this, "Reload");
                }
                this.send(this._sendPacket);
            } else {
                this._packetSequence = (byte)-1;
                this.send(buffer);
            }
        }
        catch (Exception exception) {
            throw new SQLException(SQLError.get("08S01") + ": " + exception.getClass().getName(), "08S01", 0);
        }
        try {
            buffer2 = this.readPacket();
            by = buffer2.readByte();
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (Exception exception) {
            throw new SQLException(SQLError.get("08S01") + ": " + exception.getClass().getName(), "08S01", 0);
        }
        try {
            if (by == -1) {
                int n3 = 2000;
                if (this._protocolVersion > 9) {
                    n3 = buffer2.readInt();
                    String string2 = buffer2.readString();
                    this.clearReceive();
                    String string3 = SQLError.mysqlToXOpen(n3);
                    throw new SQLException(SQLError.get(string3) + ": " + string2, string3, n3);
                }
                String string4 = buffer2.readString();
                this.clearReceive();
                if (string4.indexOf("Unknown column") != -1) {
                    throw new SQLException(SQLError.get("S0022") + ": " + string4, "S0022", -1);
                }
                throw new SQLException(SQLError.get("S1000") + ": " + string4, "S1000", -1);
            }
            if (by == 0) {
                if (n == 5 || n == 6) {
                    SQLWarning sQLWarning = new SQLWarning("Command=" + n + ": ");
                    if (this._warningChain != null) {
                        sQLWarning.setNextException(this._warningChain);
                    }
                    this._warningChain = sQLWarning;
                }
            } else if (buffer2.isLastDataPacket()) {
                SQLWarning sQLWarning = new SQLWarning("Command=" + n + ": ");
                if (this._warningChain != null) {
                    sQLWarning.setNextException(this._warningChain);
                }
                this._warningChain = sQLWarning;
            }
            return buffer2;
        }
        catch (IOException iOException) {
            throw new SQLException(SQLError.get("08S01") + ": " + iOException.getClass().getName(), "08S01", 0);
        }
    }

    final ResultSet sqlQueryDirect(Buffer buffer, int n, Connection connection) throws Exception {
        Object object;
        long l = -1L;
        long l2 = -1L;
        StringBuffer stringBuffer = null;
        long l3 = 0L;
        if (this._profileSql) {
            stringBuffer = new StringBuffer();
            l3 = System.currentTimeMillis();
            object = buffer._buf;
            String string = new String((byte[])object, 5, buffer._pos - 5);
            stringBuffer.append("Query\t\"");
            stringBuffer.append(string);
            stringBuffer.append("\"\texecution time:\t");
        }
        this.clearAllReceive();
        object = this.sendCommand(3, null, buffer);
        if (this._profileSql) {
            long l4 = System.currentTimeMillis() - l3;
            stringBuffer.append(l4);
            stringBuffer.append("\t");
        }
        --((Buffer)object)._pos;
        long l5 = ((Buffer)object).readLength();
        if (l5 == 0L) {
            try {
                if (this.versionMeetsMinimum(3, 22, 5)) {
                    l = ((Buffer)object).newReadLength();
                    l2 = ((Buffer)object).newReadLength();
                } else {
                    l = ((Buffer)object).readLength();
                    l2 = ((Buffer)object).readLength();
                }
            }
            catch (Exception exception) {
                throw new SQLException(SQLError.get("S1000") + ": " + exception.getClass().getName(), "S1000", -1);
            }
            if (this._profileSql) {
                System.err.println(stringBuffer.toString());
            }
            return this.buildResultSetWithUpdates(l, l2, connection);
        }
        long l6 = 0L;
        if (this._profileSql) {
            l6 = System.currentTimeMillis();
        }
        ResultSet resultSet = this.getResultSet(l5, n);
        if (this._profileSql) {
            long l7 = System.currentTimeMillis() - l6;
            stringBuffer.append("result set fetch time:\t");
            stringBuffer.append(l7);
        }
        return resultSet;
    }

    final ResultSet sqlQuery(String string, int n, String string2, Connection connection) throws Exception {
        int n2 = 5 + string.length() * 2 + 2;
        if (this._sendPacket == null) {
            this._sendPacket = new Buffer(n2, this._connection.getMaxAllowedPacket());
        } else {
            this._sendPacket.clear();
        }
        this._sendPacket.writeByte((byte)3);
        if (string2 != null) {
            this._sendPacket.writeStringNoNull(string, string2);
        } else {
            this._sendPacket.writeStringNoNull(string);
        }
        return this.sqlQueryDirect(this._sendPacket, n, connection);
    }

    final ResultSet sqlQuery(String string, int n, String string2) throws Exception {
        return this.sqlQuery(string, n, string2, null);
    }

    final ResultSet sqlQuery(String string, int n) throws Exception {
        long l;
        StringBuffer stringBuffer = null;
        long l2 = 0L;
        if (this._profileSql) {
            stringBuffer = new StringBuffer();
            l2 = System.currentTimeMillis();
            stringBuffer.append("Query\t\"");
            stringBuffer.append(string);
            stringBuffer.append("\"\texecution time:\t");
        }
        this.clearAllReceive();
        Buffer buffer = this.sendCommand(3, string, null);
        if (this._profileSql) {
            l = System.currentTimeMillis() - l2;
            stringBuffer.append(l);
            stringBuffer.append("\t");
        }
        --buffer._pos;
        l = buffer.readLength();
        if (l == 0L) {
            long l3 = -1L;
            long l4 = -1L;
            try {
                if (this.versionMeetsMinimum(3, 22, 5)) {
                    long l5;
                    l3 = buffer.newReadLength();
                    l4 = buffer.newReadLength();
                    String string2 = buffer.readString();
                    if (string2.length() > 0 && (l5 = MysqlIO.getMatchedRows(string2)) > -1L) {
                        l3 = l5;
                    }
                } else {
                    l3 = buffer.readLength();
                    l4 = buffer.readLength();
                }
            }
            catch (Exception exception) {
                throw new SQLException(SQLError.get("S1000") + ": " + exception.getClass().getName(), "S1000", -1);
            }
            if (this._profileSql) {
                System.err.println(stringBuffer.toString());
            }
            return this.buildResultSetWithUpdates(l3, l4, null);
        }
        long l6 = 0L;
        if (this._profileSql) {
            l6 = System.currentTimeMillis();
        }
        ResultSet resultSet = this.getResultSet(l, n);
        if (this._profileSql) {
            long l7 = System.currentTimeMillis() - l6;
            stringBuffer.append("result set fetch time:\t");
            stringBuffer.append(l7);
        }
        return resultSet;
    }

    protected ResultSet getResultSet(long l, int n) throws Exception {
        int n2;
        Object object;
        Object object2;
        Buffer buffer;
        Field[] fieldArray = new Field[(int)l];
        int n3 = 0;
        while ((long)n3 < l) {
            buffer = this.readPacket();
            object2 = buffer.readLenString();
            object = buffer.readLenString();
            n2 = buffer.readnBytes();
            int n4 = buffer.readnBytes();
            buffer.readByte();
            short s = (short)(buffer.readByte() & 0xFF);
            int n5 = buffer.readByte() & 0xFF;
            if (this.versionMeetsMinimum(3, 23, 0)) {
                ++n5;
            }
            fieldArray[n3] = new Field((String)object2, (String)object, n2, n4, s, n5);
            ++n3;
        }
        buffer = this.readPacket();
        object2 = new Vector();
        object = this.nextRow((int)l);
        n2 = 0;
        if (object != null) {
            ((Vector)object2).addElement(object);
            n2 = 1;
        }
        while (object != null && n2 < n) {
            object = this.nextRow((int)l);
            if (object == null) continue;
            ((Vector)object2).addElement(object);
            ++n2;
        }
        return this.buildResultSetWithRows(fieldArray, (Vector)object2, null);
    }

    private final byte[][] nextRow(int n) throws Exception {
        Buffer buffer = this.reuseAndReadPacket(this._reusablePacket);
        if (buffer.readByte() == -1) {
            int n2 = 2000;
            if (this._protocolVersion > 9) {
                n2 = buffer.readInt();
                String string = buffer.readString();
                String string2 = SQLError.mysqlToXOpen(n2);
                this.clearReceive();
                throw new SQLException(SQLError.get(SQLError.get(string2)) + ": " + string, string2, n2);
            }
            String string = buffer.readString();
            this.clearReceive();
            throw new SQLException(string, SQLError.mysqlToXOpen(n2), n2);
        }
        --buffer._pos;
        int[] nArray = new int[n];
        byte[][] byArrayArray = new byte[n][];
        if (!buffer.isLastDataPacket()) {
            int n3;
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = n3 = buffer._pos;
                buffer._pos = (int)buffer.readLength() + buffer._pos;
                ++n4;
            }
            n3 = 0;
            while (n3 < n) {
                buffer._pos = nArray[n3];
                byArrayArray[n3] = buffer.readLenByteArray();
                ++n3;
            }
            return byArrayArray;
        }
        return null;
    }

    final void quit() throws IOException {
        Buffer buffer = new Buffer(6);
        this._packetSequence = (byte)-1;
        buffer.writeByte((byte)1);
        this.send(buffer);
        this.forceClose();
    }

    protected final void forceClose() throws IOException {
        this._mysqlConnection.close();
    }

    final int getServerMajorVersion() {
        return this._serverMajorVersion;
    }

    final int getServerMinorVersion() {
        return this._serverMinorVersion;
    }

    final int getServerSubMinorVersion() {
        return this._serverSubMinorVersion;
    }

    private final Buffer readPacket() throws IOException {
        byte by = (byte)this._mysqlInput.read();
        byte by2 = (byte)this._mysqlInput.read();
        byte by3 = (byte)this._mysqlInput.read();
        if (by == -1 && by2 == -1 && by3 == -1) {
            this.forceClose();
            throw new IOException("Unexpected end of input stream");
        }
        int n = MysqlIO.ub(by) + 256 * MysqlIO.ub(by2) + 65536 * MysqlIO.ub(by3);
        byte by4 = (byte)this._mysqlInput.read();
        byte[] byArray = new byte[n + 1];
        this.readFully(this._mysqlInput, byArray, 0, n);
        byArray[n] = 0;
        return new Buffer(byArray);
    }

    private final Buffer reuseAndReadPacket(Buffer buffer) throws IOException {
        byte by = (byte)this._mysqlInput.read();
        byte by2 = (byte)this._mysqlInput.read();
        byte by3 = (byte)this._mysqlInput.read();
        if (by == -1 && by2 == -1 && by3 == -1) {
            this.forceClose();
            throw new IOException("Unexpected end of input stream");
        }
        int n = MysqlIO.ub(by) + 256 * MysqlIO.ub(by2) + 65536 * MysqlIO.ub(by3);
        byte by4 = (byte)this._mysqlInput.read();
        buffer._pos = 0;
        buffer._sendLength = 0;
        if (buffer._buf.length <= n) {
            buffer._buf = new byte[n + 1];
        }
        buffer._bufLength = n;
        this.readFully(this._mysqlInput, buffer._buf, 0, n);
        buffer._buf[n] = 0;
        return buffer;
    }

    private final void send(Buffer buffer) throws IOException {
        int n = buffer._pos;
        this._packetSequence = (byte)(this._packetSequence + 1);
        buffer._pos = 0;
        buffer.writeLongInt(n - 4);
        buffer.writeByte(this._packetSequence);
        this._mysqlOutput.write(buffer._buf, 0, n);
        this._mysqlOutput.flush();
        int n2 = 4;
    }

    private final void clearReceive() throws IOException {
        int n = this._mysqlInput.available();
        if (n > 0) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void clearAllReceive() throws SQLException {
        try {
            int n = this._mysqlInput.available();
            if (n > 0) {
                Buffer buffer = this.readPacket();
                if (buffer._buf[0] == -1) {
                    this.clearReceive();
                    return;
                }
                while (!buffer.isLastDataPacket()) {
                    buffer = this.readPacket();
                    if (buffer._buf[0] != -1) continue;
                }
            }
            this.clearReceive();
            return;
        }
        catch (IOException iOException) {
            throw new SQLException("Communication link failure: " + iOException.getClass().getName(), "08S01");
        }
    }

    protected abstract ResultSet buildResultSetWithRows(Field[] var1, Vector var2, Connection var3);

    protected abstract ResultSet buildResultSetWithUpdates(long var1, long var3, Connection var5);

    static int getMaxBuf() {
        return MAXBUF;
    }

    private static final int ub(byte n) {
        return n < 0 ? 256 + n : n;
    }

    private static final long getMatchedRows(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isDigit(c)) {
                if (bl) break;
                bl = true;
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            try {
                return Long.parseLong(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    boolean versionMeetsMinimum(int n, int n2, int n3) {
        if (this.getServerMajorVersion() >= n) {
            if (this.getServerMajorVersion() == n) {
                if (this.getServerMinorVersion() >= n2) {
                    if (this.getServerMinorVersion() == n2) {
                        return this.getServerSubMinorVersion() >= n3;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private final void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public void setProfileSql(boolean bl) {
        this._profileSql = bl;
    }
}

