/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   C.N Medappa <jrex_moz@yahoo.com><>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which  the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

	#ifndef JRexWindow_h_
	#define JRexWindow_h_

	#ifndef JRexIncludes_h_
	#include "JRexIncludes.h"
	#endif//#define JRexIncludes_h_

	#include "JRexWindowCreator.h"

	class JRexWindowCreator;

	class JRexWindow : public nsIWebBrowserChrome,
							public nsIWebBrowserChromeFocus,
							public nsIWebProgressListener,
							public nsIEmbeddingSiteWindow2,
							public nsITooltipListener,
							public nsIContextMenuListener2,
	                       	public nsISHistoryListener,
	                       	public nsIDOMKeyListener,
							public nsIDOMMouseListener,
							public nsIDOMMouseMotionListener,
							public nsIURIContentListener,
							public nsSupportsWeakReference,
							public nsIInterfaceRequestor
		{
			public:
				JRexWindow(nsNativeWidget mainWnd, PRUint32 waitKey);
				virtual ~JRexWindow();
				nsresult GetPIDOMWindow(nsPIDOMWindow **_result);
				nsresult Show(PRInt32 x, PRInt32 y, PRInt32 width,PRInt32 height);
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
				nsresult GotVisual(nsNativeWidget);
#endif
				nsresult SetBounds(PRInt32 x, PRInt32 y, PRInt32 width,PRInt32 height);
				nsresult GetBounds(PRInt32 *, PRInt32 *, PRInt32 *,PRInt32 *);
				nsresult Dispose();
				nsresult ModalDispose();
				nsresult SetVisible(PRBool);
				nsresult IsVisible(PRBool*);
				nsresult SetEnabled(PRBool);
				nsresult IsEnabled(PRBool*);
				nsresult GetBaseTitle(PRUnichar * *aTitle);
				nsresult SetBaseTitle(const PRUnichar * aTitle);
				nsresult Repaint(PRBool);
				nsresult ChangeFocus(PRBool focusGained);

				nsresult CanUndo(PRBool *_retval);
				nsresult CanRedo(PRBool *_retval);
				nsresult CanCut(PRBool *_retval);
				nsresult CanCopy(PRBool *_retval);
				nsresult CanCopyLinkLocation(PRBool *_retval);
				nsresult CanCopyImageLocation(PRBool *_retval);
				nsresult CanCopyImageContents(PRBool *_retval);
				nsresult CanPaste(PRBool *_retval);
				nsresult CanDelete(PRBool *_retval);

				nsresult Undo();
				nsresult Redo();
				nsresult Cut();
				nsresult Copy();
				nsresult CopyLinkLocation();
				nsresult CopyImageLocation();
				nsresult CopyImageContents();
				nsresult Paste();
				nsresult SelectAll();
				nsresult SelectNone();
				nsresult Delete();

				nsresult Print(PRBool prompt,PRBool showProgress);
				nsresult PrintPreview(PRBool shrinkToFit, PRBool isLandScape);
				nsresult PageSetup();
				nsresult CancelPrint();
				nsresult CancelPrintPreview();
				nsresult GetPrintPreviewNumPages(PRInt32 *aPrintPreviewNumPages);
				nsresult PrintPreviewNavigate(PRInt16 aNavType, PRInt32 aPageNum);
				nsresult IsPrinting(PRBool*);
				nsresult IsPrintPreviewing(PRBool*);

				nsresult AddProgressListener();
				nsresult AddContextMenuListener();
				nsresult AddHistoryListener();
				nsresult RemoveProgressListener();
				nsresult RemoveContextMenuListener();
				nsresult RemoveHistoryListener();

				nsresult AddKeyListener();
			    nsresult AddMouseListener();
				nsresult AddMouseMotionListener();
				nsresult RemoveKeyListener();
				nsresult RemoveMouseListener();
				nsresult RemoveMouseMotionListener();
				nsresult AddURIContentListener();
				nsresult RemoveURIContentListener();

				static void AbortWindowCreation(PRUint32 waitKey);
				static PRBool IsWindowAvailable(JRexWindow*);
				static JRexWindow* GetJRexWindow(nsIWebBrowserChrome *chrome);
				static void SayGoodBye();


				enum OpenWindowType{TYPE_PAGE_INFO=0,TYPE_SEC_INFO};

				//navigation function wrappers
				NS_IMETHOD GetCanGoBack(PRBool *aCanGoBack);
				NS_IMETHOD GetCanGoForward(PRBool *aCanGoForward);
				NS_IMETHOD GoBack(void);
				NS_IMETHOD GoForward(void);
				NS_IMETHOD GotoIndex(PRInt32 index);
				NS_IMETHOD LoadURI(const char *uri, PRUint32 loadFlags, const char *referrer, nsIInputStream *postData, nsIInputStream *headers);
				NS_IMETHOD OpenWindow(PRUint16 type, const char *uri, const char *referrer, const char *windowName, const char *feature);
				NS_IMETHOD Reload(PRUint32 reloadFlags);
				NS_IMETHOD Stop(PRUint32 stopFlags);
				NS_IMETHOD GetDocument(nsIDOMDocument * *aDocument);
				NS_IMETHOD GetCurrentURI(nsIURI * *aCurrentURI);
				NS_IMETHOD GetReferringURI(nsIURI * *aReferringURI);
				NS_IMETHOD GetSessionHistory(nsVoidArray* hisArray, PRInt32* maxLength);
				NS_IMETHOD SetSessionHistory(nsISHistory* aSessionHistory);

				struct HistoryEntry{
					char *uri;
					char *title;
					PRBool isSubFrame;
				};

				NS_DECL_ISUPPORTS
				NS_DECL_NSIINTERFACEREQUESTOR
				NS_DECL_NSIWEBBROWSERCHROME
				NS_DECL_NSIWEBBROWSERCHROMEFOCUS
				NS_DECL_NSIWEBPROGRESSLISTENER
				NS_DECL_NSIEMBEDDINGSITEWINDOW
				NS_DECL_NSIEMBEDDINGSITEWINDOW2
				NS_DECL_NSITOOLTIPLISTENER
				NS_DECL_NSICONTEXTMENULISTENER2
				NS_DECL_NSISHISTORYLISTENER
				NS_DECL_NSIURICONTENTLISTENER

				// nsIDOMEventListener
				NS_IMETHOD HandleEvent(nsIDOMEvent* aEvent);
				// nsIDOMKeyListener
				NS_IMETHOD KeyDown(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD KeyUp(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD KeyPress(nsIDOMEvent* aDOMEvent);
				// nsIDOMMouseListener
				NS_IMETHOD MouseDown(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD MouseUp(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD MouseClick(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD MouseDblClick(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD MouseOver(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD MouseOut(nsIDOMEvent* aDOMEvent);
				// nsIDOMMouseMotionListener
				NS_IMETHOD MouseMove(nsIDOMEvent* aDOMEvent);
				NS_IMETHOD DragMove(nsIDOMEvent* aDOMEvent);


				nsresult IsCommandSupported(const char *aCommand, PRBool *retval);
				nsresult IsCommandEnabled(const char *aCommand, PRBool *retval);
				nsresult DoCommand(const char *aCommand, nsICommandParams *aCommandParams);
				nsresult ObserverCommand(const char *aCommandToObserve);
				nsresult UnObserverCommand(const char *aCommandObserved);

			private:
				//key event maks, see Event.java
				enum{SHIFT_MASK	= 1U << 0};
				enum{CTRL_MASK	= 1U << 1};
				enum{META_MASK	= 1U << 2};
				enum{ALT_MASK	= 1U << 3};

				enum KeyMode{	KEY_TYPED=400,KEY_PRESSED,KEY_RELEASED};

				enum MouseMode{	MOUSE_CLICKED=500,MOUSE_PRESSED,MOUSE_RELEASED,
								MOUSE_MOVED_OVER,MOUSE_ENTERED,MOUSE_EXITED,
								MOUSE_DRAGGED,MOUSE_WHEEL};

				static nsresult ExecInEventQ(JRexWindow *window, PRUint16 eventType,
										void* eventData, PRBool isSync, PLHandleEventProc handler,
											PLDestroyEventProc destructor, void** _result);

				//Basic event types
				enum BasicEventTypes{	JREX_CREATE=0U,
										JREX_SHOW,
										JREX_DISPOSE,
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
										JREX_GOT_VISUAL,
										JREX_CREATE_GTK,
#endif

										JREX_GET_BOUNDS,
										JREX_SET_BOUNDS,
										JREX_IS_VISIBLE,
										JREX_SET_VISIBLE,
										JREX_IS_ENABLED,
										JREX_SET_ENABLED,
										JREX_REPAINT,
										JREX_CHANGE_FOCUS,
										JREX_SET_TITLE,
										JREX_GET_TITLE};

				struct JRexBasicEvent : PLEvent{
					JRexWindow *window;
					PRUint16 eventType;
					void* eventData;
				};
				static void* PR_CALLBACK HandleBasicEvent(PLEvent* aEvent);
				static void PR_CALLBACK  DestroyBasicEvent(PLEvent* aEvent);

				//event types for print
				enum PrintEventTypes{PRINT=0U,
								PRINT_PREVIEW,
								DOING_PRINT,
								DOING_PREVIEW,
								CANCEL_PRINT,
								CANCEL_PREVIEW,
								PREVIEW_PAGES,
								NAV_PREVIEW,
								PAGE_SETUP};

				static void* PR_CALLBACK HandlePrintEvent(PLEvent* aEvent);
				static void PR_CALLBACK  DestroyPrintEvent(PLEvent* aEvent);


				//event types for listener
				enum EventListenerTypes{ADD_KEY_LISTENER=0U,
										ADD_MOUSE_LISTENER,
										ADD_MOUSE_MOTION_LISTENER,
										ADD_HISTORY_LISTENER,
										ADD_CTX_MENU_LISTENER,
										REMOVE_KEY_LISTENER,
										REMOVE_MOUSE_LISTENER,
										REMOVE_MOUSE_MOTION_LISTENER,
										REMOVE_HISTORY_LISTENER,
										REMOVE_CTX_MENU_LISTENER};

				static void* PR_CALLBACK HandleListenerEvent(PLEvent* aEvent);
				static void PR_CALLBACK DestroyListenerEvent(PLEvent* aEvent);


				//event types for navigation
				enum NavigationEventTypes{	LOAD=0U,
											CAN_BACK,
											CAN_FORWARD,
											GO_BACK,
											GO_FORWARD,
											GO_TO_INDEX,
											RELOAD,
											STOP,
											GET_CUR_URI,
											GET_REF_URI,
											GET_DOC,
											GET_SESSION,
											SET_SESSION,
											OPEN_WINDOW};

				struct LoadURIEventData{
					char* uri;
					PRUint32 loadFlags;
					char *referrer;
					nsIInputStream *postData;
					nsIInputStream *headers;
				};

				struct OpenWindowEventData{
					PRUint16 type;
					char *uri;
					char *referrer;
					char *windowName;
					char *feature;
				};

				static void* PR_CALLBACK HandleNavigationEvent(PLEvent* aEvent);
				static void PR_CALLBACK  DestroyNavigationEvent(PLEvent* aEvent);


				enum EditEventTypes{	CAN_UNDO=0U,
										CAN_REDO,
										CAN_CUT,
										CAN_COPY,
										CAN_COPY_LINK_LOC,
										CAN_COPY_IMG_LOC,
										CAN_COPY_IMG_CONT,
										CAN_PASTE,CAN_DELETE,
										UNDO,
										REDO,
										CUT,
										COPY,
										COPY_LINK_LOC,
										COPY_IMG_LOC,
										COPY_IMG_CONT,
										PASTE,
										SELECT_ALL,
										SELECT_NONE,
										DELETE_ALL,
										CMD_SUP,
										CMD_ENABLE,
										DO_CMD};

				struct CommandEventData{
					const char* cmd;
					nsICommandParams *cmdParams;
				};

				static void* PR_CALLBACK HandleEditEvent(PLEvent* aEvent);
				static void PR_CALLBACK  DestroyEditEvent(PLEvent* aEvent);

				//uri content event types for listener
				enum URIContentEventTypes{ADD_URI_CONTENT_LISTENER=0U,
										REMOVE_URI_CONTENT_LISTENER};

				static void* PR_CALLBACK HandleURIListenerEvent(PLEvent* aEvent);
				static void PR_CALLBACK DestroyURIListenerEvent(PLEvent* aEvent);

				nsresult Init();
				static nsresult InternalInit();
				static PRBool IsEventQThread();
				nsresult ShowInternal(PRInt32 x, PRInt32 y, PRInt32 width,PRInt32 height);
#if defined(MOZ_WIDGET_GTK) || defined(MOZ_WIDGET_GTK2)
				nsresult GotVisualInternal(nsNativeWidget);
#endif
				nsresult DisposeInternal();
				nsresult SetBoundsInternal(PRInt32 x, PRInt32 y, PRInt32 width,PRInt32 height);
				nsresult ChangeFocusInternal(PRBool focusGained);
				nsresult IsVisibleInternal(PRBool*);
				nsresult PrintInternal(PRBool prompt,PRBool showProgress);
				nsresult PrintPreviewInternal(PRBool shrinkToFit, PRBool isLandScape);
			    nsresult PageSetupInternal();
				nsresult CancelPrintInternal();
				nsresult CancelPrintPreviewInternal();
				nsresult GetPrintPreviewNumPagesInternal(PRInt32 *aPrintPreviewNumPages);
				nsresult PrintPreviewNavigateInternal(PRInt16 aNavType, PRInt32 aPageNum);
				nsresult IsPrintingInternal(PRBool *);
				nsresult IsPrintPreviewingInternal(PRBool *);
				nsresult fireKeyEvent(nsIDOMEvent* aDOMEvent, PRUint16 eventID);
				nsresult fireMouseEvent(nsIDOMEvent* aDOMEvent, PRUint16 eventID, PRUint16 clickCount );

				nsresult AddContextMenuListenerInternal();
				nsresult AddHistoryListenerInternal();
				nsresult AddKeyListenerInternal();
				nsresult AddMouseListenerInternal();
				nsresult AddMouseMotionListenerInternal();
				nsresult AddURIContentListenerInternal();
				nsresult RemoveKeyListenerInternal();
				nsresult RemoveMouseListenerInternal();
				nsresult RemoveMouseMotionListenerInternal();
				nsresult RemoveURIContentListenerInternal();
				nsresult RemoveContextMenuListenerInternal();
				nsresult RemoveHistoryListenerInternal();

				nsresult IsCommandSupportedInternal(const char *aCommand, PRBool *retval);
				nsresult IsCommandEnabledInternal(const char *aCommand, PRBool *retval);
				nsresult DoCommandInternal(const char *aCommand, nsICommandParams *aCommandParams);

				nsresult CanUndoInternal(PRBool *_retval);
				nsresult CanRedoInternal(PRBool *_retval);
				nsresult CanCutInternal(PRBool *_retval);
				nsresult CanCopyInternal(PRBool *_retval);
				nsresult CanCopyLinkLocationInternal(PRBool *_retval);
				nsresult CanCopyImageLocationInternal(PRBool *_retval);
				nsresult CanCopyImageContentsInternal(PRBool *_retval);
				nsresult CanPasteInternal(PRBool *_retval);
				nsresult CanDeleteInternal(PRBool *_retval);
				nsresult UndoInternal();
				nsresult RedoInternal();
				nsresult CutInternal();
				nsresult CopyInternal();
				nsresult CopyLinkLocationInternal();
				nsresult CopyImageLocationInternal();
				nsresult CopyImageContentsInternal();
				nsresult PasteInternal();
				nsresult SelectAllInternal();
				nsresult SelectNoneInternal();
				nsresult DeleteInternal();

				nsresult GetSessionHistoryInternal(nsVoidArray* hisArray, PRInt32* maxLength);
				nsresult OpenWindowInternal(PRUint16 type,const char *aUrl, const char *ref, const char *aName, const char *aFeatures, nsIDOMWindow **_retval);

  			  	static nsVoidArray				*sWindowList;
  			  	static JRexWindowCreator		*sJRexWindowCreator;
				nsNativeWidget					mMainWnd;
				//Use a GRIP of type base nsISupports for WebChrome.
				nsCOMPtr<nsISupports>			mChromeGrip;
				nsCOMPtr<nsIWebBrowser>			mWebBrowser;
				nsCOMPtr<nsIBaseWindow>			mBaseWindow;
				nsCOMPtr<nsIWebNavigation>		mWebNavigation;
				nsCOMPtr<nsIDOMEventReceiver> 	mEventReceiver;
				nsCOMPtr<nsICommandManager> 	mCmdManager;

				PRBool							mBrowCreated;
				PRBool							mIsVisible;
				nsEmbedString					mTitle;

				PRUint32 						mChromeFlag;
				nsresult						mModalStatus;
				PRBool 							mIsModal;
				PRBool 							mModalDispose;

				PRBool 							mProgListenerAdded;
				PRBool 							mContextListenerAdded;
				PRBool 							mHistoryListenerAdded;

				PRBool							mKeyListenerAdded;
				PRBool							mMouseListenerAdded;
				PRBool							mMouseMotionListenerAdded;
				PRBool							mURIContentListenerAdded;
				friend 							JRexWindowCreator;
		};

	#endif//#define JRexWindow_h_
