/**
 * HTLM header toolbar class
 * 
 * Bugs:
 *  - changing in line style sheet (<style> block) will not affect the 
 *    WYSIWYG area until the document is rerendered (eg. save, reopen, etc.).
 *  - in the menu: View  Show/Hide  Customize Toolbar  HTML Header 
 *    toolbar opens the edit menu bar dialog which is not appropriate 
 *    for this tool bar (please let me know if you have a solution to 
 *    disable this automaticly created menu entry).
 *  - style edit: open the node tree and select the stylesheet selected 
 *    on the button bar
 *  - scrollgroupbox handles (darts) point vertical instead of horizontal
 *  - include cascades as iframe in the css dialog. open the appropriate stylesheet
 *    when loaded
 *  
 * Fatures (Todo):
 *  - Options:
 *    - show tag names
 *    - display base
 *    - display comment
 *    - display ...
 *    - display unknown
 *  - context menu on inline style nodes for opening cascades
 *  - no button icon for comment nodes
 *  - integrate advanced edit (make style attr editable only where applicable)
 *  - integrate url picker.
 *  - integrate style edit on <link rel="stylesheet" /> and <style>
 *  - multiline tooltip texts on comment buttons
 *  - drag move items.
 *  - ? add rdf data files for pulldown option values/labels. make these 
 *    editable (rememberable) where applicable (ie. allow updates to 
 *    the rdf file)
 *  - ? some tags/attribute constalations may appear only once inside head 
 *    (like title, or base href=""). check for duplicates before insert 
 *    dialog is opened (depending on tag/attribute constalation) and 
 *    before actually inserting (depending on attributes)
 *  - ? integrate Moz toolbar configuration (add / remove buttons)
 *  - check for compliance with a bunch of other dtd's like, html 1-4, xhtml 1.
 *
 * Branding/Release
 *  - 16x16px icons alla classic theme (CI/CD)
 *  - credits (gimp icons at least!)
 *  - integrate into about dialog.
 *  - xpi
 * 
 * Extension id: {136c295a-4a5a-41cf-bf24-5cee526720d5}
 * NVu developer: daniel@glazman.org
 * http://www.glazman.org/nvu/releases/test/20041213/contribs/
 * 
 */

//var currentTag = null;
var htmlHeader = {
	currentTag: null,
	initialized: false,
	updateInProgress: false,
	toolbar : null,
	toolbarBox: null,
	selectedEditorIndex: 0,
	tabEditor: null,
	tabBox: null,
	
	insertBefore: false,
	insertAfter: false,
	
	init : function() {
		
		// we get triggered more than once, do it only once
		if(this.initialized)
			return true;
		
		// assign references to commonly used objects
		this.tabEditor = document.getElementById("tabeditor");
		this.tabBox = this.tabEditor.mTabbox;
		if (!this.tabEditor || this.initialized)
			return;
		
		this.toolbar = document.getElementById("HtmlHeaderToolbar");
		this.toolbarBox = document.getElementById("htmlHeaderButtonsBox");
		
		// set eventHandlers
		this.tabBox.addEventListener("focus", htmlHeader.evDocumentChange, true);
		this.tabEditor.addEventListener("load", htmlHeader.evDocumentChange, true);
		document.getElementById("content-source").addEventListener("focus", htmlHeader.evDocumentChange, true);
		htmlHeader.selectedEditorIndex = document.getElementById("tabeditor").selectedIndex;

		// initialize the scroll box
		var arrowscrollBox = getById("htmlHeaderButtonsBox");
		this.initialized = true;
		//arrowscrollBox.childNodes.item(0).setAttribute("class", "autorepeatbutton-left");
		
	},
	
	evDocumentChange : function(ev) {
		//htmlMetaConsole.consoleOut(ev.currentTarget.id + "|" + ev.target.id +": " + ev.type);

		// 2 things to do: 
		//   1. if the target is source-editor, disable toolbar
		//   2. else update buttons deleayed and enable toolbar
		
		if (ev.currentTarget.id == "content-source" && ev.type == "focus") {
			document.getElementById("HtmlHeaderToolbox").setAttribute("collapsed", true);
		} else if (!htmlHeader.updateInProgress) {
			//htmlMetaConsole.consoleOut("Delayed update");
			htmlHeader.updateInProgress = true;
			document.getElementById("HtmlHeaderToolbox").setAttribute("collapsed", false);
			setTimeout('htmlHeader.updateToolbar()', 350);
		}
			
		return true;
	},
	
	getHeadChildren : function() {
		// find header tag
		var header   = this.document().getElementsByTagName("HEAD").item(0);
		return header.childNodes; // ok i am lazy
	},
	
	document : function() {
		return GetCurrentEditor().document;
	}, 

	updateToolbar : function() {
		htmlHeader.updateInProgress = false;

//		htmlMetaConsole.consoleOut("== updating");
		this.clearButtons();
		
		// find header tag
		var tagName = '';
		var header   = this.header();
		var children = header.childNodes; // ok i am lazy
//		htmlMetaConsole.consoleOut("number of tags in HEAD: " + children.length);
		for(var i=0; i<children.length; i++) {
			e=children.item(i);
			if (e.nodeType == TEXT_NODE ) // skip whitespace, nodeType == 3
				continue; 
			
			if (e.nodeType == COMMENT_NODE)
				tagName = "comment";
			else if (e.tagName)
				tagName = e.tagName.toLowerCase();
			else tagName = '';
			
			// if this node is not a comment or one of the 
			// implemented tags, skip it
			//
			// FIXME: use if (tagName in SUPPORTED_TAGS) 
			if (tagName != 'comment' && tagName != 'link' && tagName != 'meta' && 
			    tagName != 'script' && tagName != 'style' && tagName != 'title' && 
			    tagName != 'base') {
				this.addAnonymousButton(e);
				continue;
			}
			
			this.addButton(e);
		}
		
		// all butons added by now. collaps the add button if we have at least 
		// one header button:
		var addHeader          = getById("addHeader");
		var addHeaderSeperator = getById("addHeaderSeperator");
		var collapsed          = false;
		
		if (this.toolbarBox.childNodes.length)
			collapsed = true;
		
		addHeader.setAttribute("collapsed", collapsed);
		addHeaderSeperator.setAttribute("collapsed", collapsed);
		
	},
	
	header : function () {
		return this.document().getElementsByTagName("HEAD").item(0);
	},
	
	removeTag: function() {
		htmlHeader.currentTag.parentNode.removeChild(htmlHeader.currentTag);
		this.updateToolbar();
	},
	
	addAnonymousButton: function(headerTag) {
		var tagName = "";
		if(headerTag.tagName)
			tagName = headerTag.tagName.toLowerCase();

		var newBtn = document.createElement("toolbarbutton");
		var img = document.createElement("image");
		newBtn.appendChild(img);
		
		img.setAttribute("src", "chrome://htmlheader/content/images/icons/junk-16.png");
		newBtn.setAttribute("id", tagName);
		
		// skip label if empty
		if (tagName != '') {
			var lbl = document.createElement("label");
			newBtn.appendChild(lbl);
			lbl.setAttribute("value", tagName);
		}
		
		// attach context menu
		newBtn.setAttribute("context", "cxtHeaderMenu");

		this.toolbarBox.appendChild(newBtn);
		
		return true;
	},
	
	addButton : function(headerTag) {

		// figure the image name
		var tagName = '';
		var imgName = "default";
		if(headerTag.tagName)
			tagName = headerTag.tagName.toLowerCase();
		if (headerTag.nodeType == COMMENT_NODE)
			imgName = "comment";
		// FIXME: use if (tagName in SUPPORTED_TAGS) if this works in js; RTFM
		else if (tagName == 'link' || tagName == 'meta' || tagName == 'script' || 
		         tagName == 'style' || tagName == 'title' || tagName == 'base')
			imgName = tagName;

		var newBtn = document.createElement("toolbarbutton");

		var img = document.createElement("image");
		img.setAttribute("src", "chrome://htmlheader/content/images/icons/"+imgName+"-16.png");
		newBtn.appendChild(img);
		
		newBtn.setAttribute("id", headerTag.id);
		
		// Add a label to every button except comments
		var lblValue = "";
		// no label for comment nodes
		if (headerTag.nodeType != COMMENT_NODE)
			lblValue = headerTag.tagName.toUpperCase();
		else
			lblValue = "<!--";
		
		// don't add the label if it's empty
		if (lblValue != '') {
			var lbl = document.createElement("label");
			lbl.setAttribute("value", lblValue);
			newBtn.appendChild(lbl);
		}

		newBtn.label = headerTag.tagName;
		newBtn.associatedElement = headerTag;
		
		// if the tag has a title, use it as tooltiptext
		var t = "";
		if (headerTag.nodeType == COMMENT_NODE)
			t = "HTML Comment";
		if (headerTag.getAttribute && typeof headerTag.getAttribute == "function") {
			t = headerTag.getAttribute("title");
		}
		if (t) newBtn.setAttribute("tooltiptext", t);

		// attach button to the toolbar
		this.toolbarBox.appendChild(newBtn);

		// attach context menu
		newBtn.setAttribute("context", "cxtHeaderMenu");

		// attach events and data
		newBtn.addEventListener("command", htmlHeader.editTag, true);
		newBtn.addEventListener("contextmenu", htmlHeader.updateToolbarCxtMenu, true);
		
		newBtn.assiciatedElement = headerTag;

		return true;
	},

	clearButtons : function() {
		// alert("htmlHeader.clearButtons() : not yet implemented!");
		//alert(this.toolbarBox.childNodes.length);
		while( (e=this.toolbarBox.firstChild) ) {
			this.toolbarBox.removeChild(e);
		}
		return true;
	},
	
	editTag : function(e) {
	
		if (e.target)
			htmlHeader.currentTag = e.target.associatedElement;
		
//		var options = 'all,dialog=yes';
		var arg1 = htmlHeader.currentTag.cloneNode(true);

		htmlHeader.editTagDialog(arg1);
	},
	
	editTagDialog: function(el) {
		var url = "chrome://htmlheader/content/editTag-";
		var options = 'all,dialog=yes,modal=yes';
		var tag = "";
		if (htmlHeader.currentTag.nodeType != COMMENT_NODE)
			tag = htmlHeader.currentTag.tagName.toLowerCase();
		else
			tag = "comment";
			
		url += tag+".xul";
		window.openDialog(url, '_blank', options, el);
	},
	
	updateToolbarCxtMenu: function(e) {
		htmlHeader.currentTag = e.target.associatedElement;

		// tag name (lower case)
		var tag = '';
		if (htmlHeader.currentTag.nodeType != COMMENT_NODE)
			tag = htmlHeader.currentTag.tagName.toLowerCase();
		
		// if the tag name is style, display the style edit button, else
		// make sure its hidden
		var cssEditCollapsedState = true;
		if(tag == "style") 
			cssEditCollapsedState = false;

		getById("btnCxtCascades").setAttribute("collapsed", cssEditCollapsedState);
	
		return true;
	},
	
	createEmptyNode: function(el, insertAt) {
		if (el.label == "Comment")
			var tag = document.createComment("");
		else
			var tag = document.createElement(el.label.toLowerCase());

		tag.createNew = true;
		if (!insertAt)
			tag.insertAt = "";
		else
			tag.insertAt = insertAt;
		
		return tag;
	},
	
	addTag : function(el) {
		var tag = this.createEmptyNode(el, "");
		
		htmlHeader.currentTag = tag;
		htmlHeader.editTagDialog(tag);
	},
	
	addTagBefore: function(el) {
		var tag = this.createEmptyNode(el, "before");
		htmlHeader.insertBefore = htmlHeader.currentTag;
		
		htmlHeader.currentTag = tag;
		htmlHeader.editTagDialog(tag);
	},
	
	addTagAfter: function(el) {
		var tag = this.createEmptyNode(el, "after");
		htmlHeader.insertAfter = htmlHeader.currentTag;
		
		htmlHeader.currentTag = tag;
		htmlHeader.editTagDialog(tag);
	},
	
	insertTag : function(attr, tagBody) {
		
		var head = this.header();
		//htmlMetaConsole.dumpObject(currentTag);
		if (htmlHeader.currentTag.nodeType == COMMENT_NODE) {
			var newTag = document.createComment(htmlHeader.tagBody);
			if (tagBody) 
				newTag.nodeValue = tagBody;
		} else {
			var newTag = document.createElement(htmlHeader.currentTag.tagName.toLowerCase());
			
			for (e in attr) {
//				p(e);
				newTag.setAttribute(e, attr[e]);
			}
			
			if (tagBody) 
				newTag.appendChild(document.createTextNode(tagBody));
		}

		// check where we gonna insert the tag
		if (htmlHeader.insertBefore) {
			head.insertBefore(newTag, htmlHeader.insertBefore);
			htmlHeader.insertBefore = null;
		} else if (htmlHeader.insertAfter && htmlHeader.insertAfter.nextSibling) {
			head.insertBefore(newTag, htmlHeader.insertAfter.nextSibling);
			htmlHeader.insertAfter  = null;
		} else {
			head.appendChild(newTag);
		}
		
		// mark document as edited.
		var ed = GetCurrentEditor();
		ed.incrementModificationCount(1);
		
		// check if the tab title has changed
		if(htmlHeader.currentTag.tagName && 
		   htmlHeader.currentTag.tagName.toLowerCase() == "title") {
			ed.setDocumentTitle(tagBody);
		}
		
		// last but not least, update the toolbar
		this.updateToolbar();
		return true;
	},
	
	replaceTag : function(attr, tagBody) {
		var head = this.header();
		//htmlMetaConsole.dumpObject(currentTag);
		if (htmlHeader.currentTag.nodeType == COMMENT_NODE) {
			var newTag = document.createComment(htmlHeader.tagBody);
			if (tagBody) 
				newTag.nodeValue = tagBody;
		} else {
			var newTag = document.createElement(htmlHeader.currentTag.tagName.toLowerCase());
			
			for (e in attr) {
				newTag.setAttribute(e, attr[e]);
			}
			
			if (tagBody) 
				newTag.appendChild(document.createTextNode(tagBody));
		}

		head.replaceChild(newTag, htmlHeader.currentTag);
		var ed = GetCurrentEditor();
		ed.incrementModificationCount(1);
		
		// check if the tab title has changed
		if(htmlHeader.currentTag.tagName && 
		   htmlHeader.currentTag.tagName.toLowerCase() == "title") {
			ed.setDocumentTitle(tagBody);
		}
		
		// last but not least, update the toolbar
		this.updateToolbar();
		return true;
	}
	
};

//window.addEventListener("load", htmlHeader.init(), false);


var htmlMetaConsole = {
	inspectDocument : function(doc) {
		window.openDialog('chrome://inspector/content/', 
		                  '_blank', 'all,dialog=no', doc);
	},
	
	dumpObject : function(o) {
		var out = "== BEGIN OBJECT ==\n";
		for (e in o) {
			out += e;
			try {
				if (typeof(o[e]) == "function")
					out += "()";
				else
					out += ": " + o[e];
			} catch(err) {
				out += ": Error: " + err;
			}
			out += '\n';
		}
		this.consoleOut(out + "== END OBJECT ==\n\n");
	},
	
	consoleOut : function(txt) {
		document.getElementById("htmlHeaderConsole").value += txt + "\n";
	},
	
	show : function() {
		var sidebar = document.getElementById("sidebar-box").collapsed;
		document.getElementById("sidebar-box").collapsed = (!sidebar) ? true : false;
	}

};

function p(txt) { htmlMetaConsole.consoleOut(txt); }
function d(obj) { htmlMetaConsole.dumpObject(obj); }

/*var metaHeader = {
	editor     : document.getElementById("content-source"),
	document   : null,
	toolbar    : null,
	
	init: function() {
		this.document = document.getElementById("content-source").contentDocument;
		this.toolbar  = document.getElementById("HtmlHeaderToolbar");

		// clear it
		this.clearButtons();
		
		// find the HEAD tag of our document
		var html   = this.document.childNodes.item(0);
		var header = this.document.getElementsByTagName("HEAD").item(0);
		htmlMetaConsole.consoleOut(this.document.
			getElementsByTagName("BODY").item(0).id);
		if (!header) // no HEAD tag, bail.
			return false;
		
		// prototype button
		var btn = this.newButton();
		
		// loop over header entries and insert them into the button bar
		var i = 0; 
		var e = null;
		while (e = header.childNodes.item(i++) ) {
			var newBtn = btn.cloneNode(true);
			newBtn.setAttribute("id", "headerBtn"+i);
			newBtn.childNodes.item(0).setAttribute("value", i + 
				" " +e.childNodes.item(0).value);
			this.toolbar.appendChild(newBtn);
		}
		
	},
	
	newButton : function() {
		// prototype button
		var btn = document.createElement("toolbarbutton");
		var lbl = document.createElement("label");
		btn.appendChild(lbl);
		return btn;
	},
	
	editTag: function(target) {
		alert(target.id);
	}
}; */

