#include "nsXPCOM.h"
#include "nsIGenericFactory.h"
#include "nsCOMPtr.h"
#include "nsIVariant.h"
#include "nsIComponentManager.h"
#include "nsIServiceManager.h"
#include "nsICategoryManager.h"
#include "nsComponentManagerUtils.h"
#include "nsServiceManagerUtils.h"
#include "nsIClassInfoImpl.h"
#include "nsMemory.h"
#include "nsIScriptNameSpaceManager.h"

#include "HRTimer.h"
#include "HRProfiler.h"
#include "HRCov.h"
#include "HRBitset.h"

NS_GENERIC_FACTORY_CONSTRUCTOR(HRTimerFactory)
NS_GENERIC_FACTORY_CONSTRUCTOR(HRBitset)
NS_DECL_CLASSINFO(HRTimerFactory)
NS_DECL_CLASSINFO(HRProfiler)
NS_DECL_CLASSINFO(HRCov)
NS_DECL_CLASSINFO(HRBitset)

static NS_METHOD HRTimerFactoryServiceRegistration(
  nsIComponentManager* aCompMgr,
  nsIFile* aPath,
  const char* registryLocation,
  const char* componentType,
  const nsModuleComponentInfo* info)
{
  nsCOMPtr<nsICategoryManager> cat =
    do_GetService(NS_CATEGORYMANAGER_CONTRACTID);
  NS_ENSURE_STATE(cat);

  nsCString previous;
  nsresult rv = cat->AddCategoryEntry(
    JAVASCRIPT_GLOBAL_PROPERTY_CATEGORY,
    "hrtimer", HRTIMERFACTORY_CONTRACTID,
    PR_TRUE, PR_TRUE, getter_Copies(previous));

  return rv;
}

static const nsModuleComponentInfo components[] =
{
  {
    HRTIMERFACTORY_CLASSNAME,
    HRTIMERFACTORY_CID,
    HRTIMERFACTORY_CONTRACTID,
    HRTimerFactoryConstructor,
    HRTimerFactoryServiceRegistration,
    NULL,
    NULL,
    NS_CI_INTERFACE_GETTER_NAME(HRTimerFactory),
    NULL,
    &NS_CLASSINFO_NAME(HRTimerFactory),
    nsIClassInfo::DOM_OBJECT | nsIClassInfo::SINGLETON
  },

  {
    HRPROFILER_CLASSNAME,
    HRPROFILER_CID,
    HRPROFILER_CONTRACTID,
    HRProfilerSingletonConstructor,
    NULL,
    NULL,
    NULL,
    NS_CI_INTERFACE_GETTER_NAME(HRProfiler),
    NULL,
    &NS_CLASSINFO_NAME(HRProfiler),
    nsIClassInfo::SINGLETON
  },

  {
    HRCOV_CLASSNAME,
    HRCOV_CID,
    HRCOV_CONTRACTID,
    HRCovSingletonConstructor,
    NULL,
    NULL,
    NULL,
    NS_CI_INTERFACE_GETTER_NAME(HRCov),
    NULL,
    &NS_CLASSINFO_NAME(HRCov),
    nsIClassInfo::SINGLETON
  },

  {
    HRBITSET_CLASSNAME,
    HRBITSET_CID,
    HRBITSET_CONTRACTID,
    HRBitsetConstructor,
    NULL,
    NULL,
    NULL,
    NS_CI_INTERFACE_GETTER_NAME(HRBitset),
    NULL,
    &NS_CLASSINFO_NAME(HRBitset),
    0
  }
};

NS_IMPL_NSGETMODULE(ffhrtimer, components)

