#ifndef COMMON_H
#define COMMON_H

#include "nsIClassInfoImpl.h"
#include "nsIProgrammingLanguage.h"
#include "nsCRT.h"
#include "nsTHashtable.h"
#include "nsHashKeys.h"
#include "nsStringAPI.h"
#include "jsapi.h"

typedef nsTHashtable<nsVoidPtrHashKey> ptr_set;

nsCString hr_object_class_name(JSContext* context, JSObject* obj);

#ifdef __GNUC__
#define likely(X)    __builtin_expect((X),1)
#define unlikely(X)  __builtin_expect((X),0)
#else
#define likely(X)    !!(X)
#define unlikely(X)  !!(X)
#endif

static inline char* nsstrdup(const char* x) {
  return (char*)nsMemory::Clone(x, strlen(x) + 1);
}

// implement IClassInfo, assuming NS_IMPL_ISUPPORTSN_CI was used.
// desc must be a string literal
//
#define IMPL_CI(clsname, desc, flags)                                   \
  NS_IMETHODIMP clsname::GetInterfaces(                                 \
    PRUint32 *count, nsIID * **array)                                   \
  { return clsname##_GetInterfacesHelper(count, array);}                \
                                                                        \
  NS_IMETHODIMP clsname::GetHelperForLanguage(                          \
    PRUint32 language, nsISupports **_retval)                           \
  {                                                                     \
    if(!_retval) {                                                      \
      return NS_ERROR_NULL_POINTER;                                     \
    }                                                                   \
                                                                        \
    *_retval = NULL;                                                    \
    return NS_OK;                                                       \
  }                                                                     \
                                                                        \
  NS_IMETHODIMP clsname::GetContractID(char * *aContractID)             \
  {                                                                     \
    if(!aContractID) {                                                  \
      return NS_ERROR_NULL_POINTER;                                     \
    }                                                                   \
                                                                        \
    *aContractID = NULL;                                                \
    return NS_OK;                                                       \
  }                                                                     \
                                                                        \
  NS_IMETHODIMP clsname::GetClassDescription(                           \
    char **aClassDescription)                                           \
  {                                                                     \
    if(!aClassDescription) {                                            \
      return NS_ERROR_NULL_POINTER;                                     \
    }                                                                   \
                                                                        \
    *aClassDescription = (char*)nsMemory::Clone(                        \
      desc, sizeof(desc));                                              \
    return *aClassDescription ? NS_OK : NS_ERROR_OUT_OF_MEMORY;         \
  }                                                                     \
                                                                        \
  NS_IMETHODIMP clsname::GetClassID(nsCID * *aClassID)                  \
  {                                                                     \
    if(!aClassID) {                                                     \
      return NS_ERROR_NULL_POINTER;                                     \
    }                                                                   \
                                                                        \
    *aClassID = NULL;                                                   \
    return NS_OK;                                                       \
  }                                                                     \
                                                                        \
  NS_IMETHODIMP clsname::GetImplementationLanguage(                     \
    PRUint32 *aImplementationLanguage)                                  \
  {                                                                     \
    if(!aImplementationLanguage) {                                      \
      return NS_ERROR_NULL_POINTER;                                     \
    }                                                                   \
                                                                        \
    *aImplementationLanguage = nsIProgrammingLanguage::CPLUSPLUS;       \
    return NS_OK;                                                       \
  }                                                                     \
                                                                        \
  NS_IMETHODIMP clsname::GetFlags(PRUint32 *aFlags)                     \
  {                                                                     \
    if(!aFlags) {                                                       \
      return NS_ERROR_NULL_POINTER;                                     \
    }                                                                   \
                                                                        \
    *aFlags = flags;                                                    \
    return NS_OK;                                                       \
  }                                                                     \
                                                                        \
  NS_IMETHODIMP clsname::GetClassIDNoAlloc(nsCID *aClassIDNoAlloc)      \
  {                                                                     \
    return NS_ERROR_NOT_AVAILABLE;                                      \
  }



#endif
