var Cc = Components.classes;
var Ci = Components.interfaces;
var gHrp = Cc["@merrillpress.com/hrprofiler;1"]
  .getService();
var gTimerFactory = Cc["@merrillpress.com/hrtimerfactory;1"].getService();
var gArguments = window.arguments[0];
var gRet = window.arguments[1];
gRet.doprofile = false;

function initialize() {
  var tm = document.getElementById('timer-methods-menulist');
  var timers = gTimerFactory.getAvailableTimers({});
  for(var i = 0; i < timers.length; ++i) {
    tm.appendItem(timers[i]);
  }

  function dotry(name) {
    if(tm.selectedIndex == -1) {
      var idx = timers.indexOf(name);
      if(idx != -1) {
        tm.selectedIndex = idx;
      }
    }
  }

  dotry('CLOCK_THREAD_CPUTIME_ID');
  dotry('getrusage()-User Time');

  if(tm.selectedIndex == -1) {
    tm.selectedIndex = 0;
  }

  function getf(propname, id) {
    document.getElementById(id).checked = !!gHrp[propname];
  }
  
  getf('searchChromeWindow', 'flag-search-chrome-window');
  getf('searchWindow', 'flag-search-window');
  getf('searchOther', 'flag-search-other');
  getf('searchOnlyPrototypes', 'flag-search-prototypes-only');
  getf('preferGivenNames', 'flag-prefer-given-names');
  getf('useFileLineCache', 'flag-use-file-line-cache');
  getf('mainThreadOnly', 'flag-main-thread-only');

  document.getElementById('maxdepth').valueNumber = gHrp.maxDepth;
}

function accept() {
  var si = document.getElementById('timer-methods-menulist').selectedItem;
  gRet.timerName = si.label;
  gRet.timer = gTimerFactory.makeTimer(si.label);

  function setf(propname, id) {
    gHrp[propname] = document.getElementById(id).checked;
  }
  
  setf('searchChromeWindow', 'flag-search-chrome-window');
  setf('searchWindow', 'flag-search-window');
  setf('searchOther', 'flag-search-other');
  setf('searchOnlyPrototypes', 'flag-search-prototypes-only');
  setf('preferGivenNames', 'flag-prefer-given-names');
  setf('useFileLineCache', 'flag-use-file-line-cache');
  setf('mainThreadOnly', 'flag-main-thread-only');

  gHrp.maxDepth = document.getElementById('maxdepth').valueNumber;
  
  gRet.doprofile = true;
  return true;
}
