/*
 * License: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Gesso, an extension for Mozilla Firefox
 *
 * The Initial Developer of the Original Code is Ningjie (Jim) Chen.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the License, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the License, the GPL or the LGPL.
 *
 * See MPL.txt for terms of the Mozilla Public License Version 1.1
 * See GPL.txt for terms of the GNU General Public License Version 2.0
 * See LGPL.txt for terms of the GNU Lesser General Public License Version 2.1
 */

#pragma once


DEFINE_NSPTR(iGesso);
DEFINE_NSPTR(iGessoDocument);

class CGesso : public iGesso {
	NS_DECL_ISUPPORTS;
	NS_DECL_IGESSO;

protected:
	static CGesso *m_pGesso;

	ITfThreadMgrPtr m_pTsfMgr;
	TfClientId m_dwTsfID;

	void getText(IAccessible *pAcc, IAccessible **ppOut);

public:
	static CGesso *GetInstance();
	static ITfThreadMgr *GetThreadMgr() {return m_pGesso->m_pTsfMgr;}
};


class CGessoTextStore : public CComObjectRoot, public ITextStoreACP, public iGessoDocumentSink {

	BEGIN_COM_MAP(CGessoTextStore)
		COM_INTERFACE_ENTRY(ITextStoreACP)
	END_COM_MAP();
	DECLARE_PROTECT_FINAL_CONSTRUCT();

protected:
	static const MAX_QUEUED_LOCKS = 4;
	volatile DWORD m_dwLock;
	DWORD m_dwQueuedLocks[MAX_QUEUED_LOCKS];
	ULONG m_ulQueuedLocksCount;

	ITextStoreACPSinkPtr m_pSink;
	DWORD m_dwSinkMask;

public:
	ITfDocumentMgrPtr m_pDocMgr;
	iGessoDocumentPtr m_pDoc;
	TfEditCookie m_dwDefCookie;

	NS_DECL_IGESSODOCUMENTSINK;

	NS_IMPL_QUERY_INTERFACE1(CGessoTextStore, iGessoDocumentSink);
	NS_IMETHODIMP_(nsrefcnt) iGessoDocumentSink::AddRef(void) {return static_cast<IUnknown*>(this)->AddRef();}
	NS_IMETHODIMP_(nsrefcnt) iGessoDocumentSink::Release(void) {return static_cast<IUnknown*>(this)->Release();}

	HRESULT FinalConstruct( );
    STDMETHODIMP AdviseSink(REFIID riid, IUnknown *punk, DWORD dwMask);
    STDMETHODIMP UnadviseSink(IUnknown *punk);
    STDMETHODIMP RequestLock(DWORD dwLockFlags, HRESULT *phrSession);
    STDMETHODIMP GetStatus(TS_STATUS *pdcs);
    STDMETHODIMP QueryInsert(LONG acpTestStart, LONG acpTestEnd, ULONG cch, LONG *pacpResultStart, LONG *pacpResultEnd);
    STDMETHODIMP GetSelection(ULONG ulIndex, ULONG ulCount, TS_SELECTION_ACP *pSelection, ULONG *pcFetched);
    STDMETHODIMP SetSelection(ULONG ulCount, const TS_SELECTION_ACP *pSelection);
    STDMETHODIMP GetText(LONG acpStart, LONG acpEnd, WCHAR *pchPlain, ULONG cchPlainReq, ULONG *pcchPlainOut, TS_RUNINFO *prgRunInfo, ULONG ulRunInfoReq, ULONG *pulRunInfoOut, LONG *pacpNext);
    STDMETHODIMP SetText(DWORD dwFlags, LONG acpStart, LONG acpEnd, const WCHAR *pchText, ULONG cch, TS_TEXTCHANGE *pChange);
    STDMETHODIMP GetFormattedText(LONG acpStart, LONG acpEnd, IDataObject **ppDataObject);
    STDMETHODIMP GetEmbedded(LONG acpPos, REFGUID rguidService, REFIID riid, IUnknown **ppunk);
    STDMETHODIMP QueryInsertEmbedded(const GUID *pguidService, const FORMATETC *pFormatEtc, BOOL *pfInsertable);
    STDMETHODIMP InsertEmbedded(DWORD dwFlags, LONG acpStart, LONG acpEnd, IDataObject *pDataObject, TS_TEXTCHANGE *pChange);
    STDMETHODIMP RequestSupportedAttrs(DWORD dwFlags, ULONG cFilterAttrs, const TS_ATTRID *paFilterAttrs);
    STDMETHODIMP RequestAttrsAtPosition(LONG acpPos, ULONG cFilterAttrs, const TS_ATTRID *paFilterAttrs, DWORD dwFlags);
    STDMETHODIMP RequestAttrsTransitioningAtPosition(LONG acpPos, ULONG cFilterAttrs, const TS_ATTRID *paFilterAttrs, DWORD dwFlags);
    STDMETHODIMP FindNextAttrTransition(LONG acpStart, LONG acpHalt, ULONG cFilterAttrs, const TS_ATTRID *paFilterAttrs, DWORD dwFlags, LONG *pacpNext, BOOL *pfFound, LONG *plFoundOffset);
    STDMETHODIMP RetrieveRequestedAttrs(ULONG ulCount, TS_ATTRVAL *paAttrVals, ULONG *pcFetched);
    STDMETHODIMP GetEndACP(LONG *pacp);
    STDMETHODIMP GetActiveView(TsViewCookie *pvcView);
    STDMETHODIMP GetACPFromPoint(TsViewCookie vcView, const POINT *pt, DWORD dwFlags, LONG *pacp);
    STDMETHODIMP GetTextExt(TsViewCookie vcView, LONG acpStart, LONG acpEnd, RECT *prc, BOOL *pfClipped);
    STDMETHODIMP GetScreenExt(TsViewCookie vcView, RECT *prc);
    STDMETHODIMP GetWnd(TsViewCookie vcView, HWND *phwnd);
    STDMETHODIMP InsertTextAtSelection(DWORD dwFlags, const WCHAR *pchText, ULONG cch, LONG *pacpStart, LONG *pacpEnd, TS_TEXTCHANGE *pChange);
    STDMETHODIMP InsertEmbeddedAtSelection(DWORD dwFlags, IDataObject *pDataObject, LONG *pacpStart, LONG *pacpEnd, TS_TEXTCHANGE *pChange);
};
typedef CComPtr<CComObject<CGessoTextStore> > CGessoTextStorePtr;


