;
; Installer script
;
;
; $Id: installer.functions.nsh,v 1.2 2003/05/17 07:14:58 seb Exp $
;
; Functions
;


;
;
; Version: MPL 1.1/GPL 2.0/LGPL 2.1
;
; The contents of this file are subject to the Mozilla Public License Version 
; 1.1 (the "License"); you may not use this file except in compliance with 
; the License. You may obtain a copy of the License at 
; http://www.mozilla.org/MPL/
;
; Software distributed under the License is distributed on an "AS IS" basis,
; WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
; for the specific language governing rights and limitations under the
; License.
;
; The Original Code is the functions for the Windows installer for Phoenix
; using NSIS2.
;
; The Initial Developer of the Original Code is
; Sbastien Delahaye <seb@delahaye.net>.
; Portions created by the Initial Developer are Copyright (C) 2002
; the Initial Developer. All Rights Reserved.
;
; 
; Alternatively, the contents of this file may be used under the terms of
; either of the GNU General Public License Version 2 or later (the "GPL"),
; or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
; in which case the provisions of the GPL or the LGPL are applicable instead
; of those above. If you wish to allow use of your version of this file only
; under the terms of either the GPL or the LGPL, and not to allow others to
; use your version of this file under the terms of the MPL, indicate your
; decision by deleting the provisions above and replace them with the notice
; and other provisions required by the GPL or the LGPL. If you do not delete
; the provisions above, a recipient may use your version of this file under
; the terms of any one of the MPL, the GPL or the LGPL.
;

;
; What we do when the installer is launched:
; - exit if there is no name
; - check the date of previous install (if there is one)
; - uncheck non-existent shortcuts (if program already installed)
;

Function .onInit
  StrCmp "${MUI_PRODUCT}" "" abort continue

  abort:
    Quit

  continue:
!ifndef WEB
    ReadRegStr $R0 HKLM "SOFTWARE\${BRAND}\${NAME}" Date
    StrCmp $R0 "" install

    IntCmp ${DATE} $R0 equal older checkShortcuts
      equal:
        !insertmacro MBOX_INSTALL INFORMATION $(DESC_onInitEqual)
      older:
        !insertmacro MBOX_INSTALL EXCLAMATION $(DESC_onInitOlder)
!else
    Goto checkShortcuts
!endif

    checkShortcuts:
      Push $0
      !define SECTION_OFF 0xFFFFFFFE
      Goto checkDesktopShortcut

      checkDesktopShortcut:
        IfFileExists "$DESKTOP\${DESC_DesktopShortcut}.lnk" checkProgramShortcuts
          SectionGetFlags ${SecAddDesktopShortcut} $0
      	  IntOp $0 $0 & ${SECTION_OFF}
          SectionSetFlags ${SecAddDesktopShortcut} $0
          Goto checkProgramShortcuts

      checkProgramShortcuts:
        IfFileExists "$SMPROGRAMS\${DESC_StartDir}" checkQuicklaunchShortcut
          SectionGetFlags ${SecAddStartShortcuts} $0
          IntOp $0 $0 & ${SECTION_OFF}
          SectionSetFlags ${SecAddStartShortcuts} $0
          Goto checkQuicklaunchShortcut

      checkQuicklaunchShortcut:
        IfFileExists "$QUICKLAUNCH\${DESC_Quicklaunch}.lnk" endCheckShortcuts
          SectionGetFlags ${SecAddQuicklaunchShortcut} $0
          IntOp $0 $0 & ${SECTION_OFF}
          SectionSetFlags ${SecAddQuicklaunchShortcut} $0
          Goto endCheckShortcuts

      endCheckShortcuts:
        Pop $0
        Goto install

  install:
FunctionEnd


;
; On uninstaller launch, exit if there is no name.
;

Function un.onInit
  StrCmp "${MUI_PRODUCT}" "" abort continue
  abort:
    Quit
  continue:
FunctionEnd

; eof
