/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;

namespace LocaleInpector
{

internal sealed class ConfigTest: Config2
{

/*
locale-inspectr
	G:\Projetos\l10n\moz\mozilla-1.8\en-US\mozilla\browser\locales\en-US
	G:\Projetos\l10n\moz\mozilla-1.8\pt-BR\l10n\pt-BR\browser
	/out:MT.txt
    /directories+
    /files+
    /bom+
    /keys+??????
    /keybinding+
    /markup+
    /c-format+
    /entities+
    /placeholders+
    /accesskey+      /accesskey.maxposition:25
    /escapes+       /escapes.mt+
    /untranslated-

    /warn+

*/

public override bool InitIni()
{
    //this.SetIniDefault("files", "del.extra", "");
    this.SetIniDefault("hidden",   "warnings", "true");
    this.SetIniDefault("cmd-line", "accesskey.maxposition", "");
    this.SetIniDefault("cmd-line", "out", "");
    this.SetIniDefault("cmd-line", "escapes.unicode", "false");
    this.SetIniDefault("cmd-line", "escapes.mt", "true");

    // enable
    //this.SetIniDefault("general", "tests", "true");
    this.SetIniDefault("cmd-line", "directories", "true");
    this.SetIniDefault("cmd-line", "files", "true");
    this.SetIniDefault("cmd-line", "bom", "true");
    this.SetIniDefault("cmd-line", "keys", "true");
    this.SetIniDefault("cmd-line", "keybinding", "true");
    this.SetIniDefault("cmd-line", "markup", "true");
    this.SetIniDefault("cmd-line", "c-format", "true");
    this.SetIniDefault("cmd-line", "entities", "true");
    this.SetIniDefault("cmd-line", "placeholders", "true");
    this.SetIniDefault("cmd-line", "accesskey", "true");
    this.SetIniDefault("cmd-line", "escapes", "true");
    this.SetIniDefault("cmd-line", "untranslated", "false");


    string[] arguments = Environment.GetCommandLineArgs();
    if (arguments.Length < 3) {
        return false;
    }

    this.SetIniDefault("dir3", "original", arguments[1]);
    this.SetIniDefault("dir3", "translated", arguments[2]);

    for (int idx = 3; idx < arguments.Length; idx++) {
        string item = arguments[idx];
        if (item[0] != '/') {
            return false;

        } else {
            item = item.Substring(1);
            string[] dd = item.Split(':');
            if (dd.Length == 1) {
                bool on;
                if (item.EndsWith("+")) {
                    on = true;
                } else if (item.EndsWith("-")) {
                    on = false;
                } else {
                    return false;
                }

                item = item.Substring(0, item.Length - 1);
                string section = "cmd-line";
                switch (item) {
                    case "directories":
                    case "files":
                    case "bom":
                    case "keys":
                    case "keybinding":
                    case "markup":
                    case "c-format":
                    case "entities":
                    case "placeholders":
                    case "untranslated":
                    case "escapes.mt":
                    case "accesskey":
                    case "escapes":
                        this.SetIniDefault(section, item, on ? "true" : "false");
                        break;
                    case "warn":
                        this.SetIniDefault("hidden", "warnings", on ? "true" : "false");
                        break;
                    default:
                        return false;
                }

            } else {
                switch (dd[0]) {
                    case "out":
                        this.SetIniDefault("cmd-line", "out", dd[1]);
                        break;
                    case "accesskey.maxposition":
                        this.SetIniDefault("cmd-line", "accesskey.maxposition", dd[1]);
                        break;
                    default:
                        return false;
                }
            }
        }
    }

    return true;
}

}//class
}//ns