const DEFAULT_DATE_FORMAT = "d.m.Y - H:i:s";

/***
The month- and weekdayname is to be stored in a dtd language dependent file.
***/
var month = new Array(
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
);


var weekday = new Array(
  "Sunday",
  "Monday",
  "Tuesday",
  "Wedensday",
  "Thursday",
  "Friday",
  "Saturday"
);


var monthLength = new Array(
  31,
  28,
  31,
  30,
  31,
  30,
  31,
  31,
  30,
  31,
  30,
  31
);


/***
 Returns a string formatted according to the given format string using the given date object
***/
function date(dateString, date) {
  if(arguments.length<1)
    dateString = DEFAULT_DATE_FORMAT;

  if(arguments.length<2) {
    date = new Date();
  }
  else {
    //Check if date is a date object?
  }

  var datePatterns = new Array(
    new Array(new RegExp(/([^\\])a|^a()/g), addSlashes(getMeridiem(date.getHours()))),                     //Lowercase Ante meridiem and Post meridiem
    new Array(new RegExp(/([^\\])A|^A()/g), addSlashes(getMeridiem(date.getHours()).toUpperCase())),       //Uppercase Ante meridiem and Post meridiem
    new Array(new RegExp(/([^\\])B|^B()/g), ""),                                                           //Swatch Internet time
    new Array(new RegExp(/([^\\])d|^d()/g), insertLeadingZero(date.getDate())),                            //Day of the month, 2 digits with leading zeros
    new Array(new RegExp(/([^\\])D|^D()/g), addSlashes(weekday[getWeekday(date)].substr(0,3))),            //A textual representation of a week, three letters
    new Array(new RegExp(/([^\\])F|^F()/g), addSlashes(month[date.getMonth()])),                           //A full textual representation of a month
    new Array(new RegExp(/([^\\])g|^g()/g), twelveHour(date.getHours())),                                  //12-hour format of an hour without leading zeros
    new Array(new RegExp(/([^\\])G|^G()/g), date.getHours()),                                              //24-hour format of an hour without leading zeros
    new Array(new RegExp(/([^\\])h|^h()/g), insertLeadingZero(twelveHour(date.getHours()))),               //12-hour format of an hour with leading zeros
    new Array(new RegExp(/([^\\])H|^H()/g), insertLeadingZero(date.getHours())),                           //24-hour format of an hour with leading zeros
    new Array(new RegExp(/([^\\])i|^i()/g), insertLeadingZero(date.getMinutes())),                         //Minutes with leading zeros
    new Array(new RegExp(/([^\\])I|^I()/g), ""),                                                           //Whether or not the date is in daylights savings time
    new Array(new RegExp(/([^\\])j|^j()/g), date.getDate()),                                               //Day of the month without leading zeros
    new Array(new RegExp(/([^\\])l|^l()/g), addSlashes(weekday[getWeekday(date)])),                        //A full textual representation of the day of the week
    new Array(new RegExp(/([^\\])L|^L()/g), (isLeapYear(date.getFullYear()))?"1":"0"),                     //Whether it's a leap year
    new Array(new RegExp(/([^\\])m|^m()/g), insertLeadingZero(date.getMonth()+1)),                         //Numeric representation of a month, with leading zeros
    new Array(new RegExp(/([^\\])M|^M()/g), addSlashes(month[date.getMonth()].substr(0,3))),               //A short textual representation of a month, three letters
    new Array(new RegExp(/([^\\])n|^n()/g), date.getMonth()+1),                                            //Numeric representation of a month, without leading zeros
    new Array(new RegExp(/([^\\])O|^O()/g), getGTMdifference(date.getTimezoneOffset())),                   //Difference to Greenwich time (GMT) in hours
    new Array(new RegExp(/([^\\])r|^r()/g), ""),                                                           //RFC 822 formatted date
    new Array(new RegExp(/([^\\])s|^s()/g), insertLeadingZero(date.getSeconds())),                         //Seconds, with leading zeros
    new Array(new RegExp(/([^\\])S|^S()/g), ""),                                                           //English ordinal suffix for the day of the month, 2 characters
    new Array(new RegExp(/([^\\])t|^t()/g), monthLength[date.getMonth()]),                                 //Number of days in the given month
    new Array(new RegExp(/([^\\])T|^T()/g), ""),                                                           //Timezone setting of this machine
    new Array(new RegExp(/([^\\])U|^U()/g), date.getTime()),                                               //Miliseconds since the Unix Epoch (January 1 1970 00:00:00 GMT)
    new Array(new RegExp(/([^\\])w|^w()/g), getWeekday(date)),                                             //Numeric representation of the day of the week
    new Array(new RegExp(/([^\\])W|^W()/g), ""),                                                           //ISO-8601 week number of year, weeks starting on Monday
    new Array(new RegExp(/([^\\])y|^y()/g), (""+date.getFullYear()).substr(2,2)),                          //A two digit representation of a year
    new Array(new RegExp(/([^\\])Y|^Y()/g), date.getFullYear()),                                           //A full numeric representation of a year, 4 digits
    new Array(new RegExp(/([^\\])z|^z()/g), getNumberOfDays(date)),                                        //The day of the year
    new Array(new RegExp(/([^\\])Z|^Z()/g), ""),                                                           //Timezone offset in seconds. The offset for timezones west of UTC is always negative, and for those east of UTC is always positive.

    new Array(new RegExp(/\\([A-Za-z])/g), "")                                          //Replace all backslashes followed by a letter with the letter
  );

  var pattern;
  while(pattern = datePatterns.shift()) {
    dateString = dateString.replace(pattern[0], "$1" + pattern[1]);
  }

  return dateString;
}


/***
Returns the hour in a 12-hour format
***/
function twelveHour(hour) {
  if( getMeridiem(hour)=="pm" )
    hour -= 12;
  if(hour==0)
    hour = 12;
  return hour;
}


/***
Returns lowercase am or pm based on the given 24-hour
***/
function getMeridiem(hour) {
  if(hour>11)
    return "pm";
  else
    return "am";
}


/***
Returns the number which represent the day of the week Sunday=0 .... Saturday=6
***/
function getWeekday(date) {
  switch(date.toGMTString().substr(0,3)){
    case "Sun":
      return 0;
    case "Mon":
      return 1;
    case "Tue":
      return 2;
    case "Wed":
      return 3;
    case "Thu":
      return 4;
    case "Fri":
      return 5;
    case "Sat":
      return 6;
  }
}


/***
Retrun true if year is a leap year otherwise false
***/
function isLeapYear(year) {
  //The Date object automatic corrigates if values is out of limit
  //29 isn't out of limit if it is leap year!
  var date = new Date(year, 1, 29);
  if(date.getMonth()==1)
    return true;
  else
    return false;
}


/***
Returns the number of days from new year to current date (incl current day)
***/
function getNumberOfDays(date) {
  var numberOfDays = 0;
  for(var x=0; x<date.getMonth(); x++) {
    numberOfDays += monthLength[x];
  }
  numberOfDays += date.getDate();

  if(date.getMonth()>1) {
    if(isLeapYear(date.getFullYear())) {
      numberOfDays += 1;
    }
  }
  return numberOfDays;
}


/***
Some of the numbers needs leading zeros
and this function returns the number with a leading zero
if the number is smaller than 10
***/
function insertLeadingZero(number) {
 if(number < 10)
    number = "0" + number;
  return number;
}


function getGTMdifference(offset) {
  offset = offset/(-60);
  if(offset>0)
    return "+" + offset + ":00";
  else
    return offset + ":00";
}


/***
This function is used to make every second character a backslash
so the insterted charaters isn't converted to hours, dates and so on.
***/
function addSlashes(stringH) {
  var stringTemp = "";
  for(var x=0; x<stringH.length; x++) {
    stringTemp += "\\";
    stringTemp += stringH.substr(x, 1);
  }
  return stringTemp;
}
