/* 
 * LCDInfo V0.01 
 * Copyright (C) 2002 Jan Svenungson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#define BASE 0x378
#define ENABLE_OFF 0
#define ENABLE_ON 4
#define I_REGISTER 2
#define D_REGISTER 0
#define WRITE_DATA 8
#define READ_DATA 0

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <asm/io.h>
#include <sys/types.h>
#include <sys/utsname.h>


// LCD display control functions
void display_on(void);
void display_off(void);
void clear_display(void);
void return_home(void);
void entry_mode(void);
void cursor_display_shift(void);
void function_set(void);
void initialize_display(void);
void print_character(int character);
void second_row();

// Functions for making screens to send to the LCD
void main_loop(void);
char* uptime(void);
char* system_info(void);

// Main function
int main(void)
{
	int width; 			// LCD screen width
	int height; 			// LCD screen height
	int i; 				// Just a counter

	char string_to_print[21]; 	// This is what should be sent
	width = 20;
	height = 2;
	
	//signal (SIGINT, exit_program);// Make program exit nicely on signals
	//signal (SIGTERM, exit_program);
	
	ioperm(BASE, 3, 1);		 // Get permission to the prallel port

	outb(0, BASE + 2); 		// Make sure there is power on C0
	initialize_display();	 	// Initialize the display

	main_loop();

	/*
	for (i = 0; i < strlen(string_to_send); i++)
		print_character(string_to_send[i]);

		This function will print all characters in string_to_send to LCD
	*/

	display_off();
	return 0;
}

void display_on(void)
{
	outb(12, BASE); 				//Turn on D3 and D4
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}

void display_off(void)
{
	outb(8, BASE); 					//Turn on D3 and D4
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}

void clear_display(void)
{       
	outb(1, BASE); 					//Turn on D0
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2);	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}       


void return_home(void)
{       
	outb(2, BASE);					//Turn on D1
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2);	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}       

void entry_mode(void)
{       
	outb(6, BASE); 					//Turn on D1 and D2
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2);	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}       

void cursor_display_shift(void)
{       
	outb(20, BASE); 				//Turn on D2 and D4
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2);	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}       

void function_set(void)
{       
	outb(56, BASE); 				//Turn on D3, D4 and D5
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Turn off C1 and C3
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2);	//Turn on C2 while C1 and C3 remains off
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(I_REGISTER + WRITE_DATA, BASE + 2); 	//Reset Control pins
	usleep(0);
}      

void initialize_display(void)
{
	function_set();
	function_set();
	entry_mode();
	display_on();
	clear_display();
}

void print_character(int character)
{
	outb(D_REGISTER + WRITE_DATA, BASE + 2); 	//Set register to Write Data
	outb(character, BASE); 				// Set the character code
	outb(4 + D_REGISTER + WRITE_DATA, BASE + 2); 	//Enable High
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(D_REGISTER + WRITE_DATA, BASE + 2); 	//Disable High
	usleep(0); //Wait while Enable (C2) is high so LCD will have time to load the info
}

void second_row(void)
{
	outb(I_REGISTER + WRITE_DATA, BASE + 2);
	outb(128 + 40, BASE);
	outb(4 + I_REGISTER + WRITE_DATA, BASE + 2); 	//Enable High
//	usleep(1); 					//Wait while Enable (C2) is high so LCD will have time to load the info
	outb(D_REGISTER + WRITE_DATA, BASE + 2); 	//Disable High
	usleep(0); //Wait while Enable (C2) is high so LCD will have time to load the info
}
	
void main_loop(void)
{	
	while(1)
	{
		int i;
		clear_display();

		for (i = 0; i < 24; i++)
		{
			int x;
			int y;

			for(x = 0; x < strlen(system_info()); x++)
				print_character(system_info()[x]);

				second_row();

			for (y = 0; y < strlen(uptime()); y++)
				print_character(uptime()[y]);

				return_home();
		}
	}
}

char* uptime(void)
{
	char uptime2[21];
	int uptime;
	int seconds;
	int minutes;
	int hours;
	int days;
	int years;
	int i;
	
	FILE *f;
	char text[21];
	
	f = fopen("/proc/uptime", "r");
	fgets(text, 40, f);
	sscanf(text, "%d", &uptime);
	fclose(f);
	
	seconds = uptime;
	minutes = seconds / 60;
	seconds = seconds % 60;
	hours = minutes / 60;
	minutes = minutes % 60;
	days = hours / 24;
	hours = hours % 24;
	years = days / 365;
	days = days % 365;

	snprintf(uptime2, 21, "Up:%.2dy %.3dd %.2d:%.2d:%.2d", years, days, hours, minutes, seconds);

	return(uptime2);
}

char* system_info(void)
{
	char system_info[21];
	struct utsname name;

	uname(&name);
//	printf("%s\n", name.sysname);
//	printf("%s\n", name.release);
//	printf("%s\n", name.nodename);
//	printf("%s\n", name.machine);

	snprintf(system_info, 21, "** %s - %s **", name.sysname, name.release);

	return(system_info);
}
